<?php
namespace App\Facades;
use App\Models\StudentClassInfo;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\Education;
use App\Models\MeetingLinks;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use App\Models\UserModel;
class GetStudentsProfilePic
{

    public static function getStudentsProfilePic($generated_link)
    {


        $profilePicArray = [];
        $session_emailId = Session::get('emailId');
        $classInformation = MeetingLinks::where('email_id', '=', $session_emailId)->where('generated_link', '=', $generated_link)->get();

        if (count($classInformation) > 0) {
            foreach ($classInformation as $roww) {
                $StudentEmail = $roww["participant_email"];
                $infoArray = [];
                $resultProfile = UserModel::where('email_id', $StudentEmail)->where('role', 'individual')->get();
                $num_rows = count($resultProfile);
                if ($num_rows > 0) {
                    foreach ($resultProfile as $row) {
                        $infoArray[] = $row["profile_picture"];
                        $infoArray[] = $row["first_name"] . " " . $row["second_name"];
                    }

                } else {
                    $resultProfile =UserModel::where('email_id', $StudentEmail)->where('role', 'organizational')->get();
                    $num_rows = count($resultProfile);
                    if ($num_rows > 0) {
                        foreach ($resultProfile as $row) {
                            $infoArray[] = $row["profile_picture"];
                            $infoArray[] = $row["first_name"] . " " . $row["second_name"];
                        }
                    } else {
                        $resultProfile = UserModel::where('email_id', $StudentEmail)->where('role', 'education')->get();
                        $num_rows = count($resultProfile);
                        if ($num_rows > 0) {
                            foreach ($resultProfile as $row) {
                                $infoArray[] = $row["profile_picture"];
                                $infoArray[] = $row["first_name"] . " " . $row["second_name"];
                            }
                        }
                    }
                }

                $profilePicArray[] = $infoArray[0];

            }
        }

        return $profilePicArray;
    }



    public static function getClassName($generated_link)
    {
        $session_emailId = Session::get('emailId');
        //  $classInformation = MeetingLinks::where('email_id', '=', $session_emailId)->where('generated_link', '=', $generated_link)->get();

        $classInformation = DB::table('meeting_links')
            ->join('student_class_info', 'meeting_links.class_id', '=', 'student_class_info.id')
            ->select('student_class_info.class_name')
            ->get();


        $className = "";

        foreach ($classInformation as $row) {
            $className = $row->class_name;
        }


        return $className;
    }
}

?>