<?php

namespace App\Http\Controllers;

use App\Models\Education;
use App\Models\Individual;
use App\Models\social_media_link;
use App\Models\Organisation;
use App\Models\PostData;
use App\Models\WorkingExperience;
use App\Models\diploma_education;
use App\Models\UserModel;
use App\Models\profile_image_change_record;
use App\Models\profile_images;
use App\Models\Cover_Images;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\URL;


class AuthController extends Controller
{
    // Login Form Action
    public function action_login(Request $request)
    {
        $request->validate([
            'login_email' =>'required|email',
            'login_pass' =>'required'
        ]);
        $email_id = $request->login_email;
        $login_pass = $request->login_pass;
        $login['email_id'] = $email_id;
        $login['password'] = $login_pass;
        if (Auth::attempt($login)){
            Session::put('emailId', $email_id);
            return redirect()->route('home')->with(['accountType' => Auth::user()->role]);
        }else{
            return redirect()->route('index')->with('failed', 'your account has been banned..please contact customer service');
        }
    }

    // Signup Form Action
    public function signup(Request $request)
    {
        $email_add = $request->email_id;
        $login_pass = $request->login_passwd;
        $account_type = $request->accountType;

        // Individual
        if ($account_type == 1) {
            $result = UserModel::where('email_id', $email_add)->where('role', 'individual')->first();

            if ($result) {
                return redirect()->route('signup')->with('failed', 'Email Id Already Registered');
            } else {
                $signupInfo = [];
                $signupInfo['emailId'] = $email_add;
                $signupInfo['login_pass'] = $login_pass;
                $signupInfo['account_type'] = $account_type;
                Session::put('SignupInfoIndividual', $signupInfo);
                return redirect()->route('basicInfo');
            }
        }

        // Organisation Or Company
        if ($account_type == 2) {
            $result =  UserModel::where('email_id', $email_add)->where('role', 'organizational')->first();

            if ($result) {
                return redirect()->route('signup')->with('failed', 'Email Id Already Registered');
            } else {
                $signupInfo = [];
                $signupInfo['emailId'] = $email_add;
                $signupInfo['login_pass'] = $login_pass;
                $signupInfo['account_type'] = $account_type;
                Session::put('SignupInfoOrg', $signupInfo);
                return redirect()->route('psersonalInfomation');
            }
        }

        // Education
        if ($account_type == 3) {
            $result = UserModel::where('email_id', $email_add)->where('role', 'education')->first();
            if ($result) {
                return redirect()->route('signup')->with('failed', 'Email Id Already Registered');
            } else {
                $signupInfo = [];
                $signupInfo['emailId'] = $email_add;
                $signupInfo['login_pass'] = $login_pass;
                $signupInfo['account_type'] = $account_type;
                Session::put('SignupInfoEdu', $signupInfo);
                return redirect()->route('personalInformationEdu');
            }
        }
    }



    // Signup2 Form Action => Individual
    public function actionBasicInfo(Request $request)
    {
        $signupInfo = Session::get('SignupInfoIndividual');
        $first_name = $request->first_name;
        $country_name = $request->country_picker;
        $second_name = $request->second_name;
        $city_name = $request->city_name;
        $zip_code = $request->zip_code;
        $country_of_origin = $request->contry_of_origin;
        $Ethnicity = $request->Ethnicity;
        $gender = $request->gender_picker;
        $status = $request->status_picker;
        $phoneNumber = $request->phone_no;
        $full_address = $request->full_address;
        $dayy = $request->day;
        $monthh = $request->month;
        $yarrr = $request->year;


        $signupInfo['first_name'] = $first_name;
        $signupInfo['country_name'] = $country_name;
        $signupInfo['second_name'] = $second_name;
        $signupInfo['city_name'] = $city_name;
        $signupInfo['zip_code'] = $zip_code;
        $signupInfo['birth_date'] = $dayy . '-' . $monthh . '-' . $yarrr;
        $signupInfo['country_of_origin'] = $country_of_origin;
        $signupInfo['Ethnicity'] = $Ethnicity;
        $signupInfo['gender'] = $gender;
        $signupInfo['status'] = $status;
        $signupInfo['phoneNumber'] = $phoneNumber;
        $signupInfo['full_address'] = $full_address;
        Session::put('SignupInfoIndividual', $signupInfo);
        // return redirect()->route('diplomaInfo');
        return redirect()->route('addsocialmedialinks');
    }
    // Social Media form  Form Action => Individual
    public function actionSocialLinks(Request $request)
    {

        $signupInfo = Session::get('SignupInfoIndividual');

        $signupInfo['facebook'] = $request->facebook;
        $signupInfo['twiter'] = $request->twiter;
        $signupInfo['linkedin'] = $request->linkedin;
        $signupInfo['Instagram'] = $request->Instagram;
        $signupInfo['youtube'] = $request->youtube;
        $signupInfo['github'] = $request->github;

        Session::put('SignupInfoIndividual', $signupInfo);
        return redirect()->route('diplomaInfo');
    }
    // Diploma Information  Form Action => Individual
    public function action_diplomaInfo(Request $request)
    {
        $education = $request->education;
        $most_recent_inst = $request->most_recent_edu;
        $isiamstudent = $request->iamstudent;
        $job_title1 = $request->job_title_1;
        $company_name1 = $request->company_name_1;
        $year_from1 = $request->year_from_1;
        $year_to1 = $request->year_to_1;
        $job_title2 = $request->job_title_2;
        $company_name2 = $request->company_name_2;
        $year_from2 = $request->year_from_2;
        $year_to2 = $request->year_to_2;
        $job_title3 = $request->job_title_3;
        $company_name3 = $request->company_name_3;
        $year_from3 = $request->year_from_3;
        $year_to3 = $request->year_to_3;


        $signupInfo = Session::get('SignupInfoIndividual');

        $signupInfo['education'] = $education;
        $signupInfo['most_recent_institute'] = $most_recent_inst;
        $signupInfo['i_am_student'] = $isiamstudent;
        $signupInfo['inst_name1'] = $job_title1;
        $signupInfo['diploma1'] = $company_name1;
        $signupInfo['year_from_1'] = $year_from1;
        $signupInfo['year_to_1'] = $year_to1;
        $signupInfo['inst_name2'] = $job_title2;
        $signupInfo['diploma2'] = $company_name2;
        $signupInfo['year_from_2'] = $year_from2;
        $signupInfo['year_to_2'] = $year_to2;
        $signupInfo['inst_name3'] = $job_title3;
        $signupInfo['diploma3'] = $company_name3;
        $signupInfo['year_from_3'] = $year_from3;
        $signupInfo['year_to_3'] = $year_to3;


        Session::put('SignupInfoIndividual', $signupInfo);
        return redirect()->route('workexperience');
    }


    public function action_aboutus(Request $request)
    {
        $aboutUs = $request->aboutus;
        $signupInfo = Session::get('SignupInfoIndividual');
        $signupInfo['aboutUs'] = $aboutUs;
        Session::put('SignupInfoIndividual', $signupInfo);
        return redirect()->route('aditionalInformation');

    }
    // Workexperience Form Action => Individual
    public function action_adding_exp(Request $request)
    {
        $job_title1 = $request->job_title_1;
        $company_name1 = $request->company_name_1;
        $year_from1 = $request->year_from_1;
        $year_to1 = $request->year_to_1;
        $job_title2 = $request->job_title_2;
        $company_name2 = $request->company_name_2;
        $year_from2 = $request->year_from_2;
        $year_to2 = $request->year_to_2;
        $job_title3 = $request->job_title_3;
        $company_name3 = $request->company_name_3;
        $year_from3 = $request->year_from_3;
        $year_to3 = $request->year_to_3;
        $signupInfo = Session::get('SignupInfoIndividual');

        $signupInfo['job_title1'] = $job_title1;
        $signupInfo['company_name1'] = $company_name1;
        $signupInfo['year_from1'] = $year_from1;
        $signupInfo['year_to1'] = $year_to1;
        $signupInfo['job_title2'] = $job_title2;
        $signupInfo['company_name2'] = $company_name2;
        $signupInfo['year_from2'] = $year_from2;
        $signupInfo['year_to2'] = $year_to2;
        $signupInfo['job_title3'] = $job_title3;
        $signupInfo['company_name3'] = $company_name3;
        $signupInfo['year_from3'] = $year_from3;
        $signupInfo['year_to3'] = $year_to3;
        Session::put('SignupInfoIndividual', $signupInfo);

        // return redirect()->route('aditionalInformation');
        return redirect()->route('tellaboutus');
    }




    public function uploadUpdatedProfile(Request $request)
    {

        $fileName = "";
        $fileName1 = "";
        if (isset($_FILES['customFile'])) {
            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");
            $randomNum = rand(10, 1000);
            $email_id = Session::get('emailId');
            $position = strpos($email_id, '@');
            $fileName1 = substr($email_id, 0, $position);
            $fileName = $fileName1;
            $fileName = $randomNum . $fileName . '.' . $file_ext;
            $profileimgaspost = $randomNum . '.' . $file_ext;
            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $fileName);


                $datee = date('Y-m-d H_i_s') . '';
                $path = public_path("PostImages/" . $email_id . "/" . $datee);
                if (!file_exists($path)) {
                    mkdir($path, 0777, true);
                }
                copy("ProfileImages/Images/" . $fileName, "PostImages/" . $email_id . "/" . $datee . "/" . $profileimgaspost);

            } else {
                print_r($errors);
            }

            profile_images::create([
                'email_id' => $email_id,
                'image_name' => $fileName
            ]);



            UserModel::where('email_id', '=', $email_id)->update(['profile_picture' => $fileName]);


            $resultSet = UserModel::where('email_id', '=', $email_id)->get();
            $fullName = "";
            $userType = "";
            if (count($resultSet) > 0) {

                foreach ($resultSet as $row) {
                    $fullName = $row["first_name"] . ' ' . $row["second_name"];
                    $userType = $row['role'];
                }
            }

            $postText = $fullName . "  has updated his profile picture";

            PostData::create([
                'email_id' => $email_id,
                'FullName' => $fullName,
                'PostText' => $postText,
                'DateTime' => $datee,
                'PostImgeName' => $datee


            ]);

        }

        if ($userType == 'individual') {
            return redirect()->route('home')->with(['accountType' => 'individual']);
        } else if ($userType == 'organizational') {
            return redirect()->route('home')->with(['accountType' => 'organization']);
        }
    }

    public function uploadCoverPhoto(Request $request)
    {


        $fileName = "";
        $fileName1 = "";
        if (isset($_FILES['customCoverFile'])) {
            $errors = array();
            $file_name = $_FILES['customCoverFile']['name'];
            $file_size = $_FILES['customCoverFile']['size'];
            $file_tmp = $_FILES['customCoverFile']['tmp_name'];
            $file_type = $_FILES['customCoverFile']['type'];

            $file = explode('.', $_FILES['customCoverFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");
            $randomNum = rand(10, 1000);
            $email_id = Session::get('emailId');
            $position = strpos($email_id, '@');
            $fileName1 = substr($email_id, 0, $position);
            $fileName = $fileName1;
            $fileName = $randomNum . $fileName . '.' . $file_ext;
            $profileimgaspost = $randomNum . '.' . $file_ext;
            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $fileName);
                Cover_Images::create([
                    'email_id' => $email_id,
                    'image_name' => $fileName
                ]);

            }
        }

        return redirect()->route('home');


    }


    public function UpdateProfileImageFromOldImages(Request $request)
    {
        $fileName = $request->imageName;
        $email_id = Session::get('emailId');
        UserModel::where('email_id', '=', $email_id)->update(['profile_picture' => $fileName]);
        $resultSet = UserModel::where('email_id', '=', $email_id)->get();
        $fullName = "";

        if (count($resultSet) > 0) {
            foreach ($resultSet as $row) {
                $fullName = $row["first_name"] . ' ' . $row["second_name"];
            }
        }

        $datee = date('Y-m-d H_i_s') . '';

        $path = public_path("PostImages/" . $email_id . "/" . $datee);
        if (!file_exists($path)) {
            mkdir($path, 0777, true);
        }
        copy("ProfileImages/Images/" . $fileName, "PostImages/" . $email_id . "/" . $datee . "/" . $fileName);




        $postText = $fullName . "  has updated his profile picture";

        PostData::create([
            'email_id' => $email_id,
            'FullName' => $fullName,
            'PostText' => $postText,
            'DateTime' => $datee,
            'PostImgeName' => $datee


        ]);
        return redirect()->route('home');
    }


    // Upload CV Prfile => Individual
    public function uploadCVProfile(Request $request)
    {
        $signupInfo = Session::get('SignupInfoIndividual');
        $account_type = $signupInfo['account_type'];//Session::get('account_type');

        $first_name = $signupInfo['first_name'];
        $second_name = $signupInfo['second_name'];
        $email_id = $signupInfo['emailId'];
        // $email_id = "user9@gmail.com";
        $login_pass = $signupInfo['login_pass'];
        $birth_date = new \DateTime($signupInfo['birth_date']);

        $zip_code = $signupInfo['zip_code'];
        $city_name = $signupInfo['city_name'];
        $country_name = $signupInfo['country_name'];
        $reg_date = date('Y-m-d');

        $education = $signupInfo['education'];
        $most_recent_inst = $signupInfo['most_recent_institute'];
        $isiamstudent = $signupInfo['i_am_student'];

        $country_of_origin = $signupInfo['country_of_origin'];
        $ethnicity = $signupInfo['Ethnicity'];
        $gender = $signupInfo['gender'];


        $status = $signupInfo['status'];
        $aboutus = $signupInfo['aboutUs'];
        $phoneNumber = $signupInfo['phoneNumber'];
        $full_address = $signupInfo['full_address'];

        $profil_picture = "";
        $cv = "";
        $interview_video_path = "";
        $randomNum = rand(10, 1000);

        $position = strpos($email_id, '@');

        $fileName1 = substr($email_id, 0, $position);
        $fileName = $fileName1;

        $n_f1 = explode('.', $_FILES['customFile']['name']);
        $n_f1_raw = end($n_f1);
        $file_ext1 = strtolower($n_f1_raw);
        $profil_picture = $randomNum . $fileName . '.' . $file_ext1;

        $n_f2 = explode('.', $_FILES['cvfile']['name']);
        $n_f2_raw = end($n_f2);
        $file_ext2 = strtolower($n_f2_raw);
        if (strlen($file_ext2) > 0) {
            $cv = $fileName1 . '.' . $file_ext2;
        } else {
            $cv = "not set";
        }

        $login_pass_hash = Hash::make($login_pass);
        UserModel::create([
            'name' => $first_name." ".$second_name,
            'first_name' => $first_name,
            'second_name' => $second_name,
            'email_id' => $email_id,
            'password' => $login_pass_hash,
            'birth_date' => $birth_date,
            'zip_code' => $zip_code,
            'city_name' => $city_name,
            'country_name' => $country_name,
            'reg_date' => $reg_date,
            'education' => $education,
            'mostrecent' => $most_recent_inst,
            'student' => $isiamstudent,
            'profile_picture' => $profil_picture,
            'cv' => $cv,
            'account_status'=>'Active',
            'interview_video_path' => $interview_video_path,
            'country_of_origin' => $country_of_origin,
            'ethnicity' => $ethnicity,
            'gender' => $gender,
            'status' => $status,
            'about_us' => $aboutus,
            'image_name' => $profil_picture,
            'phone_number' => $phoneNumber,
            'full_address' => $full_address,
            'role'=>'individual',

        ]);
        //after signup login that user
        Auth::attempt(['email_id'=>$email_id,'password'=>$login_pass]);
        if (strlen($signupInfo['facebook']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['facebook'],
                'url_type' => 'facebook'
            ]);
        }
        if (strlen($signupInfo['twiter']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['twiter'],
                'url_type' => 'twiter'
            ]);
        }
        if (strlen($signupInfo['linkedin']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['linkedin'],
                'url_type' => 'linkedin'
            ]);
        }
        if (strlen($signupInfo['Instagram']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['Instagram'],
                'url_type' => 'Instagram'
            ]);
        }
        if (strlen($signupInfo['youtube']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['youtube'],
                'url_type' => 'youtube'
            ]);
        }
        if (strlen($signupInfo['github']) > 0) {
            social_media_link::create([
                'email_id' => $email_id,
                'url_link' => $signupInfo['github'],
                'url_type' => 'github'
            ]);
        }


        $job_title1 = $signupInfo['job_title1'];  //Session::get('job_title1');
        if (strlen($job_title1) == 0) {
            $job_title1 = "";
        }
        $company_name1 = $signupInfo['company_name1'];// Session::get('company_name1');
        if (strlen($company_name1) == 0) {
            $company_name1 = "";
        }
        $year_from1 = $signupInfo['year_from1'];// Session::get('year_from1');
        if (strlen($year_from1) == 0) {
            $year_from1 = "";
        }
        $year_to1 = $signupInfo['year_to1'];//Session::get('year_to1');
        if (strlen($year_to1) == 0) {
            $year_to1 = "";
        }


        $job_title2 = $signupInfo['job_title2'];//Session::get('job_title2');
        if (strlen($job_title2) == 0) {
            $job_title2 = "";
        }
        $company_name2 = $signupInfo['company_name2']; //Session::get('company_name2');
        if (strlen($company_name2) == 0) {
            $company_name2 = "";
        }
        $year_from2 = $signupInfo['year_from2'];// Session::get('year_from2');
        if (strlen($year_from2) == 0) {
            $year_from2 = "";
        }
        $year_to2 = $signupInfo['year_to2']; //Session::get('year_to2');
        if (strlen($year_to2) == 0) {
            $year_to2 = "";
        }


        $job_title3 = $signupInfo['job_title3'];  //Session::get('job_title3');
        if (strlen($job_title3) == 0) {
            $job_title3 = "";
        }
        $company_name3 = $signupInfo['company_name3']; //Session::get('company_name3');
        if (strlen($company_name3) == 0) {
            $company_name3 = "";
        }
        $year_from3 = $signupInfo['year_from3'];// Session::get('year_from3');
        if (strlen($year_from3) == 0) {
            $year_from3 = "";
        }
        $year_to3 = $signupInfo['year_to3'];// Session::get('year_to3');
        if (strlen($year_to3) == 0) {
            $year_to3 = "";
        }
        $record1 = 'O';
        $record2 = 'O';
        $record3 = 'O';
        if ($year_to1 == 'now') {
            $record1 = 'L';
        } else {
            $yearOne = (int) $year_to1;
        }
        if ($year_to2 == 'now') {
            $record2 = 'L';
        } else {
            $yearTwo = (int) $year_to2;
        }
        if ($year_to3 == 'now') {
            $record3 = 'L';
        } else {
            $yearThree = (int) $year_to3;
        }

        if ($record1 == 'O' && $record2 == 'O' && $record3 == 'O') {
            if ($yearOne > $yearTwo && $yearOne > $yearThree) {
                $record1 = 'L';
            }
            if ($yearTwo > $yearOne && $yearTwo > $yearThree) {
                $record2 = 'L';
            }
            if ($yearThree > $yearOne && $yearThree > $yearTwo) {
                $record3 = 'L';
            }
        }
        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $job_title1,
            'company' => $company_name1,
            'from_year' => $year_from1,
            'to_year' => $year_to1,
            'most_rec' => $record1
        ]);

        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $job_title2,
            'company' => $company_name2,
            'from_year' => $year_from2,
            'to_year' => $year_to2,
            'most_rec' => $record2
        ]);

        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $job_title3,
            'company' => $company_name3,
            'from_year' => $year_from3,
            'to_year' => $year_to3,
            'most_rec' => $record3
        ]);


        //adding diploma experience here...............................
        $job_title1 = $signupInfo['inst_name1'];//Session::get('inst_name1');

        if (strlen($job_title1) == 0) {
            $job_title1 = "";
        }
        $company_name1 = $signupInfo['diploma1'];// Session::get('diploma1');
        if (strlen($company_name1) == 0) {
            $company_name1 = "";
        }
        $year_from1 = $signupInfo['year_from_1']; //Session::get('year_from_1');
        if (strlen($year_from1) == 0) {
            $year_from1 = "";
        }
        $year_to1 = $signupInfo['year_to_1']; //Session::get('year_to_1');
        if (strlen($year_to1) == 0) {
            $year_to1 = "";
        }

        $job_title2 = $signupInfo['inst_name2'];  // Session::get('inst_name2');
        if (strlen($job_title2) == 0) {
            $job_title2 = "";
        }
        $company_name2 = $signupInfo['diploma2'];// Session::get('diploma2');
        if (strlen($company_name2) == 0) {
            $company_name2 = "";
        }
        $year_from2 = $signupInfo['year_from_2']; // Session::get('year_from_2');
        if (strlen($year_from2) == 0) {
            $year_from2 = "";
        }
        $year_to2 = $signupInfo['year_to_2']; //Session::get('year_to_2');
        if (strlen($year_to2) == 0) {
            $year_to2 = "";
        }

        $job_title3 = $signupInfo['inst_name3'];// Session::get('inst_name3');
        if (strlen($job_title3) == 0) {
            $job_title3 = "";
        }
        $company_name3 = $signupInfo['diploma3'];// Session::get('diploma3');
        if (strlen($company_name3) == 0) {
            $company_name3 = "";
        }
        $year_from3 = $signupInfo['year_from_3'];//Session::get('year_from_3');
        if (strlen($year_from3) == 0) {
            $year_from3 = "";
        }
        $year_to3 = $signupInfo['year_to_3'];// Session::get('year_to_3');
        if (strlen($year_to3) == 0) {
            $year_to3 = "";
        }
        $record1 = 'O';
        $record2 = 'O';
        $record3 = 'O';
        if ($year_to1 == 'now') {
            $record1 = 'L';
        } else {
            $yearOne = (int) $year_to1;
        }
        if ($year_to2 == 'now') {
            $record2 = 'L';
        } else {
            $yearTwo = (int) $year_to2;
        }
        if ($year_to3 == 'now') {
            $record3 = 'L';
        } else {
            $yearThree = (int) $year_to3;
        }

        if ($record1 == 'O' && $record2 == 'O' && $record3 == 'O') {
            if ($yearOne > $yearTwo && $yearOne > $yearThree) {
                $record1 = 'L';
            }
            if ($yearTwo > $yearOne && $yearTwo > $yearThree) {
                $record2 = 'L';
            }
            if ($yearThree > $yearOne && $yearThree > $yearTwo) {
                $record3 = 'L';
            }
        }
        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $job_title1,
            'diploma_name' => $company_name1,
            'from_year' => $year_from1,
            'to_year' => $year_to1,
            'most_rec' => $record1
        ]);

        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $job_title2,
            'diploma_name' => $company_name2,
            'from_year' => $year_from2,
            'to_year' => $year_to2,
            'most_rec' => $record2
        ]);

        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $job_title3,
            'diploma_name' => $company_name3,
            'from_year' => $year_from3,
            'to_year' => $year_to3,
            'most_rec' => $record3
        ]);


        if (isset($_FILES['customFile'])) {
            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $fileName = $randomNum . $fileName . '.' . $file_ext;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $fileName);
            } else {
                print_r($errors);
            }

            $errors = array();
            $file_name = $_FILES['cvfile']['name'];
            $file_size = $_FILES['cvfile']['size'];
            $file_tmp = $_FILES['cvfile']['tmp_name'];
            $file_type = $_FILES['cvfile']['type'];

            $file = explode('.', $_FILES['cvfile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $fileName1 = $fileName1 . '.' . $file_ext;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/CV/" . $fileName1);
            } else {
                print_r($errors);
            }
        }

        Session::put('emailId', $email_id);

        return redirect()->route('home')->with(['accountType' => 'individual']);

    }






    // signingOrg Form Action => Organisation
    public function action_signingOrg(Request $request)
    {
        $first_name = $request->first_name;
        $city_name = $request->city_name;
        $phone_number = $request->phone_number;

        $second_name = $request->second_name;
        $country_name = $request->country_name;
        $birth_date = $request->dateOFBirth;
        $ent_email = $request->EntrepriseEmail;


        $personal_email = "not set";
        $signupInfo = Session::get('SignupInfoOrg');
        $signupInfo['first_name'] = $first_name;
        $signupInfo['city_name'] = $city_name;
        $signupInfo['phone_number'] = $phone_number;
        $signupInfo['second_name'] = $second_name;
        $signupInfo['country_name'] = $country_name;
        $signupInfo['birth_date'] = $birth_date;
        $signupInfo['personal_email'] = $personal_email;
        $signupInfo['entreprise_email'] = $ent_email;

        Session::put('SignupInfoOrg', $signupInfo);

        return redirect()->route('businessOrgInfo');
    }

    // signingOrg2 Form Action => Organisation
    public function action_businessOrg_info(Request $request)
    {

        $signupInfo = Session::get('SignupInfoOrg');
        $email_id = $signupInfo['emailId'];//Session::get('emailId');
        $account_type = $signupInfo['account_type'];//Session::get('account_type');
        $first_name = $signupInfo['first_name'];//Session::get('first_name');
        $city_name = $signupInfo['city_name'];//Session::get('city_name');
        $phone_number = $signupInfo['phone_number']; //Session::get('phone_number');
        $second_name = $signupInfo['second_name'];//Session::get('second_name');
        $country_name = $signupInfo['country_name'];// Session::get('country_name');
        $birth_date =new \DateTime( $signupInfo['birth_date']); //Session::get('birth_date');
        $personal_email = $signupInfo['personal_email']; //Session::get('personal_email');
        $entreprise_email = $signupInfo['entreprise_email'];  //Session::get('entreprise_email');

        $entreprise_name = $request->entreprise_name;
        $structure = $request->structure;
        $civic_address = $request->civic_address;
        $city_name_org = $request->city_name;
        $org_email = $request->org_email;
        $org_country_name = $request->country_name;
        $org_website_url = $request->org_web_url;
        $company_website = "not set";

        $login_pass = $signupInfo['login_pass'];

        $reg_date = date('Y-m-d');


        $profil_picture = "";

        $position = strpos($email_id, '@');

        $fileName1 = substr($email_id, 0, $position);
        $fileName = $fileName1;

        $file1 = explode('.', $_FILES['customFile']['name']);
        $file_raw1 = end($file1);
        $file_ext1 = strtolower($file_raw1);

        $profil_picture = $fileName . '.' . $file_ext1;

        Session::put('emailId', $signupInfo['emailId']);
        $login_pass_hash = Hash::make($login_pass);
        UserModel::create([
            'email_id' => $email_id,
            'password' => $login_pass_hash,
            'name' => $first_name." ".$second_name,
            'first_name' => $first_name,
            'second_name' => $second_name,
            'birth_date' => $birth_date,
            'city_name' => $city_name,
            'country_name' => $country_name,
            'phone_number' => $phone_number,
            'company_website' => $company_website,
            'organization_email' => $org_email,
            'account_status'=>'Active',
            'civic_adress' => $civic_address,
            'city_company' => $city_name_org,
            'organization_reg_date' => $reg_date,
            'org_structure' => $structure,
            'country_org' => $org_country_name,
            'personal_email' => $personal_email,
            'profile_picture' => $profil_picture,
            'entriseprise_email' => $entreprise_email,
            'entreprise_name' => $entreprise_name,
            'entreprise_web_url' => $org_website_url,
            'role'=>'organization',
        ]);
        //after signup login that user
        Auth::attempt(['email_id'=>$email_id,'password'=>$login_pass]);
        if (isset($_FILES['customFile'])) {
            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $fileName = $fileName . '.' . $file_ext;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $fileName);

            } else {
                print_r($errors);
            }
        }
        return redirect()->route('home');
    }

    // edusignup Form Action => Education
    public function action_personalInfo_Edu(Request $request)
    {
        $first_name = $request->first_name;
        $city_name = $request->city_name;
        $phone_number = $request->phone_number;
        $second_name = $request->second_name;
        $country_name = $request->country_name;
        ///$birth_date = $request->dateofBirth;
        $personal_email = $request->personal_email;

        $dayy = $request->day;
        $monthh = $request->month;
        $yeary = $request->year;
        $birth_date = $dayy . '-' . $monthh . '-' . $yeary;


        $email_id = Session::get('emailId');
        $account_type = Session::get('account_type');

        $signupInfo = Session::get('SignupInfoEdu');

        $signupInfo['first_name'] = $first_name;
        $signupInfo['city_name'] = $city_name;
        $signupInfo['phone_number'] = $phone_number;
        $signupInfo['second_name'] = $second_name;
        $signupInfo['country_name'] = $country_name;
        $signupInfo['birth_date'] = $birth_date;
        $signupInfo['personal_email'] = $personal_email;

        Session::put('SignupInfoEdu', $signupInfo);


        return redirect()->route('educationInformationEdu');
    }

    // edusignup2 Form Action => Education
    public function action_eduInformation_Edu(Request $request)
    {
        $instituation = $request->instituation;
        $civic_address = $request->civic_address;
        $city_name_instituation = $request->city_name_instituation;
        $country_name_instituation = $request->country_name_instituation;
        $institution_phone_num = $request->instituation_phone_number;
        $instituation_email = $request->instituation_email;

        $signupInfo = Session::get('SignupInfoEdu');

        $email_id = $signupInfo['emailId']; //Session::get('emailId');
        $account_type = $signupInfo['account_type'];//Session::get('account_type');
        $login_pass = $signupInfo['login_pass'];//Session::get('login_pass');

        $first_name = $signupInfo['first_name']; //Session::get('first_name');
        $city_name = $signupInfo['city_name']; //Session::get('city_name');
        $phone_number = $signupInfo['phone_number']; //= Session::get('phone_number');
        $second_name = $signupInfo['second_name']; //Session::get('second_name');
        $country_name = $signupInfo['country_name']; // Session::get('country_name');
        $birth_date = $signupInfo['birth_date']; //Session::get('birth_date');
        $personal_email = $signupInfo['personal_email']; //Session::get('personal_email');

        $profil_picture = "";

        $position = strpos($email_id, '@');

        $fileName1 = substr($email_id, 0, $position);
        $fileName = $fileName1;

        $file1 = explode('.', $_FILES['customFile']['name']);
        $file_raw1 = end($file1);
        $file_ext1 = strtolower($file_raw1);

        $profil_picture = $fileName . '.' . $file_ext1;
        $login_pass_hash= Hash::make($login_pass);
        UserModel::create([
            'email_id' => $email_id,
            'password' => $login_pass_hash,
            'name' => $first_name." ".$second_name,
            'first_name' => $first_name,
            'second_name' => $second_name,
            'birth_date' => $birth_date,
            'city_name' => $city_name,
            'country_name' => $country_name,
            'phone_number' => $phone_number,
            'institutionlevel' => $instituation,
            'city_org' => $city_name_instituation,
            'country_org' => $country_name_instituation,
            'institution_phone_num' => $institution_phone_num,
            'civic_adress' => $civic_address,
            'personal_email' => $personal_email,
            'instituation_email' => $instituation_email,
            'profile_picture' => $profil_picture,
            'role' => 'education',
        ]);
        //after signup login that user
        Auth::attempt(['email_id'=>$email_id,'password'=>$login_pass]);
        if (isset($_FILES['customFile'])) {
            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $fileName = $fileName . '.' . $file_ext;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $fileName);

            } else {
                print_r($errors);
            }
        }

        return redirect()->route('home');


        //   return redirect()->route('home');
    }

    public function updateDiplomaInfo(Request $request)
    {
        $email_id = Session::get('emailId');
        $dipName1 = $request->dipname1;
        $dipName2 = $request->dipname2;
        $dipName3 = $request->dipname3;

        $insName1 = $request->insname1;
        $insName2 = $request->insname2;
        $insName3 = $request->insname3;

        $year_from1 = $request->yearfrom1;
        $year_from2 = $request->yearfrom2;
        $year_from3 = $request->yearfrom3;

        $year_to1 = $request->yearto1;
        $year_to2 = $request->yearto2;
        $year_to3 = $request->yearto3;



        $record1 = 'O';
        $record2 = 'O';
        $record3 = 'O';
        if ($request->stillworking1 == 1) {
            $record1 = 'L';
            $year_to1 = 'now';

        } else {
            $yearOne = (int) $year_to1;
        }
        if ($request->stillworking2 == 1) {
            $record2 = 'L';
            $year_to2 = 'now';
        } else {
            $yearTwo = (int) $year_to2;
        }
        if ($request->stillworking3 == 1) {
            $record3 = 'L';
            $year_to3 = 'now';

        } else {
            $yearThree = (int) $year_to3;
        }

        if ($record1 == 'O' && $record2 == 'O' && $record3 == 'O') {
            if ($yearOne > $yearTwo && $yearOne > $yearThree) {
                $record1 = 'L';
            }
            if ($yearTwo > $yearOne && $yearTwo > $yearThree) {
                $record2 = 'L';
            }
            if ($yearThree > $yearOne && $yearThree > $yearTwo) {
                if ($request->stillworking3 == 1) {
                    $record3 = 'L';
                }
            }
        }

        diploma_education::where('email_address', $email_id)->delete();

        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $insName1,
            'diploma_name' => $dipName1,
            'from_year' => $year_from1,
            'to_year' => $year_to1,
            'most_rec' => $record1
        ]);

        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $insName2,
            'diploma_name' => $dipName2,
            'from_year' => $year_from2,
            'to_year' => $year_to2,
            'most_rec' => $record2
        ]);

        diploma_education::create([
            'email_address' => $email_id,
            'Institution_name' => $insName3,
            'diploma_name' => $dipName3,
            'from_year' => $year_from3,
            'to_year' => $year_to3,
            'most_rec' => $record3
        ]);


        return redirect()->route('home');



    }


    public function updateWorkExperience(Request $request)
    {

        $email_id = Session::get('emailId');
        $dipName1 = $request->jobtitle1;
        $dipName2 = $request->jobtitle2;
        $dipName3 = $request->jobtitle3;

        $insName1 = $request->company1;
        $insName2 = $request->company2;
        $insName3 = $request->company3;

        $year_from1 = $request->yearfromWorkExp1;
        $year_from2 = $request->yearfromWorkExp2;
        $year_from3 = $request->yearfromWorkExp3;

        $year_to1 = $request->yeartoWorkExp1;
        $year_to2 = $request->yeartoWorkExp2;
        $year_to3 = $request->yeartoWorkExp3;


        $record1 = 'O';
        $record2 = 'O';
        $record3 = 'O';
        if ($request->stillWorkingWorkingExp1 == 1) {
            $record1 = 'L';
            $year_to1 = 'now';

        } else {
            $yearOne = (int) $year_to1;
        }
        if ($request->stillWorkingWorkingExp2 == 1) {
            $record2 = 'L';
            $year_to2 = 'now';
        } else {
            $yearTwo = (int) $year_to2;
        }
        if ($request->stillWorkingWorkingExp3 == 1) {
            $record3 = 'L';
            $year_to3 = 'now';

        } else {
            $yearThree = (int) $year_to3;
        }

        if ($record1 == 'O' && $record2 == 'O' && $record3 == 'O') {
            if ($yearOne > $yearTwo && $yearOne > $yearThree) {
                $record1 = 'L';
            }
            if ($yearTwo > $yearOne && $yearTwo > $yearThree) {
                $record2 = 'L';
            }
            if ($yearThree > $yearOne && $yearThree > $yearTwo) {
                if ($request->stillworking3 == 1) {
                    $record3 = 'L';
                }
            }
        }

        WorkingExperience::where('email_address', $email_id)->delete();

        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $insName1,
            'company' => $dipName1,
            'from_year' => $year_from1,
            'to_year' => $year_to1,
            'most_rec' => $record1
        ]);

        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $insName2,
            'company' => $dipName2,
            'from_year' => $year_from2,
            'to_year' => $year_to2,
            'most_rec' => $record2
        ]);

        WorkingExperience::create([
            'email_address' => $email_id,
            'job_title' => $insName3,
            'company' => $dipName3,
            'from_year' => $year_from3,
            'to_year' => $year_to3,
            'most_rec' => $record3
        ]);

        return redirect()->route('home');

    }

}
