<?php

namespace App\Http\Controllers;

use App\Models\PostData;
use App\Models\PostImage;
use App\Models\PostLike;
use App\Models\comments_adds;
use Illuminate\Http\Request;
use App\Models\Education;
use App\Models\Individual;
use App\Models\PostJob;
use App\Models\UserModel;
use App\Models\Organisation;
use App\Models\QuestionDetail;
use App\Models\JobAppStatus;
use App\Models\QuestionInformation;
use App\Models\JobsApplyData;
use App\Models\QuestionAns;
use App\Models\PostJobFilterData;
use App\Models\Follower;
use App\Models\UserLiveStatus;
use App\Models\social_media_link;
use App\Models\Live_Chat;
use App\Models\Chat_History;
use App\Models\ChatGroup;
use App\Models\FollowerCount;
use App\Models\WorkingExperience;
use App\Models\diploma_education;
use Illuminate\Support\Facades\Session;
use Carbon\Carbon;


class ChatController extends Controller
{

    public function set_status_live(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $date = date('Y-m-d H:i:s');
        UserLiveStatus::where('user_email', $session_emailId)->delete();

        UserLiveStatus::create([
            'user_email' => $session_emailId,
            'last_live_time_stmp' => 'Live',

        ]);

    }

    public function check_live(Request $request)
    {
        $user_email = $request->user_email_add;
        $isLive = 'false';
        $resultLiveStatus = UserLiveStatus::where('user_email', $user_email)->get();
        if ($resultLiveStatus) {
            foreach ($resultLiveStatus as $row) {

                $timeStmp = $row["updated_at"] . '';
                $date = date('Y-m-d H:i:s') . '';
                $timeFirst = strtotime($timeStmp);
                $timeSecond = strtotime($date);
                $differenceInSeconds = $timeSecond - $timeFirst;
                if ($differenceInSeconds < 15) {
                    $isLive = 'true';
                }

            }
        }

        echo $isLive;

    }

    public function getNewMessageCount()
    {
        $session_emailId = Session::get('emailId');
        $mailCount = Live_Chat::select('*')->where('receiver_email', '=', $session_emailId)->get();
        $mailRecCount = $mailCount->count();
        $data = array("msgCount" => $mailRecCount);
        print_r(json_encode($data));

    }
    public function checkRecMessageCount()
    {
        $session_emailId = Session::get('emailId');
        UserLiveStatus::updateOrCreate(
            ['user_email' => $session_emailId,],  // Condition to find the record
            ['updated_at' => now()]           // Attributes to update or add
        );
        //  $mailCount = Live_Chat::select('*')->where('receiver_email','=', $session_emailId)->get();

        // $mailCount = Live_Chat::where('receiver_email', '=', $session_emailId)->get();
        //   $mailRecCount = $mailCount->count();
        //$old=(int)Session::get('messagCount');
        $isNewMessage = 'false';
        $messageSenderEmail = "";
        $profile_image = "";
        $senderMessage = "";
        $createdAt = "";
        $fullName = "";
        $folderPath = "";
        $chatGroupId = "";
        $fileNames = [];
        $last = Live_Chat::select('*')->where('receiver_email', '=', $session_emailId)
            ->join('chat_groups', 'live_chat.chat_group_id', '=', 'chat_groups.chat_group_id')
            ->where('chat_groups.chat_type', '=', 'Single')
            ->get();
        // $last = Live_Chat::select('*')
        //     ->where('receiver_email', '=', $session_emailId)
        //     ->join('chat_groups', 'live_chat.chat_group_id', '=', 'chat_groups.chat_group_id')
        //     ->where('chat_groups.chat_type', '=', 'Single')
        //     ->where('live_chat.created_at', '>=', Carbon::now()->subMinute()) // Filter messages within the last minute
        //     ->get();
        // Live_Chat::where('receiver_email', $session_emailId)->orderBy('id', 'DESC')->get();
        if (count($last) > 0) {
            //   Session::put('messagCount', $mailRecCount);
            foreach ($last as $row) {
                $messageSenderEmail = $row['sender_email'];
                $senderMessage = $row['sended_text'];
                $createdAt = $row['created_at'];
                $isNewMessage = 'true';
                $folderPath = $row["images_path"];
                $chatGroupId = $row["chat_group_id"];
                break;
            }


            if ($folderPath != "Not Uploaded") {
                if (strlen($folderPath) != 0) {

                    $path = public_path($folderPath);
                    $files = array_slice(scandir($path), 2);

                    // Initialize an array to hold the file names


                    // Loop through the scanned files
                    foreach ($files as $file) {
                        // Exclude the current and parent directory references ('.' and '..')
                        if ($file !== '.' && $file !== '..') {
                            // Add the file name to the array
                            $fileNames[] = $file;
                        }
                    }

                }
            }


            /// Live_Chat::where([['receiver_email', $session_emailId], ['sender_email', $messageSenderEmail], ['created_at', $createdAt]])->delete();
            Live_Chat::where('receiver_email', $session_emailId)
                ->where('sended_text', $senderMessage)
                ->join('chat_groups', 'live_chat.chat_group_id', '=', 'chat_groups.chat_group_id')
                ->where('chat_groups.chat_type', '=', 'Single')
                ->delete();




                $resultProfile = UserModel::where('email_id', $messageSenderEmail)->get();
            if (count($resultProfile) > 0) {
                foreach ($resultProfile as $row) {
                    $profile_image = $row["profile_picture"];
                    $fullName = $row["first_name"] . " " . $row["second_name"];

                }

            }


            // else {
            //     $resultProfile = Organisation::where('email_id', $messageSenderEmail)->get();
            //     if (count($resultProfile) > 0) {
            //         foreach ($resultProfile as $row) {
            //             $profile_image = $row["profile_picture"];
            //             $fullName = $row["first_name"] . " " . $row["second_name"];
            //         }
            //     } else {
            //         $resultProfile = Education::where('email_id', $messageSenderEmail)->get();
            //         if (count($resultProfile) > 0) {
            //             foreach ($resultProfile as $row) {
            //                 $profile_image = $row["profile_picture"];
            //                 $fullName = $row["first_name"] . " " . $row["second_name"];
            //             }
            //         }
            //     }
            // }

            //Getting old chat.....................................................
            $chatHistoryWithUser = Chat_History::where([['sender_email', $session_emailId], ['receiver_email', $messageSenderEmail]])->orWhere([['sender_email', $messageSenderEmail], ['receiver_email', $session_emailId]])->get();
            // $data = array("msgCount" => $mailRecCount, "newMessage" => $isNewMessage, "sendEmailProfile" => $profile_image, "textMesage" => $senderMessage, "senderName" => $fullName, "sender_email_id" => $messageSenderEmail, "created_At" => $createdAt, "old_chat" => $chatHistoryWithUser,"photoList" => $fileNames,"ImagePath" => $folderPath);
            $data = array("messageType" => 'peer', "chatGroupId" => $chatGroupId, "newMessage" => $isNewMessage, "sendEmailProfile" => $profile_image, "textMesage" => $senderMessage, "senderName" => $fullName, "sender_email_id" => $messageSenderEmail, "created_At" => $createdAt, "old_chat" => $chatHistoryWithUser, "photoList" => $fileNames, "ImagePath" => $folderPath);
            print_r(json_encode($data));
        } else {
            $last = Live_Chat::select('*')->where('receiver_email', '=', $session_emailId)
                ->join('chat_groups', 'live_chat.chat_group_id', '=', 'chat_groups.chat_group_id')
                ->where('chat_groups.chat_type', '=', 'multiple')
                ->get();




            foreach ($last as $row) {
                $messageSenderEmail = $row['sender_email'];
                $senderMessage = $row['sended_text'];
                $createdAt = $row['created_at'];
                $isNewMessage = 'true';
                $folderPath = $row["images_path"];
                $chatGroupId = $row["chat_group_id"];
                break;
            }


            if ($folderPath != "Not Uploaded") {
                if (strlen($folderPath) != 0) {
                    $path = public_path($folderPath);
                    $files = array_slice(scandir($path), 2);
                    // Initialize an array to hold the file names
                    // Loop through the scanned files
                    foreach ($files as $file) {
                        // Exclude the current and parent directory references ('.' and '..')
                        if ($file !== '.' && $file !== '..') {
                            // Add the file name to the array
                            $fileNames[] = $file;
                        }
                    }

                }
            }
            Live_Chat::where('receiver_email', $session_emailId)
                ->where('sended_text', $senderMessage)
                ->join('chat_groups', 'live_chat.chat_group_id', '=', 'chat_groups.chat_group_id')
                ->where('chat_groups.chat_type', '=', 'multiple')
                ->delete();
            $resultProfile = UserModel::where('email_id', $messageSenderEmail)->get();
            if (count($resultProfile) > 0) {
                foreach ($resultProfile as $row) {
                    $profile_image = $row["profile_picture"];
                    $fullName = $row["first_name"] . " " . $row["second_name"];

                }

            }
            //  else {
            //     $resultProfile = Organisation::where('email_id', $messageSenderEmail)->get();
            //     if (count($resultProfile) > 0) {
            //         foreach ($resultProfile as $row) {
            //             $profile_image = $row["profile_picture"];
            //             $fullName = $row["first_name"] . " " . $row["second_name"];
            //         }
            //     } else {
            //         $resultProfile = Education::where('email_id', $messageSenderEmail)->get();
            //         if (count($resultProfile) > 0) {
            //             foreach ($resultProfile as $row) {
            //                 $profile_image = $row["profile_picture"];
            //                 $fullName = $row["first_name"] . " " . $row["second_name"];
            //             }
            //         }
            //     }
            // }

            $chatHistoryWithUser = Chat_History::where([['sender_email', $session_emailId], ['receiver_email', $messageSenderEmail]])->orWhere([['sender_email', $messageSenderEmail], ['receiver_email', $session_emailId]])->get();
            // $data = array("msgCount" => $mailRecCount, "newMessage" => $isNewMessage, "sendEmailProfile" => $profile_image, "textMesage" => $senderMessage, "senderName" => $fullName, "sender_email_id" => $messageSenderEmail, "created_At" => $createdAt, "old_chat" => $chatHistoryWithUser,"photoList" => $fileNames,"ImagePath" => $folderPath);
            $data = array("messageType" => 'group', "chatGroupId" => $chatGroupId, "newMessage" => $isNewMessage, "sendEmailProfile" => $profile_image, "textMesage" => $senderMessage, "senderName" => $fullName, "sender_email_id" => $messageSenderEmail, "created_At" => $createdAt, "old_chat" => $chatHistoryWithUser, "photoList" => $fileNames, "ImagePath" => $folderPath);
            print_r(json_encode($data));

        }
        //  echo $mailRecCount;
    }




    public function countUnreadMessaageCount(Request $request)
    {

        $emailArrayList = $request->input('emailArrayList');

        $emailStatus = [];
        $chatGroupId=[];
        foreach ($emailArrayList as $email) {
            $resultLiveStatus = UserLiveStatus::where('user_email', $email)->get();

            if (count($resultLiveStatus) > 0) {
                foreach ($resultLiveStatus as $row) {
                    $timeStmp = $row["updated_at"] . '';
                    $date = date('Y-m-d H:i:s') . '';
                    $timeFirst = strtotime($timeStmp);
                    $timeSecond = strtotime($date);
                    $differenceInSeconds = $timeSecond - $timeFirst;

                    if ($differenceInSeconds < 15) {


                        $emailStatus[$email] = 1;






                    } else {
                        $emailStatus[$email] = 0;

                    }


                }
            } else {
                $emailStatus[$email] = 0;

            }


        }

        $session_emailId = Session::get('emailId');
        $mailCount = Live_Chat::select('*')->where('receiver_email', '=', $session_emailId)->get();

        $mailRecCount = 0;
        if ($mailCount->count() > 0) {
            $mailRecCount = $mailCount->count();
        }
        $data = array("msgCount" => $mailRecCount);
        $data = array_merge_recursive($data, array('emailStatus' => $emailStatus));
        print_r(json_encode($data));
    }
    public function checkMessageForInboxPage(Request $request)
    {
        $session_emailId = Session::get('emailId');
        UserLiveStatus::updateOrCreate(
            ['user_email' => $session_emailId,],  // Condition to find the record
            ['updated_at' => now()]           // Attributes to update or add
        );
        $chat_group_id = $request->chat_group_id;
        $mailCount = Live_Chat::where('receiver_email', '=', $session_emailId)->get();
        $messageSenderEmail = "";
        $createdAt = "";
        $latestMessage = Live_Chat::where([['chat_group_id', $chat_group_id], ['receiver_email', $session_emailId]])->orderBy('id', 'DESC')->get();
        Live_Chat::where([['chat_group_id', $chat_group_id], ['receiver_email', $session_emailId]])->delete();


        $folderPath = "";
        if (count($latestMessage) > 0) {
            foreach ($latestMessage as $roww) {
                $folderPath = $roww["images_path"];
            }
        }

        $fileNames = [];
        if ($folderPath != "Not Uploaded") {
            if (strlen($folderPath) != 0) {

                $path = public_path($folderPath);
                $files = array_slice(scandir($path), 2);

                // Initialize an array to hold the file names


                // Loop through the scanned files
                foreach ($files as $file) {
                    // Exclude the current and parent directory references ('.' and '..')
                    if ($file !== '.' && $file !== '..') {
                        // Add the file name to the array
                        $fileNames[] = $file;
                    }
                }

            }
        }

        //    $data = array("latestMessage" => $latestMessage, "files" => $files);
        // $data = array(["latestMessage" => $latestMessage,"files" =>$files]);
        $data = array("latestMessage" => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath);

        print_r(json_encode($data));
        //  echo $mailRecCount;
    }




    //Getting ChatDialogTab1 chat from database

    public function getOldChatForDialogOne(Request $request)
    {
        $ChatArray = [];
        $fileNames = [];
        $session_emailId = Session::get('emailId');
        $sender_Email = $request->sender_email;
        $chatGroupIdd = $request->chatGroupId;
        $GroupMembersArray = [];

        if($chatGroupIdd!='peer'){
            $StatusGrou=ChatGroup::where('chat_group_id', $chatGroupIdd)->first();
            if($StatusGrou->chat_type=='Single'){
                $chatGroupIdd='peer';
            }
        }
        //Getting old chat.....................................................
        // $chatHistoryWithUser = Chat_History::where([['sender_email', $session_emailId], ['receiver_email', $sender_Email]])->orWhere([['sender_email', $sender_Email], ['receiver_email', $session_emailId]])->get();

           if($chatGroupIdd=='peer'){

            // $chatGroupId=  ChatGroup::where('chat_type', 'Single')
            // ->where(function ($query) use ($session_emailId, $sender_Email) {
            //     $query->where(function ($query) use ($session_emailId, $sender_Email) {
            //             $query->where('owner_email', $session_emailId)
            //                   ->where('participant_email', $sender_Email);
            //         })
            //         ->orWhere(function ($query) use ($session_emailId, $sender_Email) {
            //             $query->where('owner_email', $sender_Email)
            //                   ->where('participant_email', $session_emailId);
            //         });
            // })->first();
        //    $GroupId=ChatGroup::where('chat_type','=','Single')->where([['owner_email', $session_emailId], ['participant_email', $sender_Email]])->orWhere([['owner_email', $sender_Email], ['participant_email', $session_emailId]])->get();

        //    if(count($GroupId)>0){
        //     foreach ($GroupId as $row) {
        //         $chatGroupId=$row['chat_group_id'];
        //     }
        //   }

           //$chatHistoryWithUser = Chat_History::Where([['chat_group_id', $chatGroupId]])->get();
           $chatHistoryWithUser = Chat_History::join('chat_groups', function($join) use ($session_emailId, $sender_Email) {
            // Join condition where both tables have the same chat_group_id
            $join->on('chat_history.chat_group_id', '=', 'chat_groups.chat_group_id')
                 ->where(function($query) use ($session_emailId, $sender_Email) {
                     // Original query logic: where sender_email and receiver_email match either way
                     $query->where([
                         ['chat_history.sender_email', '=', $session_emailId],   // Use table alias here
                         ['chat_history.receiver_email', '=', $sender_Email]
                     ])
                     ->orWhere([
                         ['chat_history.sender_email', '=', $sender_Email],
                         ['chat_history.receiver_email', '=', $session_emailId]
                     ]);
                 });
        })
        ->where('chat_groups.chat_type', 'single')  // Filter for 'single' chat_type
        ->get();

          //  $chatHistoryWithUser = Chat_History::where([['sender_email', $session_emailId], ['receiver_email', $sender_Email]])->orWhere([['sender_email', $sender_Email], ['receiver_email', $session_emailId]])->get();

            $user_data = $this->returnUserInfo($sender_Email);

            $arrayToAdd = [
                'profile_img' => $user_data[0],
                'sender_name' => $user_data[1],

            ];
            $GroupMembersArray[] = $arrayToAdd;

        //    $GroupPersonalInfo = ChatGroup::Where([['chat_group_id', $chatGroupId]])->get();
        //    if (count($GroupPersonalInfo) > 0) {
        //        foreach ($GroupPersonalInfo as $row) {
        //            $email_id = $row['participant_email'];
        //            $sender_user_data = $this->returnUserInfo($email_id);
        //            $arrayToAdd = [
        //                'profile_img' => $sender_user_data[0],
        //                'sender_name' => $sender_user_data[1],

        //            ];
        //            $GroupMembersArray[] = $arrayToAdd;

        //        }
        //    }


        }else{
            $chatHistoryWithUser = Chat_History::select('*')->where([['sender_email', $session_emailId]])->orWhere([['receiver_email', $session_emailId]])->where('chat_history.chat_group_id', '=', $chatGroupIdd)->get();




            $GroupPersonalInfo = ChatGroup::Where('chat_group_id', '=',  $chatGroupIdd)->get();
            if (count($GroupPersonalInfo) > 0) {
                foreach ($GroupPersonalInfo as $row) {
                    $email_id = $row['participant_email'];
                    $sender_user_data = $this->returnUserInfo($email_id);
                    $arrayToAdd = [
                        'profile_img' => $sender_user_data[0],
                        'sender_name' => $sender_user_data[1],
                        'participant_email_add'=> $email_id,

                    ];
                    $GroupMembersArray[] = $arrayToAdd;
                }
            }
        }


        if (count($chatHistoryWithUser) > 0) {
            foreach ($chatHistoryWithUser as $row) {

                $folderPath = $row['images_path'];

                if ($folderPath != "Not Uploaded") {
                    if (strlen($folderPath) != 0) {

                        $path = public_path($folderPath);
                        $files = array_slice(scandir($path), 2);

                        // Initialize an array to hold the file names


                        // Loop through the scanned files
                        foreach ($files as $file) {
                            // Exclude the current and parent directory references ('.' and '..')
                            if ($file !== '.' && $file !== '..') {
                                // Add the file name to the array
                                $fileNames[] = $file;
                            }
                        }

                    }
                }


                $arrayToAdd = [
                    'sender_email' => $row['sender_email'],
                    'receiver_email' => $row['receiver_email'],
                    'sended_text' => $row['sended_text'],
                    'created_at' => $row['created_at'],
                    'updated_at' => $row['updated_at'],
                    'full_name' => $row['full_name'],
                    'profile_img' => $row['profile_img'],
                    'full_name_sender' => $row['full_name_sender'],
                    'profile_img_sender' => $row['profile_img_sender'],
                    'folderPath' => $row['images_path'],
                    'photoList' => $fileNames,


                ];

                $ChatArray[] = $arrayToAdd;
                $fileNames = [];
            }


        }



        $data = array("old_chat" => $ChatArray ,"chat_members" => $GroupMembersArray );
        print_r(json_encode($data));
    }



    public function deleteReadedChat(Request $request)
    {
        $senderEmail = $request->sender_email;
        $textMessage = $request->textMessage;
        $session_emailId = Session::get('emailId');
        Live_Chat::where([['sender_email', '=', $senderEmail], ['receiver_email', $session_emailId], ['sended_text', $textMessage]])->delete();


    }
    public function returnUserInfo($emailAdd)
    {
        $infoArray = [];
        $resultProfile = UserModel::where('email_id', $emailAdd)->get();
        $num_rows = count($resultProfile);
        if ($num_rows > 0) {
            foreach ($resultProfile as $row) {
                $infoArray[] = $row["profile_picture"];
                $infoArray[] = $row["first_name"] . " " . $row["second_name"];
            }

        }
        // else {
        //     $resultProfile = Organisation::where('email_id', $emailAdd)->get();
        //     $num_rows = count($resultProfile);
        //     if ($num_rows > 0) {
        //         foreach ($resultProfile as $row) {
        //             $infoArray[] = $row["profile_picture"];
        //             $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //         }
        //     } else {
        //         $resultProfile = Education::where('email_id', $emailAdd)->get();
        //         $num_rows = count($resultProfile);
        //         if ($num_rows > 0) {
        //             foreach ($resultProfile as $row) {
        //                 $infoArray[] = $row["profile_picture"];
        //                 $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //             }
        //         }
        //     }
        // }
        return $infoArray;
    }
    public function searchUser(Request $request)
    {

        $searchCriteria = $request->searchCriteria;
        $userInformationArray = [];

        $individuals = UserModel::where('email_id', 'like', '%' . $searchCriteria . '%')->orwhere('first_name', 'like', '%' . $searchCriteria . '%')->orwhere('second_name', 'like', '%' . $searchCriteria . '%')->get();
        if (count($individuals)) {
            foreach ($individuals as $row) {

                $singleUser = [
                    'receiver_email_id' => $row["email_id"],
                    'firstName' => $row["first_name"],
                    'lastName' => $row["second_name"],
                    'ProfilePicture' => $row["profile_picture"],

                ];

                $userInformationArray[] = $singleUser;
            }
        }


        // $orgnization = Organisation::where('email_id', 'like', '%' . $searchCriteria . '%')->orwhere('first_name', 'like', '%' . $searchCriteria . '%')->orwhere('second_name', 'like', '%' . $searchCriteria . '%')->get();
        // if (count($orgnization)) {
        //     foreach ($orgnization as $row) {

        //         $singleUser = [
        //             'receiver_email_id' => $row["email_id"],
        //             'firstName' => $row["first_name"],
        //             'lastName' => $row["second_name"],
        //             'ProfilePicture' => $row["profile_picture"],

        //         ];

        //         $userInformationArray[] = $singleUser;
        //     }
        // }



        // $education = Education::where('email_id', 'like', '%' . $searchCriteria . '%')->orwhere('first_name', 'like', '%' . $searchCriteria . '%')->orwhere('second_name', 'like', '%' . $searchCriteria . '%')->get();
        // if (count($education)) {
        //     foreach ($education as $row) {

        //         $singleUser = [
        //             'receiver_email_id' => $row["email_id"],
        //             'firstName' => $row["first_name"],
        //             'lastName' => $row["second_name"],
        //             'ProfilePicture' => $row["profile_picture"],

        //         ];

        //         $userInformationArray[] = $singleUser;
        //     }
        // }

        $data = array("searchUserData" => $userInformationArray);
        print_r(json_encode($data));


    }


    public function deleteChatGroupPeerToPeer(Request $request)
    {
        $chatGroupId = $request->chatGroupId;
        ChatGroup::where([['chat_group_id', $chatGroupId]])->delete();
          Chat_History::where([['chat_group_id', $chatGroupId]])->delete();
    }

    public function deleteUserFromChatGroup(Request $request)
    {
        $chatGroupId = $request->chatGroupId;
        $rec_email_add = $request->rec_email_add;
        Chat_History::where([['chat_group_id', $chatGroupId],['participant_email', $rec_email_add]])->delete();
        ChatGroup::where([['chat_group_id', $chatGroupId], ['participant_email', $rec_email_add]])->delete();

    }




    public function blockUserFromChatGroup(Request $request)
    {
        $chatGroupId = $request->chatGroupId;
        $rec_email_add = $request->rec_email_add;
        $action_value = $request->action_performed;

        ChatGroup::where([['chat_group_id', $chatGroupId], ['participant_email', $rec_email_add]])
            ->update([
                'is_user_block' => $action_value
            ]);


    }






    public function submitChat(Request $request)
    {
        $chatGroupId = 0;
        $session_emailId = Session::get('emailId');
        $fullName = "";
        $profile_image = "";
        $destination = "Not Uploaded";
        $pathSaveToDb = "Not Uploaded";
        $chat_text = $request->chatText;

        $to_send_email = null;
        $chat_group_id = null;
        $isChat_group_id = null;



        //logic sending message from message dialog box 3 at each pages..........................................
        if (isset($request->chat_group_id)) {
            $chat_group_id = $request->chat_group_id;
        } else if (isset($request->visiter_email)) {
            $to_send_email = $request->visiter_email;
        }
        if (isset($to_send_email)) {

            $checkGroup = ChatGroup::where([['owner_email', $session_emailId], ['participant_email', $to_send_email], ['chat_type', 'Single']])->orwhere([['owner_email', $to_send_email], ['participant_email', $session_emailId], ['chat_type', 'Single']])->get();
            if (count($checkGroup) == 0) {
                $chatGroupId = rand(10, 10000000000000);
                ChatGroup::create([
                    'chat_group_id' => $chatGroupId,
                    'owner_email' => $session_emailId,
                    'participant_email' => $to_send_email,
                    'chat_type' => 'Single',


                ]);
            }


            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
                $files = $_FILES['files'];
                $uploaded = [];
                $errors = [];
                foreach ($files['tmp_name'] as $index => $tmpName) {
                    $name = $files['name'][$index];
                    // $name = round(microtime(true)) . '.' . end($name);
                    $name = date('dmYHis') . str_replace(" ", "", $name);

                    //  $name = preg_replace('/[^\w\d_]/', '', $name);
                    $error = $files['error'][$index];




                    if ($error === UPLOAD_ERR_OK) {

                        $datee = date('Y-m-d_H_i_s') . '';
                        $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                        $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                        if (!file_exists($path)) {
                            mkdir($path, 0777, true);
                        }
                        $destination = $path . '/' . $name;
                        if (move_uploaded_file($tmpName, $destination)) {
                            $uploaded[] = $name;
                        }
                    }

                    if (!empty($uploaded)) {
                        echo "Uploaded files: " . implode(', ', $uploaded);
                    }
                    if (!empty($errors)) {
                        echo "Errors: " . implode(', ', $errors);
                    }
                }
            } else {
                $destination = "Not Uploaded";
            }




            $resultForChatGroupId = ChatGroup::where([['owner_email', $session_emailId], ['participant_email', $to_send_email], ['chat_type', 'Single']])->get();
            if (count($resultForChatGroupId) > 0) {
                foreach ($resultForChatGroupId as $row) {
                    $isChat_group_id = $row["chat_group_id"];
                    break;

                }
                $session_user_data = $this->returnUserInfo($session_emailId);
                $sender_user_data = $this->returnUserInfo($to_send_email);

                Live_Chat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $to_send_email,
                    'sended_text' => $chat_text,
                    'full_name' => $session_user_data[1],
                    'profile_img' => $session_user_data[0],
                    'full_name_sender' => $sender_user_data[1],
                    'profile_img_sender' => $sender_user_data[0],
                    'images_path' => $pathSaveToDb,
                    'chat_group_id' => $isChat_group_id,

                ]);

                Chat_History::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $to_send_email,
                    'sended_text' => $chat_text,
                    'full_name' => $session_user_data[1],
                    'profile_img' => $session_user_data[0],
                    'full_name_sender' => $sender_user_data[1],
                    'profile_img_sender' => $sender_user_data[0],
                    'images_path' => $pathSaveToDb,
                    'chat_group_id' => $isChat_group_id,


                ]);



            } else {

                $resultProfile = ChatGroup::where([['owner_email', $to_send_email], ['participant_email', $session_emailId], ['chat_type', 'Single']])->get();
                $num_rows = count($resultProfile);
                // if ($num_rows == 0) {

                //     $chatGroupId = rand(10, 10000000000000);
                //     ChatGroup::create([
                //         'chat_group_id' => $chatGroupId,
                //         'owner_email' => $session_emailId,
                //         'participant_email' => $to_send_email,
                //         'chat_type' => 'Single',


                //     ]);
                // }
                if (count($resultProfile) > 0) {
                    foreach ($resultProfile as $row) {
                        $chatGroupId = $row["chat_group_id"];
                        break;

                    }
                }

                $session_user_data = $this->returnUserInfo($session_emailId);
                $sender_user_data = $this->returnUserInfo($to_send_email);

                Live_Chat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $to_send_email,
                    'sended_text' => $chat_text,
                    'full_name' => $session_user_data[1],
                    'profile_img' => $session_user_data[0],
                    'full_name_sender' => $sender_user_data[1],
                    'profile_img_sender' => $sender_user_data[0],
                    'images_path' => $pathSaveToDb,
                    'chat_group_id' => $chatGroupId,

                ]);

                Chat_History::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $to_send_email,
                    'sended_text' => $chat_text,
                    'full_name' => $session_user_data[1],
                    'profile_img' => $session_user_data[0],
                    'full_name_sender' => $sender_user_data[1],
                    'profile_img_sender' => $sender_user_data[0],
                    'images_path' => $pathSaveToDb,
                    'chat_group_id' => $chatGroupId,

                ]);

            }
        }
        if (isset($chat_group_id)) {
            if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
                $files = $_FILES['files'];
                $uploaded = [];
                $errors = [];
                foreach ($files['tmp_name'] as $index => $tmpName) {
                    $name = $files['name'][$index];
                    // $name = round(microtime(true)) . '.' . end($name);
                    $name = date('dmYHis') . str_replace(" ", "", $name);

                    //  $name = preg_replace('/[^\w\d_]/', '', $name);
                    $error = $files['error'][$index];




                    if ($error === UPLOAD_ERR_OK) {

                        $datee = date('Y-m-d_H_i_s') . '';
                        $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                        $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                        if (!file_exists($path)) {
                            mkdir($path, 0777, true);
                        }
                        $destination = $path . '/' . $name;
                        if (move_uploaded_file($tmpName, $destination)) {
                            $uploaded[] = $name;
                        }
                    }

                    if (!empty($uploaded)) {
                        echo "Uploaded files: " . implode(', ', $uploaded);
                    }
                    if (!empty($errors)) {
                        echo "Errors: " . implode(', ', $errors);
                    }
                }
            } else {
                $destination = "Not Uploaded";
            }
            $sender_email_array = [];
            $resultForChatGroupId = ChatGroup::where([['chat_group_id', $chat_group_id]])->get();
            if (count($resultForChatGroupId) > 0) {
                foreach ($resultForChatGroupId as $row) {
                    if ($session_emailId != $row["participant_email"]) {
                        $sender_email_array[] = $row["participant_email"];
                    } else if ($session_emailId != $row["owner_email"]) {
                        $sender_email_array[] = $row["owner_email"];
                    }

                }

                for ($k = 0; $k < count($sender_email_array); $k++) {


                    $session_user_data = $this->returnUserInfo($session_emailId);
                    $sender_user_data = $this->returnUserInfo($sender_email_array[$k]);


                    $IsUserBlock = "NO";
                    $chatGroupForId = ChatGroup::where('owner_email', '=', $sender_email_array[$k])->orwhere('participant_email', '=', $sender_email_array[$k])->Where('chat_group_id', '=', $chat_group_id)->get();
                    if (count($chatGroupForId)) {
                        foreach ($chatGroupForId as $rowID) {
                            $IsUserBlock = $rowID['is_user_block'];
                            break;
                        }

                    }

                    if ($IsUserBlock == "NO") {
                        Live_Chat::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $sender_email_array[$k],
                            'sended_text' => $chat_text,
                            'full_name' => $session_user_data[1],
                            'profile_img' => $session_user_data[0],
                            'full_name_sender' => $sender_user_data[1],
                            'profile_img_sender' => $sender_user_data[0],
                            'images_path' => $pathSaveToDb,
                            'chat_group_id' => $chat_group_id,

                        ]);

                        Chat_History::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $sender_email_array[$k],
                            'sended_text' => $chat_text,
                            'full_name' => $session_user_data[1],
                            'profile_img' => $session_user_data[0],
                            'full_name_sender' => $sender_user_data[1],
                            'profile_img_sender' => $sender_user_data[0],
                            'images_path' => $pathSaveToDb,
                            'chat_group_id' => $chat_group_id,


                        ]);
                    }
                }



            }
            //..........................................................................................................
        }
        $data = array("chatGroupId" => $chatGroupId);
        print_r(json_encode($data));
    }



    public function addUserToGroup(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $email_id = $request->email_id;
        $group_id = $request->group_id;

        $owner_email = '';
        $isAlreadyAdd = ChatGroup::where([['chat_group_id', $group_id], ['participant_email', $email_id]])->get();


        if (count($isAlreadyAdd) == 0) {
            $ChatGroupAdmin = ChatGroup::where('chat_group_id', '=', $group_id)->get();


            foreach ($ChatGroupAdmin as $rowRec) {
                $owner_email = $rowRec["owner_email"];
                break;
            }


            ChatGroup::create([
                'chat_group_id' => $group_id,
                'owner_email' => $owner_email,
                'participant_email' => $email_id,
                'chat_type' => 'multiple',


            ]);

            $group = ChatGroup::where('chat_group_id', $group_id)
                ->where('owner_email', $owner_email)
                ->first();

            if ($group) {
                // Update the record
                $group->chat_type = 'multiple'; // Example update
                // Save the changes
                $group->save();
                // Optionally, you can return a response or redirect

            }

        }
    }

    public function inboxmessages()
    {


        $emailAddList = array();
        $InboxUserArray = [];
        $chatGroupIdArray = [];
        $chatGroupType = [];
        $isUserBlockArray = [];
        $email_id = Session::get('emailId');
        $isLastMessageRead = 'TRUE';
        $lastMessage = "";
        $messageDate = "";


        $chatGroup = ChatGroup::where('owner_email', '=', $email_id)->orWhere('participant_email', '=', $email_id)->get();


        if (count($chatGroup)) {

            foreach ($chatGroup as $row) {
                $emailAdd = $row["owner_email"];
                if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
                    array_push($emailAddList, $emailAdd);
                    $chatGroupId = $row["chat_group_id"];
                    array_push($chatGroupIdArray, $chatGroupId);
                    array_push($chatGroupType, $row["chat_type"]);
                    array_push($isUserBlockArray, $row["is_user_block"]);


                }

                $emailAdd = $row["participant_email"];
                if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
                    array_push($emailAddList, $emailAdd);
                    $chatGroupId = $row["chat_group_id"];
                    array_push($chatGroupIdArray, $chatGroupId);
                    array_push($chatGroupType, $row["chat_type"]);
                    array_push($isUserBlockArray, $row["is_user_block"]);
                }



            }
        }



        for ($i = 0; $i < count($emailAddList); $i++) {


            if ($chatGroupType[$i] == "Single") {
                $individual = UserModel::where('email_id', $emailAddList[$i])->get();
                if (count($individual)) {
                    foreach ($individual as $row) {
                        $profile_image = $row["profile_picture"];
                        $firstName = $row["first_name"];
                        $secondName = $row["second_name"];
                        $account_status= $row["account_status"];
                        break;

                    }
                }

                // else {

                //     $orginazation = Organisation::where('email_id', $emailAddList[$i])->get();
                //     if (count($orginazation)) {
                //         foreach ($orginazation as $row) {
                //             $profile_image = $row["profile_picture"];
                //             $firstName = $row["first_name"];
                //             $secondName = $row["second_name"];
                //             $account_status= $row["account_status"];
                //             break;

                //         }

                //     } else {
                //         $education = Education::where('email_id', $emailAddList[$i])->get();
                //         if (count($education)) {
                //             foreach ($education as $row) {
                //                 $profile_image = $row["profile_picture"];
                //                 $firstName = $row["first_name"];
                //                 $secondName = $row["second_name"];
                //                 break;

                //             }

                //         }

                //     }

                // }


                $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();
                if (count($chatGroup)) {

                    foreach ($chatGroup as $row) {
                        $lastMessage = $row["sended_text"];
                        $isLastMessageRead = 'FALSE';
                        $messageDate = $row["created_at"];
                        break;

                    }
                } else {


                    $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();

                    if (count($chatGroup)) {
                        foreach ($chatGroup as $row) {
                            $lastMessage = $row["sended_text"];
                            $messageDate = $row["created_at"];
                            break;

                        }
                    }


                }


                // Create a DateTime object from the string
                $date = new \DateTime($messageDate);

                // Format the date to the desired format
                $formattedDate = $date->format('d/m/Y H:i:s');
                $arrayToAdd = [
                    'receiver_email_id' => $emailAddList[$i],
                    'fullName' => $firstName . ' ' . $secondName,
                    'ProfilePicture' => $profile_image,
                    'isLastMessageRead' => $isLastMessageRead,
                    'lastMessage' => $lastMessage,
                    'messageDate' => $formattedDate,
                    'ChatGroupId' => $chatGroupIdArray[$i],
                    'ChatGroupType' => $chatGroupType[$i],
                    'AccountStatus' =>   $account_status,


                ];


                $InboxUserArray[] = $arrayToAdd;

            } else {
                $groupUserArray = [];
                $isLastMessageRead = 'TRUE';
                // /...................................................................
                $chatGroupId = $chatGroupIdArray[$i];
                $chatGroupProfile = ChatGroup::where('chat_group_id', '=', $chatGroupId)->get();
                if (count($chatGroupProfile)) {
                    foreach ($chatGroupProfile as $row) {

                        if ($row['participant_email'] != $email_id) {
                            $individual = UserModel::where('email_id', $row['participant_email'])->get();
                        } else if ($row['owner_email'] != $email_id) {
                            $individual = UserModel::where('email_id', $row['owner_email'])->get();
                        }


                        if (count($individual)) {
                            foreach ($individual as $row) {
                                $profile_image = $row["profile_picture"];
                                $firstName = $row["first_name"];
                                $secondName = $row["second_name"];
                                $IsUserBlock = "NO";
                                $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                                if (count($chatGroupForId)) {
                                    foreach ($chatGroupForId as $rowID) {
                                        $IsUserBlock = $rowID['is_user_block'];
                                        break;
                                    }

                                }
                                $arrayToAddGroupUser = [
                                    'receiver_email_id' => $row["email_id"],
                                    'fullName' => $firstName . ' ' . $secondName,
                                    'ProfilePicture' => $profile_image,
                                    'IsUserBlock' => $IsUserBlock,

                                ];

                                $groupUserArray[] = $arrayToAddGroupUser;

                            }
                        }





                        // if ($row['participant_email'] != $email_id) {
                        //     $orginazation = Organisation::where('email_id', $row['participant_email'])->get();
                        // } else if ($row['owner_email'] != $email_id) {
                        //     $orginazation = Organisation::where('email_id', $row['owner_email'])->get();
                        // }
                        // //  $orginazation = Organisation::where('email_id', $row['participant_email'])->orwhere('email_id', $row['owner_email'])->get();
                        // if (count($orginazation)) {
                        //     foreach ($orginazation as $row) {
                        //         $profile_image = $row["profile_picture"];
                        //         $firstName = $row["first_name"];
                        //         $secondName = $row["second_name"];

                        //         $IsUserBlock = "NO";
                        //         $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                        //         if (count($chatGroupForId)) {
                        //             foreach ($chatGroupForId as $rowID) {
                        //                 $IsUserBlock = $rowID['is_user_block'];
                        //                 break;
                        //             }

                        //         }
                        //         $arrayToAddGroupUser = [
                        //             'receiver_email_id' => $row["email_id"],
                        //             'fullName' => $firstName . ' ' . $secondName,
                        //             'ProfilePicture' => $profile_image,
                        //             'IsUserBlock' => $IsUserBlock,


                        //         ];

                        //         $groupUserArray[] = $arrayToAddGroupUser;


                        //     }

                        // }



                        // if ($row['participant_email'] != $email_id) {
                        //     $education = Education::where('email_id', $row['participant_email'])->get();
                        // } else if ($row['owner_email'] != $email_id) {
                        //     $education = Education::where('email_id', $row['owner_email'])->get();
                        // }
                        // //$education = Education::where('email_id', $row['participant_email'])->orwhere('email_id', $row['owner_email'])->get();
                        // if (count($education)) {
                        //     foreach ($education as $row) {
                        //         $profile_image = $row["profile_picture"];
                        //         $firstName = $row["first_name"];
                        //         $secondName = $row["second_name"];
                        //         $IsUserBlock = "NO";
                        //         $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                        //         if (count($chatGroupForId)) {
                        //             foreach ($chatGroupForId as $rowID) {
                        //                 $IsUserBlock = $rowID['is_user_block'];
                        //                 break;
                        //             }

                        //         }
                        //         $arrayToAddGroupUser = [
                        //             'receiver_email_id' => $row["email_id"],
                        //             'fullName' => $firstName . ' ' . $secondName,
                        //             'ProfilePicture' => $profile_image,
                        //             'IsUserBlock' => $IsUserBlock,


                        //         ];
                        //         $groupUserArray[] = $arrayToAddGroupUser;

                        //     }

                        // }





                        // $arrayToAddGroupUser = [
                        //     'receiver_email_id' => $emailAddList[$i],
                        //     'fullName' => $firstName . ' ' . $secondName,
                        //     'ProfilePicture' => $profile_image,

                        // ];
                        // $groupUserArray[] = $arrayToAddGroupUser;




                        // Geting last message from group chat........................................................

                        $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();
                        if (count($chatGroup)) {

                            foreach ($chatGroup as $row) {
                                $lastMessage = $row["sended_text"];
                                $isLastMessageRead = 'FALSE';
                                $messageDate = $row["created_at"];
                                break;

                            }
                        }
                        //........................................................................................................





                    }
                }



                if ($isLastMessageRead == 'TRUE') {

                    $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();

                    if (count($chatGroup)) {
                        foreach ($chatGroup as $row) {
                            $lastMessage = $row["sended_text"];
                            $messageDate = $row["created_at"];
                            break;

                        }
                    }
                }


                //adding array
                $date = new \DateTime($messageDate);
                $formattedDate = $date->format('d/m/Y H:i:s');
                $arrayToAdd = [
                    'chatGroupUserInfo' => $groupUserArray,
                    'isLastMessageRead' => $isLastMessageRead,
                    'lastMessage' => $lastMessage,
                    'messageDate' => $formattedDate,
                    'ChatGroupId' => $chatGroupIdArray[$i],
                    'ChatGroupType' => $chatGroupType[$i],

                ];

                $InboxUserArray[] = $arrayToAdd;

                //........................................................................

            }
        }


        return view('TestingMessages')->with(['InboxUserArray' => $InboxUserArray]);



    }




    public function inboxmessagesmobile()
    {
        $email_id = Session::get('emailId');
        $mailCount = Live_Chat::where('receiver_email', '=', $email_id)->get();
        $mailRecCount = $mailCount->count();
        Session::put('messagCount', $mailRecCount);

        $profile_image = '';
        $firstName = "";
        $secondName = "";
        $cityName = "";
        $countryName = "";
        $statusDes = "";
        $acountType = "";
        $company_name = "";
        $entriseprise_email = "";
        $entreprise_name = "";
        $entreprise_web_url = "";

        $individual = UserModel::where('email_id', $email_id)->get();

        if ($individual) {
            foreach ($individual as $row) {
                $profile_image = $row["profile_picture"];
                $firstName = $row["first_name"];
                $secondName = $row["second_name"];
                $cityName = $row["city_name"];
                $countryName = $row["country_name"];
            }

            $experience = WorkingExperience::where([
                'email_address' => $email_id

            ])->get();


            $job_title = "";
            $jobDes1 = "";
            $jobDes2 = "";
            $jobDes3 = "";
            $bool1 = false;
            $bool2 = false;
            $bool3 = false;
            if ($experience) {
                foreach ($experience as $roww) {
                    $job_title = $roww["job_title"];
                    $company_name = $roww["company"];
                    $from_sa = $roww["from_year"];
                    $to_sa = $roww["to_year"];
                    $toRec = $roww["most_rec"];
                    if ($toRec == 'L') {
                        $jobDes1 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                    } else {
                        if ($bool1 == false) {
                            $jobDes2 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool1 = true;
                        } else if ($bool2 == false) {
                            $jobDes3 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool2 = true;
                        } else if ($bool3 == false) {
                            $jobDes1 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                        }
                    }
                }
            }


            $dipDes1 = "";
            $dipDes2 = "";
            $dipDes3 = "";
            $bool1 = false;
            $bool2 = false;
            $experience = diploma_education::where([
                'email_address' => $email_id

            ])->get();


            if ($experience) {
                foreach ($experience as $roww) {
                    $inst_name = $roww["Institution_name"];
                    $dip_name = $roww["diploma_name"];
                    $from_sa = $roww["from_year"];
                    $to_sa = $roww["to_year"];
                    $toRec = $roww["most_rec"];
                    if ($toRec == 'L') {
                        $dipDes1 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                    } else {
                        if ($bool1 == false) {
                            $dipDes2 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool1 = true;
                        } else if ($bool2 == false) {
                            $dipDes3 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool2 = true;
                        } else if ($bool3 == false) {
                            $dipDes1 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                        }
                    }
                }

            }







            $statusDes = $job_title . ' , ' . $company_name;
            $acountType = "personal";

        }


        // $organisation = Organisation::where('email_id', $email_id)->get();

        // $civi_address = "";
        // $org_structure = "";

        // if ($organisation) {
        //     foreach ($organisation as $row) {
        //         $profile_image = $row["profile_picture"];
        //         $firstName = $row["first_name"];
        //         $secondName = $row["second_name"];
        //         $cityName = $row["city_name"];
        //         $countryName = $row["country_name"];
        //         $civi_address = $row["civic_adress"];
        //         $org_structure = $row["org_structure"];
        //         $statusDes = $civi_address . ' , ' . $org_structure;

        //         $entriseprise_email = $row["entriseprise_email"];
        //         $entreprise_name = $row["entreprise_name"];
        //         $entreprise_web_url = $row["entreprise_web_url"];

        //         $acountType = "org";
        //     }

        // }

        // $education = Education::where('email_id', $email_id)->get();

        // $civi_address = "";
        // $instituationLevel = "";

        // if ($education) {

        //     foreach ($education as $row) {

        //         $profile_image = $row["profile_picture"];
        //         $firstName = $row["first_name"];
        //         $secondName = $row["second_name"];
        //         $cityName = $row["city_name"];
        //         $countryName = $row["country_name"];
        //         $civi_address = $row["civic_adress"];
        //         $instituationLevel = $row["institutionlevel"];
        //         $acountType = "edu";
        //         $statusDes = $civi_address . ' , ' . $instituationLevel;
        //     }


        // }



        if ($profile_image != "") {
            $profile_image = 'ProfileImages/Images/' . $profile_image;
        } else {
            $profile_image = 'ProfileImages/Images/default.png';
        }


        $fullName = $firstName . ' ' . $secondName;
        $myFullName = $fullName;
        $cityCountryName = $cityName . ', ' . $countryName;

        $newMessageCount = array();


        $messageRecordsSender = Chat_History::where('receiver_email', '!=', $email_id)->Where('sender_email', $email_id)->distinct()->get(['receiver_email', 'profile_img_sender', 'full_name_sender']);
        $messageRecordsRec = Chat_History::where('receiver_email', $email_id)->Where('sender_email', '!=', $email_id)->distinct()->get(['sender_email', 'profile_img', 'full_name']);










        return view('livechat/messagemobile')

            ->with('fullName', $fullName)
            ->with('myFullName', $myFullName)
            ->with('cityCountryName', $cityCountryName)
            ->with('email_id', $email_id)
            ->with('profile_image', $profile_image)
            ->with('firstName', $firstName)
            ->with('secondName', $secondName)
            ->with('cityName', $cityName)
            ->with('countryName', $countryName)
            ->with('statusDes', $statusDes)
            ->with('acountType', $acountType)
            ->with('exp1', $jobDes1)
            ->with('exp2', $jobDes2)
            ->with('exp3', $jobDes3)
            ->with('dip1', $dipDes1)
            ->with('dip2', $dipDes2)
            ->with('dip3', $dipDes3)
            ->with('entriseprise_email', $entriseprise_email)
            ->with('entreprise_name', $entreprise_name)
            ->with('entreprise_web_url', $entreprise_web_url)
            ->with('inboxChatSend', $messageRecordsSender)
            ->with('inboxChatRec', $messageRecordsRec)
            ->with('toWhomWithChatEmail', null);

    }












    function check_replay_back(Request $request)
    {
        $user_email = $request->user_email_check;
        $Session_Email_id = Session::get('emailId');
        $resultSet = Live_Chat::where([['sender_email', '=', $user_email], ['receiver_email', $Session_Email_id]])->get();
        $message = "";
        $dateTime = "";
        $fullName = "";
        $profile_img = "";
        $isFound = "false";
        if ($resultSet) {
            foreach ($resultSet as $row) {
                $message = $row["sended_text"];
                $dateTime = $row["created_at"];
                $fullName = $row["full_name"];
                $profile_img = $row["profile_img"];
                $isFound = "true";
            }
            $profile_image = 'ProfileImages/Images/' . $profile_img;
            Live_Chat::where([['sender_email', '=', $user_email], ['receiver_email', $Session_Email_id]])->delete();
            $data = array("isFound" => $isFound, "messageTxt" => $message, "dateTime" => $dateTime, "fullName" => $fullName, "profile_pic" => $profile_image);
            print_r(json_encode($data));

        }
    }
    function DeleteChatGroup()
    {

        $chat_goup_id = $_POST['chatGroupId'];
        ChatGroup::where([['chat_group_id', $chat_goup_id]])->delete();
        Chat_History::where([['chat_group_id', $chat_goup_id]])->delete();
        return redirect()->route('inboxmessages');

    }
    function ShowUserMessages()
    {

        $Session_Email_id = Session::get('emailId');
        $chat_goup_id = $_POST['chat_group_id'];
        $reciverEmailArrays = [];
        $participantDataArray = [];
        $chatGroup = ChatGroup::where([['chat_group_id', $chat_goup_id]])->get();
        if (count($chatGroup)) {
            foreach ($chatGroup as $row) {
                if ($Session_Email_id != $row["participant_email"]) {
                    $reciverEmailArrays[] = $row["participant_email"];
                } else if ($Session_Email_id != $row["owner_email"]) {
                    $reciverEmailArrays[] = $row["owner_email"];
                }



            }
        }


        //checking is user is alive....................
        // $isLive = 'Offline';
        // $resultLiveStatus = UserLiveStatus::where('user_email', $chat_email_id)->get();
        // if ($resultLiveStatus) {
        //     foreach ($resultLiveStatus as $row) {
        //         $timeStmp = $row["updated_at"] . '';
        //         $date = date('Y-m-d H:i:s') . '';
        //         $timeFirst = strtotime($timeStmp);
        //         $timeSecond = strtotime($date);
        //         $differenceInSeconds = $timeSecond - $timeFirst;
        //         if ($differenceInSeconds < 15) {
        //             $isLive = 'Online';
        //         }
        //     }
        // }

        //Getting user profile information..........................

        for ($i = 0; $i < count($reciverEmailArrays); $i++) {
            $individual = UserModel::where('email_id', $reciverEmailArrays[$i])->get();
            if (count($individual)) {
                foreach ($individual as $row) {
                    $profile_image_user = $row["profile_picture"];
                    $firstName = $row["first_name"];
                    $secondName = $row["second_name"];
                    $cityName = $row["city_name"];
                    $countryName = $row["country_name"];
                    $rec_email = $row["email_id"];


                }
            }

            // else {
            //     $organisation = Organisation::where('email_id', $reciverEmailArrays[$i])->get();
            //     if (count($organisation)) {
            //         foreach ($organisation as $row) {
            //             $profile_image_user = $row["profile_picture"];
            //             $firstName = $row["first_name"];
            //             $secondName = $row["second_name"];
            //             $cityName = $row["city_name"];
            //             $countryName = $row["country_name"];
            //             $rec_email = $row["email_id"];

            //         }
            //     } else {
            //         $education = Education::where('email_id', $reciverEmailArrays[$i])->get();
            //         if (count($education)) {
            //             foreach ($education as $row) {
            //                 $profile_image_user = $row["profile_picture"];
            //                 $firstName = $row["first_name"];
            //                 $secondName = $row["second_name"];

            //             }
            //         }
            //     }

            // }
            $arrayRow = [
                'rec_email_id' => $rec_email,
                'fullName' => $firstName . ' ' . $secondName,
                'ProfilePicture' => $profile_image_user,




            ];

            $participantDataArray[] = $arrayRow;
        }



        //Geting left side panel information.....................................................................
        // $emailAddList = array();
        // $InboxUserArray = [];
        // $chatGroupIdArray = [];
        // $chatGroupType = [];
        // $email_id = Session::get('emailId');
        // $isLastMessageRead = 'TRUE';
        // $lastMessage = "";
        // $messageDate = "";
        // $profile_image = "";

        // $chatGroup = ChatGroup::where('owner_email', '=', $email_id)->orWhere('participant_email', '=', $email_id)->get();

        // if (count($chatGroup)) {

        //     foreach ($chatGroup as $row) {
        //         $emailAdd = $row["owner_email"];
        //         if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
        //             array_push($emailAddList, $emailAdd);
        //             $chatGroupId = $row["chat_group_id"];
        //             array_push($chatGroupIdArray, $chatGroupId);
        //             array_push($chatGroupType, $row["chat_type"]);


        //         }

        //         $emailAdd = $row["participant_email"];
        //         if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
        //             array_push($emailAddList, $emailAdd);
        //             $chatGroupId = $row["chat_group_id"];
        //             array_push($chatGroupIdArray, $chatGroupId);
        //             array_push($chatGroupType, $row["chat_type"]);

        //         }



        //     }
        // }

        // for ($i = 0; $i < count($emailAddList); $i++) {
        //     if ($chatGroupType[$i] == "Single") {
        //         $individual = Individual::where('email_id', $emailAddList[$i])->get();
        //         if (count($individual)) {
        //             foreach ($individual as $row) {
        //                 $profile_image = $row["profile_picture"];
        //                 $firstName = $row["first_name"];
        //                 $secondName = $row["second_name"];

        //                 break;

        //             }
        //         } else {

        //             $orginazation = Organisation::where('email_id', $emailAddList[$i])->get();
        //             if (count($orginazation)) {
        //                 foreach ($orginazation as $row) {
        //                     $profile_image = $row["profile_picture"];
        //                     $firstName = $row["first_name"];
        //                     $secondName = $row["second_name"];
        //                     break;

        //                 }

        //             } else {
        //                 $education = Education::where('email_id', $emailAddList[$i])->get();
        //                 if (count($education)) {
        //                     foreach ($education as $row) {
        //                         $profile_image = $row["profile_picture"];
        //                         $firstName = $row["first_name"];
        //                         $secondName = $row["second_name"];
        //                         break;

        //                     }

        //                 }

        //             }

        //         }


        //         $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();
        //         if (count($chatGroup)) {

        //             foreach ($chatGroup as $row) {
        //                 $lastMessage = $row["sended_text"];
        //                 $isLastMessageRead = 'TRUE';
        //                 $messageDate = $row["created_at"];
        //                 break;

        //             }
        //         } else {


        //             $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();

        //             if (count($chatGroup)) {
        //                 foreach ($chatGroup as $row) {
        //                     $lastMessage = $row["sended_text"];
        //                     $messageDate = $row["created_at"];
        //                     break;

        //                 }
        //             }


        //         }


        //         // Create a DateTime object from the string
        //         $date = new \DateTime($messageDate);

        //         // Format the date to the desired format
        //         $formattedDate = $date->format('d/m/Y H:i:s');
        //         $arrayToAdd = [
        //             'receiver_email_id' => $emailAddList[$i],
        //             'fullName' => $firstName . ' ' . $secondName,
        //             'ProfilePicture' => $profile_image,
        //             'isLastMessageRead' => $isLastMessageRead,
        //             'lastMessage' => $lastMessage,
        //             'messageDate' => $formattedDate,
        //             'ChatGroupId' => $chatGroupIdArray[$i],
        //             'ChatGroupType' => $chatGroupType[$i],

        //         ];

        //         $InboxUserArray[] = $arrayToAdd;

        //     } else {
        //         $groupUserArray = [];
        //         $chatGroupId = $chatGroupIdArray[$i];
        //         $chatGroupProfile = ChatGroup::where('owner_email', '=', $email_id)->where('chat_group_id', '=', $chatGroupId)->get();
        //         if (count($chatGroupProfile)) {
        //             foreach ($chatGroupProfile as $row) {


        //                 $individual = Individual::where('email_id', $row['participant_email'])->get();
        //                 if (count($individual)) {
        //                     foreach ($individual as $row) {
        //                         $profile_image = $row["profile_picture"];
        //                         $firstName = $row["first_name"];
        //                         $secondName = $row["second_name"];

        //                         break;

        //                     }
        //                 } else {

        //                     $orginazation = Organisation::where('email_id', $row['participant_email'])->get();
        //                     if (count($orginazation)) {
        //                         foreach ($orginazation as $row) {
        //                             $profile_image = $row["profile_picture"];
        //                             $firstName = $row["first_name"];
        //                             $secondName = $row["second_name"];
        //                             break;

        //                         }

        //                     } else {
        //                         $education = Education::where('email_id', $row['participant_email'])->get();
        //                         if (count($education)) {
        //                             foreach ($education as $row) {
        //                                 $profile_image = $row["profile_picture"];
        //                                 $firstName = $row["first_name"];
        //                                 $secondName = $row["second_name"];
        //                                 break;

        //                             }

        //                         }

        //                     }

        //                 }

        //                 $arrayToAddGroupUser = [
        //                     'receiver_email_id' => $emailAddList[$i],
        //                     'fullName' => $firstName . ' ' . $secondName,
        //                     'ProfilePicture' => $profile_image,

        //                 ];
        //                 $groupUserArray[] = $arrayToAddGroupUser;
        //             }
        //         }

        //         //adding array



        //         // Geting last message from group chat........................................................

        //         $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();
        //         if (count($chatGroup)) {

        //             foreach ($chatGroup as $row) {
        //                 $lastMessage = $row["sended_text"];
        //                 $isLastMessageRead = 'FALSE';
        //                 $messageDate = $row["created_at"];
        //                 break;

        //             }
        //         }
        //         //........................................................................................................

        //         if ($isLastMessageRead == 'TRUE') {

        //             $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id]])->get();

        //             if (count($chatGroup)) {
        //                 foreach ($chatGroup as $row) {
        //                     $lastMessage = $row["sended_text"];
        //                     $messageDate = $row["created_at"];
        //                     break;

        //                 }
        //             }
        //         }

        //         $date = new \DateTime($messageDate);
        //         $formattedDate = $date->format('d/m/Y H:i:s');
        //              $arrayToAdd = [
        //                 'chatGroupUserInfo' => $groupUserArray,
        //                 'isLastMessageRead' => $isLastMessageRead,
        //                 'lastMessage' => $lastMessage,
        //                  'messageDate' => $formattedDate,
        //                 'ChatGroupId' => $chatGroupIdArray[$i],
        //                 'ChatGroupType' => $chatGroupType[$i],

        //             ];

        //             $InboxUserArray[] = $arrayToAdd;


        //     }
        // }

        $emailAddList = array();
        $InboxUserArray = [];
        $chatGroupIdArray = [];
        $chatGroupType = [];
        $isUserBlockArray = [];
        $email_id = Session::get('emailId');
        $isLastMessageRead = 'TRUE';
        $lastMessage = "";
        $messageDate = "";


        $chatGroup = ChatGroup::where('owner_email', '=', $email_id)->orWhere('participant_email', '=', $email_id)->get();


        if (count($chatGroup)) {

            foreach ($chatGroup as $row) {
                $emailAdd = $row["owner_email"];
                if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
                    array_push($emailAddList, $emailAdd);
                    $chatGroupId = $row["chat_group_id"];
                    array_push($chatGroupIdArray, $chatGroupId);
                    array_push($chatGroupType, $row["chat_type"]);
                    //    array_push($isUserBlockArray, $row["is_user_block"]);

                }

                $emailAdd = $row["participant_email"];
                if ($emailAdd != $email_id && !in_array($row["chat_group_id"], $chatGroupIdArray)) {
                    array_push($emailAddList, $emailAdd);
                    $chatGroupId = $row["chat_group_id"];
                    array_push($chatGroupIdArray, $chatGroupId);
                    array_push($chatGroupType, $row["chat_type"]);
                    //  array_push($isUserBlockArray, $row["is_user_block"]);
                }



            }
        }



        for ($i = 0; $i < count($emailAddList); $i++) {

            if ($chatGroupType[$i] == "Single") {
                $individual = UserModel::where('email_id', $emailAddList[$i])->get();
                if (count($individual)) {
                    foreach ($individual as $row) {
                        $profile_image = $row["profile_picture"];
                        $firstName = $row["first_name"];
                        $secondName = $row["second_name"];
                        $account_status= $row["account_status"];
                        break;

                    }
                }


                // else {

                //     $orginazation = Organisation::where('email_id', $emailAddList[$i])->get();
                //     if (count($orginazation)) {
                //         foreach ($orginazation as $row) {
                //             $profile_image = $row["profile_picture"];
                //             $firstName = $row["first_name"];
                //             $secondName = $row["second_name"];
                //             $account_status= $row["account_status"];
                //             break;

                //         }

                //     } else {
                //         $education = Education::where('email_id', $emailAddList[$i])->get();
                //         if (count($education)) {
                //             foreach ($education as $row) {
                //                 $profile_image = $row["profile_picture"];
                //                 $firstName = $row["first_name"];
                //                 $secondName = $row["second_name"];
                //                 break;

                //             }

                //         }

                //     }

                // }


                $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id], ['chat_group_id', $chat_goup_id]])->get();
                if (count($chatGroup)) {

                    foreach ($chatGroup as $row) {
                        $lastMessage = $row["sended_text"];
                        $isLastMessageRead = 'FALSE';
                        $messageDate = $row["created_at"];
                        break;

                    }
                } else {


                    $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id], ['chat_group_id', $chat_goup_id]])->get();

                    if (count($chatGroup)) {
                        foreach ($chatGroup as $row) {
                            $lastMessage = $row["sended_text"];
                            $messageDate = $row["created_at"];
                            break;

                        }
                    }


                }


                // Create a DateTime object from the string
                $date = new \DateTime($messageDate);

                // Format the date to the desired format
                $formattedDate = $date->format('d/m/Y H:i:s');
                $arrayToAdd = [
                    'receiver_email_id' => $emailAddList[$i],
                    'fullName' => $firstName . ' ' . $secondName,
                    'ProfilePicture' => $profile_image,
                    'isLastMessageRead' => $isLastMessageRead,
                    'lastMessage' => $lastMessage,
                    'messageDate' => $formattedDate,
                    'ChatGroupId' => $chatGroupIdArray[$i],
                    'ChatGroupType' => $chatGroupType[$i],
                    'AccountStatus'=>$account_status,

                ];


                $InboxUserArray[] = $arrayToAdd;

            } else {
                $groupUserArray = [];
                $isLastMessageRead = 'TRUE';
                // /...................................................................
                $chatGroupId = $chatGroupIdArray[$i];
                $chatGroupProfile = ChatGroup::where('chat_group_id', '=', $chatGroupId)->get();
                if (count($chatGroupProfile)) {
                    foreach ($chatGroupProfile as $row) {

                        if ($row['participant_email'] != $email_id) {
                            $individual = UserModel::where('email_id', $row['participant_email'])->get();
                        } else if ($row['owner_email'] != $email_id) {
                            $individual = UserModel::where('email_id', $row['owner_email'])->get();
                        }


                        if (count($individual)) {
                            foreach ($individual as $row) {
                                $profile_image = $row["profile_picture"];
                                $firstName = $row["first_name"];
                                $secondName = $row["second_name"];
                                $IsUserBlock = 'NO';
                                $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                                if (count($chatGroupForId)) {
                                    foreach ($chatGroupForId as $rowID) {
                                        $IsUserBlock = $rowID['is_user_block'];
                                        break;
                                    }

                                }

                                $arrayToAddGroupUser = [
                                    'receiver_email_id' => $row["email_id"],
                                    'fullName' => $firstName . ' ' . $secondName,
                                    'ProfilePicture' => $profile_image,
                                    'IsUserBlock' => $IsUserBlock,

                                ];
                                $groupUserArray[] = $arrayToAddGroupUser;

                            }
                        }





                        // if ($row['participant_email'] != $email_id) {
                        //     $orginazation = Organisation::where('email_id', $row['participant_email'])->get();
                        // } else if ($row['owner_email'] != $email_id) {
                        //     $orginazation = Organisation::where('email_id', $row['owner_email'])->get();
                        // }
                        // //  $orginazation = Organisation::where('email_id', $row['participant_email'])->orwhere('email_id', $row['owner_email'])->get();
                        // if (count($orginazation)) {
                        //     foreach ($orginazation as $row) {
                        //         $profile_image = $row["profile_picture"];
                        //         $firstName = $row["first_name"];
                        //         $secondName = $row["second_name"];
                        //         $IsUserBlock = 'NO';
                        //         $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                        //         if (count($chatGroupForId)) {
                        //             foreach ($chatGroupForId as $rowID) {
                        //                 $IsUserBlock = $rowID['is_user_block'];
                        //                 break;
                        //             }

                        //         }
                        //         $arrayToAddGroupUser = [
                        //             'receiver_email_id' => $row["email_id"],
                        //             'fullName' => $firstName . ' ' . $secondName,
                        //             'ProfilePicture' => $profile_image,
                        //             'IsUserBlock' => $IsUserBlock,

                        //         ];
                        //         $groupUserArray[] = $arrayToAddGroupUser;


                        //     }

                        // }



                        // if ($row['participant_email'] != $email_id) {
                        //     $education = Education::where('email_id', $row['participant_email'])->get();
                        // } else if ($row['owner_email'] != $email_id) {
                        //     $education = Education::where('email_id', $row['owner_email'])->get();
                        // }
                        // //$education = Education::where('email_id', $row['participant_email'])->orwhere('email_id', $row['owner_email'])->get();
                        // if (count($education)) {
                        //     foreach ($education as $row) {
                        //         $profile_image = $row["profile_picture"];
                        //         $firstName = $row["first_name"];
                        //         $secondName = $row["second_name"];
                        //         $IsUserBlock = 'NO';
                        //         $chatGroupForId = ChatGroup::where('owner_email', '=', $row["email_id"])->orwhere('participant_email', '=', $row["email_id"])->Where('chat_group_id', '=', $chatGroupId)->get();
                        //         if (count($chatGroupForId)) {
                        //             foreach ($chatGroupForId as $rowID) {
                        //                 $IsUserBlock = $rowID['is_user_block'];
                        //                 break;
                        //             }

                        //         }
                        //         $arrayToAddGroupUser = [
                        //             'receiver_email_id' => $row["email_id"],
                        //             'fullName' => $firstName . ' ' . $secondName,
                        //             'ProfilePicture' => $profile_image,
                        //             'IsUserBlock' => $IsUserBlock,

                        //         ];
                        //         $groupUserArray[] = $arrayToAddGroupUser;

                        //     }

                        // }





                        // $arrayToAddGroupUser = [
                        //     'receiver_email_id' => $emailAddList[$i],
                        //     'fullName' => $firstName . ' ' . $secondName,
                        //     'ProfilePicture' => $profile_image,

                        // ];
                        // $groupUserArray[] = $arrayToAddGroupUser;




                        // Geting last message from group chat........................................................

                        $chatGroup = Live_Chat::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id], ['chat_group_id', $chat_goup_id]])->get();
                        if (count($chatGroup)) {

                            foreach ($chatGroup as $row) {
                                $lastMessage = $row["sended_text"];
                                $isLastMessageRead = 'FALSE';
                                $messageDate = $row["created_at"];
                                break;

                            }
                        }
                        //........................................................................................................





                    }
                }



                if ($isLastMessageRead == 'TRUE') {

                    $chatGroup = Chat_History::where([['sender_email', $emailAddList[$i]], ['receiver_email', $email_id], ['chat_group_id', $chat_goup_id]])->get();

                    if (count($chatGroup)) {
                        foreach ($chatGroup as $row) {
                            $lastMessage = $row["sended_text"];
                            $messageDate = $row["created_at"];
                            break;

                        }
                    }
                }


                //adding array
                $date = new \DateTime($messageDate);
                $formattedDate = $date->format('d/m/Y H:i:s');
                $arrayToAdd = [
                    'chatGroupUserInfo' => $groupUserArray,
                    'isLastMessageRead' => $isLastMessageRead,
                    'lastMessage' => $lastMessage,
                    'messageDate' => $formattedDate,
                    'ChatGroupId' => $chatGroupIdArray[$i],
                    'ChatGroupType' => $chatGroupType[$i],

                ];

                $InboxUserArray[] = $arrayToAdd;

                //........................................................................

            }
        }


        //............................................................................................................................


        //     $messageRecordsSender = Chat_History::where('receiver_email', '!=', $email_id)->Where('sender_email', $email_id)->distinct()->get(['receiver_email', 'profile_img_sender', 'full_name_sender']);
        // $messageRecordsRec = Chat_History::where('receiver_email', $email_id)->Where('sender_email', '!=', $email_id)->distinct()->get(['sender_email', 'profile_img', 'full_name']);


        // $messageRecordsSender = Chat_History::where([['receiver_email', '=', $Session_Email_id], ['chat_group_id', '=', $chat_goup_id]])->orWhere([['chat_group_id', '=', $chat_goup_id], ['sender_email', '=', $Session_Email_id]])->orderBy('id', 'asc')->get();

        $messageRecordsSender = Chat_History::where([['chat_group_id', '=', $chat_goup_id]])->orderBy('id', 'asc')->get()->unique('sended_text');
        ;


        //    if (count($messageRecordsSender)) {
        //     foreach ($messageRecordsSender as $row) {
        //         $text= $row["sended_text"];
        //         echo  $text;

        //     }
        // }

        // die;




        return view('TestingMessages')->with([

            'participantPersonalInfomation' => $participantDataArray,
            'messageHistory' => $messageRecordsSender,

            'InboxUserArray' => $InboxUserArray,
            'chat_group_id' => $chat_goup_id,


        ]);



    }


    function ChatGroupLeft(Request $request){
        $Session_Email_id = Session::get('emailId');
        $groupChatId=$request->GroupId;

        ChatGroup::where('chat_group_id', $groupChatId)->where('participant_email', $Session_Email_id)->delete();
        Chat_History::where([['chat_group_id', $groupChatId],['receiver_email', $Session_Email_id]])->orWhere([['chat_group_id', $groupChatId],['sender_email', $Session_Email_id]])->delete();
        return $this->inboxmessages();
    }
    function ShowUserMessagesMobile()
    {
        $Session_Email_id = Session::get('emailId');
        $chat_email_id = $_GET['userEmailId'];
        Live_Chat::where([['receiver_email', '=', $Session_Email_id], ['sender_email', $chat_email_id]])->delete();

        $chatHistory = Chat_History::where([['sender_email', $chat_email_id], ['receiver_email', $Session_Email_id]])->orWhere([['sender_email', $Session_Email_id], ['receiver_email', $chat_email_id]])->get();
        $email_id = Session::get('emailId');
        $mailCount = Live_Chat::where('receiver_email', '=', $email_id)->get();
        $mailRecCount = $mailCount->count();
        Session::put('messagCount', $mailRecCount);
        $profile_image = '';
        $firstName = "";
        $secondName = "";
        $cityName = "";
        $countryName = "";
        $statusDes = "";
        $acountType = "";
        $company_name = "";
        $entriseprise_email = "";
        $entreprise_name = "";
        $entreprise_web_url = "";
        $individual = UserModel::where('email_id', $email_id)->get();
        if ($individual) {
            foreach ($individual as $row) {
                $profile_image = $row["profile_picture"];
                $firstName = $row["first_name"];
                $secondName = $row["second_name"];
                $cityName = $row["city_name"];
                $countryName = $row["country_name"];
            }

            $experience = WorkingExperience::where([
                'email_address' => $email_id

            ])->get();
            $job_title = "";
            $jobDes1 = "";
            $jobDes2 = "";
            $jobDes3 = "";
            $bool1 = false;
            $bool2 = false;
            $bool3 = false;
            if ($experience) {
                foreach ($experience as $roww) {
                    $job_title = $roww["job_title"];
                    $company_name = $roww["company"];
                    $from_sa = $roww["from_year"];
                    $to_sa = $roww["to_year"];
                    $toRec = $roww["most_rec"];
                    if ($toRec == 'L') {
                        $jobDes1 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                    } else {
                        if ($bool1 == false) {
                            $jobDes2 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool1 = true;
                        } else if ($bool2 == false) {
                            $jobDes3 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool2 = true;
                        } else if ($bool3 == false) {
                            $jobDes1 = $job_title . ' at ' . $company_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                        }
                    }
                }
            }
            $dipDes1 = "";
            $dipDes2 = "";
            $dipDes3 = "";
            $bool1 = false;
            $bool2 = false;
            $experience = diploma_education::where([
                'email_address' => $email_id

            ])->get();


            if ($experience) {
                foreach ($experience as $roww) {
                    $inst_name = $roww["Institution_name"];
                    $dip_name = $roww["diploma_name"];
                    $from_sa = $roww["from_year"];
                    $to_sa = $roww["to_year"];
                    $toRec = $roww["most_rec"];
                    if ($toRec == 'L') {
                        $dipDes1 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                    } else {
                        if ($bool1 == false) {
                            $dipDes2 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool1 = true;
                        } else if ($bool2 == false) {
                            $dipDes3 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                            $bool2 = true;
                        } else if ($bool3 == false) {
                            $dipDes1 = $dip_name . '  ' . $inst_name . '<br>' . '(' . $from_sa . ' to ' . $to_sa . ')';
                        }
                    }
                }

            }







            $statusDes = $job_title . ' , ' . $company_name;
            $acountType = "personal";

        }


        // $organisation = Organisation::where('email_id', $email_id)->get();

        // $civi_address = "";
        // $org_structure = "";

        // if ($organisation) {
        //     foreach ($organisation as $row) {
        //         $profile_image = $row["profile_picture"];
        //         $firstName = $row["first_name"];
        //         $secondName = $row["second_name"];
        //         $cityName = $row["city_name"];
        //         $countryName = $row["country_name"];
        //         $civi_address = $row["civic_adress"];
        //         $org_structure = $row["org_structure"];
        //         $statusDes = $civi_address . ' , ' . $org_structure;

        //         $entriseprise_email = $row["entriseprise_email"];
        //         $entreprise_name = $row["entreprise_name"];
        //         $entreprise_web_url = $row["entreprise_web_url"];

        //         $acountType = "org";
        //     }

        // }

        // $education = Education::where('email_id', $email_id)->get();

        // $civi_address = "";
        // $instituationLevel = "";

        // if ($education) {

        //     foreach ($education as $row) {

        //         $profile_image = $row["profile_picture"];
        //         $firstName = $row["first_name"];
        //         $secondName = $row["second_name"];
        //         $cityName = $row["city_name"];
        //         $countryName = $row["country_name"];
        //         $civi_address = $row["civic_adress"];
        //         $instituationLevel = $row["institutionlevel"];
        //         $acountType = "edu";
        //         $statusDes = $civi_address . ' , ' . $instituationLevel;
        //     }


        // }



        if ($profile_image != "") {
            $profile_image = 'ProfileImages/Images/' . $profile_image;
        } else {
            $profile_image = 'ProfileImages/Images/default.png';
        }


        $fullName = $firstName . ' ' . $secondName;
        $myFullName = $fullName;
        $cityCountryName = $cityName . ', ' . $countryName;



        $messageRecordsSender = Chat_History::where('receiver_email', '!=', $email_id)->Where('sender_email', $email_id)->distinct()->get(['receiver_email', 'profile_img_sender', 'full_name_sender']);
        $messageRecordsRec = Chat_History::where('receiver_email', $email_id)->Where('sender_email', '!=', $email_id)->distinct()->get(['sender_email', 'profile_img', 'full_name']);

        return view('livechat/chatmobile')
            ->with('profile_user_email_id', $chat_email_id)
            ->with('fullName', $fullName)
            ->with('myFullName', $myFullName)
            ->with('cityCountryName', $cityCountryName)
            ->with('email_id', $email_id)
            ->with('profile_image', $profile_image)
            ->with('firstName', $firstName)
            ->with('secondName', $secondName)
            ->with('cityName', $cityName)
            ->with('countryName', $countryName)
            ->with('statusDes', $statusDes)
            ->with('acountType', $acountType)
            ->with('exp1', $jobDes1)
            ->with('exp2', $jobDes2)
            ->with('exp3', $jobDes3)
            ->with('dip1', $dipDes1)
            ->with('dip2', $dipDes2)
            ->with('dip3', $dipDes3)
            ->with('entriseprise_email', $entriseprise_email)
            ->with('entreprise_name', $entreprise_name)
            ->with('entreprise_web_url', $entreprise_web_url)
            ->with('inboxChatSend', $messageRecordsSender)
            ->with('chatHistory', $chatHistory)
            ->with('inboxChatRec', $messageRecordsRec)
            ->with('toWhomWithChatEmail', $chat_email_id);

    }

}
