<?php
// Update your ChatifyPopupController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ChMessage as Message;
use App\Models\ChFavorite as Favorite;
use Chatify\Facades\ChatifyMessenger as Chatify;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Str;

class ChatifyPopupController extends Controller
{
    /**
     * Get popup chat view
     */
    public function index()
    {
        return view('chatify-popup.popup');
    }

    /**
     * Get contacts list for popup
     */
    public function getContacts(Request $request)
    {
        //$users = User::where('id', '!=', Auth::user()->id)->get();
        $friendsList = [];
        $users = Message::join('users',  function ($join) {
            $join->on('ch_messages.from_id', '=', 'users.id')
                ->orOn('ch_messages.to_id', '=', 'users.id');
        })
            ->where(function ($q) {
                $q->where('ch_messages.from_id', Auth::user()->id)
                    ->orWhere('ch_messages.to_id', Auth::user()->id);
            })
            ->where('users.id','!=',Auth::user()->id)
            ->select('users.*',DB::raw('MAX(ch_messages.created_at) max_created_at'))
            ->orderBy('max_created_at', 'desc')
            ->groupBy('users.id')->get();
        foreach ($users as $user) {
            $lastMessage = Message::where('to_id', Auth::user()->id)
                ->where('from_id', $user->id)

                ->orWhere('from_id', Auth::user()->id)
                ->where('to_id', $user->id)
                ->orderBy('updated_at', 'DESC')
                ->first();
            $userAvatar = Chatify::getUserWithAvatar($user)->avatar;
            array_push($friendsList, [
                'user' => $user,
                'avatar' => $userAvatar,
                'lastMessage' => $lastMessage->body ? $lastMessage->body : 'Attachment',
                'lastMessageDate' => $lastMessage ? $lastMessage->created_at->diffForHumans() : null,
            ]);
        }

        return Response::json([
            'contacts' => $friendsList,
        ], 200);
    }

    /**
     * Get messages for a specific user
     */
    public function getMessages(Request $request)
    {
        $user_id = $request->user_id;

        // Make sure we're using the correct query to get messages
        // This ensures proper filtering of conversations between the two users
        $query = Message::where(function($q) use ($user_id) {
            $q->where('from_id', Auth::user()->id)
                ->where('to_id', $user_id);
        })->orWhere(function($q) use ($user_id) {
            $q->where('from_id', $user_id)
                ->where('to_id', Auth::user()->id);
        });

        // Order by creation date to show messages chronologically
        $messages = $query->orderBy('created_at', 'asc')->get();

        // Debug the messages - remove this in production
        /*return Response::json([
             'count' => $messages->count(),
             'messages' => $messages
         ], 200);*/

        $messagesHTML = '';
        foreach ($messages as $message) {
            if ($message->attachment){
                $attch = json_decode($message->attachment);
                $src = Chatify::getAttachmentUrl($attch->new_name);
                $arr = explode('.',$attch->old_name);
                $ext = end($arr);
                $img = array('png','jpg','jpeg','gif');
                $download = route('chatify.download',$attch->new_name);
                if (in_array($ext,$img)){
                    $type = "image";
                }else{
                    $type =  "file";
                }
                if ($type == "image"){
                    $attachment = "<img style='width: 200px; height: 150px' src='$src'>";
                }else{
                    $attachment = "<a href='$download' class='file-download'><span class='fas fa-file'></span> $attch->old_name</a>";
                }
            }else{
                $attachment = '';
            }
            $fromMe = $message->from_id == Auth::user()->id ? 'from-me' : 'from-other';
            $messagesHTML .= '<div class="message-item '.$fromMe.'">';
            $messagesHTML .= '<div class="message-bubble">'.($message->body ?: '').' '.$attachment.'</div>';
            $messagesHTML .= '<div class="message-time">'.$message->created_at->format('g:i A').'</div>';
            $messagesHTML .= '</div>';
        }

        // If no messages, show a placeholder
        if (empty($messagesHTML)) {
            $messagesHTML = '<div class="no-messages-placeholder">No messages yet. Start the conversation!</div>';
        }

        return Response::json([
            'messages' => $messagesHTML,
        ], 200);
    }

    /**
     * Send a message
     */
    public function sendMessage(Request $request)
    {
        // Default values
        $attachment = null;
        $attachment_title = null;

        // If there is an attachment
        if ($request->hasFile('file')) {
            // Upload attachment
            $attachment = Str::uuid() . "." . $request->file('file')->getClientOriginalExtension();
            $attachment_title = $request->file('file')->getClientOriginalName();
            $request->file('file')->storeAs(config('chatify.attachments.folder'), $attachment, config('chatify.storage_disk_name'));
        }

        // Send the message
        $messageData = [
            'from_id' => Auth::user()->id,
            'to_id' => $request->user_id,
            'body' => $request->message,
            'attachment' => ($attachment) ? json_encode((object)[
                'new_name' => $attachment,
                'old_name' => $attachment_title,
            ]) : null,
        ];

        $message = Chatify::newMessage($messageData);

        return Response::json([
            'status' => true,
            'message' => $message
        ], 200);
    }
    public function download($fileName)
    {
        $filePath = config('chatify.attachments.folder') . '/' . $fileName;
        if (Chatify::storage()->exists($filePath)) {
            return Chatify::storage()->download($filePath);
        }
        return abort(404, "Sorry, File does not exist in our server or may have been deleted!");
    }
}
