<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PeerToPeerVideoCall;
use App\Models\PeerToPeerVideoCallChat;
use Illuminate\Support\Facades\Session;
use App\Models\Organisation;
use App\Models\Video_Chat;
use App\Models\Education;
use App\Models\UserModel;
use App\Models\MeetingLinks;
use App\Models\StudentClassInfo;
use App\Models\Video_Call_Entry_Scheduling;
use App\Models\Video_Call_Entry_Classroom;
use App\Models\NormalMeetingVideoCallChat;
use App\Models\VideosRecordingEntries;

use Carbon\Carbon;
class ClassRoomVideoCallsChat extends Controller
{
    public function generateClassRoomLink(Request $request)
    {
        $meetingDate = $request->datepicker;
        $meetingTime = $request->meetingTime;
        $className = $request->class_room_name;
        $fullName = $request->fullName;
        $profilePic = $request->profilePic;
        $meetingType = $request->link_type;
        $session_emailId = Session::get('emailId');
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $generated_Link = '';
        $length = 10;
        for ($i = 0; $i < $length; $i++) {
            $generated_Link .= $characters[random_int(0, $charactersLength - 1)];
        }
        $usr_id = rand(10, 10000);
        $session_user_data = $this->returnUserInfo($session_emailId);
        //$newformat = date('Y-m-d',$meetingDate);
        $newformat = date('Y-m-d', strtotime($meetingDate));
       $dataRecord= StudentClassInfo::where('class_name', '=', $className)->where('owner_email', '=', $session_emailId)->get();
       if(count($dataRecord)){
        foreach ($dataRecord as $row) {
            $rec_full_name="";
            $rec_profile_pic="";
            $user_data = $this->returnUserInfo( $row["student_email"]);
            MeetingLinks::create([
                'email_id' => $session_emailId,
                'participant_email' => $row["student_email"],
                'participant_name' => $user_data[1],
                'meeting_date' => $newformat,
                'meeting_time' => $meetingTime,
                'participant_profile_pic' => $user_data[0],
                'generated_link' => $generated_Link,
                'link_type' => $meetingType,
                'caller_profile_pic' => $session_user_data[0],
                'caller_name' => $session_user_data[1],
                'user_id' => $usr_id,
                'class_id'=>$row["id"],
                'Is_Call_Accepted'=>true,

            ]);
        }
    }

        return redirect()->route('ScheduleMeeting');
    }


public function returnUserInfo($emailAdd)
{
    $infoArray = [];
    $resultProfile = UserModel::where('email_id', $emailAdd)->get();
    $num_rows = count($resultProfile);
    if ($num_rows > 0) {
        foreach ($resultProfile as $row) {
            $infoArray[] = $row["profile_picture"];
            $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        }
    }

    // else {
    //     $resultProfile = Organisation::where('email_id', $emailAdd)->get();
    //     $num_rows = count($resultProfile);
    //     if ($num_rows > 0) {
    //         foreach ($resultProfile as $row) {
    //             $infoArray[] = $row["profile_picture"];
    //             $infoArray[] = $row["first_name"] . " " . $row["second_name"];
    //         }
    //     } else {
    //         $resultProfile = Education::where('email_id', $emailAdd)->get();
    //         $num_rows = count($resultProfile);
    //         if ($num_rows > 0) {
    //             foreach ($resultProfile as $row) {
    //                 $infoArray[] = $row["profile_picture"];
    //                 $infoArray[] = $row["first_name"] . " " . $row["second_name"];
    //             }
    //         }
    //     }
    // }
    return $infoArray;
}
}
?>