<?php

namespace App\Http\Controllers;

use App\Models\Education;
use Illuminate\Http\Request;
use App\Models\Follower;
use App\Models\FollowerCount;
use App\Models\UserModel;
use App\Models\Organisation;
use App\Models\WorkingExperience;
use Illuminate\Support\Facades\Session;

class FollowerController extends Controller
{

    // View Followers Info
    public function FollowersInfo(Request $request){
        $searchCtr = 'All';

        $session_criteria = Session::get('criteria');
        $session_emailId = Session::get('emailId');

        if (isset($session_criteria)) {
            $searchCtr = $session_criteria;
            Session::put('criteria', NULL);
        }

        $email_id = "";
        if(isset($session_emailId) && !empty($session_emailId)) {
            $email_id = $session_emailId;
        }

        $profile_image = '';
        $firstName = "";
        $secondName = "";
        $cityName = "";
        $countryName = "";
        $statusDes = "";
        $acountType = "";

        $result = UserModel::where('email_id', $email_id)->get();

        if ($result) {
            foreach($result as $row) {
                $profile_image = $row["profile_picture"];
                $firstName = $row["first_name"];
                $secondName = $row["second_name"];
                $cityName = $row["city_name"];
                $countryName = $row["country_name"];
            }

            $result1 = WorkingExperience::where([
                'email_address' => $email_id,
                'most_rec' => 'T'
            ])->get();

            $job_title = "";
            $company_name = "";

            if ($result1) {
                foreach($result1 as $roww) {
                    $job_title = $roww["job_title"];
                    $company_name = $roww["company"];
                }
            }

            $statusDes = $job_title.' , '.$company_name;
            $acountType = "personal";

        }
        // else{

        // $result = Organisation::where('email_id', $email_id)->get();

        // $civi_address = "";
        // $org_structure = "";

        // if ($result) {
        //     foreach($result as $row) {
        //         $profile_image = $row["profile_picture"];
        //         $firstName = $row["first_name"];
        //         $secondName = $row["second_name"];
        //         $cityName = $row["city_name"];
        //         $countryName = $row["country_name"];
        //         $civi_address = $row["civic_adress"];
        //         $org_structure = $row["org_structure"];
        //     }
        //     $statusDes = $civi_address.' , '.$org_structure;
        //     $acountType = "org";
        // }
        //     // else {

        //         $result = Education::where('email_id', $email_id)->get();

        //         $civi_address = "";
        //         $instituationLevel = "";

        //         if ($result) {
        //             foreach($result as $row) {
        //                 $profile_image = $row["profile_picture"];
        //                 $firstName = $row["first_name"];
        //                 $secondName = $row["second_name"];
        //                 $cityName = $row["city_name"];
        //                 $countryName = $row["country_name"];
        //                 $civi_address = $row["civic_adress"];
        //                 $instituationLevel = $row["institutionlevel"];
        //             }
        //             $statusDes = $civi_address.' , '.$instituationLevel;
        //             $acountType = "edu";
        //         }
            // }
        // }

        if($profile_image != ""){
            $profile_image = 'ProfileImages/Images/'.$profile_image;
        }else{
            $profile_image = 'ProfileImages/Images/default.png';
        }

        $fullName = $firstName.' '.$secondName;
        $cityCountryName = $cityName.', '.$countryName;

        return view('FollowersInfo')
            ->with('profile_image', $profile_image)
            ->with('cityName', $cityName)
            ->with('countryName', $countryName)
            ->with('fullName', $fullName)
            ->with('cityCountryName', $cityCountryName)
            ->with('email_id', $email_id)
            ->with('searchCtr', $searchCtr)
            ->with('statusDes', $statusDes);
    }


    // Check Followers
    public function CheckFollower(Request $request){
        $emailID = $request->emailID;
        $followerEmailID = $request->followerEmail;

        $result = Follower::where([
            'email_id' => $emailID,
            'follower_email_id' => $followerEmailID
        ])->get();

        if (count($result)>0) {
            echo "yes";
        }
        else {
            echo "no";
        }
    }

    // Add To Followers
    public function FollowsAddToDb(Request $request){

        $emailID = $request->emailID;
        $followerEmailId = $request->followerEmailId;

        $result = FollowerCount::where('email_id', $emailID)->get();

        if (count($result)>0) {
            foreach($result as $row) {
                $followersCount = (int)$row["F_Count"];
                $followersCount = $followersCount+1;
                FollowerCount::where('email_id', $emailID)->update([
                    'F_Count' => $followersCount
                ]);

            }
        }
        else {
            FollowerCount::create([
                'email_id' => $emailID,
                'F_Count' => '1'
            ]);
        }

        Follower::create([
            'email_id' => $emailID,
            'follower_email_id' => $followerEmailId,
        ]);

    }

    // Remove From Followers
    public function UnFollowsAddToDb(Request $request){
        $emailID = $request->emailID;
        $followerEmailId = $request->followerEmailId;

        $result = FollowerCount::where('email_id', $emailID)->get();

        if (count($result)>0) {
            foreach($result as $row) {
                $followersCount = (int)$row["F_Count"];
                if($followersCount > 0){
                    $followersCount = $followersCount-1;

                    FollowerCount::where('email_id', $emailID)->update([
                        'F_Count' => $followersCount
                    ]);
                }

            }
        }

        Follower::where([
            'email_id' => $emailID,
            'follower_email_id' => $followerEmailId
        ])->delete();

    }
}
