<?php

namespace App\Http\Controllers;

use App\Models\Education;
use App\Models\Follower;
use App\Models\FollowerCount;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\ChatController;
use App\Models\WorkingExperience;
use App\Models\Live_Chat;
use App\Models\diploma_education;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\UserLiveStatus;
use App\Models\Chat_History;
use App\Models\profile_images;
use App\Models\Cover_Images;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\social_media_link;
use App\Models\PostData;
class LobbyPageController extends Controller
{



    public function uploadlobbyIntroductionVideoRecorded(Request $request)
    {
        $session_emailId = Session::get('emailId');
        // Check if the file is sent via POST
        if (isset($_FILES['file'])) {
            // Get the uploaded file details
            $file = $_FILES['file'];

            // Set the destination path (for example, in the current directory)
            $uploadPath = 'lobbyroomdata/' . $session_emailId;
            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true); // Create directory if it doesn't exist
            }
            $uploadPath = 'lobbyroomdata/' . $session_emailId . '/' . $request->videoName;
            // Move the uploaded file from the temporary location to the target location
            if (move_uploaded_file($file['tmp_name'], $uploadPath)) {
                // Successfully saved
                $data = array("success" => true, "message" => 'Introduction video uploaded successfully!');
                print_r(json_encode($data));
            } else {
                // Error saving the file
                $data = array("success" => false, "message" => 'Error moving the uploaded file.');
                print_r(json_encode($data));
            }
        } else {
            // If no file is received
            $data = array("success" => false, "message" => 'Error moving the uploaded file.');
            print_r(json_encode($data));
        }



    }
    public function uploadlobbyIntroductionVideo(Request $request)
    {
        $session_emailId = Session::get('emailId');
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            // Check if the file was uploaded
            if (isset($_FILES['introductionVideo']) && $_FILES['introductionVideo']['error'] == 0) {
                $fileTmpPath = $_FILES['introductionVideo']['tmp_name'];  // Temporary file path
                $fileName = $_FILES['introductionVideo']['name'];  // Original file name
                $fileSize = $_FILES['introductionVideo']['size'];  // File size
                $fileType = $_FILES['introductionVideo']['type'];  // File MIME type

                // Define allowed video file types (e.g., MP4, AVI, MOV)
                $allowedTypes = ['video/mp4', 'video/avi', 'video/quicktime'];

                // Check if the file type is allowed
                if (in_array($fileType, $allowedTypes)) {
                    // Set the upload path for the video
                    $uploadPath = 'lobbyroomdata/' . $session_emailId;

                    if (!is_dir($uploadPath)) {
                        mkdir($uploadPath, 0777, true);
                    }
                    $uploadPath = 'lobbyroomdata/' . $session_emailId . '/' . $fileName;

                    // Move the file from the temporary location to the desired folder
                    if (move_uploaded_file($fileTmpPath, $uploadPath)) {
                        // Send a JSON response on success
                        $data = array("success" => true, "message" => 'Introduction video uploaded successfully!');
                        print_r(json_encode($data));

                    } else {
                        // Send a JSON response on failure
                        $data = array("success" => false, "message" => 'Error moving the uploaded file.');
                        print_r(json_encode($data));

                    }
                } else {
                    // Send a JSON response for invalid file type
                    $data = array("success" => false, "message" => 'Only MP4, AVI, and MOV video files are allowed');
                    print_r(json_encode($data));

                }
            } else {
                // Send a JSON response for upload error
                $data = array("success" => false, "message" => 'No video uploaded or there was an upload error.');
                print_r(json_encode($data));

            }
        } else {
            // Send a JSON response for invalid request method
            $data = array("success" => false, "message" => 'Invalid request method.');
            print_r(json_encode($data));

        }
    }
}

