<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PeerToPeerVideoCall;
use App\Models\PeerToPeerVideoCallChat;
use Illuminate\Support\Facades\Session;
use App\Models\Organisation;
use App\Models\Video_Chat;
use App\Models\Education;
use App\Models\UserModel;
use App\Models\MeetingLinks;
use App\Models\Lobby_Page_Detail;
use App\Models\StudentClassInfo;
use App\Models\Video_Call_Entry_Scheduling;
use App\Models\Video_Call_Entry_Classroom;
use App\Models\Loby_Waiting_Clients;
use App\Models\NormalMeetingVideoCallChat;
use App\Models\NormalMeetingLobyChat;
use App\Models\VideosRecordingEntries;
use App\Models\ChatGroup;
use App\Models\VideoCallStatus;
use App\Models\Chat_History;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
class NormalMeetingVideoChat extends Controller
{

    public function GetNormalVideoCallChannelInfo(Request $request)
    {

        $session_emailId = Session::get('emailId');
        $channelID = $request->channel_id;
        Loby_Waiting_Clients::where('channel_id', '=', $channelID)->delete();
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();

        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }
        $caller_name = "";
        $receiver_name = "";
        $caller_profile_pic = "";
        $receiver_profile_pic = "";
        $receiver_email = "";

        $foundEntry = MeetingLinks::where('email_id', '=', $session_emailId)
            ->where('generated_link', '=', $channelID)
            ->first(); // Use first() to get a single record
        if ($foundEntry) {

            $caller_name = $foundEntry->caller_name;
            $receiver_name = $foundEntry->participant_name;
            $caller_profile_pic = $foundEntry->caller_profile_pic;
            $receiver_profile_pic = $foundEntry->participant_profile_pic;
            $receiver_email = $foundEntry->participant_email;

            MeetingLinks::where('email_id', '=', $session_emailId)
                ->where('generated_link', '=', $channelID)
                ->update(['Is_Call_Accepted' => false]);

        }

        $is_text_ticker = "no";
        $text_ticker_content = NULL;
        $is_text_ticker_video_call = "no";
        $text_ticker_content_video_call = NULL;
        $is_chat_pannel = 'yes';
        $lobby_profile_pic = "no";
        $lobby_background_pic = "no";
        $lobby_intro_video = "no_file";
        $lobby_meeting_name = "";
        $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $channelID)->first();
        if ($lobby_page_info) {
            $is_text_ticker = $lobby_page_info->is_text_ticker;
            $text_ticker_content = $lobby_page_info->text_ticker_content;
            $is_chat_pannel = $lobby_page_info->is_chat_pannel;
            $lobby_profile_pic = "lobbyroomdata/" . $session_emailId . '/' . $lobby_page_info->lobby_profile_pic;
            $lobby_background_pic = "lobbyroomdata/" . $session_emailId . '/' . $lobby_page_info->lobby_background_pic;
            if ($lobby_page_info->intro_video_name != 'no_file') {
                $lobby_intro_video = "lobbyroomdata/" . $session_emailId . '/' . $lobby_page_info->intro_video_name;
            }
            $is_text_ticker_video_call = $lobby_page_info->is_ticker_for_video_page;
            $text_ticker_content_video_call = $lobby_page_info->ticker_text_for_video_page;

            $lobby_meeting_name = $lobby_page_info->meeting_name;
        }

        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($receiver_name);
        // $lobby_background_pic = "no";
        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channelID,
            'acountType' => $acountType,
            'calling_person_name' => $calling_name,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $receiver_profile_pic,
            'calling_person_email' => $receiver_email,
            'caller_person_email' => $session_emailId,
            'is_text_ticker' => $is_text_ticker,
            'text_ticker_content' => $text_ticker_content,
            'is_chat_pannel' => $is_chat_pannel,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $lobby_background_pic,
            'lobby_intro_video' => $lobby_intro_video,
            'is_text_ticker_video_call' => $is_text_ticker_video_call,
            'text_ticker_content_video_call' => $text_ticker_content_video_call,
            'lobby_meeting_name' => $lobby_meeting_name,
        ];
        Session::put('VideoCallInfo', $videoCallInfo);

        $data = array();
        print_r(json_encode($data));
    }



    public function VideChatInfoNormalMeeting(Request $request)
    {
        $channel_id = $request->channel_id;
        $session_emailId = Session::get('emailId');
        $channelID = '';
        $caller_name = '';
        $receiver_name = '';
        $caller_profile_pic = '';
        $creceiver_profile_pic = '';
        $receiver_email_add = '';
        $channelInfo = MeetingLinks::where('participant_email', '=', $session_emailId)->where('generated_link', '=', $channel_id)->orderBy('created_at', 'desc')->first();
        if ($channelInfo) {

            $caller_name = $channelInfo->caller_name;
            $receiver_name = $channelInfo->participant_name;
            $caller_profile_pic = $channelInfo->caller_profile_pic;
            $creceiver_profile_pic = $channelInfo->participant_profile_pic;
            $receiver_email_add = $channelInfo->participant_email;
        }


        // $result = Video_Call_Entry_Scheduling::where('calling_email', $session_emailId)->where('caller_email', $caller_email)->get();
        // $caller_name = $request->caller_name;
        // $caller_profile_pic = $request->caller_profile_image;
        // $calling_name = $request->calling_name;
        // $call_type = $request->call_type;
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();
        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }

        // if ($result) {
        //     foreach ($result as $row) {
        //         $channelID = $row["channel_id"];
        //     }
        // }  hereeeeeeeeeeeeeeeeeeeeeeeeeeeeeeee
        $is_text_ticker = "no";
        $text_ticker_content = NULL;
        $is_text_ticker_video_call = "no";
        $text_ticker_content_video_call = NULL;
        $is_chat_pannel = 'yes';
        $lobby_profile_pic = "no";
        $lobby_background_pic = "no";
        $lobby_intro_video = "no_file";
        $lobby_meeting_name = "";
        $is_direct_entry = 'no';
        $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $channel_id)->first();
        if ($lobby_page_info) {
            $is_text_ticker = $lobby_page_info->is_text_ticker;
            $text_ticker_content = $lobby_page_info->text_ticker_content;
            $is_chat_pannel = $lobby_page_info->is_chat_pannel;
            $lobby_profile_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_profile_pic;
            $lobby_background_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_background_pic;
            if ($lobby_page_info->intro_video_name != 'no_file') {
                $lobby_intro_video = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->intro_video_name;
            }
            $is_text_ticker_video_call = $lobby_page_info->is_ticker_for_video_page;
            $text_ticker_content_video_call = $lobby_page_info->ticker_text_for_video_page;
            $lobby_meeting_name = $lobby_page_info->meeting_name;

            if ($lobby_page_info->enter_direct == 'no') {

                $is_direct_entry = 'no';
            } else {
                $is_direct_entry = 'yes';
            }

        }

        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($receiver_name);

        //   $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $channel_id)->orderBy('created_at', 'desc')->first();

        Loby_Waiting_Clients::create([
            'user_email' => $session_emailId,
            'channel_id' => $channel_id,
        ]);



        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channel_id,
            'acountType' => $acountType,
            'calling_person_name' => $calling_name,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $creceiver_profile_pic,
            'calling_person_email' => $receiver_email_add,
            'caller_person_email' => $session_emailId,
            'is_text_ticker' => $is_text_ticker,
            'text_ticker_content' => $text_ticker_content,
            'is_chat_pannel' => $is_chat_pannel,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $lobby_background_pic,
            'lobby_intro_video' => $lobby_intro_video,
            'is_text_ticker_video_call' => $is_text_ticker_video_call,
            'text_ticker_content_video_call' => $text_ticker_content_video_call,
            'lobby_meeting_name' => $lobby_meeting_name,
            'is_direct_entry' => $is_direct_entry,

        ];
        Session::put('VideoCallInfo', $videoCallInfo);
        $data = array("caller_name" => $caller_name, "caller_profile_pic" => $caller_profile_pic, "channel_id" => $channel_id);
        print_r(json_encode($data));
    }


    public function GroupVideoWithoutLobyChatRoom(Request $request)
    {
        $acountType = 'other';
        $session_emailId = Session::get('emailId');
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $checkGroup = ChatGroup::where([['chat_group_id', $request->group_id]])->get();
        $channelID = "";
        $meetingType = 'Video';
        for ($i = 0; $i < $length; $i++) {
            $channelID .= $characters[random_int(0, $charactersLength - 1)];
        }

        foreach ($checkGroup as $row) {
            $initiatorEmail = $row["owner_email"];
            $participantEmail = $row["participant_email"];
            $u_id = rand(10, 1000);

            $callInitiatorData = $this->returnUserInfo($initiatorEmail);
            $callParticipant = $this->returnUserInfo($participantEmail);



            PeerToPeerVideoCall::create([
                'Caller_Email' => $initiatorEmail,
                'Receiver_Email' => $participantEmail,
                'Caller_Profile_Pic' => $callInitiatorData[0],
                'Receiver_Profile_Pic' => $callParticipant[0],
                'Channel_Id' => $channelID,
                'Caller_Full_Name' => $callInitiatorData[1],
                'Receiver_Full_Name' => $callParticipant[1],
                'Is_Call_Accepted' => false,
                'is_call_read' => false,
                'user_id' => $u_id,
            ]);
        }


        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channelID,
            'acountType' => $acountType,
            'calling_person_name' => '',
            'caller_name' => $request->caller_name,
            'caller_picture' => $request->profile_pic,
            'calling_profile_pic' => '',
            'calling_person_email' => '',
            'caller_person_email' => $session_emailId,
            'is_text_ticker' => "no",
            'text_ticker_content' => NULL,
            'is_chat_pannel' => 'yes',
            'lobby_profile_pic' => "no",
            'lobby_background_pic' => "no",
            'lobby_intro_video' => "no_file",
            'is_text_ticker_video_call' => "no",
            'text_ticker_content_video_call' => NULL,
            'lobby_meeting_name' => "",
            'is_direct_entry' => 'no',

        ];
        Session::put('VideoCallInfo', $videoCallInfo);
        $data = array("channel_id" => $channelID, "meeting_type" => $meetingType);
        print_r(json_encode($data));
    }

    public function GroupVidoeCallFromChatRoom(Request $request)
    {
        $session_emailId = Session::get('emailId');

        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();
        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }
        $meetingDate = date('Y-m-d');
        ;
        $meetingTime = date('H:i:s');
        ;
        $generated_Link = '';
        $meetingType = 'Video';
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $usr_id = rand(10, 10000);
        for ($i = 0; $i < $length; $i++) {
            $generated_Link .= $characters[random_int(0, $charactersLength - 1)];
        }
        MeetingLinks::where([['email_id', $session_emailId]])->delete();
        $checkGroup = ChatGroup::where([['chat_group_id', $request->group_id]])->get();
        $newformat = date('Y-m-d', strtotime($meetingDate));
        if (count($checkGroup)) {

            foreach ($checkGroup as $row) {
                $groupAdminEmail = $row["owner_email"];
                $usr_id = rand(10, 10000);
                if ($row["participant_email"] != $session_emailId) {

                    $oneMinuteAgo = Carbon::now()->subMinute();
                    $record = VideoCallStatus::where('email_id', $row["participant_email"])
                        ->where('updated_at', '>=', $oneMinuteAgo)
                        ->first();
                    if ($record) {

                    } else {
                        $user_data = $this->returnUserInfo($row["participant_email"]);
                        MeetingLinks::create([
                            'email_id' => $session_emailId,
                            'participant_email' => $row["participant_email"],
                            'participant_name' => $user_data[1],
                            'meeting_date' => $newformat,
                            'meeting_time' => $meetingTime,
                            'participant_profile_pic' => $user_data[0],
                            'generated_link' => $generated_Link,
                            'link_type' => $meetingType,
                            'caller_profile_pic' => $request->profile_pic,
                            'caller_name' => $request->caller_name,
                            'user_id' => $usr_id,
                            'class_id' => $row["id"],

                        ]);
                    }
                }
            }
            if ($groupAdminEmail != $session_emailId) {
                $user_data = $this->returnUserInfo($groupAdminEmail);
                MeetingLinks::create([
                    'email_id' => $session_emailId,
                    'participant_email' => $groupAdminEmail,
                    'participant_name' => $user_data[1],
                    'meeting_date' => $newformat,
                    'meeting_time' => $meetingTime,
                    'participant_profile_pic' => $user_data[0],
                    'generated_link' => $generated_Link,
                    'link_type' => $meetingType,
                    'caller_profile_pic' => $request->profile_pic,
                    'caller_name' => $request->caller_name,
                    'user_id' => $usr_id,
                    'class_id' => $row["id"],

                ]);
            }



        }


        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $generated_Link,
            'acountType' => $acountType,
            'calling_person_name' => '',
            'caller_name' => $request->caller_name,
            'caller_picture' => $request->profile_pic,
            'calling_profile_pic' => '',
            'calling_person_email' => '',
            'caller_person_email' => $session_emailId,
            'is_text_ticker' => "no",
            'text_ticker_content' => NULL,
            'is_chat_pannel' => 'yes',
            'lobby_profile_pic' => "no",
            'lobby_background_pic' => "no",
            'lobby_intro_video' => "no_file",
            'is_text_ticker_video_call' => "no",
            'text_ticker_content_video_call' => NULL,
            'lobby_meeting_name' => "",
            'is_direct_entry' => 'no',

        ];
        Session::put('VideoCallInfo', $videoCallInfo);
        $data = array("channel_id" => $generated_Link, "meeting_type" => $meetingType);
        print_r(json_encode($data));
    }

    public function generateNormalMeeting(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $meetingDate = $request->datepicker;
        $meetingTime = $request->meetingTime;
        $participentEmail = $request->participentEmailNormalMeeting;


        $fullName = $request->fullNameNormalMeeting;
        $profilePic = $request->profilePicNormalMeeting;
        $meetingType = $request->link_typeNormalMeeting;
        $lobby_profile_pic = "no_img";
        $background_img_name = "no_img";

        $name_of_meeting = $request->name_of_the_meeting_submit;
        //uploading lobbyLogo..............................................................
        //if (isset($_POST['submit'])) {
        if (isset($_FILES['logyProfilePic']) && $_FILES['logyProfilePic']['error'] == 0) {


            $fileTmpPath = $_FILES['logyProfilePic']['tmp_name'];  // Temporary file path
            $fileName = $_FILES['logyProfilePic']['name'];  // Original file name
            $fileSize = $_FILES['logyProfilePic']['size'];  // File size
            $fileType = $_FILES['logyProfilePic']['type'];  // File MIME type
            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/jpg'];


            if (in_array($fileType, $allowedTypes)) {
                // Set the upload path
                $uploadPath = 'lobbyroomdata/' . $session_emailId;

                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777, true);
                }
                $uploadPath = 'lobbyroomdata/' . $session_emailId . '/' . $fileName;
                $lobby_profile_pic = $fileName;
                // Move the file from the temporary location to the desired folder
                if (move_uploaded_file($fileTmpPath, $uploadPath)) {
                    echo "File uploaded successfully!";
                } else {
                    echo "There was an error uploading your file.";
                }
            } else {
                echo "Only JPEG, PNG, and GIF files are allowed.";
            }
        } else {
            echo "No file uploaded or there was an upload error.";
        }
        //  }

        //..........................................................................................

        //uploading Background Image..............................................................
        // if (isset($_POST['submit'])) {
        // Check if the file was uploaded
        if (isset($_FILES['backgroun_img']) && $_FILES['backgroun_img']['error'] == 0) {
            $fileTmpPath = $_FILES['backgroun_img']['tmp_name'];  // Temporary file path
            $fileName = $_FILES['backgroun_img']['name'];  // Original file name
            $fileSize = $_FILES['backgroun_img']['size'];  // File size
            $fileType = $_FILES['backgroun_img']['type'];  // File MIME type

            // Define allowed file types for background image (e.g., JPEG, PNG, GIF)
            $allowedTypes = ['image/jpeg', 'image/png', 'image/gif', 'image/jpg'];

            // Check if the file type is allowed
            if (in_array($fileType, $allowedTypes)) {
                // Set the upload path for the background image
                $uploadPath = 'lobbyroomdata/' . $session_emailId;

                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777, true);
                }
                $background_img_name = $fileName;
                $uploadPath = 'lobbyroomdata/' . $session_emailId . '/' . $fileName;

                // Move the file from the temporary location to the desired folder
                if (move_uploaded_file($fileTmpPath, $uploadPath)) {
                    echo "Background image uploaded successfully!";
                } else {
                    echo "There was an error uploading your background image.";
                }
            } else {
                echo "Only JPEG, PNG, and GIF files are allowed for background image.";
            }
        } else {
            echo "No background image uploaded or there was an upload error.";
        }
        //   }

        //...........................................................................................
        $withoutAnAccountJoinForSubmit = $request->withoutAnAccountJoinForSubmit;
        $directEntryToLobyVideoForSubmit = $request->directEntryToLobyVideoForSubmit;
        $doYouWantTickerTextForSubmit = $request->doYouWantTickerTextForSubmit;
        $Ticker_TextTextForSubmit = $request->Ticker_TextTextForSubmit;
        $allowChatPanelTextForSubmit = $request->allowChatPanelTextForSubmit;
        $canPeopleSeeWaitingLobbyForSubmit = $request->canPeopleSeeWaitingLobbyForSubmit;
        $uploadIntroductionVideoFileName = $request->uploadIntroductionVideoFileName;
        $canUserJoinUsingCellPhoneForSubmit = $request->canUserJoinUsingCellPhoneForSubmit;


        $doYouWantTickerTextVideoCallingForSubmit = $request->doYouWantTickerTextVideoCallingForSubmit;
        $Ticker_TextTextVideoCallingForSubmit = $request->Ticker_TextTextVideoCallingForSubmit;



        $session_emailId = Session::get('emailId');
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $generated_Link = '';
        $length = 10;
        for ($i = 0; $i < $length; $i++) {
            $generated_Link .= $characters[random_int(0, $charactersLength - 1)];
        }

        $session_user_data = $this->returnUserInfo($session_emailId);
        $usr_id = rand(10, 10000);
        //$newformat = date('Y-m-d',$meetingDate);
        $newformat = date('Y-m-d', strtotime($meetingDate));
        MeetingLinks::create([
            'email_id' => $session_emailId,
            'participant_email' => $request->participentEmailNormalMeeting,
            'participant_name' => $fullName,
            'meeting_date' => $newformat,
            'meeting_time' => $meetingTime,
            'participant_profile_pic' => $profilePic,
            'generated_link' => $generated_Link,
            'link_type' => $meetingType,
            'caller_profile_pic' => $session_user_data[0],
            'caller_name' => $session_user_data[1],
            'user_id' => $usr_id,
            'Is_Call_Accepted' => true,
        ]);

        Lobby_Page_Detail::create([
            'channel_id' => $generated_Link,
            'meeting_name' => $name_of_meeting,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $background_img_name,
            'without_accont_join' => $withoutAnAccountJoinForSubmit,
            'enter_direct' => $directEntryToLobyVideoForSubmit,
            'is_text_ticker' => $doYouWantTickerTextForSubmit,
            'text_ticker_content' => $Ticker_TextTextForSubmit,
            'is_chat_pannel' => $allowChatPanelTextForSubmit,
            'can_see_waiting_people' => $canPeopleSeeWaitingLobbyForSubmit,
            'join_using_cellphone' => $canUserJoinUsingCellPhoneForSubmit,
            'intro_video_name' => $uploadIntroductionVideoFileName,
            'is_ticker_for_video_page' => $doYouWantTickerTextVideoCallingForSubmit,
            'ticker_text_for_video_page' => $Ticker_TextTextVideoCallingForSubmit,
        ]);

        return redirect()->route('meeting.schedule')->with('message', 'Meeting generated successfully!');
    }

    public function submitVideoChatNormalMeeting(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $fullName = "";
        $profile_image = "";
        $destination = "Not Uploaded";
        $pathSaveToDb = "Not Uploaded";
        $chat_text = $request->chatText;

        $chat_group_id = null;
        $chanelIdd = $request->channelId;

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
            $files = $_FILES['files'];
            $uploaded = [];
            $errors = [];
            foreach ($files['tmp_name'] as $index => $tmpName) {
                $name = $files['name'][$index];
                // $name = round(microtime(true)) . '.' . end($name);
                $name = date('dmYHis') . str_replace(" ", "", $name);
                //  $name = preg_replace('/[^\w\d_]/', '', $name);
                $error = $files['error'][$index];

                if ($error === UPLOAD_ERR_OK) {
                    $datee = date('Y-m-d_H_i_s') . '';
                    $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                    $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                    if (!file_exists($path)) {
                        mkdir($path, 0777, true);
                    }
                    $destination = $path . '/' . $name;
                    if (move_uploaded_file($tmpName, $destination)) {
                        $uploaded[] = $name;
                    }
                }

                if (!empty($uploaded)) {
                    echo "Uploaded files: " . implode(', ', $uploaded);
                }
                if (!empty($errors)) {
                    echo "Errors: " . implode(', ', $errors);
                }
            }
        } else {
            $destination = "Not Uploaded";
        }

        $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('email_id', '=', $session_emailId)->first();
        if ($caller_data) {
            $sender_name = $caller_data->caller_name;
            $sender_profile_pic = $caller_data->caller_profile_pic;
            $MessageSendTo = MeetingLinks::where('generated_link', '=', $chanelIdd)->get();
            foreach ($MessageSendTo as $rowwData) {
                NormalMeetingVideoCallChat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $rowwData['participant_email'],
                    'sended_text' => $chat_text,
                    'full_name_sender' => $sender_name,
                    'profile_pic_sender' => $sender_profile_pic,
                    'full_name_receiver' => $rowwData['participant_name'],
                    'profile_pic_receiver' => $rowwData['participant_profile_pic'],
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,
                ]);
            }

        } else {
            $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('participant_email', '=', $session_emailId)->first();
            if ($caller_data) {
                $sender_name = $caller_data->participant_name;
                $sender_profile_pic = $caller_data->participant_profile_pic;
                $sender_email = $caller_data->participant_email;

                $rec_name = $caller_data->caller_name;
                $rec_profile_pic = $caller_data->caller_profile_pic;
                $rec_email = $caller_data->email_id;
                NormalMeetingVideoCallChat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $rec_email,
                    'sended_text' => $chat_text,
                    'full_name_sender' => $sender_name,
                    'profile_pic_sender' => $sender_profile_pic,
                    'full_name_receiver' => $rec_name,
                    'profile_pic_receiver' => $rec_profile_pic,
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,
                ]);


                $MessageSendTo = MeetingLinks::where('generated_link', '=', $chanelIdd)->get();
                foreach ($MessageSendTo as $rowwData) {
                    if ($rowwData['participant_email'] != $sender_email)
                        NormalMeetingVideoCallChat::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $rowwData['participant_email'],
                            'sended_text' => $chat_text,
                            'full_name_sender' => $sender_name,
                            'profile_pic_sender' => $sender_profile_pic,
                            'full_name_receiver' => $rowwData['participant_name'],
                            'profile_pic_receiver' => $rowwData['participant_profile_pic'],
                            'images_path' => $pathSaveToDb,
                            'channel_id' => $chanelIdd,
                        ]);
                }

            }

        }

        $data = array("chatGroupId" => 'noset');
        print_r(json_encode($data));
    }



    public function submitVideoChatLobyPage(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $fullName = "";
        $profile_image = "";
        $destination = "Not Uploaded";
        $pathSaveToDb = "Not Uploaded";
        $chat_text = $request->chatText;

        $chat_group_id = null;
        $chanelIdd = $request->channelId;

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
            $files = $_FILES['files'];
            $uploaded = [];
            $errors = [];
            foreach ($files['tmp_name'] as $index => $tmpName) {
                $name = $files['name'][$index];
                // $name = round(microtime(true)) . '.' . end($name);
                $name = date('dmYHis') . str_replace(" ", "", $name);
                //  $name = preg_replace('/[^\w\d_]/', '', $name);
                $error = $files['error'][$index];

                if ($error === UPLOAD_ERR_OK) {
                    $datee = date('Y-m-d_H_i_s') . '';
                    $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                    $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                    if (!file_exists($path)) {
                        mkdir($path, 0777, true);
                    }
                    $destination = $path . '/' . $name;
                    if (move_uploaded_file($tmpName, $destination)) {
                        $uploaded[] = $name;
                    }
                }

                if (!empty($uploaded)) {
                    echo "Uploaded files: " . implode(', ', $uploaded);
                }
                if (!empty($errors)) {
                    echo "Errors: " . implode(', ', $errors);
                }
            }
        } else {
            $destination = "Not Uploaded";
        }

        $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('email_id', '=', $session_emailId)->first();
        if ($caller_data) {
            $sender_name = $caller_data->caller_name;
            $sender_profile_pic = $caller_data->caller_profile_pic;
            $MessageSendTo = MeetingLinks::where('generated_link', '=', $chanelIdd)->get();
            foreach ($MessageSendTo as $rowwData) {
                NormalMeetingLobyChat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $rowwData['participant_email'],
                    'sended_text' => $chat_text,
                    'full_name_sender' => $sender_name,
                    'profile_pic_sender' => $sender_profile_pic,
                    'full_name_receiver' => $rowwData['participant_name'],
                    'profile_pic_receiver' => $rowwData['participant_profile_pic'],
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,
                ]);
            }

        } else {
            $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('participant_email', '=', $session_emailId)->first();
            if ($caller_data) {
                $sender_name = $caller_data->participant_name;
                $sender_profile_pic = $caller_data->participant_profile_pic;
                $sender_email = $caller_data->participant_email;

                $rec_name = $caller_data->caller_name;
                $rec_profile_pic = $caller_data->caller_profile_pic;
                $rec_email = $caller_data->email_id;
                NormalMeetingLobyChat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $rec_email,
                    'sended_text' => $chat_text,
                    'full_name_sender' => $sender_name,
                    'profile_pic_sender' => $sender_profile_pic,
                    'full_name_receiver' => $rec_name,
                    'profile_pic_receiver' => $rec_profile_pic,
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,
                ]);


                $MessageSendTo = MeetingLinks::where('generated_link', '=', $chanelIdd)->get();
                foreach ($MessageSendTo as $rowwData) {
                    if ($rowwData['participant_email'] != $sender_email)
                    NormalMeetingLobyChat::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $rowwData['participant_email'],
                            'sended_text' => $chat_text,
                            'full_name_sender' => $sender_name,
                            'profile_pic_sender' => $sender_profile_pic,
                            'full_name_receiver' => $rowwData['participant_name'],
                            'profile_pic_receiver' => $rowwData['participant_profile_pic'],
                            'images_path' => $pathSaveToDb,
                            'channel_id' => $chanelIdd,
                        ]);
                }

            }

        }

        $data = array("chatGroupId" => 'noset');
        print_r(json_encode($data));
    }

    public function submitVideoChatNormalMeetingIndividual(Request $request)
    {

        $session_emailId = Session::get('emailId');
        $fullName = "";
        $profile_image = "";
        $destination = "Not Uploaded";
        $pathSaveToDb = "Not Uploaded";
        $chat_text = $request->chatText;
        $receiver_email_id = $request->receiver_email_id;
        $chat_group_id = null;
        $chanelIdd = $request->channelId;

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
            $files = $_FILES['files'];
            $uploaded = [];
            $errors = [];
            foreach ($files['tmp_name'] as $index => $tmpName) {
                $name = $files['name'][$index];
                // $name = round(microtime(true)) . '.' . end($name);
                $name = date('dmYHis') . str_replace(" ", "", $name);
                //  $name = preg_replace('/[^\w\d_]/', '', $name);
                $error = $files['error'][$index];

                if ($error === UPLOAD_ERR_OK) {
                    $datee = date('Y-m-d_H_i_s') . '';
                    $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                    $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                    if (!file_exists($path)) {
                        mkdir($path, 0777, true);
                    }
                    $destination = $path . '/' . $name;
                    if (move_uploaded_file($tmpName, $destination)) {
                        $uploaded[] = $name;
                    }
                }

                if (!empty($uploaded)) {
                    echo "Uploaded files: " . implode(', ', $uploaded);
                }
                if (!empty($errors)) {
                    echo "Errors: " . implode(', ', $errors);
                }
            }
        } else {
            $destination = "Not Uploaded";
        }



        $sender_name = "";
        $sender_profile = "";


        $rec_name = "";
        $rec_profile = "";

        $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('participant_email', '=', $session_emailId)->get();
        if (count($caller_data) > 0) {
            foreach ($caller_data as $rowwData) {
                $sender_name = $rowwData['participant_name'];
                $sender_profile = $rowwData['participant_profile_pic'];
            }

        } else {
            $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('email_id', '=', $session_emailId)->get();

            foreach ($caller_data as $rowwData) {
                $sender_name = $rowwData['caller_name'];
                $sender_profile = $rowwData['caller_profile_pic'];
            }
        }

        $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('participant_email', '=', $receiver_email_id)->get();
        if (count($caller_data) > 0) {
            foreach ($caller_data as $rowwData) {
                $rec_name = $rowwData['participant_name'];
                $rec_profile = $rowwData['participant_profile_pic'];
            }

        } else {
            $caller_data = MeetingLinks::where('generated_link', '=', $chanelIdd)->where('email_id', '=', $receiver_email_id)->get();

            foreach ($caller_data as $rowwData) {
                $rec_name = $rowwData['caller_name'];
                $rec_profile = $rowwData['caller_profile_pic'];
            }
        }

        NormalMeetingVideoCallChat::create([
            'sender_email' => $session_emailId,
            'receiver_email' => $receiver_email_id,
            'sended_text' => $chat_text,
            'full_name_sender' => $sender_name,
            'profile_pic_sender' => $sender_profile,
            'full_name_receiver' => $rec_name,
            'profile_pic_receiver' => $rec_profile,
            'images_path' => $pathSaveToDb,
            'channel_id' => $chanelIdd,

        ]);

        Chat_History::create([
            'sender_email' => $session_emailId,
            'receiver_email' => $receiver_email_id,
            'sended_text' => $chat_text,
            'full_name' => $sender_name,
            'profile_img' => $sender_profile,
            'full_name_sender' => $rec_name,
            'profile_img_sender' => $rec_profile,
            'images_path' => $pathSaveToDb,
            'chat_group_id' => $chanelIdd,


        ]);
        $data = array("chatGroupId" => 'noset');
        print_r(json_encode($data));
    }
    public function NormalMeetingCallParticipantLoby(Request $request)
    {
        $caller_profile_img = $request->caller_profile_pic;
        $caller_name = $request->caller_full_name;
        $rec_profile_img = $request->rec_profile_pic;
        $rec_full_name = $request->rec_full_name;
        $channel_id = $request->channel_id;


        $session_emailId = Session::get('emailId');
        $channelInfo = MeetingLinks::where('participant_email', '=', $session_emailId)->where('generated_link', '=', $channel_id)->orderBy('created_at', 'desc')->first();
        if ($channelInfo) {

            $caller_name = $channelInfo->caller_name;
            $receiver_name = $channelInfo->participant_name;
            // $caller_profile_pic = $channelInfo->caller_profile_pic;
            // $creceiver_profile_pic = $channelInfo->participant_profile_pic;
            // $receiver_email_add = $channelInfo->participant_email;
        }
        $is_text_ticker = "no";
        $text_ticker_content = NULL;
        $is_text_ticker_video_call = "no";
        $text_ticker_content_video_call = NULL;
        $is_chat_pannel = 'yes';
        $lobby_profile_pic = "no";
        $lobby_background_pic = "no";
        $lobby_intro_video = "no_file";
        $lobby_meeting_name = "";
        $is_direct_entry = 'no';
        $can_see_waiting_people = 'no';
        $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $channel_id)->first();
        if ($lobby_page_info) {
            $is_text_ticker = $lobby_page_info->is_text_ticker;
            $text_ticker_content = $lobby_page_info->text_ticker_content;
            $is_chat_pannel = $lobby_page_info->is_chat_pannel;
            $can_see_waiting_people = $lobby_page_info->can_see_waiting_people;

            $lobby_profile_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_profile_pic;
            $lobby_background_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_background_pic;
            if ($lobby_page_info->intro_video_name != 'no_file') {
                $lobby_intro_video = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->intro_video_name;
            }
            $is_text_ticker_video_call = $lobby_page_info->is_ticker_for_video_page;
            $text_ticker_content_video_call = $lobby_page_info->ticker_text_for_video_page;
            $lobby_meeting_name = $lobby_page_info->meeting_name;

            if ($lobby_page_info->enter_direct == 'no') {

                $is_direct_entry = 'no';
            } else {
                $is_direct_entry = 'yes';
            }
        }

        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($receiver_name);

        Loby_Waiting_Clients::updateOrInsert(
            ['user_email' => $session_emailId, 'channel_id' => $channel_id], // Condition to find existing record
            ['is_accepted' => 0, 'Isread' => 1, 'Is_rejected' => 0] // Values to insert or update
        );

        $videoCallInfo = [
            'is_text_ticker' => $is_text_ticker,
            'text_ticker_content' => $text_ticker_content,
            'is_chat_pannel' => $is_chat_pannel,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $lobby_background_pic,
            'lobby_intro_video' => $lobby_intro_video,
            'is_text_ticker_video_call' => $is_text_ticker_video_call,
            'text_ticker_content_video_call' => $text_ticker_content_video_call,
            'lobby_meeting_name' => $lobby_meeting_name,
            'is_direct_entry' => $is_direct_entry,
            'can_see_waiting_people' => $can_see_waiting_people,
            'channelID'=>$channel_id,

        ];
        Session::put('VideoCallInfo', $videoCallInfo);

        return view('NormalMeetingVideoCall/LobyNormalMeetingParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_img)
            ->with('caller_name', $caller_name)->with('rec_profile_img', $rec_profile_img)->with('rec_name', $rec_full_name)->with('channel_id', $channel_id);
    }
    public function deleteReadedChatMessageGroupVideoCall(Request $request)
    {
        NormalMeetingVideoCallChat::where('id', '=', (int) $request->messageId)->delete();
    }

    public function deleteReadedChatMessageGroupLobyPage(Request $request)
    {
        NormalMeetingLobyChat::where('id', '=', (int) $request->messageId)->delete();
    }


    public function checkMessageForVideoCallNormalMeeting(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $channelId = $request->channelId;
        $isMessageFound = false;

        //  $mailCount = Video_Chat::where('receiver_email', '=', $session_emailId)->get();
        $latestMessage = NormalMeetingVideoCallChat::where('receiver_email', '=', $session_emailId)->where('channel_id', '=', $channelId)->orderBy('id', 'DESC')->get();
        // NormalMeetingVideoCallChat::where('receiver_email', '=', $session_emailId)->where('channel_id', '=', $channelId)->delete();

        $folderPath = "";
        if (count($latestMessage) > 0) {
            $isMessageFound = true;
            foreach ($latestMessage as $roww) {
                $folderPath = $roww["images_path"];
            }
        }

        $fileNames = [];
        if ($folderPath != "Not Uploaded") {
            if (strlen($folderPath) != 0) {
                $path = public_path($folderPath);
                $files = array_slice(scandir($path), 2);
                // Initialize an array to hold the file names
                // Loop through the scanned files
                foreach ($files as $file) {
                    // Exclude the current and parent directory references ('.' and '..')
                    if ($file !== '.' && $file !== '..') {
                        // Add the file name to the array
                        $fileNames[] = $file;
                    }
                }
            }
        }

        $GroupInfo = MeetingLinks::where('generated_link', $channelId)->first();
        //checking loby for incomming calls...............................

        $user_data = [];
        $isCallInitiator = false;
        if ($GroupInfo->email_id == $session_emailId) {


            $lobyWaitingUserInfo = Loby_Waiting_Clients::where('channel_id', $channelId)->where('Isread', false)->first();
            if ($lobyWaitingUserInfo) {
                if ($lobyWaitingUserInfo->is_accepted == false) {
                    $user_data = $this->returnUserInfo($lobyWaitingUserInfo->user_email);
                    if (count($user_data) == 0) {
                        $recordUser = MeetingLinks::where('generated_link', $channelId)->where('participant_email', $lobyWaitingUserInfo->user_email)->first();
                        $user_data[] = $recordUser->participant_profile_pic;
                        $user_data[] = $recordUser->participant_name;
                    }
                    //  Loby_Waiting_Clients::where('channel_id', $channelId)->where('user_email',$lobyWaitingUserInfo->user_email)->delete();
                    Loby_Waiting_Clients::where('channel_id', $channelId)
                        ->where('user_email', $lobyWaitingUserInfo->user_email)
                        ->update(['Isread' => true]);
                }
            } else {
                $isCallInitiator = true;
            }

        }
        //else{
        //$allWaitingPersonsInLobby = Loby_Waiting_Clients::where('channel_id', $channelId)->get();

        // $lobyWaitingUserInfo = Loby_Waiting_Clients::where('channel_id', $channelId)->get();
        //  if(count( $lobyWaitingUserInfo)>0){
        //     foreach ($lobyWaitingUserInfo as $rowwData) {
        //         $lobbyWaitingAreaPeopleList= MeetingLinks::where('generated_link', $channelId)->where('participant_email', $rowwData['user_email'])->first();
        //         $lobbyWaitingAreaList[]=$lobbyWaitingAreaPeopleList;
        //     }
        //  }
        //     $lobyWaitingUserInfoRec = Loby_Waiting_Clients::join('meeting_links', 'loby_waiting_clients.channel_id', '=', 'meeting_links.generated_link')
        //     ->where('loby_waiting_clients.channel_id', $channelId)
        //     ->whereColumn('loby_waiting_clients.user_email', '=', 'meeting_links.participant_email')
        //    ->distinct()
        //     ->select('loby_waiting_clients.*', 'meeting_links.*') // Select all columns from both tables
        //     ->get();

        // }
        //.............................................................


        // Keep Saving about caller information that this caller is busy in doing call
        $record = VideoCallStatus::where('email_id', $session_emailId)->first();
        if ($record) {
            $record->updated_at = Carbon::now();
            $record->save();
        } else {
            VideoCallStatus::create([
                'email_id' => $session_emailId,
                'updated_at' => Carbon::now(),
            ]);
        }
        //.......................................................................................





        if (count($user_data) > 0) {
            $data = array("latestMessage" => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath, "IsMessageFound" => $isMessageFound, "ParticipantName" => $user_data[1], "ParticipanProfilePic" => $user_data[0], "participant_email" => $lobyWaitingUserInfo->user_email, "channel_id" => $channelId);
        } else if ($isCallInitiator == true) {
            $data = array("latestMessage" => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath, "IsMessageFound" => $isMessageFound, "channel_id" => $channelId);
        } else {
            $data = array("latestMessage" => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath, "IsMessageFound" => $isMessageFound);
        }
        print_r(json_encode($data));
    }


    public function AcceptParticipantRequestForJoiningVideoCallRoom(Request $request)
    {
        Loby_Waiting_Clients::where('channel_id', $request->channelId)->where('user_email', $request->user_email)->update(['is_accepted' => true]);
    }


    public function AcceptAllParticipantRequestForJoiningVideoCallRoom(Request $request)
    {
        Loby_Waiting_Clients::where('channel_id', $request->channelId)->update(['is_accepted' => true]);
    }




    public function joinVideoCallByUrlNormalMeeting(Request $request)
    {

        $call_joiner_email = $request->email_address;
        $call_joiner_name = $request->full_name;
        $chanelID = $request->chanelId;
        $caller_email = "";
        $caller_name = "";
        $caller_profile_pic = "";
        $meeting_date = date('Y-m-d');
        $meeting_time = date('H:i:s');


        $checkIsAllowWithoutURL = Lobby_Page_Detail::where('channel_id', '=', $chanelID)->first();
        if ($checkIsAllowWithoutURL) {
            if ($checkIsAllowWithoutURL->without_accont_join == 'no') {
                return view('JoinCall')->with('message', 'The presenter restricts users from joining the video call via the URL.');
            }
            if ($request->header('User-Agent')) {
                $userAgent = $request->header('User-Agent');
                if (preg_match('/mobile/i', $userAgent)) {
                    if ($checkIsAllowWithoutURL->join_using_cellphone == 'no') {
                        return view('JoinCall')->with('message', 'The presenter restricts users from joining the video call via mobile phone .');
                    }
                }

            }





        }

        $callerInfo = MeetingLinks::where('generated_link', '=', $chanelID)->get();
        if ($callerInfo) {
            foreach ($callerInfo as $row) {
                $caller_email = $row["email_id"];
                $caller_name = $row["caller_name"];
                $caller_profile_pic = $row["caller_profile_pic"];
                $meeting_date = $row["meeting_date"];
                $meeting_time = $row["meeting_time"];
            }
        }
        $file_name = "";
        $randomNum = rand(10, 1000);
        $fileName = "";
        if (isset($_FILES['customFile'])) {

            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $file_name = $randomNum . $file_name;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $file_name);
            } else {
                print_r($errors);
            }
        }

        $existingRecord = MeetingLinks::where('generated_link', $chanelID)
            ->where(function ($query) use ($call_joiner_email, $caller_email) {
                $query->where('participant_email', $call_joiner_email);
            })
            ->first();


        Session::put('emailId', $call_joiner_email);
        Loby_Waiting_Clients::create([
            'user_email' => $call_joiner_email,
            'channel_id' => $chanelID,
            'Isread' => 1,
        ]);

        if (!$existingRecord) {
            $usr_id = rand(10, 10000);
            MeetingLinks::where('participant_email', $call_joiner_email)->delete();
            MeetingLinks::create([
                'participant_email' => $call_joiner_email,
                'email_id' => $caller_email,
                'meeting_date' => $meeting_date,
                'meeting_time' => $meeting_time,
                'link_type' => 'NormalMeeting',
                'participant_profile_pic' => $file_name,
                'caller_profile_pic' => $caller_profile_pic,
                'generated_link' => $chanelID,
                'caller_name' => $caller_name,
                'participant_name' => $call_joiner_name,
                'user_id' => $usr_id,
                'join_from_url' => 'Yes',

            ]);
        }

        Session::put('emailId', $call_joiner_email);

        $is_text_ticker = "no";
        $text_ticker_content = NULL;
        $is_text_ticker_video_call = "no";
        $text_ticker_content_video_call = NULL;
        $is_chat_pannel = 'yes';
        $lobby_profile_pic = "no";
        $lobby_background_pic = "no";
        $lobby_intro_video = "no_file";
        $lobby_meeting_name = "";
        $can_see_waiting_people = 'no';
        $is_direct_entry = 'no';
        $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $chanelID)->first();
        if ($lobby_page_info) {
            $is_text_ticker = $lobby_page_info->is_text_ticker;
            $text_ticker_content = $lobby_page_info->text_ticker_content;
            $can_see_waiting_people = $lobby_page_info->can_see_waiting_people;
            $is_text_ticker_video_call = $lobby_page_info->is_ticker_for_video_page;
            $text_ticker_content_video_call = $lobby_page_info->ticker_text_for_video_page;
            $is_chat_pannel = $lobby_page_info->is_chat_pannel;
            $lobby_profile_pic = "lobbyroomdata/" . $caller_email . '/' . $lobby_page_info->lobby_profile_pic;
            $lobby_background_pic = "lobbyroomdata/" . $caller_email . '/' . $lobby_page_info->lobby_background_pic;
            if ($lobby_page_info->intro_video_name != 'no_file') {
                $lobby_intro_video = "lobbyroomdata/" . $caller_email . '/' . $lobby_page_info->intro_video_name;
            }
            $lobby_meeting_name = $lobby_page_info->meeting_name;
            if ($lobby_page_info->enter_direct == 'no') {
                $is_direct_entry = 'no';
            } else {
                $is_direct_entry = 'yes';
            }

        }

        // $caller_name = ucfirst($caller_name);
        // $calling_name = ucfirst($receiver_name);
        //  $lobby_background_pic = "no";
        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $chanelID,
            'acountType' => null,
            'calling_person_name' => null,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $caller_profile_pic,
            'calling_person_email' => null,
            'caller_person_email' => null,
            'is_text_ticker' => $is_text_ticker,
            'text_ticker_content' => $text_ticker_content,
            'is_chat_pannel' => $is_chat_pannel,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $lobby_background_pic,
            'lobby_intro_video' => $lobby_intro_video,
            'is_text_ticker_video_call' => $is_text_ticker_video_call,
            'text_ticker_content_video_call' => $text_ticker_content_video_call,
            'lobby_meeting_name' => $lobby_meeting_name,
            'is_direct_entry' => $is_direct_entry,
            'can_see_waiting_people' => $can_see_waiting_people,

        ];
        Session::put('VideoCallInfo', $videoCallInfo);







        if ($this->isMobile()) {
            return view('NormalMeetingVideoCall/LobyMobileViewParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_pic)
                ->with('caller_name', $caller_name)->with('rec_profile_img', $file_name)->with('rec_name', $call_joiner_name)->with('channel_id', $chanelID);

            // return view('NormalMeetingVideoCall/MobileDisplay')->with('type', 'receiver')->with('channel_id', $chanelID);
            ;
        } else {
            //   return redirect()->route('NormalMeetingCallParticipantLoby')->with('caller_profile_pic', $caller_profile_pic)->with('caller_full_name', $caller_name)->with('rec_profile_pic',$file_name )->with('rec_full_name', $call_joiner_name)->with('channel_id', $chanelID);
            return view('NormalMeetingVideoCall/LobyNormalMeetingParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_pic)
                ->with('caller_name', $caller_name)->with('rec_profile_img', $file_name)->with('rec_name', $call_joiner_name)->with('channel_id', $chanelID);
            // return view('NormalMeetingVideoCall/DesktopDisplay')->with('type', 'receiver')->with('channel_id', $chanelID);
        }
    }


    function isMobile()
    {
        // Check the User-Agent string for common mobile device identifiers
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        // Array of keywords that are common for mobile devices
        $mobileDevices = ['Mobile', 'Android', 'iPhone', 'iPod', 'Windows Phone', 'BlackBerry', 'webOS'];

        // Check if any of the keywords exist in the User-Agent string
        foreach ($mobileDevices as $device) {
            if (stripos($userAgent, $device) !== false) {
                return true;  // Return true if a mobile device is detected
            }
        }

        return false;  // Return false if no mobile device is detected
    }

    public function returnUserInfo($emailAdd)
    {
        $infoArray = [];
        $resultProfile = UserModel::where('email_id', $emailAdd)->get();
        $num_rows = count($resultProfile);
        if ($num_rows > 0) {
            foreach ($resultProfile as $row) {
                $infoArray[] = $row["profile_picture"];
                $infoArray[] = $row["first_name"] . " " . $row["second_name"];
            }
        }


        // else {
        //     $resultProfile = Organisation::where('email_id', $emailAdd)->get();
        //     $num_rows = count($resultProfile);
        //     if ($num_rows > 0) {
        //         foreach ($resultProfile as $row) {
        //             $infoArray[] = $row["profile_picture"];
        //             $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //         }
        //     } else {
        //         $resultProfile = Education::where('email_id', $emailAdd)->get();
        //         $num_rows = count($resultProfile);
        //         if ($num_rows > 0) {
        //             foreach ($resultProfile as $row) {
        //                 $infoArray[] = $row["profile_picture"];
        //                 $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //             }
        //         }
        //     }
        // }
        return $infoArray;
    }
    public function getCallerInformationForNewJoiningUser(Request $request)
    {
        $channelid = $request->channel_id;
        $userid = $request->user_id;
        $userName = "";
        $userEmail = "";
        $userPic = "";
        if ($userid == 1) {
            $caller_data = MeetingLinks::where('generated_link', '=', $channelid)->get();
        } else {
            $caller_data = MeetingLinks::where('generated_link', '=', $channelid)->where('user_id', '=', $userid)->get();
        }


        if (count($caller_data) > 0) {
            foreach ($caller_data as $rowwData) {
                if ($userid == 1) {
                    $userName = $rowwData['caller_name'];
                    $userEmail = $rowwData['email_id'];
                    $userPic = $rowwData['caller_profile_pic'];
                } else {
                    $userName = $rowwData['participant_name'];
                    $userEmail = $rowwData['participant_email'];
                    $userPic = $rowwData['participant_profile_pic'];
                }

                break;
            }
        }


        $data = array("userName" => $userName, "userEmail" => $userEmail, "ImagePath" => $userPic);
        print_r(json_encode($data));
    }

    public function NotAllowingToJoinVideoCallingRoom(Request $request)
    {
        Loby_Waiting_Clients::where('channel_id', $request->channelId)->where('user_email', $request->participant_email)->update(['Is_rejected' => true]);

    }
    public function addingVideoRecordingEntryToDB(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $folderName = $request->timeStmp;
        VideosRecordingEntries::create([
            'email_add' => $session_emailId,
            'folder_name' => $folderName,
        ]);
    }
    public function DeleteLobyWaitingClientEntry($channelId)
    {


        Loby_Waiting_Clients::where('channel_id', $channelId)->update(['is_accepted' => true]);
    }
    public function deleteMeetingLink(Request $request)
    {

        $generated_link = $request->generatedLink;
        MeetingLinks::where('generated_link', '=', $generated_link)->delete();
        return redirect()->route('ScheduleMeeting');
    }
    public function NormalMeetingVideoCallDesktopView(Request $request)
    {

        Loby_Waiting_Clients::where('channel_id', $request->channelId)
            ->where('user_email', $request->user_email)
            ->update(['Isread' => true]);
        $this->DeleteLobyWaitingClientEntry($request->channelId);
        return view('NormalMeetingVideoCall/DesktopDisplay')->with('type', 'caller')->with('camStatus', $request->camStatus)->with('micStatus', $request->micStatus);
    }
    public function NormalMeetingVideoCallReceiverDesktopView(Request $request)
    {

        return view('NormalMeetingVideoCall/DesktopDisplay')->with('type', 'receiver')->with('channel_id', $request->channel_id)->with('camStatus', $request->camStatus)->with('micStatus', $request->micStatus);
    }
    public function NormalMeetingVideoCallMobileLoby()
    {
        return view('NormalMeetingVideoCall/LobyMobileView')->with('type', 'caller');
        ;
    }
    public function NormalMeetingVideoLoby()
    {
        return view('NormalMeetingVideoCall/Loby')->with('type', 'caller');
        ;
    }
    public function NormalMeetingVideoCallReceiverMobileView(Request $request)
    {
        return view('NormalMeetingVideoCall/MobileDisplay')->with('type', 'receiver')->with('channel_id', $request->channel_id);
    }
    public function NormalMeetingVideoCallMobileView(Request $request)
    {

        Loby_Waiting_Clients::where('channel_id', $request->channelId)
            ->where('user_email', $request->user_email)
            ->update(['Isread' => true]);
        $this->DeleteLobyWaitingClientEntry($request->channelId);
        return view('NormalMeetingVideoCall/MobileDisplay')->with('type', 'caller')->with('camStatus', $request->camStatus)->with('micStatus', $request->micStatus);



        //$channel_id = $request->channelId;
        // $this->DeleteLobyWaitingClientEntry($channel_id);
        // return view('NormalMeetingVideoCall/MobileDisplay')->with('type', 'caller')->with('camStatus', $request->camStatus)->with('micStatus', $request->micStatus);
    }


    public function NormalMeetingMobileParticipantLoby(Request $request)
    {
        $caller_profile_img = $request->caller_profile_pic;
        $caller_name = $request->caller_full_name;
        $rec_profile_img = $request->rec_profile_pic;
        $rec_full_name = $request->rec_full_name;
        $channel_id = $request->channel_id;

        $checkIsAllowWithoutURL = Lobby_Page_Detail::where('channel_id', '=', $request->channel_id)->first();


        $session_emailId = Session::get('emailId');
        $channelInfo = MeetingLinks::where('participant_email', '=', $session_emailId)->where('generated_link', '=', $channel_id)->orderBy('created_at', 'desc')->first();
        if ($channelInfo) {

            $caller_name = $channelInfo->caller_name;
            $receiver_name = $channelInfo->participant_name;
            // $caller_profile_pic = $channelInfo->caller_profile_pic;
            // $creceiver_profile_pic = $channelInfo->participant_profile_pic;
            // $receiver_email_add = $channelInfo->participant_email;
        }

        $is_text_ticker = "no";
        $text_ticker_content = NULL;
        $is_text_ticker_video_call = "no";
        $text_ticker_content_video_call = NULL;
        $is_chat_pannel = 'yes';
        $lobby_profile_pic = "no";
        $lobby_background_pic = "no";
        $lobby_intro_video = "no_file";
        $lobby_meeting_name = "";
        $can_see_waiting_people = 'no';
        $is_direct_entry = 'no';
        $lobby_page_info = Lobby_Page_Detail::where('channel_id', '=', $channel_id)->first();
        if ($lobby_page_info) {
            $is_text_ticker = $lobby_page_info->is_text_ticker;
            $text_ticker_content = $lobby_page_info->text_ticker_content;
            $is_chat_pannel = $lobby_page_info->is_chat_pannel;
            $lobby_profile_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_profile_pic;
            $lobby_background_pic = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->lobby_background_pic;
            if ($lobby_page_info->intro_video_name != 'no_file') {
                $lobby_intro_video = "lobbyroomdata/" . $channelInfo->email_id . '/' . $lobby_page_info->intro_video_name;
            }
            $can_see_waiting_people = $lobby_page_info->can_see_waiting_people;
            $is_text_ticker_video_call = $lobby_page_info->is_ticker_for_video_page;
            $text_ticker_content_video_call = $lobby_page_info->ticker_text_for_video_page;
            $lobby_meeting_name = $lobby_page_info->meeting_name;

            if ($lobby_page_info->enter_direct == 'no') {

                $is_direct_entry = 'no';
            } else {
                $is_direct_entry = 'yes';
            }
        }

        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($receiver_name);

        Loby_Waiting_Clients::updateOrInsert(
            ['user_email' => $session_emailId, 'channel_id' => $channel_id], // Condition to find existing record
            ['is_accepted' => 0, 'Isread' => 0, 'Is_rejected' => 0] // Values to insert or update
        );

        $videoCallInfo = [
            'is_text_ticker' => $is_text_ticker,
            'text_ticker_content' => $text_ticker_content,
            'is_chat_pannel' => $is_chat_pannel,
            'lobby_profile_pic' => $lobby_profile_pic,
            'lobby_background_pic' => $lobby_background_pic,
            'lobby_intro_video' => $lobby_intro_video,
            'is_text_ticker_video_call' => $is_text_ticker_video_call,
            'text_ticker_content_video_call' => $text_ticker_content_video_call,
            'lobby_meeting_name' => $lobby_meeting_name,
            'is_direct_entry' => $is_direct_entry,
            'join_using_cellphone' => 'yes',

            'can_see_waiting_people' => $can_see_waiting_people,

        ];
        Session::put('VideoCallInfo', $videoCallInfo);


        if ($checkIsAllowWithoutURL) {
            if ($checkIsAllowWithoutURL->join_using_cellphone == 'no') {

                return view('NormalMeetingVideoCall/LobyMobileViewParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_img)
                    ->with('caller_name', $caller_name)->with('rec_profile_img', $rec_profile_img)->with('rec_name', $rec_full_name)->with('channel_id', $channel_id)->with('message', "The presenter restricts users from joining the video call via mobile phone .");
            } else {

                Loby_Waiting_Clients::updateOrInsert(
                    ['user_email' => Session::get('emailId'), 'channel_id' => $channel_id], // Condition to find existing record
                    ['is_accepted' => 0, 'Isread' => 0, 'Is_rejected' => 0] // Values to insert or update
                );

                return view('NormalMeetingVideoCall/LobyMobileViewParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_img)
                    ->with('caller_name', $caller_name)->with('rec_profile_img', $rec_profile_img)->with('rec_name', $rec_full_name)->with('channel_id', $channel_id);
            }
        } else {
            Loby_Waiting_Clients::updateOrInsert(
                ['user_email' => Session::get('emailId'), 'channel_id' => $channel_id], // Condition to find existing record
                ['is_accepted' => 0, 'Isread' => 0, 'Is_rejected' => 0] // Values to insert or update
            );

            return view('NormalMeetingVideoCall/LobyMobileViewParticipant')->with('type', 'receiver')->with('caller_profile_pic', $caller_profile_img)
                ->with('caller_name', $caller_name)->with('rec_profile_img', $rec_profile_img)->with('rec_name', $rec_full_name)->with('channel_id', $channel_id);
        }

    }
    public function videocalldashboardmobileReceiverNormalMeeting(Request $request)
    {
        return view('NormalMeetingVideoCall/MobileDisplay')->with('type', 'receiver')->with('camStatus', $request->camStatus)->with('micStatus', $request->micStatus)->with('channel_id', $request->channel_id);
    }







    function isMobileRequest()
    {
        // Check the 'User-Agent' string for mobile devices
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        // List of common mobile device patterns
        $mobileDevices = [
            'iPhone',
            'iPad',
            'Android',
            'BlackBerry',
            'Windows Phone',
            'Mobile',
            'Opera Mini',
            'IEMobile'
        ];

        // Loop through the list and check if any are found in the 'User-Agent' string
        foreach ($mobileDevices as $device) {
            if (stripos($userAgent, $device) !== false) {
                return true;
            }
        }

        // Return false if no mobile device pattern is found
        return false;
    }




    public function CheckLobyWaitingClientsScheduleMeeting(Request $request)
    {

        $channelId = $request->channelId;
        $isMessageFound = false;
        $session_emailId = Session::get('emailId');
        $individualData = DB::table('Loby_Waiting_Clients as lwc')
            ->join('individuals as i', 'lwc.user_email', '=', 'i.email_id') // Join with individual table
            ->where('lwc.channel_id', $channelId)
            ->select('lwc.*', 'i.*') // Select from both Loby_Waiting_Clients and individuals table
            ->get();

        // Fetching data from organisations table if no match in individuals
        $organizationData = DB::table('Loby_Waiting_Clients as lwc')
            ->join('organisations as o', 'lwc.user_email', '=', 'o.email_id') // Join with organization table
            ->where('lwc.channel_id', $channelId)
            ->select('lwc.*', 'o.*') // Select from both Loby_Waiting_Clients and organisations table
            ->get();

            $latestMessage = NormalMeetingLobyChat::where('receiver_email', '=', $session_emailId)->where('channel_id', '=', $channelId)->orderBy('id', 'DESC')->get();
            $folderPath = "";
        if (count($latestMessage) > 0) {
            $isMessageFound = true;
            foreach ($latestMessage as $roww) {
                $folderPath = $roww["images_path"];
            }
        }

        $fileNames = [];
        if ($folderPath != "Not Uploaded") {
            if (strlen($folderPath) != 0) {
                $path = public_path($folderPath);
                $files = array_slice(scandir($path), 2);
                // Initialize an array to hold the file names
                // Loop through the scanned files
                foreach ($files as $file) {
                    // Exclude the current and parent directory references ('.' and '..')
                    if ($file !== '.' && $file !== '..') {
                        // Add the file name to the array
                        $fileNames[] = $file;
                    }
                }
            }
        }

        $MeetingLinkData = DB::table('Loby_Waiting_Clients as lwc')
        ->join('meeting_links as m', 'lwc.user_email', '=', 'm.participant_email') // Join with organization table
        ->where('lwc.channel_id', $channelId)
        ->where('m.generated_link', $channelId)
        ->select('lwc.*', 'm.*') // Select from both Loby_Waiting_Clients and organisations table
        ->get();


        $data = $individualData->merge($organizationData);



        return response()->json(['status' => 'success', 'data' => $data,'latestMessage' => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath,"IsMessageFound" => $isMessageFound,"MeetingLinkData"=>$MeetingLinkData]);
    }



}