<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Session;
use App\Models\Video_Call_Entry;
use Illuminate\Http\Request;
use App\Models\Organisation;
use App\Models\Video_Chat;
use App\Models\Education;
use App\Models\UserModel;
use App\Models\MeetingLinks;
use App\Models\StudentClassInfo;
use App\Models\Video_Call_Entry_Scheduling;
use App\Models\PeerToPeerVideoCall;
use App\Models\VideoCallJoinUrl;
use Carbon\Carbon;
class VideoChat extends Controller
{


    public function VideChatInfo(Request $request)
    {
        $calling_email_id = $request->email_id_Calling;
        $calling_profile_pic = $request->profile_image_calling;
        $session_emailId = Session::get('emailId');


        $caller_name = $request->caller_name;
        $caller_profile_pic = $request->caller_profile_image;
        $calling_name = $request->calling_name;
        $call_type = $request->call_type;
        $channelID = $request->channel_id;
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();

        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }

        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);

        // for ($i = 0; $i < $length; $i++) {
        //     $channelID .= $characters[random_int(0, $charactersLength - 1)];
        // }
        $foundEntry = Video_Call_Entry::where('caller_email', '=', $session_emailId)
            ->where('calling_email', '=', $calling_email_id)
            ->where('channel_id', '=', $channelID)
            ->first(); // Use first() to get a single record

        if ($foundEntry) {

            $foundEntry->is_call_accepted = false;
            // Update the updated_at timestamp
            $foundEntry->updated_at = now(); // or \Carbon\Carbon::now()

            $foundEntry->save();
        } else {
            $channelID = "";
            for ($i = 0; $i < $length; $i++) {
                $channelID .= $characters[random_int(0, $charactersLength - 1)];
            }

            Video_Call_Entry::create([
                'calling_email' => $calling_email_id,
                'caller_email' => $session_emailId,
                'calling_email_profile_image' => $calling_profile_pic,
                'caller_email_profile_image' => $caller_profile_pic,
                'channel_id' => $channelID,
                'caller_full_name' => $caller_name,
                'calling_full_name' => $calling_name,
                'call_type' => $call_type,
                'is_call_accepted' => false,
            ]);
        }


        // Video_Call_Entry_Scheduling::where('calling_email', '=', $calling_email_id)->where('caller_email', '=', $session_emailId)->delete();
        // Video_Call_Entry_Scheduling::create([
        //     'calling_email' => $calling_email_id,
        //     'caller_email' => $session_emailId,
        //     'calling_email_profile_image' => $calling_profile_pic,
        //     'caller_email_profile_image' => $caller_profile_pic,
        //     'channel_id' => $channelID,
        //     'caller_full_name' => $caller_name,
        //     'calling_full_name' => $calling_name,
        //     'call_type' => $call_type,
        // ]);



        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($calling_name);
        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channelID,
            'acountType' => $acountType,
            'calling_person_name' => $calling_name,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $calling_profile_pic,
            'calling_person_email' => $calling_email_id,
            'caller_person_email' => $session_emailId,



        ];

        Session::put('VideoCallInfo', $videoCallInfo);

        $data = array();
        print_r(json_encode($data));
    }


    public function VideChatInfoMeeting(Request $request)
    {
        $calling_email_id = $request->email_id_Calling;
        $caller_email = $request->caller_email;

        $calling_profile_pic = $request->profile_image_calling;

        $session_emailId = Session::get('emailId');

        $channelID = '';

        $caller_name = '';
        $calling_name = '';
        $caller_profile_pic = '';

        $channelInfo = MeetingLinks::where('email_id', '=', $session_emailId)->orderBy('created_at', 'desc')->first();
        if ($channelInfo) {
            $channelID = $channelInfo->generated_link;
            $caller_name = $channelInfo->caller_name;
            $calling_name = $channelInfo->participant_name;
            $caller_profile_pic = $channelInfo->caller_profile_pic;

        }


        // $result = Video_Call_Entry_Scheduling::where('calling_email', $session_emailId)->where('caller_email', $caller_email)->get();
        // $caller_name = $request->caller_name;
        // $caller_profile_pic = $request->caller_profile_image;
        // $calling_name = $request->calling_name;
        // $call_type = $request->call_type;
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();
        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }

        // if ($result) {
        //     foreach ($result as $row) {
        //         $channelID = $row["channel_id"];
        //     }
        // }

        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($calling_name);
        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channelID,
            'acountType' => $acountType,
            'calling_person_name' => $calling_name,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $calling_profile_pic,
            'calling_person_email' => $calling_email_id,
            'caller_person_email' => $caller_email,

        ];

        Session::put('VideoCallInfo', $videoCallInfo);

        $data = array();
        print_r(json_encode($data));
    }

    public function AcceptCall(Request $request)
    {
        $channelID = $request->channel_id;
        // Video_Call_Entry::where('channel_id', '=', $channelID)->delete();
        //   return view('videocalldashboard')
        //   ->with('receiver', 'true')
        //   ->with('calling_profile_pic', '')
        //   ->with('channelID', $channelID)
        //  ;

    }

    public function videocalldashboard()
    {


        return view('videocallnewgui');
    }

    public function videocalldashboardmobile()
    {

        return view('videocallmobile');
    }


    public function isMobile()
    {
        $userAgent = $_SERVER['HTTP_USER_AGENT'];

        // List of common mobile user agents
        $mobileAgents = [
            'Android',
            'iPhone',
            'iPad',
            'iPod',
            'Opera Mini',
            'IEMobile',
            'BlackBerry',
            'webOS',
            'Mobile'
        ];

        foreach ($mobileAgents as $device) {
            if (stripos($userAgent, $device) !== false) {
                return true;
            }
        }

        return false;
    }

    public function joinVideoCallByUrl(Request $request)
    {
        $call_joiner_email = $request->email_address;
        $call_joiner_name = $request->full_name;
        $chanelID = $request->chanelId;
        $caller_email = "";
        $caller_name = "";
        $caller_profile_pic = "";



        $callerInfo = MeetingLinks::where('generated_link', '=', $chanelID)->get();

        if ($callerInfo) {
            foreach ($callerInfo as $row) {
                $caller_email = $row["email_id"];
                $caller_name = $row["caller_name"];
                $caller_profile_pic = $row["caller_profile_pic"];
            }
        }
        $file_name = "";
        $randomNum = rand(10, 1000);
        $fileName = "";
        if (isset($_FILES['customFile'])) {

            $errors = array();
            $file_name = $_FILES['customFile']['name'];
            $file_size = $_FILES['customFile']['size'];
            $file_tmp = $_FILES['customFile']['tmp_name'];
            $file_type = $_FILES['customFile']['type'];

            $file = explode('.', $_FILES['customFile']['name']);
            $file_raw = end($file);
            $file_ext = strtolower($file_raw);

            $extensions = array("jpeg", "jpg", "png");

            $file_name = $randomNum . $file_name;

            if (empty($errors) == true) {
                move_uploaded_file($file_tmp, "ProfileImages/Images/" . $file_name);
            } else {
                print_r($errors);
            }
        }



        MeetingLinks::create([
            'participant_email' => $call_joiner_email,
            'email_id' => $caller_email,
            'participant_profile_pic' => $file_name,
            'caller_profile_pic' => $caller_profile_pic,
            'generated_link' => $chanelID,
            'caller_name' => $caller_name,
            'participant_name' => $call_joiner_name,

        ]);


        // VideoCallJoinUrl::create([
        //     'user_email' => $call_joiner_email,
        //     'user_name' => $call_joiner_name,
        //     'Channel_ID' => $chanelID,
        //     'profile_pic' => $file_name,

        // ]);

        Session::put('emailId', $call_joiner_email);

        if ($this->isMobile()) {
            return view('videocallmobile');
        } else {
            return view('videocallnewgui');
        }
    }

    public function checkUserJoinVideoCallByUrl(Request $request)
    {

        $userInfo = VideoCallJoinUrl::where('Channel_ID', '=', $request->channel_Id)->get();
        $user_email = "";
        $user_full_name = "";
        $profile_pic = "";

        if (count($userInfo) > 0) {
            foreach ($userInfo as $row) {
                $user_email = $row['user_email'];
                $user_full_name = $row['user_name'];
                $profile_pic = $row['profile_pic'];

                break;
            }
        }
        VideoCallJoinUrl::where('Channel_ID', '=', $request->channel_Id)->delete();
        $data = array("user_email" => $user_email, "user_name" => $user_full_name, "profile_pic" => $profile_pic);
        print_r(json_encode($data));

    }
    public function generateNormalMeeting(Request $request)
    {
        $meetingDate = $request->datepicker;
        $meetingTime = $request->meetingTime;
        $participentEmail = $request->participentEmail;

        $fullName = $request->fullName;
        $profilePic = $request->profilePic;
        $meetingType = $request->link_type;
        $session_emailId = Session::get('emailId');
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $generated_Link = '';
        $length = 10;
        for ($i = 0; $i < $length; $i++) {
            $generated_Link .= $characters[random_int(0, $charactersLength - 1)];
        }

        $session_user_data = $this->returnUserInfo($session_emailId);

        //$newformat = date('Y-m-d',$meetingDate);
        $newformat = date('Y-m-d', strtotime($meetingDate));
        MeetingLinks::create([
            'email_id' => $session_emailId,
            'participant_email' => $participentEmail,
            'participant_name' => $fullName,
            'meeting_date' => $newformat,
            'meeting_time' => $meetingTime,
            'participant_profile_pic' => $profilePic,
            'generated_link' => $generated_Link,
            'link_type' => $meetingType,
            'caller_profile_pic' => $session_user_data[0],
            'caller_name' => $session_user_data[1],

        ]);

        return view('MeetingSchedule');
    }

    public function GenerateClassRoomLinksForStudents(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $length = 10;
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $channelID = '';
        $channelInfo = MeetingLinks::where('email_id', '=', $session_emailId)->orderBy('created_at', 'desc')->first();
        if ($channelInfo) {
            $channelID = $channelInfo->generated_link;

        }

        $calling_email_id = $request->email_id_Calling;
        $calling_profile_pic = $request->profile_image_calling;

        $caller_name = $request->caller_name;
        $caller_profile_pic = $request->caller_profile_image;
        $calling_name = $request->calling_name;
        $call_type = $request->call_type;
        $class_name = $request->class_name;

        $studentInfo = StudentClassInfo::where([['owner_email', '=', $session_emailId], ['class_name', '=', $class_name]])->get();
        $caller_info = $this->returnUserInfo($session_emailId);
        Video_Call_Entry::where('caller_email', '=', $session_emailId)->delete();
        if (count($studentInfo)) {
            foreach ($studentInfo as $row) {

                $user_data_info = $this->returnUserInfo($row['student_email']);

                Video_Call_Entry::create([
                    'calling_email' => $row['student_email'],
                    'caller_email' => $session_emailId,
                    'calling_email_profile_image' => $user_data_info[0],
                    'caller_email_profile_image' => $caller_info[0],
                    'channel_id' => $channelID,
                    'caller_full_name' => $caller_info[1],
                    'calling_full_name' => $user_data_info[1],
                    'call_type' => 'Video',
                    'is_call_accepted' => false,
                ]);
            }
        }
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();

        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }
        $caller_name = ucfirst($caller_name);
        $calling_name = ucfirst($calling_name);
        $videoCallInfo = [
            'receiver' => 'false',
            'channelID' => $channelID,
            'acountType' => $acountType,
            'calling_person_name' => $calling_name,
            'caller_name' => $caller_name,
            'caller_picture' => $caller_profile_pic,
            'calling_profile_pic' => $calling_profile_pic,
            'calling_person_email' => $calling_email_id,
            'caller_person_email' => $session_emailId,

        ];

        Session::put('VideoCallInfo', $videoCallInfo);

        $data = array();
        print_r(json_encode($data));
    }
    public function addStudentToClassroom(Request $request)
    {
        $studentEmail = $request->studentEmail;
        $className = $request->classRoomName;
        $session_emailId = Session::get('emailId');
        $studentInfo = StudentClassInfo::where([['student_email', '=', $studentEmail], ['class_name', '=', $className]])->get();

        if (count($studentInfo) == 0) {

            StudentClassInfo::create([
                'class_name' => $className,
                'student_email' => $studentEmail,
                'owner_email' => $session_emailId,
            ]);
            $data = array("message" => "AddSuccessfully");
        } else {
            $data = array("message" => "AlreadyAdded");
        }

        print_r(json_encode($data));
    }
    public function videocalldashboardaccept()
    {

        return view('videocalldashboard');
    }

    public function audiocalldashboard()
    {

        return view('audiocalldashboard');
    }
    public function audiocalldashboardmobile()
    {

        return view('audiocalldashboardmobile');
    }



    public function RejectVideoCall(Request $request)
    {
        $channelIDs = $request->channelID;
        //  Video_Call_Entry::where('channel_id', '=', $channelIDs)->delete();
        echo "Cancelled";
    }
    public function checkVideoCallLink()
    {
        $session_emailId = Session::get('emailId');
        $caller_data = PeerToPeerVideoCall::where('Receiver_Email', '=', $session_emailId)->where('is_call_read', '=', 0)->where('updated_at', '>', \Carbon\Carbon::now()->subMinutes(1))->get();
        if (count($caller_data) > 0) {
            PeerToPeerVideoCall::where('Receiver_Email', $session_emailId)->update(['is_call_read' => true]);
            // $data = array("IsDataFound" => 'yes');
            //  print_r(json_encode($data));
        }
        // $session_emailId = Session::get('emailId');
        // $caller_data = Video_Call_Entry::where('calling_email', '=', $session_emailId)->where('is_call_accepted', '=', 0)->where('updated_at', '>', \Carbon\Carbon::now()->subMinutes(1))->get();
        $caller_name = "";
        $channel_ID = "";
        $caller_type = "";
        $caller_profile_pic = "";
        $data = 'Not_Found';
        $acountType = 'other';
        $organisation = Organisation::where('email_id', $session_emailId)->get();
        if ($organisation) {
            foreach ($organisation as $row) {
                $caller_name = $row["entreprise_name"];
                $acountType = 'org';
            }
        }
        if (count($caller_data) > 0) {
            foreach ($caller_data as $roww) {
                $caller_profile_pic = $roww["Caller_Profile_Pic"];
                $calling_profile_pic = $roww["Receiver_Profile_Pic"];
                $caller_name = $roww["Caller_Full_Name"];
                $calling_name = $roww["Receiver_Full_Name"];
                $channel_ID = $roww["Channel_Id"];
                // $caller_type = $roww["call_type"];
                $caller_person_email = $roww["Caller_Email"];
            }
            Video_Call_Entry::where('channel_id', $channel_ID)->where('calling_email', '=', $session_emailId)->update(['is_call_accepted' => true]);
            $caller_name = ucfirst($caller_name);
            $calling_name = ucfirst($calling_name);
            $data = array("IsDataFound" => 'yes', "caller_profile_pic" => $caller_profile_pic, "caller_name" => $caller_name, "caller_channel_id" => $channel_ID, 'caller_type' => $caller_type, 'calling_profile_img' => $calling_profile_pic,"isGroupVideoCall"=>false);
            print_r(json_encode($data));
        } else {
            $caller_data = MeetingLinks::where('participant_email', '=', $session_emailId)->where('Is_Call_Accepted', '=', 0)->where('updated_at', '>', \Carbon\Carbon::now()->subMinutes(1))->get();
            if (count($caller_data) > 0) {
                MeetingLinks::where('participant_email', $session_emailId)->update(['Is_Call_Accepted' => true]);
            }
            if (count($caller_data) > 0) {
                foreach ($caller_data as $roww) {
                    $caller_profile_pic = $roww["caller_profile_pic"];
                    $calling_profile_pic = $roww["participant_profile_pic"];
                    $caller_name = $roww["caller_name"];
                    $calling_name = $roww["participant_name"];
                    $channel_ID = $roww["generated_link"];
                    $caller_person_email = $roww["email_id"];
                }
                $data = array("IsDataFound" => 'yes', "caller_profile_pic" => $caller_profile_pic, "caller_name" => $caller_name, "caller_channel_id" => $channel_ID, 'caller_type' => $caller_type, 'calling_profile_img' => $calling_profile_pic,"isGroupVideoCall"=>true);
                print_r(json_encode($data));
            } else {
                $data = array("IsDataFound" => 'no');
                print_r(json_encode($data));
            }
        }
    }






    public function submitVideoChat(Request $request)
    {

        $session_emailId = Session::get('emailId');
        $fullName = "";
        $profile_image = "";
        $destination = "Not Uploaded";
        $pathSaveToDb = "Not Uploaded";
        $chat_text = $request->chatText;
        $to_send_email = null;
        $chat_group_id = null;
        $isChat_group_id = null;
        $chanelIdd = $request->channelId;
        $private_gmail = "";
        $session_user_data = $this->returnUserInfo($session_emailId);

        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['files'])) {
            $files = $_FILES['files'];
            $uploaded = [];
            $errors = [];
            foreach ($files['tmp_name'] as $index => $tmpName) {
                $name = $files['name'][$index];
                // $name = round(microtime(true)) . '.' . end($name);
                $name = date('dmYHis') . str_replace(" ", "", $name);

                //  $name = preg_replace('/[^\w\d_]/', '', $name);
                $error = $files['error'][$index];




                if ($error === UPLOAD_ERR_OK) {

                    $datee = date('Y-m-d_H_i_s') . '';
                    $pathSaveToDb = "ChatImages/" . $chat_group_id . "/" . $datee;
                    $path = public_path("ChatImages/" . $chat_group_id . "/" . $datee);
                    if (!file_exists($path)) {
                        mkdir($path, 0777, true);
                    }
                    $destination = $path . '/' . $name;
                    if (move_uploaded_file($tmpName, $destination)) {
                        $uploaded[] = $name;
                    }
                }

                if (!empty($uploaded)) {
                    echo "Uploaded files: " . implode(', ', $uploaded);
                }
                if (!empty($errors)) {
                    echo "Errors: " . implode(', ', $errors);
                }
            }
        } else {
            $destination = "Not Uploaded";
        }

        $user_sending_message = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('calling_email', '=', $session_emailId)->get();
        $sender_user_full_name = "";
        $sender_user_profile_image = "";
        foreach ($user_sending_message as $userData) {
            if ($userData['calling_email'] == $session_emailId) {
                $sender_user_full_name = $userData['calling_full_name'];
                $sender_user_profile_image = $userData['calling_email_profile_image'];
                break;
            }
        }


        if ($request->has('participant_email')) {
            $calling_full_name = "";
            $calling_profile_pic = "";
            $caller_full_name = "";
            $caller_profile_pic = "";
            $calling_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('calling_email', '=', $request->participant_email)->get();
            if (count($calling_data) > 0) {

                foreach ($calling_data as $rowwData) {
                    $calling_full_name = $rowwData['calling_full_name'];
                    $calling_profile_pic = $rowwData['calling_email_profile_image'];
                    break;
                }
                $caller_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('calling_email', '=', $session_emailId)->get();
                if (count($caller_data) > 0) {
                    foreach ($caller_data as $rowwData) {
                        $caller_full_name = $rowwData['calling_full_name'];
                        $caller_profile_pic = $rowwData['calling_email_profile_image'];
                        break;
                    }

                } else {
                    $caller_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('caller_email', '=', $session_emailId)->get();
                    if (count($caller_data) > 0) {
                        foreach ($caller_data as $rowwData) {
                            $caller_full_name = $rowwData['caller_full_name'];
                            $caller_profile_pic = $rowwData['caller_email_profile_image'];
                            break;
                        }

                    }
                }

                Video_Chat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $request->participant_email,
                    'sended_text' => $chat_text,
                    'full_name' => $caller_full_name,
                    'profile_img' => $caller_profile_pic,
                    'full_name_sender' => $calling_full_name,
                    'profile_img_sender' => $calling_profile_pic,
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,

                ]);

            } else {
                $calling_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('caller_email', '=', $request->participant_email)->get();
                foreach ($calling_data as $rowwData) {
                    $calling_full_name = $rowwData['caller_full_name'];
                    $calling_profile_pic = $rowwData['caller_email_profile_image'];
                    break;
                }
                $caller_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->where('calling_email', '=', $session_emailId)->get();
                if (count($caller_data) > 0) {
                    foreach ($caller_data as $rowwData) {
                        $caller_full_name = $rowwData['calling_full_name'];
                        $caller_profile_pic = $rowwData['calling_email_profile_image'];
                        break;
                    }
                }
                Video_Chat::create([
                    'sender_email' => $session_emailId,
                    'receiver_email' => $request->participant_email,
                    'sended_text' => $chat_text,
                    'full_name' => $caller_full_name,
                    'profile_img' => $caller_profile_pic,
                    'full_name_sender' => $calling_full_name,
                    'profile_img_sender' => $calling_profile_pic,
                    'images_path' => $pathSaveToDb,
                    'channel_id' => $chanelIdd,

                ]);


            }


        } else {

            $caller_data = Video_Call_Entry::where('channel_id', '=', $chanelIdd)->get();
            $chandel_creator_email = "noset";
            foreach ($caller_data as $rowwData) {
                if ($rowwData['caller_email'] == $session_emailId) {
                    Video_Chat::create([
                        'sender_email' => $session_emailId,
                        'receiver_email' => $rowwData['calling_email'],
                        'sended_text' => $chat_text,
                        'full_name' => $rowwData['caller_full_name'],
                        'profile_img' => $rowwData['caller_email_profile_image'],
                        'full_name_sender' => $rowwData['calling_full_name'],
                        'profile_img_sender' => $rowwData['calling_email_profile_image'],
                        'images_path' => $pathSaveToDb,
                        'channel_id' => $chanelIdd,

                    ]);
                } else {


                    if ($rowwData['calling_email'] != $session_emailId) {
                        Video_Chat::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $rowwData['calling_email'],
                            'sended_text' => $chat_text,
                            'full_name' => $sender_user_full_name,
                            'profile_img' => $sender_user_profile_image,
                            'full_name_sender' => $rowwData['calling_full_name'],
                            'profile_img_sender' => $rowwData['calling_email_profile_image'],
                            'images_path' => $pathSaveToDb,
                            'channel_id' => $chanelIdd,

                        ]);
                    } else {
                        Video_Chat::create([
                            'sender_email' => $session_emailId,
                            'receiver_email' => $rowwData['caller_email'],
                            'sended_text' => $chat_text,
                            'full_name' => $sender_user_full_name,
                            'profile_img' => $sender_user_profile_image,
                            'full_name_sender' => $rowwData['calling_full_name'],
                            'profile_img_sender' => $rowwData['calling_email_profile_image'],
                            'images_path' => $pathSaveToDb,
                            'channel_id' => $chanelIdd,

                        ]);
                    }
                }

            }




            // if (count($caller_data) > 0) {
            //     $full_name_message_sender="";
            //     $profile_pic_message_sender="";
            //     foreach ($caller_data as $rowwData) {
            //         if ($rowwData['calling_email'] == $session_emailId) {
            //             $full_name_message_sender=$rowwData['calling_full_name'];
            //             $profile_pic_message_sender=$rowwData['calling_email_profile_image'];
            //     }
            // }

            //     $chandel_creator_email ="noset";
            //     foreach ($caller_data as $roww) {
            //         if ($chandel_creator_email == "noset") {
            //             $chandel_creator_email = $roww['caller_email'];
            //         }
            //     $calling_email = $roww['calling_email'];
            //         if ($calling_email != $session_emailId) {
            //             $sender_user_data = $this->returnUserInfo($calling_email);
            //             Video_Chat::create([
            //                 'sender_email' => $session_emailId,
            //                 'receiver_email' => $calling_email,
            //                 'sended_text' => $chat_text,
            //                 'full_name' => $full_name_message_sender,
            //                 'profile_img' => $profile_pic_message_sender,
            //                 'full_name_sender' => $roww['calling_full_name'],
            //                 'profile_img_sender' => $roww['calling_email_profile_image'],
            //                 'images_path' => $pathSaveToDb,

            //             ]);
            //         }
            //     }
            // }
            // if ($chandel_creator_email != $session_emailId) {
            //     $sender_user_data = $this->returnUserInfo($chandel_creator_email);
            //     Video_Chat::create([
            //         'sender_email' => $session_emailId,
            //         'receiver_email' => $chandel_creator_email,
            //         'sended_text' => $chat_text,
            //         'full_name' =>$full_name_message_sender,
            //         'profile_img' =>  $profile_pic_message_sender,
            //         'full_name_sender' => $sender_user_data[1],
            //         'profile_img_sender' => $sender_user_data[0],
            //         'images_path' => $pathSaveToDb,

            //     ]);
            // }
        }

        $data = array("chatGroupId" => 'noset');
        print_r(json_encode($data));
    }



    public function GetUserName(Request $request)
    {
        $userData = $this->returnUserInfo($request->email_id);
        $data = array("userFullName" => $userData[1]);
        print_r(json_encode($data));
    }


    public function returnUserInfo($emailAdd)
    {
        $infoArray = [];
        $resultProfile = UserModel::where('email_id', $emailAdd)->get();
        $num_rows = count($resultProfile);
        if ($num_rows > 0) {
            foreach ($resultProfile as $row) {
                $infoArray[] = $row["profile_picture"];
                $infoArray[] = $row["first_name"] . " " . $row["second_name"];
            }
        }

        // else {
        //     $resultProfile = Organisation::where('email_id', $emailAdd)->get();
        //     $num_rows = count($resultProfile);
        //     if ($num_rows > 0) {
        //         foreach ($resultProfile as $row) {
        //             $infoArray[] = $row["profile_picture"];
        //             $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //         }
        //     } else {
        //         $resultProfile = Education::where('email_id', $emailAdd)->get();
        //         $num_rows = count($resultProfile);
        //         if ($num_rows > 0) {
        //             foreach ($resultProfile as $row) {
        //                 $infoArray[] = $row["profile_picture"];
        //                 $infoArray[] = $row["first_name"] . " " . $row["second_name"];
        //             }
        //         }
        //     }
        // }
        return $infoArray;
    }

    public function checkMessageForVideoCallPage(Request $request)
    {
        $session_emailId = Session::get('emailId');
        $channelId = $request->channelId;

        //  $mailCount = Video_Chat::where('receiver_email', '=', $session_emailId)->get();


        $latestMessage = Video_Chat::where('receiver_email', '=', $session_emailId)->where('channel_id', '=', $channelId)->orderBy('id', 'DESC')->get();
        Video_Chat::where('receiver_email', '=', $session_emailId)->where('channel_id', '=', $channelId)->delete();

        $folderPath = "";
        if (count($latestMessage) > 0) {
            foreach ($latestMessage as $roww) {
                $folderPath = $roww["images_path"];
            }
        }

        $fileNames = [];
        if ($folderPath != "Not Uploaded") {
            if (strlen($folderPath) != 0) {

                $path = public_path($folderPath);
                $files = array_slice(scandir($path), 2);

                // Initialize an array to hold the file names


                // Loop through the scanned files
                foreach ($files as $file) {
                    // Exclude the current and parent directory references ('.' and '..')
                    if ($file !== '.' && $file !== '..') {
                        // Add the file name to the array
                        $fileNames[] = $file;
                    }
                }
            }
        }

        $data = array("latestMessage" => $latestMessage, "photoList" => $fileNames, "ImagePath" => $folderPath);

        print_r(json_encode($data));
    }
}