<?php

namespace App\Providers;
use App\Facades\GetJobPostData;
use App\Models\Education;
use App\Models\Follower;
use App\Models\FollowerCount;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\ChatController;
use App\Models\WorkingExperience;
use App\Models\Live_Chat;
use App\Models\diploma_education;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\UserLiveStatus;
use App\Facades\GetPostLikes;
use App\Facades\ServiceData;
use App\Facades\GetStudentsProfilePic;


use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind('GetPostLikeCheck', function($app){
            return new GetPostLikes();
        });

        $this->app->bind('GetJobPostDataRecord', function($app){
            return new GetJobPostData();
        });

        $this->app->bind('ServiceData', function($app){
            return new ServiceData();
        });

        $this->app->bind('GetStudentsProfilePic', function($app){
            return new GetStudentsProfilePic();
        });
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
          if (auth()->check()) {
            View::composer('layout.app', function ($view) {
                $userName = auth()->user()->name;
                echo $userName;
                die;
                $view->with(['userName' => $userName]);
            });
        }

    }
}
