<?php

namespace App\Providers;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use Illuminate\Support\Facades\View;
use App\Models\UserModel;
use Illuminate\Support\ServiceProvider;

class InboxMessageServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {

        View::composer(['TestingMessages', 'MeetingSchedule'], function ($view) {
            $recordsIndividual = UserModel::where('role', 'individual') // Add where clause
            ->latest()
            ->take(20)
            ->get();
            $recordsOrganisation = UserModel::where('role', 'organizational') // Add where clause
            ->latest()
            ->take(20)
            ->get();
            $recordsEducation = UserModel::where('role', 'education') // Add where clause
            ->latest()
            ->take(20)
            ->get();
             $view->with(['recordIndividual' =>$recordsIndividual,'recordOrganisation' =>   $recordsOrganisation ,'recordEdu'=> $recordsEducation ]);

        });
    }
}
