<?php

namespace App\Providers;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Session;
use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;
use App\Models\MeetingLinks;
use App\Models\StudentClassInfo;
use Illuminate\Support\Facades\DB;
class MeetingLinksProvider extends ServiceProvider
{
    /**
     * The policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // 'App\Models\Model' => 'App\Policies\ModelPolicy',
    ];

    /**
     * Register any authentication / authorization services.
     *
     * @return void
     */
    public function boot()
    {

        View::composer(['MeetingSchedule'], function ($view) {
            $sessionEmail=Session::get('emailId');


            $MeegingLinksList = DB::select(
                DB::raw("SELECT
                            generated_link,
                            MAX(id) as id,
                            MAX(email_id) as email_id,
                            MAX(participant_email) as participant_email,
                            MAX(participant_name) as participant_name,
                            MAX(meeting_date) as meeting_date,
                            MAX(meeting_time) as meeting_time,
                            MAX(participant_profile_pic) as participant_profile_pic,
                            MAX(link_type) as link_type,
                            MAX(caller_profile_pic) as caller_profile_pic,
                            MAX(caller_name) as caller_name

                        FROM `meeting_links`
                        WHERE (email_id = '$sessionEmail' OR participant_email = '$sessionEmail') AND join_from_url='No'
                        GROUP BY generated_link")
            );


            // $MeegingLinksList = DB::table('meeting_links')
            // ->where('email_id', '=', 'aamir@gmail.com')
            // ->orWhere('participant_email', '=', 'aamir@gmail.com')
            // ->groupBy('generated_link',  'id','created_at','updated_at',    'email_id',
            // 'participant_email',
            //  'participant_name',
            // 'meeting_date',
            // 'meeting_time',
            //  'participant_profile_pic',
            // 'generated_link',
            // 'link_type',
            // 'caller_profile_pic',
            // 'caller_name',
            // 'user_id',
            // 'join_from_url')  // Group by the generated_link column
            // ->get();
            $classList = StudentClassInfo::where('owner_email', '=',  $sessionEmail)->select('class_name')->distinct()->get();
            $view->with(['meetingLinksList' =>$MeegingLinksList,'studentClassInfo' =>$classList]);
        });

    }
}
