<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\FollowerCount;
use App\Models\Follower;
use App\Models\PostData;


class PostForHomePageProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
        Paginator::useBootstrap();
        
 // Define a view composer
 View::composer('*', function ($view) {

     $sessionEmail=Session::get('emailId');
     $PostData = PostData::latest('datetime')->where('email_id', $sessionEmail)->paginate(5);
     
     $view->with('UserPostData', $PostData);
 });
 
    }
}
