<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\FollowerCount;
use App\Models\Follower;
use App\Models\UserModel;
class SuggestionsProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
         // Define a view composer
 View::composer('*', function ($view) {

    $ProfilePic="ProfileImages/Images/";

    $emailId=null;
    $fullName=null;
    $cityCounty=null;
    $followCount=null;

    $SuggestionArray = [];
     $sessionEmail=Session::get('emailId');


     $result = UserModel::where('email_id', '!=', $sessionEmail)->where('role', '=', 'individual')->where('account_status','=','Active')->limit(3)->get();
     if($result){
        foreach($result as $row) {
            $fullName = $row["first_name"].' '.$row["second_name"];
            $cityCounty = $row["city_name"].', '.$row["country_name"];
            $ProfilePic=$row["profile_picture"];
            $emailId=$row["email_id"];

            $resultt =  Follower::where('email_id', '=', $row["email_id"])->get();
            $followUpCount = $resultt->count();
            if ($followUpCount > 1000) {
              $firstV = $followUpCount / 1000;
              $secondV = round($firstV, 2);
              $followCount = $secondV . 'k';
            }else{
                $followCount = $followUpCount . '';
            }

            $arrayToAdd = [
                'email_id' =>  $emailId,
                'FullName' =>   $fullName,
                'CityCountry' => $cityCounty,
                'FollowCount' => $followCount,
                'ProfilePic' =>$ProfilePic,
                'AccountType' => 'Ind'
            ];

            $SuggestionArray[] = $arrayToAdd ;

        }
     }
     //......................................................................

  //Getting 3 users from Education Tables and their Following Count and adding them into array list
  $result = UserModel::where('email_id', '!=', $sessionEmail)->where('role', '=', 'education')->where('account_status','=','Active')->limit(3)->get();
  if($result){
     foreach($result as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic=$row["profile_picture"];
         $emailId=$row["email_id"];

         $resultt =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resultt->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
            'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' =>$followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Edu'
         ];

         $SuggestionArray[] = $arrayToAdd ;

     }
  }
  //......................................................................
   //Getting 3 users from Organisation Tables and their Following Count and adding them into array list
   $result = UserModel::where('email_id', '!=', $sessionEmail)->where('role', '=', 'organizational')->where('account_status','=','Active')->limit(3)->get();
   if($result){
      foreach($result as $row) {
          $fullName = $row["first_name"].' '.$row["second_name"];
          $cityCounty = $row["city_name"].', '.$row["country_name"];
          $ProfilePic = $row["profile_picture"];
          $emailId=$row["email_id"];
          $resultt =  Follower::where('email_id', '=', $row["email_id"])->get();
          $followUpCount = $resultt->count();
          if ($followUpCount > 1000) {
            $firstV = $followUpCount / 1000;
            $secondV = round($firstV, 2);
            $followCount = $secondV . 'k';
          }else{
              $followCount = $followUpCount . '';
          }

          $arrayToAdd = [
            'email_id' =>  $emailId,
              'FullName' =>   $fullName,
              'CityCountry' => $cityCounty,
              'FollowCount' =>$followCount,
              'ProfilePic' =>$ProfilePic,
              'AccountType' => 'Org'
          ];

          $SuggestionArray[] = $arrayToAdd ;

      }
   }
   //......................................................................




    $view->with('SuggestionsData', $SuggestionArray);
 });

    }
}
