<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\DB;
use App\Models\profile_images;
use App\Models\Cover_Images;
use Illuminate\Support\Facades\Session;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\Follower;
use App\Models\diploma_education;
use App\Models\WorkingExperience;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\social_media_link;
use App\Models\UserModel;
class UserInformationServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {

 // Define a view composer
 View::composer('*', function ($view) {
   $firstName=null;
   $lastName=null;
   $CountryName=null;
   $CityName=null;
   $StatusDes=null;
   $followerCount =null;
   $followingCount=null;
   $FolowerArray = [];
   $FollowingArray =[];
   $ProfilePic="ProfileImages/Images/";
    $sessionEmail=Session::get('emailId');

    $userAccountTyle="Other";

    $result = UserModel::where([
        'email_id' => $sessionEmail
    ])->where([
        'role' =>'organizational'
    ])->first();


    if ($result) {
        $userAccountTyle='org';
    }else{
        $result = UserModel::where([
            'email_id' => $sessionEmail
        ])->first();
    }


    $resultFollower =  Follower::where('email_id', '=', $sessionEmail)->get();
    $followUpCount = $resultFollower->count();
    if ($followUpCount > 1000) {
      $firstV = $followUpCount / 1000;
      $secondV = round($firstV, 2);
      $followerCount = $secondV . 'k';
    }else{
        $followerCount = $followUpCount . '';
    }
    $resultFollowing =  Follower::where('follower_email_id', '=', $sessionEmail)->get();
    $followUpCount = $resultFollowing->count();

    if ($followUpCount > 1000) {
      $firstV = $followUpCount / 1000;
      $secondV = round($firstV, 2);
      $followingCount = $secondV . 'k';
    }else{
        $followingCount = $followUpCount . '';
    }


    // Getting Follower Information of the Login User..........................................................
     if( $resultFollower )
      {
        foreach($resultFollower as $row) {
        $follower_email=$row['follower_email_id'];
         $resultInd = UserModel::where('email_id', $follower_email)->where('role', 'individual')->get();
        if($resultInd){
           foreach($resultInd as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic=$row["profile_picture"];
               $emailId=$row["email_id"];

               $resultFoolwerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resultFoolwerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                   'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' => $followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Ind'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }

        $resultEdu = UserModel::where('email_id', $follower_email)->where('role', 'education')->get();
        if($resultEdu){
           foreach($resultEdu as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic=$row["profile_picture"];
               $emailId=$row["email_id"];

               $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resulttFollowerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                  'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' =>$followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Edu'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }


        $resultOrg = UserModel::where('email_id', $follower_email)->where('role', 'organizational')->get();
        if($resultOrg){
           foreach($resultOrg as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic = $row["profile_picture"];
               $emailId=$row["email_id"];
               $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resulttFollowerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                 'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' =>$followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Org'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }

        }
      }
    // End of Getting Follower Information of the Login User..........................................................




// Getting Following  Information of the Login User..........................................................
if( $resultFollowing )
{
  foreach($resultFollowing as $row) {
  $follower_email=$row['email_id'];
   $resultInd = UserModel::where('email_id', $follower_email)->where('role', 'individual')->get();
  if($resultInd){
     foreach($resultInd as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic=$row["profile_picture"];
         $emailId=$row["email_id"];

         $resultFoolwerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resultFoolwerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
             'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' => $followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Ind'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }

  $resultEdu =  UserModel::where('email_id', $follower_email)->where('role', 'education')->get();
  if($resultEdu){
     foreach($resultEdu as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic=$row["profile_picture"];
         $emailId=$row["email_id"];

         $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resulttFollowerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
            'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' =>$followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Edu'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }


  $resultOrg =  UserModel::where('email_id', $follower_email)->where('role', 'organizational')->get();
  if($resultOrg){
     foreach($resultOrg as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic = $row["profile_picture"];
         $emailId=$row["email_id"];
         $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resulttFollowerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
           'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' =>$followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Org'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }

  }
}
// End of Getting Follower Information of the Login User..........................................................




    $FolowerArrayPagination = $this->paginate($FolowerArray);
    $FollowingArrayPagination = $this->paginate($FollowingArray);
    $view->with([
        'userProfileData' => $result,
        'followerCount' => $followerCount,
        'followingCount' => $followingCount,
        'followerData' =>   $FolowerArrayPagination,
        'followingData' =>   $FollowingArrayPagination,
        'userAccountType'=>  $userAccountTyle,

    ] );


});

View::composer('homeind', function ($view) {
$sessionEmail=Session::get('emailId');



// Getting Diploma Education  for the user..............
$userDiplomaEdu =  diploma_education::where('email_address', '=', $sessionEmail)->get();
// Getting Working Experience for the user...................
$workingExperience =  WorkingExperience::where('email_address', '=', $sessionEmail)->get();
$socialMediaLinks=social_media_link::where('email_id', '=', $sessionEmail)->get();
$facebook=null;
$twiter=null;
$linkedin=null;
$Instagram=null;
$youtube=null;
$githubube=null;
if($socialMediaLinks){
    foreach($socialMediaLinks as $row) {
        if($row["url_type"]=='facebook'){
         $facebook = $row["url_link"];
        }else if($row["url_type"]=='twiter'){
            $twiter = $row["url_link"];
        }else if($row["url_type"]=='linkedin'){
            $linkedin = $row["url_link"];
        }else if($row["url_type"]=='Instagram'){
            $Instagram = $row["url_link"];
        }else if($row["url_type"]=='youtube'){
            $youtube = $row["url_link"];
        }else if($row["url_type"]=='github'){
            $githubube = $row["url_link"];
        }


    }
}

$oldProfilePictures = profile_images::where('email_id', '=', $sessionEmail)->latest()->take(20)->get();

$coverProilePic="homebanner.jpg";
$coverPic = Cover_Images::where('email_id', '=', $sessionEmail)->get();
if($coverPic){
    foreach($coverPic as $row) {
        $coverProilePic=$row['image_name'];
    }
}




$view->with([

    'diplomaEdu' => $userDiplomaEdu,
    'workingExp' => $workingExperience,
    'facebook' => $facebook,
    'twiter' => $twiter,
    'linkedin' => $linkedin,
    'Instagram' => $Instagram,
    'youtube' => $youtube,
    'githubube' =>  $githubube,
    'oldProfilePictures' => $oldProfilePictures,
    'CoverPic' => $coverProilePic,
]);
});



View::composer('homeorg', function ($view) {
    $sessionEmail=Session::get('emailId');
    $oldProfilePictures = profile_images::where('email_id', '=', $sessionEmail)->latest()->take(20)->get();
    //getting picture ...................................
    $coverProilePic="homebanner.jpg";
    $coverPic = Cover_Images::where('email_id', '=', $sessionEmail)->get();
    if($coverPic){
        foreach($coverPic as $row) {
            $coverProilePic=$row['image_name'];
        }
    }


    $view->with([


        'CoverPic' => $coverProilePic,
        'oldProfilePictures' => $oldProfilePictures,
    ]);
    });

    }

   /**
     * Paginate an array of items.
     *
     * @return LengthAwarePaginator         The paginated items.
     */
    private function paginate(array $items, int $perPage = 6, ?int $page = null, $options = []): LengthAwarePaginator
    {
        $page = $page ?: (LengthAwarePaginator::resolveCurrentPage() ?: 1);
        $items = collect($items);
        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }
}
