<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\FollowerCount;
use App\Models\Follower;
use App\Models\diploma_education;
use Illuminate\Pagination\LengthAwarePaginator;
use App\Models\WorkingExperience;
use App\Models\social_media_link;
use App\Models\Cover_Images;
use App\Models\profile_images;
use App\Models\PostData;
use App\Models\UserModel;
class UserProfileServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap services.
     *
     * @return void
     */
    public function boot()
    {
         // Define a view composer
// View::composer(['ProfileInd', 'ProfileOrg' ,'videocalldashboard'], function ($view) {
    View::composer(['ProfileInd', 'ProfileOrg' ,'videocalldashboard','checkvideocallstatus','TestingMessages'], function ($view) {
    $followerCount =null;
    $followingCount=null;
    $FolowerArray = [];
    $FollowingArray =[];
    $ProfilePic="ProfileImages/Images/";
    $profile_user_email_id=Session::get('profilePersonEmail');



    $result = UserModel::where([
        'email_id' => $profile_user_email_id
    ])->first();

    $resultFollower =  Follower::where('email_id', '=', $profile_user_email_id)->get();
    $followUpCount = $resultFollower->count();
    if ($followUpCount > 1000) {
      $firstV = $followUpCount / 1000;
      $secondV = round($firstV, 2);
      $followerCount = $secondV . 'k';
    }else{
        $followerCount = $followUpCount . '';
    }
    $resultFollowing =  Follower::where('follower_email_id', '=', $profile_user_email_id)->get();
    $followUpCount = $resultFollowing->count();

    if ($followUpCount > 1000) {
      $firstV = $followUpCount / 1000;
      $secondV = round($firstV, 2);
      $followingCount = $secondV . 'k';
    }else{
        $followingCount = $followUpCount . '';
    }


    // Getting Follower Information of the Login User..........................................................
     if( $resultFollower )
      {
        foreach($resultFollower as $row) {
        $follower_email=$row['follower_email_id'];
         $resultInd = UserModel::where('email_id', $follower_email)->where('role', 'individual')->get();
        if($resultInd){
           foreach($resultInd as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic=$row["profile_picture"];
               $emailId=$row["email_id"];

               $resultFoolwerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resultFoolwerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                   'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' => $followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Ind'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }

        $resultEdu = UserModel::where('email_id', $follower_email)->where('role', 'education')->get();
        if($resultEdu){
           foreach($resultEdu as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic=$row["profile_picture"];
               $emailId=$row["email_id"];

               $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resulttFollowerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                  'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' =>$followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Edu'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }


        $resultOrg = UserModel::where('email_id', $follower_email)->where('role', 'organizational')->get();
        if($resultOrg){
           foreach($resultOrg as $row) {
               $fullName = $row["first_name"].' '.$row["second_name"];
               $cityCounty = $row["city_name"].', '.$row["country_name"];
               $ProfilePic = $row["profile_picture"];
               $emailId=$row["email_id"];
               $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
               $followUpCount = $resulttFollowerCount->count();
               if ($followUpCount > 1000) {
                 $firstV = $followUpCount / 1000;
                 $secondV = round($firstV, 2);
                 $followCount = $secondV . 'k';
               }else{
                   $followCount = $followUpCount . '';
               }

               $arrayToAdd = [
                 'email_id' =>  $emailId,
                   'FullName' =>   $fullName,
                   'CityCountry' => $cityCounty,
                   'FollowCount' =>$followCount,
                   'ProfilePic' =>$ProfilePic,
                   'AccountType' => 'Org'
               ];

               $FolowerArray[] = $arrayToAdd ;

           }
        }

        }
      }
    // End of Getting Follower Information of the Login User..........................................................




// Getting Following  Information of the Login User..........................................................
if( $resultFollowing )
{
  foreach($resultFollowing as $row) {
  $follower_email=$row['follower_email_id'];
   $resultInd = UserModel::where('email_id', $follower_email)->where('role', 'individual')->get();
  if($resultInd){
     foreach($resultInd as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic=$row["profile_picture"];
         $emailId=$row["email_id"];

         $resultFoolwerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resultFoolwerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
             'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' => $followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Ind'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }

  $resultEdu =UserModel::where('email_id', $follower_email)->where('role', 'education')->get();
  if($resultEdu){
     foreach($resultEdu as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic=$row["profile_picture"];
         $emailId=$row["email_id"];

         $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resulttFollowerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
            'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' =>$followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Edu'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }


  $resultOrg = UserModel::where('email_id', $follower_email)->where('role', 'organizational')->get();
  if($resultOrg){
     foreach($resultOrg as $row) {
         $fullName = $row["first_name"].' '.$row["second_name"];
         $cityCounty = $row["city_name"].', '.$row["country_name"];
         $ProfilePic = $row["profile_picture"];
         $emailId=$row["email_id"];
         $resulttFollowerCount =  Follower::where('email_id', '=', $row["email_id"])->get();
         $followUpCount = $resulttFollowerCount->count();
         if ($followUpCount > 1000) {
           $firstV = $followUpCount / 1000;
           $secondV = round($firstV, 2);
           $followCount = $secondV . 'k';
         }else{
             $followCount = $followUpCount . '';
         }

         $arrayToAdd = [
           'email_id' =>  $emailId,
             'FullName' =>   $fullName,
             'CityCountry' => $cityCounty,
             'FollowCount' =>$followCount,
             'ProfilePic' =>$ProfilePic,
             'AccountType' => 'Org'
         ];

         $FollowingArray[] = $arrayToAdd ;

     }
  }

  }
}
// End of Getting Follower Information of the Login User..........................................................




    $FolowerArrayPagination = $this->paginate($FolowerArray);
    $FollowingArrayPagination = $this->paginate($FollowingArray);


// Getting Diploma Education  for the user..............
$userDiplomaEdu =  diploma_education::where('email_address', '=', $profile_user_email_id)->get();
// Getting Working Experience for the user...................
$workingExperience =  WorkingExperience::where('email_address', '=', $profile_user_email_id)->get();
$socialMediaLinks=social_media_link::where('email_id', '=', $profile_user_email_id)->get();
$facebook=null;
$twiter=null;
$linkedin=null;
$Instagram=null;
$youtube=null;
$githubube=null;
if($socialMediaLinks){
foreach($socialMediaLinks as $row) {
    if($row["url_type"]=='facebook'){
     $facebook = $row["url_link"];
    }else if($row["url_type"]=='twitter'){
        $twiter = $row["url_link"];
    }else if($row["url_type"]=='linkdin'){
        $linkedin = $row["url_link"];
    }else if($row["url_type"]=='instagram'){
        $Instagram = $row["url_link"];
    }else if($row["url_type"]=='youtube'){
        $youtube = $row["url_link"];
    }else if($row["url_type"]=='github'){
        $githubube = $row["url_link"];
    }


}
}

$oldProfilePictures = profile_images::where('email_id', '=', $profile_user_email_id)->latest()->take(20)->get();

$coverProilePic="homebanner.jpg";
$coverPic = Cover_Images::where('email_id', '=', $profile_user_email_id)->get();
if($coverPic){
foreach($coverPic as $row) {
    $coverProilePic=$row['image_name'];
}
}

$PostData = PostData::latest('datetime')->where('email_id', $profile_user_email_id)->paginate(5);


$SessionEmail=Session::get('emailId');


$isFollowe = Follower::where([['email_id', '=', $profile_user_email_id], ['follower_email_id', '=', $SessionEmail]])->get();
$isFolloww = 'Follow';
if (count($isFollowe) > 0) {
    $isFolloww = 'UnFollow';
} else {
    $isFolloww = 'Follow';
}






$userProfileVisiterData = [
    'userEmail'=>$profile_user_email_id,
    'facebook' => $facebook,
    'twiter' => $twiter,
    'linkedin' => $linkedin,
    'Instagram' => $Instagram,
    'youtube' => $youtube,
    'githubube' =>  $githubube,
    'oldProfilePictures' => $oldProfilePictures,
    'CoverPic' => $coverProilePic,
    'followerCount' => $followerCount,
    'followingCount' => $followingCount,
    'IsFollow' => $isFolloww,


  ];
  $view->with(['userProfileVisiterData'=> $userProfileVisiterData,'userProfileVisitedUser' => $result, 'workingExpVisitedUser' => $workingExperience, 'diplomaEduVisitedUser' => $userDiplomaEdu,'UserPostDataVisitedUser'=> $PostData, 'followerDataVistedUser' =>   $FolowerArrayPagination, 'followingDataVistedUser' =>   $FollowingArrayPagination]);

 });

    }

       /**
     * Paginate an array of items.
     *
     * @return LengthAwarePaginator         The paginated items.
     */
    private function paginate(array $items, int $perPage = 6, ?int $page = null, $options = []): LengthAwarePaginator
    {
        $page = $page ?: (LengthAwarePaginator::resolveCurrentPage() ?: 1);
        $items = collect($items);
        return new LengthAwarePaginator($items->forPage($page, $perPage), $items->count(), $perPage, $page, $options);
    }
}
