<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('first_name');
            $table->string('second_name');
            $table->string('email_id')->unique();
            $table->date('birth_date')->nullable();
            $table->string('zip_code')->nullable();
            $table->string('city_name')->nullable();
            $table->string('country_name')->nullable();
            $table->date('reg_date')->nullable();
            $table->string('education')->nullable();
            $table->string('mostrecent')->nullable();
            $table->string('student')->nullable();
            $table->string('profile_picture')->nullable();
            $table->string('cv')->nullable();
            $table->string('ethnicity')->nullable();
            $table->string('gender')->nullable();
            $table->string('status')->nullable();
            $table->string('about_us')->nullable();
            $table->string('phone_number')->nullable();
            $table->string('full_address')->nullable();
            $table->string('account_status')->nullable();
            $table->string('account_status_date')->nullable();
            $table->string('ban_reason')->nullable();
            $table->string('ban_type')->nullable();
            $table->string('interview_video_path')->nullable();

            $table->string('company_website')->nullable();
            $table->string('organization_email')->nullable();
            $table->string('civic_adress')->nullable();
            $table->string('city_company')->nullable();
            $table->string('organization_reg_date')->nullable();
            $table->string('org_structure')->nullable();
            $table->string('country_org')->nullable();
            $table->string('personal_email')->nullable();
            $table->string('entriseprise_email')->nullable();
            $table->string('entreprise_name')->nullable();
            $table->string('entreprise_web_url')->nullable();

            $table->string('role')->default('user');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('login_password');
            $table->string('avatar')->default('avatar.png');
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
