<?php
use App\Facades\GetVideoCallInfo;
$user_id = 0;
if ($type == 'caller') {
    $callInformationSession = Session::get('VideoCallInfo');
    $user_id = 1;

} else {
    $callInformationSession = GetVideoCallInfo::getReceiverVideoCallInformationNormalMeetingVideoCall($channel_id);
    $user_id = $callInformationSession['user_id'];
}
$uploadVidoeDateTime = date('Y-m-d h-i-sa');
$dateForCanvas = date('Y-m-d h:i:sa');
$session_emailId = Session::get('emailId');
$uploadVidoeDateTime = str_replace(' ', 'k', $uploadVidoeDateTime);

?>
<!DOCTYPE html>
<html>

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script>

        savedUserId = <?php echo (int) $user_id;?>;

    </script>
    <script src="https://cdn.webrtc-experiment.com/MediaStreamRecorder.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src='js//AgoraRTC_N-4.11.0.js'></script>
    <script src='js//agora-rtm-sdk-1.5.1.js'></script>
    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js//url.js"></script>
    <script src="https://www.webrtc-experiment.com/MultiStreamsMixer.js"></script>

    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .fullScreen {
            width: 100%;
        }

        .half {
            width: 50%;
        }

        .headerDiv {
            display: flex;
            overflow-x: auto;
            white-space: nowrap;
            /* Prevents the flex items from wrapping */
            border: 1px solid #ccc;
            padding: 10px;
            height: 160px;
            width: 100%;
            background-color: white;
        }

        .item {
            flex: 0 0 auto;
            /* Prevents the items from growing or shrinking */
            width: 140px;
            /* Set a fixed width for each item */
            margin-right: 10px;
            /* Add some space between items */
            border: 1px solid black;

            text-align: center;
        }

        .item-main-video {
            width: 100%;
            height: 76vh;

            margin-top: 20px;
            margin-left: 10px;
            margin-right: 10px;
            border: 2px solid black;
        }

        .item-main-chat {
            width: 90%;
            height: 76vh;

            margin-top: 20px;
            margin-left: 10px;
            margin-right: 10px;
            border: 2px solid black;
        }

        .dots {
            margin-top: 10px;

        }





        @media (max-height: 300px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 53vh;
                /* Height for viewport heights between 400px and 800px */
            }
        }

        @media (min-height: 301px) and (max-height: 600px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 26vh;
                /* Height for viewport heights between 400px and 800px */
            }
        }

        /* Media query for height ranges */
        @media (min-height: 601px) and (max-height: 700px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 19vh;
                /* Height for viewport heights between 400px and 800px */
            }
        }

        @media (min-height: 701px) and (max-height: 800px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 14vh;
                /* Height for viewport heights between 801px and 1200px */
            }
        }

        @media (min-height:801px) and (max-height:900px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 13vh;
                /* Height for viewport heights between 801px and 1200px */
            }

        }

        @media (min-height:901px) {
            .small-panal {
                background-color: black;
                margin-left: 1px;
                margin-right: 1px;
                display: flex;
                height: 5vh;
                /* Height for viewport heights between 801px and 1200px */
            }

        }


        #exampleModal {
            transform: translate(50px, 50px);
        }

        .modal-body {
            overflow-y: scroll;
            text-align: justify;
        }

        /* Container for the ticker */
        .ticker-container {
            width: 100%;
            /* Ensure it's responsive */
            overflow: hidden;
            /* Hide anything that goes outside of the container */
            position: relative;
            background-color: #2d3e50;
            color: #ffffff;
            padding: 10px 0;

        }

        .ticker {
            display: flex;
            /* Flexbox for continuous inline elements */
            white-space: nowrap;
            /* Prevent line breaks */
            animation: ticker-animation 60s linear;
            font-size: 20px;
            padding-left: 30%;
            font-weight: bold;
        }

        .ticker span {
            padding-right: 20px;
            /* Optional: space between ticker items */
        }

        @keyframes ticker-animation {
            0% {
                transform: translateX(100%);
                /* Start from the right side (off-screen) */
            }

            100% {
                transform: translateX(-100%);
                /* Move to the left side (off-screen) */
            }
        }
    </style>
    <script>


        let APP_ID = "73e8edbdef7f4a6d81d4eae91be83a5f";
        let tokenPeerToPeer = null;
        let client;
        let channel;
        let isRecCall = false;
        let channelNamePeerToPeer = '<?php echo $callInformationSession['channelID']; ?>';

        let joinUserCount = 1;
        //let channelNamePeerToPeer = "TcpekRm232";
        // let uidd = String(Math.floor(Math.random() * 10000));;
        let uidd = <?php echo (int) $user_id; ?>;
        let localStream;
        let remoteStream;
        let peerConnection;
        let videoCountWeb = 1;
        let videoCount = 1;
        let localTracks = [];
        let remoteUsers = {};
        let localScreenTracks;
        let sharingScreen = false;
        let audioMuted = false;
        let screenCaptureStream;
        let isScreenIsShared = false;
        let userScreenType;
        let isWebCamOn = true;
        let user_count = 1;
        let remoteUserStreamPeerToPeer;
        let hasJoined = false;
        var camStatus = <?php echo isset($camStatus) ? $camStatus : true; ?>;
        var micStatus = <?php echo isset($micStatus) ? $micStatus : true; ?>;
        let init = async (type, screenType) => {
            if (hasJoined) {
                return;
            }
            let counter = 1;
            userScreenType = screenType;
            client = AgoraRTC.createClient({ mode: 'rtc', codec: 'vp8' });

            await client.join(APP_ID, channelNamePeerToPeer, tokenPeerToPeer, uidd);
            joinStream(screenType);
            hasJoined = true;
            client.on('user-published', handleUserPublished);
            client.on('user-left', handelVideoUserLeft);
        }


        let selectUserId = uidd;

        let handleUserPublished = async (user, mediaType) => {

            remoteUserStreamPeerToPeer = user;
            remoteUsers[user.uid] = user;
            await client.subscribe(user, mediaType);
            // if (typeof user.videoTrack === 'undefined') {
            //     return; // Exit the function if videoTrack is undefined
            // }


            if (mediaType === 'video') {
                var combinedStreamRemoteUserSmallFrame = new MediaStream();
                const trackVideo = remoteUserStreamPeerToPeer.videoTrack.getMediaStreamTrack();
                if (trackVideo.enabled) {
                    combinedStreamRemoteUserSmallFrame.addTrack(trackVideo);
                }

            }
            if (mediaType === 'audio') {
                user.audioTrack.play();
            }

            fetchUserByName(user.uid);

            // if (selectUserId == user.uid) {
            //     setCallingPersonDisplay(selectUserId);

            // } else {
            //     setOwnVideoDisplay(uidd);
            // }

            setGlobalDisplayPeerToPeer();

        }

        let handelVideoUserLeft = async (user) => {
            var element = document.getElementById(`user-local${user.uid}`);
            if (element) {
                var container = document.getElementById("user-container-local");
                container.removeChild(element);
            } else {
                console.log("Element not found!");
            }
            var liElement = document.getElementById("list" + user.uid);
            var mainElement = document.getElementById("VideoCallClientList");
            if (liElement) {
                mainElement.removeChild(liElement);
            }
            var liElementMessage = document.getElementById("message" + user.uid);
            const selectElement = document.getElementById('Selected_Participants');
            if (liElementMessage) {
                selectElement.removeChild(liElementMessage);
            }


        }
        let joinStream = async (screenTyle) => {
            localTracks = await AgoraRTC.createMicrophoneAndCameraTracks({}, {
                encoderConfig: {
                    width: {
                        min: 640,
                        ideal: 1920,
                        max: 1920
                    },
                    height: {
                        min: 480,
                        ideal: 1080,
                        max: 1080
                    }
                }
            });
            localTracks[1].play(document.getElementById("user-local"));
            await client.publish([localTracks[0], localTracks[1]]);
            setGlobalDisplayPeerToPeer();
            document.getElementById("video-call-btn").style.background = "green";
            document.getElementById("mic-btn").style.background = "green";
            if (camStatus == false) {
                shareVideoMobileNormalMeeting();
            }
            if (micStatus == false) {
                toggleAudioMobileNormalMeeting();
            }
        }
        function setOwnVideoDisplay() {
            isScreenIsShared = false;
            removeVideoFrames();
            createUserLocalFrame();
            localTracks[1].play(document.getElementById("user-local"));
        }

        function createUserLocalFrame() {
            if (document.getElementById('user-local')) {
                document.getElementById("user-local").remove();
            }
            let player = `<div class="video-player" id="user-local" style="width:100%;height:88vh;object-fit: cover;
                    border: 3px solid #fff;
                    border-radius: 8px;"></div>`;
            document.getElementById('user-container-local').insertAdjacentHTML('beforeend', player);
        }


        function setCallingPersonDisplay(uid) {
            selectUserId = uid;
            removeVideoFrames();
            if (remoteUsers[uid] !== undefined || remoteUsers[uid] !== null) {
                createUserLocalFrame();
                remoteUserStream = remoteUsers[uid];
                remoteUserStream.videoTrack.play(document.getElementById("user-local"));
            }
        }

        function removeVideoFrames() {
            if (document.getElementById('user-local')) {
                document.getElementById("user-local").remove();
            }
            for (let uid in remoteUsers) {
                if (remoteUsers.hasOwnProperty(uid)) {
                    if (document.getElementById(`user-local${uid}`)) {
                        document.getElementById(`user-local${uid}`).remove();
                    }
                }
            }
        }

        function setGlobalDisplayPeerToPeer() {

            removeVideoFrames();
            let player1 = `<div class="video-player" id="user-local" style="width:100%;height:45vh; width: 100%;
            object-fit: cover;
            border: 3px solid #fff;
            border-radius: 8px;"></div>`;
            document.getElementById('user-container-local').insertAdjacentHTML('beforeend', player1);
            localTracks[1].play(document.getElementById("user-local"));


            for (let uid in remoteUsers) {
                if (remoteUsers.hasOwnProperty(uid)) {
                    let remoteUserStream = remoteUsers[uid];
                    // Do something with remoteUserStream
                    let player2 = `<div class="video-player" id='user-local${uid}' style="width:100%;height:45vh; width: 100%;
                    object-fit: cover;
                    border: 3px solid #fff;
                    border-radius: 8px;"></div>`;
                    document.getElementById('user-container-local').insertAdjacentHTML('beforeend', player2);
                    if (remoteUserStream !== undefined || remoteUserStream !== null) {
                        remoteUserStream.videoTrack.play(document.getElementById(`user-local${uid}`));
                    }
                }
            }



        }


          init();
    </script>











































    </script>
</head>

<body>


    <body>




        <div class="row" style="background-color:black;">
            <div class="col-6  ps-4">

                <button type="button" class="btn dots dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false"
                    style="width:60px;height:35px;padding:0px;margin:0px;color:white;">
                    <i class="fas fa-ellipsis-h"></i>
                </button>

                <ul class="dropdown-menu" aria-labelledby="dropdownMenuLink" id="VideoCallClientList">
                    <!-- <li><a class="dropdown-item" href="#" onclick="setCallingPersonDisplay();">View Presenter Screen</a></li> -->
                    <li><a class="dropdown-item" href="#" onclick="setOwnVideoDisplay();">View My Screen</a>
                    </li>
                    <li><a class="dropdown-item" href="#" onclick="setGlobalDisplayPeerToPeer();">Global View</a></li>

                </ul>
            </div>

            <div class="col-5 d-flex justify-content-end pe-3">
                <img src="images/messageicon.png" style="width:30px;height:30px;cursor:pointer;margin-end:30px;"
                    onclick=" showChatDialog();">
            </div>
        </div>

        <div class="container-fluid p-0 m-0" style="background-color:black;">
            <div class="item-main-video mt-0 pt-0">
                <div class="row" style="background-color:black;height:100vh;width:100%;">

                    <div class="video__container" id="user-container-local"
                        style="width:100%;height:100vh;margin-top:5px;">
                        <div class="video-player" id="user-local" style="width:100%;height:90vh;"></div>


                    </div>
                    <div class="row" id="callscontolls" style="width:100%;margin-bottom:100px;background-color:transparent;top: 50%;
            transform: translateY(400%);  position: fixed;     display:flex;
    justify-content: center;
    align-items: center;;">

                        <!-- <div class="control-container" id="camera-btn" data-toggle="tooltip"
                                        data-placement="top" title="Share Screen">
                                        <img src="videocallicons/screensharing.png" id="screensharing"
                                            onclick="shareScreen();" />
                                    </div> -->
                        <div class="col-3 text-end">
                            <div class="control-container-mobile" id="video-call-btn" data-toggle="tooltip"
                                onclick="shareVideoMobileNormalMeeting();" data-placement="top" title="Toggle Video"
                                style="margin-left:auto;;">
                                <img src="videocallicons/camera.png" id="camera" />
                            </div>
                        </div>
                        <div class="col-3 text-center">
                            <div class="control-container-mobile" id="mic-btn" data-toggle="tooltip"
                                onclick="toggleAudioMobileNormalMeeting();" data-placement="top" title="Toggle Mic">
                                <img src="videocallicons/mic.png" id="mic" />
                            </div>
                        </div>
                        <!--
                                    <div class="control-container" id="videoRecButton" onclick="startRec();"
                                        data-toggle="tooltip" data-placement="top" title="Start/Stop Recording">
                                        <img src="videocallicons/recvideo.png" style="width:50px;height:30px" />
                                    </div> -->



                        <div class="col-3 text-start">
                            <div class="control-container-mobile" id="leave-btn" onclick="closeWindows();"
                                style="margin-right:auto;" data-toggle="tooltip" data-placement="top" title="End Call">
                                <img src="videocallicons/phone.png" id="sharedScreen" />
                            </div>
                        </div>



                    </div>
                </div>



            </div>
        </div>

        </div>


        <div class="modal fade" id="ChatModel1" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header" style="background-color:  #3b3c3b ;height:40px;">
                        <div class="row" style="width:100%;">

                            <div class="col-10  me-auto">
                                <a href="javascript:void(0);"
                                    style="margin-left:0px;padding-top:0;padding-bottom:0;color: white  ;text-decoration: none;"
                                    id="sender1ImageProfileUrl"><img src="" id="sender1Imge" width="50" height="50"
                                        style="border-radius: 50%;visibility:hidden;margin-top:3px; border: 4px solid white;">
                                    <label id="sender1Name"
                                        style="margin-left:0px;padding-top:0;padding-bottom:0;font-size:14px;text-decoration:none;cursor: pointer;font-weight: bold;"></label></a>
                            </div>



                            <div class="col-1 pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" onclick="setMinimize();"
                                    style="color:white;cursor: pointer;" width="19" height="19" fill="currentColor"
                                    class="bi bi-dash-square" viewBox="0 0 16 16">
                                    <path
                                        d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z" />
                                    <path d="M4 8a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 4 8z" />
                                </svg>
                            </div>
                            <div class="col-1 pt-3">
                                <svg xmlns="http://www.w3.org/2000/svg" data-bs-dismiss="modal"
                                    style="color:white;cursor: pointer;" width="20" height="20" fill="currentColor"
                                    class="bi bi-file-excel" viewBox="0 0 16 16" onclick="closeChatBox1();">
                                    <path
                                        d="M5.18 4.616a.5.5 0 0 1 .704.064L8 7.219l2.116-2.54a.5.5 0 1 1 .768.641L8.651 8l2.233 2.68a.5.5 0 0 1-.768.64L8 8.781l-2.116 2.54a.5.5 0 0 1-.768-.641L7.349 8 5.116 5.32a.5.5 0 0 1 .064-.704z" />
                                    <path
                                        d="M4 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H4zm0 1h8a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1z" />
                                </svg>
                            </div>
                        </div>
                    </div>
                    <div class="modal-body" id="chat1Body" style="background-color:white;height:70vh;">
                        <div class="row" style="border-bottom:1px solid gray;">
                            <div class="col-1"></div>
                            <div class="col-4 d-flex align-items-center justify-content-end">Private Chat</div>
                            <div class="col-6 mb-2">
                                <select class="form-select pt-0 mt-0 pb-0 pe-2" style="height: 20px;"
                                    id="Selected_Participants">
                                    <option selected value="All">All</option>

                                </select>
                            </div>
                        </div>
                        <div id="MessageHistory1">
                            <div class="main-chat-box-body"
                                style="background-color:white; border:2px solid blck;height:70vh;">
                                <div class="users-conversation" id="userChatTab"
                                    style="scrollbar-width: none;height: 360px;">
                                    <div class="single-message-box" id="appendTextBox"
                                        style="font-size:13px; font-family:Times New Roman, Times, serif;<?php echo ($callInformationSession['is_chat_pannel'] == 'no' ? 'pointer-events: none; opacity: 0.5;' : ''); ?>">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="parent" id="imageAppendIdChatBox1"
                            style="position:sticky;z-index:1001;display: flex;   transform: translate(250px, 0px);">
                        </div>
                    </div>

                    <div class="modal-footer" id="chat1Footer" style="background-color: #f7f7f9 ">
                        <div class="row align-items-start d-flex align-items-center" style="width:100%">
                            <div class="col-8">
                                <input type="text" autocomplete="off" class="form-control" id="messageSend"
                                    name="sendSMS" autocomplete="off" placeholder="Type your message..." autofocus />
                            </div>
                            <!-- //uploading images here............................................................ -->
                            <div class="col-1"
                                style="<?php echo ($callInformationSession['is_chat_pannel'] == 'no' ? 'pointer-events: none; opacity: 0.5;' : ''); ?>">
                                <a href="javascript:void(0);" class="emojies-btn"
                                    onclick="openFileDialogPopupChatBox1();">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="23.014" height="26.301"
                                        viewBox="0 0 23.014 26.301">
                                        <path id="Icon_metro-attachment" data-name="Icon metro-attachment"
                                            d="M19.815,10.328,18.146,8.661,9.8,17a3.539,3.539,0,0,0,5.005,5L24.82,12a5.9,5.9,0,1,0-8.342-8.341L5.967,14.166l-.023.022A8.226,8.226,0,0,0,17.58,25.82L17.6,25.8h0l7.175-7.174-1.669-1.667-7.175,7.173-.022.022a5.867,5.867,0,0,1-8.3-8.3l.023-.022v0L18.147,5.324a3.539,3.539,0,1,1,5.006,5L13.141,20.338a1.18,1.18,0,0,1-1.669-1.667l8.343-8.342Z"
                                            transform="translate(-3.535 -1.928)" fill="#363636" opacity="0.5" />
                                    </svg>
                                </a>
                            </div>
                            <!-- ............................................................................... -->
                            <!-- //emojie button ..................................................................... -->
                            <div class="col-1"
                                style="<?php echo ($callInformationSession['is_chat_pannel'] == 'no' ? 'pointer-events: none; opacity: 0.5;' : ''); ?>">
                                <a href="javascript:void(0);" class="attatchments-btn" id="emojiButtonChatBox1">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24.751" height="24.751"
                                        viewBox="0 0 24.751 24.751">
                                        <g id="Icon_feather-smile" data-name="Icon feather-smile"
                                            transform="translate(1.225 1.225)" opacity="0.5">
                                            <path id="Path_480" data-name="Path 480"
                                                d="M25.3,14.151A11.151,11.151,0,1,1,14.151,3,11.151,11.151,0,0,1,25.3,14.151Z"
                                                transform="translate(-3 -3)" fill="none" stroke="#000"
                                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2.45" />
                                            <path id="Path_481" data-name="Path 481"
                                                d="M12,21a6.021,6.021,0,0,0,4.46,2.23A6.021,6.021,0,0,0,20.921,21"
                                                transform="translate(-5.31 -7.619)" fill="none" stroke="#000"
                                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2.45" />
                                            <path id="Path_482" data-name="Path 482" d="M13.5,13.5h.011"
                                                transform="translate(-5.694 -5.694)" fill="none" stroke="#000"
                                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2.45" />
                                            <path id="Path_483" data-name="Path 483" d="M22.5,13.5h.011"
                                                transform="translate(-8.004 -5.694)" fill="none" stroke="#000"
                                                stroke-linecap="round" stroke-linejoin="round" stroke-width="2.45" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                            <!-- ............................................................................................... -->

                            <div class="col-1"
                                style=" <?php echo ($callInformationSession['is_chat_pannel'] == 'no' ? 'pointer-events: none; opacity: 0.5;' : ''); ?>">
                                <a href="javascript:void(0);" class="send-msg-btn" id="chat1autoclick"
                                    onclick="appendChat();">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="40" height="40" viewBox="0 0 40 40">
                                        <g id="Group_6777" data-name="Group 6777"
                                            transform="translate(-1681.999 -1108)">
                                            <path id="Path_479" data-name="Path 479"
                                                d="M20,0A20,20,0,1,1,0,20,20,20,0,0,1,20,0Z"
                                                transform="translate(1681.999 1108)" fill="#14213d" />
                                            <path id="Icon_ionic-ios-send" data-name="Icon ionic-ios-send"
                                                d="M24.932,4.55,4.764,13.34a.462.462,0,0,0,.016.841l5.455,3.082a.88.88,0,0,0,1.005-.1L22,7.89c.071-.06.242-.176.308-.11s-.038.236-.1.308L12.9,18.57a.877.877,0,0,0-.088,1.049l3.565,5.719a.464.464,0,0,0,.835-.011L25.553,5.16A.462.462,0,0,0,24.932,4.55Z"
                                                transform="translate(1685.495 1114.497)" fill="#fff" />
                                        </g>
                                    </svg>
                                </a>
                            </div>
                            <div class="col-1">
                                <a href="javascript:void(0)" class="send-msg-btn" onclick="openLobyDialgoBox()">
                                    <svg width="40" height="40" viewBox="0 0 1024 1024" class="icon" version="1.1"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M512 768c-106.666667 0-106.666667-128-106.666667-128v-128h213.333334v128s0 128-106.666667 128z"
                                            fill="#FF9800" />
                                        <path
                                            d="M746.666667 384a42.666667 42.666667 0 1 1-85.312 0.021333A42.666667 42.666667 0 0 1 746.666667 384M362.666667 384a42.666667 42.666667 0 1 1-85.312 0.021333A42.666667 42.666667 0 0 1 362.666667 384"
                                            fill="#FFA726" />
                                        <path
                                            d="M704 256c0-162.88-384-106.048-384 0v149.333333c0 106.048 85.952 192 192 192s192-85.952 192-192v-149.333333z"
                                            fill="#FFB74D" />
                                        <path
                                            d="M512 64c-129.6 0-213.333333 105.066667-213.333333 234.666667v48.725333L341.333333 384v-106.666667l256-85.333333 85.333334 85.333333v106.666667l42.666666-37.141333V298.666667c0-85.866667-22.144-170.986667-128-192l-21.333333-42.666667h-64z"
                                            fill="#424242" />
                                        <path
                                            d="M576 384a21.333333 21.333333 0 1 0 42.666667 0 21.333333 21.333333 0 0 0-42.666667 0M405.333333 384a21.333333 21.333333 0 1 0 42.666667 0 21.333333 21.333333 0 0 0-42.666667 0"
                                            fill="#784719" />
                                        <path
                                            d="M618.666667 640s-21.333333 85.333333-106.666667 85.333333-106.666667-85.333333-106.666667-85.333333S170.666667 682.368 170.666667 917.333333v42.666667h682.666666v-42.666667c0-234.133333-234.666667-277.333333-234.666666-277.333333z"
                                            fill="#8BC34A" />
                                        <path d="M384 640l21.333333 170.666667M640 640l-21.333333 170.666667"
                                            fill="none" />
                                        <path
                                            d="M597.333333 814.08h-170.666666l36.8-57.408c3.989333-6.250667 10.752-10.005333 17.941333-10.005333h61.141333c7.210667 0 13.952 3.754667 17.984 10.005333L597.333333 814.08z"
                                            fill="#512DA8" />
                                        <path
                                            d="M640 938.666667a21.333333 21.333333 0 0 1-21.333333 21.333333H405.333333a21.333333 21.333333 0 0 1-21.333333-21.333333v-128a21.333333 21.333333 0 0 1 21.333333-21.333334h213.333334a21.333333 21.333333 0 0 1 21.333333 21.333334v128z"
                                            fill="#5E35B1" />
                                        <path
                                            d="M469.333333 874.666667a42.666667 42.666667 0 1 1 85.354667 0.021333A42.666667 42.666667 0 0 1 469.333333 874.666667"
                                            fill="#B388FF" />
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <!-- //emojie images................................................................ -->
                        <div class="row"
                            style="<?php echo ($callInformationSession['is_chat_pannel'] == 'no' ? 'pointer-events: none; opacity: 0.5;' : ''); ?>">
                            <div class="emoji-picker" id="emojiPickerChatBox1"
                                style="width:220px;height:90px;overflow-y: scroll;display:none;">
                                <span style="cursor:pointer;">😀</span>
                                <span style="cursor:pointer;">😂</span>
                                <span style="cursor:pointer;">😍</span>
                                <span style="cursor:pointer;">😎</span>
                                <span style="cursor:pointer;">😢</span>
                                <span style="cursor:pointer;">👍</span>
                                <span style="cursor:pointer;">🎉</span>
                                <span style="cursor:pointer;">👋</span>
                                <span style="cursor:pointer;">👌</span>
                                <span style="cursor:pointer;">️🥰</span>
                                <span style="cursor:pointer;">🧑‍</span>
                            </div>
                        </div>
                        <!-- ........................................................................................... -->
                    </div>

                </div>
            </div>
            <section>
                <?php if ($callInformationSession['is_text_ticker_video_call'] == 'yes') { ?>
                <div class="row">
                    <div class="ticker-container">
                        <div class="ticker" id="ticker">
                            <!-- Initial ticker content -->
                            <?php
    $content = $callInformationSession['text_ticker_content_video_call'];
    echo "<span>" . $content . "</span>"; // Initially load the content
                    ?>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </section>
        </div>




        <div class="modal fade" id="exitfromchat" tabindex="-1" aria-labelledby="recordingModalLabel"
            aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <!-- Camera Icon + Title -->
                        <h5 class="modal-title" id="exitFromChatModel">
                            <i class="fas fa-video" style="font-size: 1.5rem; margin-right: 10px;"></i><b>Exit From
                                Video Chat
                            </b>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="alert alert-danger" role="alert">
                            Call presentrator set <strong>off!</strong> you.
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                    </div>
                </div>
            </div>
        </div>





        <div class="modal chat-modal" id="WaitingAreaUserModel" tabindex="-1" role="dialog"
            aria-labelledby="myModalLabel" style="scrollbar-width: none;overflow-y: hidden; ">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header" style="background-color:  #3b3c3b ;height:60px;">



                        <div class="row" style="width:100%;">

                            <div class="col-10">
                                <label style="color:white;"><b>Lobby Waiting Area</b></label>
                            </div>
                            <div class="col-1">
                                <svg xmlns="http://www.w3.org/2000/svg" onclick="setMinimize();"
                                    style="color:white;cursor: pointer;" width="19" height="19" fill="currentColor"
                                    class="bi bi-dash-square" viewBox="0 0 16 16">
                                    <path
                                        d="M14 1a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1H2a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h12zM2 0a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V2a2 2 0 0 0-2-2H2z" />
                                    <path d="M4 8a.5.5 0 0 1 .5-.5h7a.5.5 0 0 1 0 1h-7A.5.5 0 0 1 4 8z" />
                                </svg>
                            </div>


                        </div>
                    </div>
                    <div class="modal-body" id="chat1Body" style="background-color:white;">
                        <div id="joiner_list">

                        </div>
                    </div>

                    <div class="modal-footer" id="chat1Footer" style="display:none;background-color: #f7f7f9 ">

                        <!-- ........................................................................................... -->
                    </div>


                </div>

            </div>
        </div>








        <input type="file" name="txtMessageFilesChatBox1" multiple="multiple" id="txtMessageFilesChatBox1"
            style="display:none;">

        <script>

            // Select the ticker container and get the initial ticker text content
            const tickerElement = document.getElementById('ticker');
            const tickerText = '<?php echo addslashes($callInformationSession['text_ticker_content']); ?>'; // Ensure the content is properly escaped for JavaScript
            // Function to continuously append text to the ticker
            function appendTickerText() {
                if (tickerElement) {
                    const newTickerItem = document.createElement('span');
                    newTickerItem.textContent = tickerText;
                    tickerElement.appendChild(newTickerItem);
                }

            }
            setInterval(appendTickerText, 500);
            const selectElement = document.getElementById('Selected_Participants');

            function openLobyDialgoBox() {
                $('#WaitingAreaUserModel').modal('show');
            }
            function setMinimize() {
                $('#WaitingAreaUserModel').modal('hide');
            }


            $(document).ready(function () {
                $('[data-toggle="tooltip"]').tooltip();
            });

            function showChatDialog() {
                $('#ChatModel1').modal('show');
            }


            function RejectCall(participant_email, channel_id, id) {

                var formData = new FormData();
                formData.append('participant_email', participant_email);
                formData.append('channelId', channel_id);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('NotAllowingToJoinVideoCallingRoom.post') }}",
                    data: formData,
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false,
                    success: function (response) {
                        var parentElement = document.getElementById("joiner_list");
                        var removedNode = document.getElementById(id);
                        // Remove the rowDiv from the parent element
                        if (parentElement && removedNode) {
                            parentElement.removeChild(removedNode);
                        }
                    },
                    error: function (xhr, status, error) {
                        RejectCall(participant_email, channel_id, id)
                    }
                });
                // $('#newClientModal' + id).modal('hide');
            }

            // variable declaration......................................................
            var combinedStream = new MediaStream();
            var remoteUserStream;
            var timeoutRecording;
            // var timeoutRecordingRemote;
            var uploadVidoeDateTime = '<?php echo $uploadVidoeDateTime ?>';
            var dateCanvas = '<?php echo $dateForCanvas; ?>';
            var sessionEmail = '<?php echo $session_emailId;?>';
            var callingPersonEmail = '<?php echo $callInformationSession['calling_person_email']; ?>';
            var VideoUploaded = 0;
            var TotalVideos = 0;
            var videoRecStarted = false;
            var recordingThread;
            var endCall = false;
            var onceAssign = false;

            var combinedStreamRemoteUser = new MediaStream();

            //...........................................................................
            var recordingDotThread;
            async function closeWindows() {
                window.close();
            }
            function closeAlert() {
                $('#confirm').modal('hide');
            }
            var isAlreadRec = false;
            let socket;
            var combinedStream;
            async function sleep(ms) {
                return new Promise(resolve => setTimeout(resolve, ms));
            }
            function fetchUserByName(uid) {
                var data = new FormData();
                data.append('user_id', uid); //Correct: sending the Blob itself
                data.append('channel_id', channelNamePeerToPeer);

                $.ajax({
                    xhr: function () {
                        var xhr = new window.XMLHttpRequest();

                        xhr.upload.addEventListener("progress", function (evt) {
                            if (evt.lengthComputable) {

                            }
                        }, false);

                        return xhr;
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('getCallerInformationForNewJoiningUser.post') }}",
                    data: data,
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false,

                    timeout: 600000,
                    success: function (data) {
                        var obj = JSON.parse(data);

                        const selectElement = document.getElementById('Selected_Participants');
                        const newOption = document.createElement('option');
                        const existingOption = Array.from(selectElement.options).find(option => option.value === obj.userEmail);
                        if (!existingOption) {


                            // Only create and append the new option if it doesn't exist
                            const newOption = document.createElement('option');
                            newOption.value = obj.userEmail;
                            newOption.textContent = obj.userName;
                            newOption.id = "message" + uid;
                            selectElement.appendChild(newOption);
                            let li = document.createElement('li');
                            li.id = "list" + uid;
                            let a = document.createElement('a');
                            a.className = 'dropdown-item';
                            a.href = '#';
                            a.setAttribute('onclick', `setCallingPersonDisplay(${uid});`);
                            a.innerText = obj.userName;  // The label text can be changed
                            li.appendChild(a);
                            document.getElementById('VideoCallClientList').appendChild(li);

                        } else {
                            console.log('Option with this value already exists!');
                        }



                    },
                    error: function (e) {
                        console.log("ERROR : ", e);
                    }
                });


            }




            var isfullScreen = false;

            function appendChat() {
                var selectElement = document.getElementById("Selected_Participants");
                var selectedValue = selectElement.value;

                var text = document.getElementById("messageSend").value;
                if (text.length == 0) {
                    alert("Type Message...!")
                    return;
                }
                var files = document.getElementById('txtMessageFilesChatBox1').files;
                document.getElementById("messageSend").value = "";
                message_aPP = document.getElementById("appendTextBox");
                var messageBox = document.createElement('div');
                messageBox.classList.add('single-message-box-inner', 'right');
                messageBox.id = 'messageAppendBoxMainPage_Send_Home';
                messageBox.style.display = 'flex';
                messageBox.style.marginTop = '16px';
                // Create the <div> for avatar
                var avatarDiv = document.createElement('div');
                avatarDiv.classList.add('avatar');
                // Create the <img> element for the avatar
                var avatarImg = document.createElement('img');
                var profilePic = '<?php echo $callInformationSession['calling_profile_pic'];?>';
                avatarImg.src = "ProfileImages/Images/" + profilePic;
                avatarImg.alt = '';
                avatarImg.id = 'p_iamg_send'; // Fix typo: should be 'p_img_send' or 'p_img_send'?
                // Append the avatar image to the avatar <div>
                //avatarDiv.appendChild(avatarImg);
                // Create the <div> for message content
                var messageDiv = document.createElement('div');
                messageDiv.classList.add('single-message');
                messageDiv.style.width = 'calc(100% - 50px)';
                messageDiv.style.paddingLeft = '16px';
                // Create the <div> for message text
                var textDiv = document.createElement('div');
                textDiv.id = 'p_text_send';
                textDiv.innerText = text;
                // Create the <div> for message time
                var timeDiv = document.createElement('div');
                timeDiv.id = 't_time_send';
                timeDiv.innerHTML = '<?php echo date('h:i A'); ?>';
                timeDiv.style.fontSize = '10px';
                timeDiv.style.textAlign = 'left';
                // Appnd the message text and time <div>s to the message <div>
                messageDiv.appendChild(textDiv);
                messageDiv.appendChild(timeDiv);
                // Append the avatar <div> and message <div> to the main message box <div>
                messageBox.appendChild(avatarDiv);
                messageBox.appendChild(messageDiv);
                message_aPP.appendChild(messageBox);
                //messageBox.style.display = 'none';
                const element = document.getElementById('appendTextBox');
                element.scrollTop = element.scrollHeight;

                var formData = new FormData();
                if (selectedValue != 'All') {
                    formData.append('receiver_email_id', selectedValue);
                }
                // Add chatText and visitor_email to formData
                formData.append('chatText', text);
                '<?php if (isset($callInformationSession['receiver'])) {
                    ?>'
                formData.append('channelId', '<?php    echo $callInformationSession['channelID'];?>');
                '<?php
}
                ?>'
                // Add files to formData
                for (var i = 0; i < files.length; i++) {
                    formData.append('files[]', files[i]);
                }
                if (selectedValue != 'All') {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST',
                        url: "{{ route('submitVideoChatNormalMeetingIndividual.post') }}",
                        data: formData,
                        processData: false, // Prevent jQuery from processing the data
                        contentType: false,
                        success: function (response) {

                        },
                        error: function (xhr, status, error) {

                        }
                    });
                } else {
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST',
                        url: "{{ route('submitVideoChatNormalMeeting.post') }}",
                        data: formData,
                        processData: false, // Prevent jQuery from processing the data
                        contentType: false,
                        success: function (response) {


                        },
                        error: function (xhr, status, error) {

                        }
                    });
                }

                if (files.length > 0) {

                    appendSingleImage(files, "null", "own", "null", "null", "chatBox1");
                }

                document.getElementById('txtMessageFilesChatBox1').value = '';
                scrollToBottomTab1();
                //messageBox.style.display = 'none';
                document.getElementById('imageAppendIdChatBox1').innerHTML = null;

            }


            window.onload = function () {
                checkMessageRecFromUser();
            }

            var userJoiningRoomId = 0;
            function checkMessageRecFromUser() {
                setInterval(function () {
                    var formData = new FormData();
                    formData.append('channelId', channelNamePeerToPeer);
                    console.log('checking users messages routine is running.............running')
                    $.ajax({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        },
                        type: 'POST',
                        url: "{{ route('checkMessageForVideoCallNormalMeeting.post')}}",
                        data: formData,
                        processData: false, // Prevent jQuery from processing the data
                        contentType: false, // Prevent jQuery from setting contentType
                        success: function (data) {
                            userJoiningRoomId = userJoiningRoomId + 1;
                            var isDialogOpen = 'false';
                            var array = JSON.parse(data);
                            if (array.waitingParticipant) {
                                if (document.getElementById("joiner_list")) {
                                    document.getElementById("joiner_list").innerHTML = '';
                                }
                                var dataObjUser = array.waitingParticipant;
                                dataObjUser.forEach(function (dataObjrow) {

                                    createModalNewClientJoingRoomForParticipant(userJoiningRoomId, dataObjrow.participant_name, dataObjrow.participant_profile_pic, dataObjrow.email_id, array.channel_id);
                                });

                            } else {
                                if (array && array.ParticipantName) {

                                    createModalNewClientJoingRoom(userJoiningRoomId, array.ParticipantName, array.ParticipanProfilePic, array.participant_email, array.channel_id);
                                }
                            }
                            if (array.IsMessageFound == true) {
                                var dataObj = array.latestMessage;
                                var photoList = array.photoList;
                                var folderPath = array.ImagePath;
                                // console.log('Images Array NAME::'+photoList.length);
                                dataObj.forEach(function (dataObj) {
                                    if (dataObj.sended_text.includes("exit:")) {
                                        let parts = dataObj.sended_text.split(":");
                                        if (uidd == parseInt(parts[1])) {
                                            client.leave();
                                            for (let uid in remoteUsers) {
                                                if (remoteUsers.hasOwnProperty(uid)) {
                                                    if (document.getElementById(`user-local${uid}`)) {
                                                        document.getElementById(`user-local${uid}`).remove();
                                                    }
                                                }
                                            }
                                            var modal = new bootstrap.Modal(document.getElementById('exitfromchat'));
                                            modal.show();
                                        }
                                    } else {
                                        createMessageBoxRight(dataObj.sended_text, dataObj.profile_pic_sender,
                                            photoList, folderPath);
                                    }
                                    deleteReadMessage(dataObj.id);

                                });
                            }
                        },
                        error: function (xhr, status, error) {

                        }
                    });
                }, 4000);
            }




            function deleteReadMessage(messagId) {
                var formData = new FormData();

                formData.append('messageId', messagId);
                console.log('checking users messages routine is running.............running')
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('deleteReadedChatMessageGroupVideoCall.post')}}",
                    data: formData,
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false, // Prevent jQuery from setting contentType
                    success: function (data) {
                    },
                    error: function (xhr, status, error) {
                    }
                });
            }

            function createMessageBoxRight(message, profilePic, imagesList, folderPath) {

                // Create the outer container
                message_aPP = document.getElementById("appendTextBox");
                var messageBox = document.createElement('div');
                messageBox.classList.add('single-message-box-inner', 'left');
                messageBox.style.display = 'flex';
                messageBox.style.marginTop = '16px';
                // Create the <div> for avatar
                var avatarDiv = document.createElement('div');
                avatarDiv.classList.add('avatar');
                // Create the <img> element for the avatar
                //  var avatarImg = document.createElement('img');
                //  avatarImg.src = `ProfileImages/Images/` + profilePic;
                // avatarImg.alt = '';
                //  avatarImg.id = 'p_iamg_send'; // Fix typo: should be 'p_img_send' or 'p_img_send'?
                // Append the avatar image to the avatar <div>




                const img = document.createElement('img');
                img.src = `ProfileImages/Images/` + profilePic;
                img.style.width = "50px";
                img.style.height = "50px";
                img.id = 'p_iamg_send'
                img.style.borderRadius = "50%";  // This makes the image circular
                img.style.objectFit = "cover";
                img.classList.add('img-fluid');



                avatarDiv.appendChild(img);
                // Create the <div> for message content
                var messageDiv = document.createElement('div');
                messageDiv.classList.add('single-message');
                messageDiv.style.width = 'calc(100% - 50px)';
                messageDiv.style.paddingLeft = '16px';
                // Create the <div> for message text
                var textDiv = document.createElement('div');
                textDiv.id = 'p_text_send';
                textDiv.innerText = message;
                // Create the <div> for message time
                var timeDiv = document.createElement('div');
                timeDiv.id = 't_time_send';
                timeDiv.innerHTML = '<?php echo date('h:i A'); ?>';
                timeDiv.style.fontSize = '10px';
                timeDiv.style.textAlign = 'left';
                // Appnd the message text and time <div>s to the message <div>
                messageDiv.appendChild(textDiv);
                messageDiv.appendChild(timeDiv);
                // Append the avatar <div> and message <div> to the main message box <div>
                messageBox.appendChild(avatarDiv);
                messageBox.appendChild(messageDiv);
                message_aPP.appendChild(messageBox);




                // const messageBox = document.createElement('div');
                // messageBox.classList.add('single-message');

                // // Create the inner container
                // const messageBoxInner = document.createElement('div');
                // messageBoxInner.classList.add('single-message-box-inner', 'left');

                // // Create the avatar container and image
                // const avatarContainer = document.createElement('div');
                // avatarContainer.classList.add('avatar');
                // const avatarImg = document.createElement('img');
                // avatarImg.src = `ProfileImages/Images/` + profilePic;
                // avatarImg.alt = 'avatar';
                // avatarContainer.appendChild(avatarImg);

                // // Create the message text container
                // const messageText = document.createElement('div');
                // messageText.classList.add('single-message');
                // messageText.textContent = message;

                // // Append avatar and message text to the inner container
                // messageBoxInner.appendChild(avatarContainer);
                // messageBoxInner.appendChild(messageText);

                // // Append the inner container to the outer container
                // messageBox.appendChild(messageBoxInner);

                // Append the outer container to the message container in the DOM
                //  document.getElementById('appendTextBox').appendChild(messageBox);
                var contentDiv = document.getElementById('userChatTab');
                contentDiv.scrollTop = contentDiv.scrollHeight;

                if (imagesList.length > 0) {


                    appendSingleImage(null, imagesList, "otherSide", folderPath, profilePic, "chatBox1");

                }


            }


            document.getElementById('emojiButtonChatBox1').addEventListener('click', function (event) {
                var emojiPicker = document.getElementById('emojiPickerChatBox1');
                emojiPicker.style.display = emojiPicker.style.display === 'none' ? 'block' : 'none';
                event.stopPropagation();
            });

            document.querySelectorAll('#emojiPickerChatBox1 span').forEach(function (emoji) {
                emoji.addEventListener('click', function () {
                    var input = document.getElementById('messageSend');
                    input.value += emoji.textContent;
                    document.getElementById('emojiPickerChatBox1').style.display = 'none';
                });
            });

            function openFileDialogPopupChatBox1() {
                document.getElementById("txtMessageFilesChatBox1").click();
            }
            document.getElementById('txtMessageFilesChatBox1').addEventListener('change', function (event) {
                document.getElementById('imageAppendIdChatBox1').innerHTML = null;
                xPosition = 0;
                yPostion = 0;
                count = 0;
                const files = event.target.files; // Get the selected files (FileList object)
                for (let i = 0; i < files.length; i++) {
                    const file = files[i];
                    if (file) {
                        const reader = new FileReader();
                        // Define what happens when the file is read
                        reader.onload = function (e) {
                            const img = document.createElement('img');
                            img.style.borderRadius = '50%';
                            img.style.width = '50px';
                            img.style.height = '50px';
                            img.style.border = '1px solid gray';
                            if (count == 0) {
                                img.style.position = 'relative';
                                count = count + 1;
                            } else {
                                img.style.position = 'absolute';
                            }
                            img.style.top = xPosition + "px";
                            img.style.left = yPostion + "px";
                            xPosition = xPosition + 5;
                            yPostion = yPostion + 5;

                            // Set the src attribute
                            img.src = e.target.result;
                            // Append the image to the desired container
                            document.getElementById('imageAppendIdChatBox1').appendChild(img);
                        };
                        // Read the file as a Data URL (base64 string)
                        reader.readAsDataURL(file);
                    }

                }
                const file = event.target.files[0]; // Get the selected file
                //  scrollToBottomTab1();
            });






            function appendSingleImage(files, imagesList, messageType, folderPath, profilePic, messageBoxId) {

                var randomInt = Math.floor(Math.random() * (800000 - 10) + 10);
                // Create the outer div with class single-message-box
                var singleMessageBox = document.createElement('div');
                singleMessageBox.style.width = "100%";

                singleMessageBox.className = 'single-message-box';


                // Create the inner div with class single-message-box-inner and data attributes
                var singleMessageBoxInner = document.createElement('div');

                singleMessageBoxInner.className = 'single-message-box-inner';

                //  singleMessageBoxInner.style.border = '1px solid black';
                //  singleMessageBoxInner.style.alignContent = 'right';
                singleMessageBoxInner.setAttribute('data-bs-toggle', 'modal');
                singleMessageBoxInner.setAttribute('data-bs-target', '#chatGalleryOneItemModal' + randomInt);

                // Create the avatar div
                var avatarDiv = document.createElement('div');
                avatarDiv.className = 'avatar';
                avatarDiv.style.cssText = 'text-align: right;';

                // Create the img element for the avatar
                var avatarImg = document.createElement('img');

                if (messageType == "otherSide") {
                    singleMessageBoxInner.classList.add('single-message-box-inner', 'left');
                    avatarDiv.classList.add('single-message-box-inner', 'left');
                    avatarImg.src = `ProfileImages/Images/` + profilePic;
                } else {

                    singleMessageBoxInner.classList.add('single-message-box-inner', 'right');
                    avatarDiv.classList.add('single-message-box-inner', 'right');
                    var profilePic = '<?php echo $callInformationSession['calling_profile_pic'];?>';
                    avatarImg.src = 'ProfileImages/Images/' + profilePic;

                }

                avatarImg.alt = 'avatar';

                // Append the avatar image to the avatar div
                avatarDiv.appendChild(avatarImg);



                // Create the single message div with class single-message
                var singleMessageDiv = document.createElement('div');
                singleMessageDiv.className = 'single-message p-0 bg-transparent';

                // Create the chat media gallery div with class chat-media-gallery and one-item
                var chatMediaGalleryDiv = document.createElement('div');

                if (messageType == "otherSide") {

                    if (imagesList.length == 1) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery one-item';
                    } else if (imagesList.length == 2) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery two-item';
                    } else if (imagesList.length == 3) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery three-item';
                    } else if (imagesList.length == 4) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery four-item';
                    } else if (imagesList.length > 4) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery more-than-four-item';
                    }

                    for (var i = 0; i < imagesList.length; i++) {
                        if (i > 3) {
                            break;
                        }
                        (function (file) {
                            // Create the item box div
                            var itemBoxDiv = document.createElement('div');
                            itemBoxDiv.className = 'item-box';

                            // Create the image element for the image
                            var imgElement = document.createElement('img');
                            imgElement.src = folderPath + "/" + file;

                            itemBoxDiv.appendChild(imgElement);

                            // Append the item box div to the chat media gallery div
                            chatMediaGalleryDiv.appendChild(itemBoxDiv);
                        })(imagesList[i]);
                    }


                    if (imagesList.length > 4) {
                        var remPic = imagesList.length - 4;
                        // Create the div element
                        var numberLayerDiv = document.createElement('div');
                        // Set the class name
                        numberLayerDiv.className = 'number-layer';
                        // Set the inner text
                        numberLayerDiv.textContent = '+' + remPic;
                        chatMediaGalleryDiv.appendChild(numberLayerDiv);

                    }



                } else {

                    if (files.length == 1) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery one-item';
                    } else if (files.length == 2) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery two-item';
                    } else if (files.length == 3) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery three-item';
                    } else if (files.length == 4) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery four-item';
                    } else if (files.length > 4) {
                        chatMediaGalleryDiv.className = 'chat-media-gallery more-than-four-item';
                    }

                    for (var i = 0; i < files.length; i++) {
                        if (i > 3) {
                            break;
                        }
                        (function (file) {
                            // Create the item box div
                            var itemBoxDiv = document.createElement('div');
                            itemBoxDiv.className = 'item-box';

                            // Create the image element for the image
                            var imgElement = document.createElement('img');

                            // Create a new FileReader instance
                            var reader = new FileReader();

                            // Define what happens when the file is read
                            reader.onload = function (e) {
                                // Set the src attribute to the result of the FileReader
                                imgElement.src = e.target.result;
                            };

                            // Read the file as a Data URL (base64 string)
                            reader.readAsDataURL(file);

                            // Append the image to the item box div
                            itemBoxDiv.appendChild(imgElement);

                            // Append the item box div to the chat media gallery div
                            chatMediaGalleryDiv.appendChild(itemBoxDiv);
                        })(files[i]);
                    }


                    if (files.length > 4) {
                        var remPic = files.length - 4;
                        // Create the div element
                        var numberLayerDiv = document.createElement('div');
                        // Set the class name
                        numberLayerDiv.className = 'number-layer';
                        // Set the inner text
                        numberLayerDiv.textContent = '+' + remPic;
                        chatMediaGalleryDiv.appendChild(numberLayerDiv);

                    }


                }




                // Append the chat media gallery div to the single message div
                singleMessageDiv.appendChild(chatMediaGalleryDiv);

                // Append the avatar div and single message div to the inner div

                if (messageType == "otherSide") {
                    singleMessageBoxInner.appendChild(avatarDiv);
                    singleMessageBoxInner.appendChild(singleMessageDiv);



                } else {
                    singleMessageBoxInner.appendChild(avatarDiv);
                    singleMessageBoxInner.appendChild(singleMessageDiv);

                }

                // Append the inner div to the outer div
                singleMessageBox.appendChild(singleMessageBoxInner);
                singleMessageBox.style.marginTop = "10px";


                // Append the outer div to the document body or any other desired parent element
                if (messageBoxId == 'chatBox1') {
                    document.getElementById('appendTextBox').appendChild(singleMessageBox);
                } else if (messageBoxId == 'chatBox2') {
                    document.getElementById('appendTextBox2').appendChild(singleMessageBox);
                } else if (messageBoxId == 'chatBox3') {
                    document.getElementById('appendTextBox3').appendChild(singleMessageBox);
                }


                // Create the modal dialog div with class modal fade
                var modalDialog = document.createElement('div');
                modalDialog.className = 'modal fade';
                modalDialog.id = 'chatGalleryOneItemModal' + randomInt;
                modalDialog.setAttribute('tabindex', '-1');
                modalDialog.setAttribute('aria-labelledby', 'chatGalleryOneItemModalLabel');
                modalDialog.setAttribute('aria-hidden', 'true');
                // Create the modal dialog center div with class modal-dialog modal-dialog-center
                var modalDialogCenter = document.createElement('div');
                modalDialogCenter.className = 'modal-dialog modal-dialog-center';
                var modalHeader = document.createElement('div');
                modalHeader.classList.add('modal-header');
                modalHeader.style.backgroundColor = 'gray';

                // Create the close button
                var closeButton = document.createElement('button');
                closeButton.setAttribute('type', 'button');
                closeButton.classList.add('close');
                closeButton.setAttribute('data-dismiss', 'modal');
                closeButton.setAttribute('aria-label', 'Close');
                closeButton.style.marginLeft = 'auto';

                // Create the close icon (times symbol)
                var closeIcon = document.createElement('span');
                closeIcon.setAttribute('aria-hidden', 'true');
                closeIcon.innerHTML = '&times;';

                // Append the close icon to the close button
                closeButton.appendChild(closeIcon);

                // Append the close button to the modal header
                modalHeader.appendChild(closeButton);
                modalDialogCenter.appendChild(modalHeader);





                // Create the modal content div with class modal-content
                var modalContent = document.createElement('div');
                modalContent.className = 'modal-content';
                // Create the modal body div with class modal-body
                var modalBody = document.createElement('div');
                modalBody.className = 'modal-body';
                // Create the chat media gallery carousel div with class carousel slide
                var chatMediaGalleryCarousel = document.createElement('div');
                chatMediaGalleryCarousel.id = 'chatMediaGalleryCarousel' + randomInt;
                chatMediaGalleryCarousel.className = 'carousel slide';
                chatMediaGalleryCarousel.setAttribute('data-bs-ride', 'carousel');
                // Create the carousel inner div with class carousel-inner
                var carouselInner = document.createElement('div');
                // Set multiple class names
                carouselInner.className = 'carousel-inner carousel slide pointer-event';

                // Set the data attributes
                carouselInner.setAttribute('data-interval', 'false');
                carouselInner.setAttribute('data-bs-ride', 'carousel');

                if (messageType == "otherSide") {
                    for (var i = 0; i < imagesList.length; i++) {
                        (function (file) {

                            // Create the carousel item div with class carousel-item active
                            var carouselItem = document.createElement('div');

                            carouselItem.style.justifyContent = 'center'; // Center horizontally
                            carouselItem.style.alignItems = 'center';
                            // Create the item box div

                            if (i == 0) {
                                carouselItem.className = 'carousel-item active';
                            } else {
                                carouselItem.className = 'carousel-item';
                            }

                            // Create the image element for the image
                            var imgElementt = document.createElement('img');
                            imgElementt.className = 'd-block w-100';
                            imgElementt.src = folderPath + "/" + file;
                            // Append the image to the carousel item div
                            carouselItem.appendChild(imgElementt);
                            // Append the carousel item to the carousel inner div
                            carouselInner.appendChild(carouselItem);



                        })(imagesList[i]);
                    }


                } else {


                    for (var i = 0; i < files.length; i++) {
                        (function (file) {

                            // Create the carousel item div with class carousel-item active
                            var carouselItem = document.createElement('div');

                            carouselItem.style.justifyContent = 'center'; // Center horizontally
                            carouselItem.style.alignItems = 'center';
                            // Create the item box div

                            if (i == 0) {
                                carouselItem.className = 'carousel-item active';
                            } else {
                                carouselItem.className = 'carousel-item';
                            }


                            // Create the image element for the image
                            var imgElementt = document.createElement('img');
                            //   imgElementt.style.width="90%";
                            //   imgElementt.style.height="50vh";
                            imgElementt.className = 'd-block w-100';
                            const readerr = new FileReader();
                            // Define what happens when the file is read
                            readerr.onload = function (e) {

                                // Set the src attribute
                                imgElementt.src = e.target.result;
                                // Append the image to the desired container

                            };
                            // Read the file as a Data URL (base64 string)
                            readerr.readAsDataURL(file);


                            // Append the image to the carousel item div
                            carouselItem.appendChild(imgElementt);

                            // Append the carousel item to the carousel inner div
                            carouselInner.appendChild(carouselItem);



                        })(files[i]);
                    }


                }



                // Create the carousel control prev button
                var controlPrevButton = document.createElement('button');
                controlPrevButton.className = 'carousel-control-prev';
                controlPrevButton.type = 'button';
                controlPrevButton.setAttribute('data-bs-target', '#chatMediaGalleryCarousel' + randomInt);
                controlPrevButton.setAttribute('data-bs-slide', 'prev');
                controlPrevButton.setAttribute('style', 'color: black; background-color: gray;height: 30px;margin-top:auto;margin-bottom:auto;');
                // Create the span for the carousel control prev icon
                var prevIconSpan = document.createElement('span');
                prevIconSpan.className = 'carousel-control-prev-icon';

                prevIconSpan.setAttribute('aria-hidden', 'true');

                // Create the visually hidden span for the carousel control prev
                var prevVisuallyHiddenSpan = document.createElement('span');
                prevVisuallyHiddenSpan.className = 'visually-hidden';

                prevVisuallyHiddenSpan.textContent = 'Previous';

                // Append the icon and visually hidden span to the control prev button
                controlPrevButton.appendChild(prevIconSpan);
                controlPrevButton.appendChild(prevVisuallyHiddenSpan);

                // Create the carousel control next button
                var controlNextButton = document.createElement('button');
                controlNextButton.className = 'carousel-control-next';
                controlNextButton.type = 'button';
                controlNextButton.setAttribute('data-bs-target', '#chatMediaGalleryCarousel' + randomInt);
                controlNextButton.setAttribute('data-bs-slide', 'next');
                controlNextButton.setAttribute('style', 'color: black; background-color: gray;height: 30px;margin-top:auto;margin-bottom:auto;');


                // Create the span for the carousel control next icon
                var nextIconSpan = document.createElement('span');
                nextIconSpan.className = 'carousel-control-next-icon';

                nextIconSpan.setAttribute('aria-hidden', 'true');

                // Create the visually hidden span for the carousel control next
                var nextVisuallyHiddenSpan = document.createElement('span');
                nextVisuallyHiddenSpan.className = 'visually-hidden';
                nextVisuallyHiddenSpan.textContent = 'Next';

                // Append the icon and visually hidden span to the control next button
                controlNextButton.appendChild(nextIconSpan);
                controlNextButton.appendChild(nextVisuallyHiddenSpan);

                // Append the carousel inner div, control prev button, and control next button to the chat media gallery carousel div
                chatMediaGalleryCarousel.appendChild(carouselInner);
                chatMediaGalleryCarousel.appendChild(controlPrevButton);
                chatMediaGalleryCarousel.appendChild(controlNextButton);

                // Append the chat media gallery carousel div to the modal body div
                modalBody.appendChild(chatMediaGalleryCarousel);

                // Append the modal body div to the modal content div
                modalContent.appendChild(modalBody);

                // Append the modal content div to the modal dialog center div
                modalDialogCenter.appendChild(modalContent);

                // Append the modal dialog center div to the modal dialog div
                modalDialog.appendChild(modalDialogCenter);

                // Append the modal dialog div to the document body or any other desired parent element
                document.body.appendChild(modalDialog);

                setTimeout(
                    function () {
                        var contentDiv = document.getElementById('UserChatConversationArea');
                        //  contentDiv.scrollTop = contentDiv.scrollHeight;
                    }, 2000);



            }
            document.addEventListener('keydown', function (event) {
                if (event.key === 'Enter') {
                    appendChat();


                }
            });


            function scrollToBottomTab1() {
                setTimeout(
                    function () {
                        const element = document.getElementById('userChatTab');
                        element.scrollTop = element.scrollHeight;
                    }, 1000);
            }

            function setOwnVideoDisplay() {
                selectUserId == 1
                removeVideoFrames();
                createUserLocalFrame();
                localTracks[1].play(document.getElementById("user-local"));
            }
            function restVideoFrame() {

                for (let uid in remoteUsers) {
                    if (remoteUsers.hasOwnProperty(uid)) {

                        if (document.getElementById(`user-local${uid}`)) {
                            document.getElementById(`user-local${uid}`).remove();
                        }

                    }
                }

            }

            function createUserLocalFrame() {

                let player = `<div class="video-player" id="user-local" style="width:100%;height:88vh;object-fit: cover;
                    border: 3px solid #fff;
                    border-radius: 8px;"></div>`;
                document.getElementById('user-container-local').insertAdjacentHTML('beforeend', player);
            }





            let shareVideoMobileNormalMeeting = async (e) => {
                if (isWebCamOn == true) {
                    // document.getElementById("user-local").remove();
                    await client.unpublish([localTracks[1]]);
                    isWebCamOn = false;
                    document.getElementById("video-call-btn").style.background = "#d4b1ee";
                } else {
                    isWebCamOn = true;
                    let player = `<div class="video-player" id="user-local" style="width:100%;height:88vh;"></div>`;
                    document.getElementById('user-container-local').insertAdjacentHTML('beforeend', player);
                    document.getElementById("video-call-btn").style.background = "green";
                    localTracks[1].play(document.getElementById("user-local"));

                    await client.publish([localTracks[1]]);
                }

            }
            let toggleAudioMobileNormalMeeting = async () => {
                // let audioTrack= localStream.getTracks().find(track => track.kind === 'audio');
                if (audioMuted == false) {
                    audioMuted = true;
                    await localTracks[0].setMuted(true);
                    document.getElementById("mic-btn").style.background = "#d4b1ee";
                } else {
                    audioMuted = false;
                    await localTracks[0].setMuted(false);
                    document.getElementById("mic-btn").style.background = "green";
                }
            }
            function AcceptClientInvitation(participant_email, channel_id, id) {

                var formData = new FormData();
                formData.append('participant_email', participant_email);
                formData.append('channelId', channel_id);
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    type: 'POST',
                    url: "{{ route('AcceptParticipantRequestForJoiningVideoCallRoom.post') }}",
                    data: formData,
                    processData: false, // Prevent jQuery from processing the data
                    contentType: false,
                    success: function (response) {
                        var parentElement = document.getElementById("joiner_list");
                        var removedNode = document.getElementById(id);
                        // Remove the rowDiv from the parent element
                        if (parentElement && removedNode) {
                            parentElement.removeChild(removedNode);
                        }
                    },
                    error: function (xhr, status, error) {
                        AcceptClientInvitation(participant_email, channel_id, id)
                    }
                });

            }
            function createModalNewClientJoingRoom(modelId, participantName, participantProfile, participant_email, channel_id) {

                // Create a div for the row
                var rowDiv = document.createElement("div");
                rowDiv.classList.add("row");
                rowDiv.id = modelId;
                // Create the first column (Image)
                var col1 = document.createElement("div");
                col1.classList.add("col-3");
                var img = document.createElement("img");
                img.src = "ProfileImages/Images/" + participantProfile;  // Add the image URL
                img.style.height = "40px";
                img.style.width = "40px";
                img.style.borderRadius = "50%";
                img.classList.add("img-fluid");
                col1.appendChild(img);

                // Create the second column (Name)
                var col2 = document.createElement("div");
                col2.classList.add("col-3");
                var name = document.createElement("h6");
                name.style.fontWeight = "bold";
                name.textContent = capitalizeFirstLetter(participantName);  // Replace with dynamic name if needed
                col2.appendChild(name);

                // Create the third column (Accept Button)
                var col3 = document.createElement("div");
                col3.classList.add("col-3");
                var acceptButton = document.createElement("button");
                acceptButton.classList.add("btn", "btn-success");
                acceptButton.textContent = "Accept";
                acceptButton.style.width = "70px";  // Set a specific width (e.g., 100px)
                acceptButton.style.height = "50px"; // Set a specific height (e.g., 30px)
                acceptButton.onclick = function () {
                    AcceptClientInvitation(participant_email, channel_id, modelId);
                };
                col3.appendChild(acceptButton);

                // Create the fourth column (Reject Button)
                var col4 = document.createElement("div");
                col4.classList.add("col-3");
                var rejectButton = document.createElement("button");
                rejectButton.classList.add("btn", "btn-danger");
                rejectButton.textContent = "Reject";
                rejectButton.style.width = "70px";  // Set a specific width (e.g., 100px)
                rejectButton.style.height = "50px"; // Set a specific height (e.g., 30px)
                rejectButton.onclick = function () {
                    RejectCall(participant_email, channel_id, modelId);
                };
                col4.appendChild(rejectButton);

                // Append the columns to the row
                rowDiv.appendChild(col1);
                rowDiv.appendChild(col2);
                rowDiv.appendChild(col3);
                rowDiv.appendChild(col4);
                // Append the row to the modal body (or any other container you want)
                document.getElementById("joiner_list").appendChild(rowDiv);
                $('#WaitingAreaUserModel').modal('show');
            }



            function createModalNewClientJoingRoomForParticipant(modelId, participantName, participantProfile, participant_email, channel_id) {
                // Create a div for the row
                var rowDiv = document.createElement("div");
                rowDiv.classList.add("row");
                rowDiv.id = modelId;
                // Create the first column (Image)
                var col1 = document.createElement("div");
                col1.classList.add("col-6");
                var img = document.createElement("img");
                img.src = "ProfileImages/Images/" + participantProfile;  // Add the image URL
                img.style.height = "75px";
                img.style.width = "74px";
                img.style.borderRadius = "50%";
                img.classList.add("img-fluid");
                col1.appendChild(img);

                // Create the second column (Name)
                var col2 = document.createElement("div");
                col2.classList.add("col-6");
                col2.classList.add("d-flex");
                col2.classList.add("justify-content-center");
                col2.classList.add("align-items-center");
                var name = document.createElement("h5");
                name.style.fontWeight = "bold";
                name.textContent = participantName;  // Replace with dynamic name if needed
                col2.appendChild(name);

                // Create the third column (Accept Button)
                var col3 = document.createElement("div");
                col3.classList.add("col-3");
                var acceptButton = document.createElement("button");
                acceptButton.classList.add("btn", "btn-success");
                acceptButton.textContent = "Accept";
                acceptButton.disabled = true;
                acceptButton.style.opacity = "0.5";
                acceptButton.style.width = "100%";  // Set a specific width (e.g., 100px)
                acceptButton.style.height = "50px"; // Set a specific height (e.g., 30px)

                col3.appendChild(acceptButton);


                var col4 = document.createElement("div");
                col4.classList.add("col-3");
                var rejectButton = document.createElement("button");
                rejectButton.classList.add("btn", "btn-danger");
                rejectButton.textContent = "Reject";
                rejectButton.disabled = true;
                rejectButton.style.opacity = "0.5";
                rejectButton.style.width = "100%";  // Set a specific width (e.g., 100px)
                rejectButton.style.height = "50px"; // Set a specific height (e.g., 30px)

                col4.appendChild(rejectButton);

                // Append the columns to the row
                rowDiv.appendChild(col1);
                rowDiv.appendChild(col2);
                // rowDiv.appendChild(col3);
                // rowDiv.appendChild(col4);

                // Append the row to the modal body (or any other container you want)
               if(document.getElementById("joiner_list")){
                document.getElementById("joiner_list").appendChild(rowDiv);
               }


                //   $('#WaitingAreaUserModel').modal('show');

            }

















            function capitalizeFirstLetter(str) {
                return str.charAt(0).toUpperCase() + str.slice(1).toLowerCase();
            }
        </script>

        <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
        <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
        <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
            integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p"
            crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
            integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF"
            crossorigin="anonymous"></script>
        <script type="text/javascript" src="js//url.js"></script>


    </body>


</html>