<!DOCTYPE html>
<html lang="en">

<head>
  <!-- links and scripts -->
  <title>Workfrater</title>
  <meta charset="utf-8">
  <meta name="csrf-token" content="{{ csrf_token() }}">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="css/utils.css">
  <link rel="stylesheet" href="css/ui-elements.css">
  <link rel="stylesheet" href="css/bootstrap-overrides.css">
  <link rel="stylesheet" href="css/home.css">
  <link rel="stylesheet" href="css/index.css">
  <link rel="stylesheet" href="css/responsive.css">

  <script src="js/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js" integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous"></script>
  <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
  <script type="text/javascript" src="js/custom.js"></script>
  <script type="text/javascript" src="js//url.js"></script>

  <script type="text/javascript">
    function PreviewImage() {
      var fileName = document.getElementById('customFile').value;

      if (fileName.includes(".png") || fileName.includes(".jpg") || fileName.includes(".jpeg")) {
        var oFReader = new FileReader();
        oFReader.readAsDataURL(document.getElementById("customFile").files[0]);

        oFReader.onload = function(oFREvent) {
          document.getElementById("profile_img").src = oFREvent.target.result;
        };
      } else {
        document.getElementById('customFile').value = null;
      }

    };








    function CVSelecting() {
      var fileName = document.getElementById('cvfile').value;

      if (fileName.includes(".pdf")) {


      } else {
        document.getElementById('cvfile').value = null;
      }

    };
  </script>
</head>

<body>
  @include('header')

  <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
    <div class="container">

      <div class="form-box mx-auto">
        <div class="text-center mb-4">
          <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
        </div>
        <h4 class="text-center mb-3">{{ getJsonLocalization('signup', 'Additional Information') }}</h4>
        <fieldset>
          <form method="POST" action="{{route('uploadCVProfile')}}" enctype="multipart/form-data">
            @csrf
            <div class="mb-3 text-center mx-auto" style="width:90px; height:90px; overflow:hidden; border-radius:50%; border:1px solid #dee2e6;"><img src="logos//img.png" alt="Girl in a jacket" id="profile_img" class="object-fit-cover"> </div>
            <div class="row gy-2">
              <div class="col-12">
                <label class="text-mini">1.{{ getJsonLocalization('signup', 'Add a profile picture') }}:</label>
                <input type="file" accept=".png,.jpg,.jpeg" class="form-control" id="customFile" name="customFile" onchange="PreviewImage();" required />
              </div>

              <div class="col-12">
                <label class="text-mini">2-{{ getJsonLocalization('signup', 'Add a curriculum vitae') }}</label>
                <input type="file" accept=".pdf" class="form-control" id="cvfile" name="cvfile" onchange="CVSelecting();" />
              </div>

              <div class="col-12">
                <label class="text-mini">3-{{ getJsonLocalization('signup', 'Record a basic interview') }}</label>
                <div class="row gy-3">
                  <div class="col-6">
                    <a href="#" class="text-secondary text-mini">{{ getJsonLocalization('signup', 'How interviews work ?') }}</a>
                  </div>
                  <div class="col-6 text-end">
                    <a href="#" class="text-secondary text-mini">{{ getJsonLocalization('signup', 'Record interview') }}</a>
                  </div>
                </div>
              </div>
            </div>

            <div class="row mt-3">
              <div class="col-6">
                <a href="{{route('workexperience')}}" type="button" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Go Back') }}</a>
              </div>
              <div class="col-6 text-end">

                <button type="submit" class="wf-btn wf-btn-success">{{ getJsonLocalization('signup', 'Submit') }}</button>
              </div>
            </div>
          </form>
        </fieldset>
      </div>
    </div>
  </section>


</body>

</html>