<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Find Job | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>
    @include('header')
    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('find-a-job', 'find_a_job') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('find-a-job', 'employers_use_platform') }}
                    </h5>
                    <div class="description mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <p>
                            {{ getJsonLocalization('find-a-job', 'workfrater_next_gen') }}
                        </p>
                        <p class="text-secondary">
                            {{ getJsonLocalization('find-a-job', 'platform_tools') }}
                        </p>
                        <p>
                            {{ getJsonLocalization('find-a-job', 'cv_interview_tests') }}
                        </p>
                    </div>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('find-a-job', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('find-a-job', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img1.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Search Job Directly section -->
    <section class="section-padding bg-lightgrey position-relative text-white">
        <div class="bg-video-layer">
            <video src="{{ URL::to('/') }}/videos/video1_find_a_job.mp4" autoplay loop muted></video>
        </div>
        <div class="container py-5">
            <div class="section-title-area text-center mx-auto">
            <h2 class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'search-a-job') }}</h2>

            </div>
            <div class="container-xl px-0">
                <form id="searchjobs" class="mb-4 mb-md-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" action="{{ route('viewjobs') }}" method="get">
                    <div class="row gx-2 gx-md-4 gy-3 justify-content-center">
                        <div class="col-sm-6 col-md-3 position-relative">
                            <input type="text" class="form-select exam_search" id="exam_search" name="exam_search" placeholder="Search for a job, company, etc." onkeyup="suggestSearch(this.value)" />
                            <div id="result" class="list-group suggested-search position-absolute w-100"></div>
                        </div>
                        <div class="col-sm-6 col-md-3">
                            <div class="input-group mb-3">
                                <span class="input-group-text bg-white text-primary" style="font-size:26px;border-color:#dee2e6;" id="basic-addon1"><i class="fa fa-map-marker" aria-hidden="true"></i></span>
                                <input type="text" class="form-control" placeholder="Enter a location" aria-label="Enter a location" aria-describedby="basic-addon1">
                            </div>
                        </div>
                        <div class="col-sm-6 col-md-3"><button type="submit" class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'search') }}</button></div>
                    </div>
                </form>
            </div>
        </div>
    </section>

    <!-- Search Job By Field section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('find-a-job', 'search-a-job-by-field') }}</h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('find-a-job', 'search-description') }}</p>
                </div>
            </div>
            <div class="icons-boxes-container mx-auto">
                <!-- <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/1.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Health</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/2.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Finance</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/3.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">T.I programming</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/4.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">T.I  tech support</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/4.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">T.I data analyst</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/6.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">T.I video games/3D</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/7.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Engineering</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/8.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Calling center</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/9.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Office</h6>
                </a>
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/Job-field-buttons-icons/10.png" class="icon" alt="img" />
                    <h6 class="icon-box-title">Infographic and design</h6>
                </a> -->
                <a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/1.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'health') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/2.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'finance') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/3.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'ti_programming') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/4.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'ti_tech_support') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/4.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'ti_data_analyst') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/6.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'ti_video_games_3d') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/7.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'engineering') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/8.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'calling_center') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/9.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'office') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/10.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'infographic_and_design') }}</h6>
</a>


<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/11.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'general_cleaning') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/12.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'general_sales') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/13.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'general_warehouses') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/14.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'factory_and_industry') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/15.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'marketing_and_sales') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/16.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'web_marketing') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/17.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'recruitment') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/18.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'stores') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/19.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'construction') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/20.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'security_guard') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/21.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'human_resources') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/22.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'management') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/23.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'science') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/24.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'education') }}</h6>
</a>
<a href="javascript:void(0)" class="single-icon-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
    <img src="images/icons/Job-field-buttons-icons/25.png" class="icon" alt="img" />
    <h6 class="icon-box-title">{{ getJsonLocalization('find-a-job', 'other') }}</h6>
</a>

            </div>
        </div>
    </section>



    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>

            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')


    <!-- Site Footer -->
    @include('footer')
</body>

</html>
