<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'becoming_an_entrepreneur_on_the_platform') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item position-relative">
                    <div class="faq-target" id="becoming-entreprenure"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingNine">
                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseNine" aria-expanded="true" aria-controls="faqCategories-accordion-collapseNine">
                        {{ getJsonLocalization('generalfaq', 'becoming_an_entrepreneur_on_the_platform') }}
                    </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseNine" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingNine" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="becoming-an-entrepreneur">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseOne" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'howToBecomeEntrepreneur') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseOne" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingOne" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'entrepreneurDescription') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwo" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'whyShareProject') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTwo" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwo" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'sharingBenefits') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'increaseVisibility') }}:</b> {{ getJsonLocalization('generalfaq', 'increaseVisibilityDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'buildConnections') }}:</b> {{ getJsonLocalization('generalfaq', 'buildConnectionsDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'crowdfundingOpportunities') }}:</b> {{ getJsonLocalization('generalfaq', 'crowdfundingOpportunitiesDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'professionalFeedback') }}:</b> {{ getJsonLocalization('generalfaq', 'professionalFeedbackDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'globalReach') }}:</b> {{ getJsonLocalization('generalfaq', 'globalReachDescription') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'platformExposure') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseThree" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'stepsToPublishProject') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseThree" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingThree" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'projectPublishSteps') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'createProject') }}:</b> {{ getJsonLocalization('generalfaq', 'createProjectDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'fillForm') }}:</b> {{ getJsonLocalization('generalfaq', 'fillFormDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'videoInterview') }}:</b> {{ getJsonLocalization('generalfaq', 'videoInterviewDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'publishProject') }}:</b> {{ getJsonLocalization('generalfaq', 'publishProjectDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'engageWithOthers') }}:</b> {{ getJsonLocalization('generalfaq', 'engageWithOthersDescription') }}</li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'updateVideos') }}:</b> {{ getJsonLocalization('generalfaq', 'updateVideosDescription') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'buildConnectionsDescription') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFour" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'fieldsForm') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseFour" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFour" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'fieldsFormDescription') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'enterpriseName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'location') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'personalInfo') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'interests') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'website') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectType') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'developmentStage') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'team') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'initialFunds') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'fundsRequired') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'expansionPlans') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'fieldsInfo') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseFive" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'videoInterviewQuestions') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseFive" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingFive" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewDescription') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'executiveSummary') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'businessDescription') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'marketAnalysis') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'organizationManagement') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'productsOrServices') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'marketingSalesStrategy') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'operationalPlan') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'financialPlan') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'growthExpansionPlans') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'videoInterviewDetails') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSix" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'projectVisibility') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseSix" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSix" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'projectVisibilityDescription') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'filtersAndSearch') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSection') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseSeven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'forYouSectionHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseSeven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingSeven" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSectionText1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'forYouSectionText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEight" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'searchForProjectHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseEight" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEight" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'searchForProjectText1') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'entrepreneurName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectName') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'ethnicity') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'countryOfOrigin') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'projectType') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'location') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'searchForProjectText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseNine" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'disallowedProjectsHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseNine" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingNine" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'disallowedProjectsText1') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'cryptocurrency') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'pornography') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'gambling') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'barsAndClubs') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'drugs') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'alcohol') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'disallowedProjectsText2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTen" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'financeProjectHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTen" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTen" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'financeProjectText1') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseEleven" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'getPaidHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseEleven" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingEleven" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'getPaidText') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="becoming-an-entrepreneur-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#becoming-an-entrepreneur-collapseTwelve" aria-expanded="false" aria-controls="becoming-an-entrepreneur-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'reportFraudHeading') }}
                                        </button>
                                    </h2>
                                    <div id="becoming-an-entrepreneur-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="becoming-an-entrepreneur-headingTwelve" data-bs-parent="#becoming-an-entrepreneur">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'reportFraudText') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
