<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'doingOnlineExamsTitle') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>
    

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item position-relative">
                    <div class="faq-target" id="doing-online-exams"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingFour">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseFour" aria-expanded="true" aria-controls="faqCategories-accordion-collapseFour">
                            {{ getJsonLocalization('generalfaq', 'doingOnlineExamsTitle') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseFour" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingFour" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="doing-online-exams">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseOne" aria-expanded="false" aria-controls="doing-online-exams-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'howExamsWork') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseOne" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingOne" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'howExamsWorkText') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwo" aria-expanded="false" aria-controls="doing-online-exams-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'whyUsingOurExams') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTwo" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwo" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'whyUsingOurExamsText') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'limitations') }}:</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsSmallPoolQuestions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsSmallPoolExams') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsCheating') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'limitationsChatbots') }}</li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'solutions') }}:</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsGrowingQuestions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsLargeExams') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsRecordedWebcam') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'solutionsRecordedScreen') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThree" aria-expanded="false" aria-controls="doing-online-exams-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'whatAreMainCategories') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseThree" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThree" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'whatAreMainCategoriesText') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'programmingLanguages-cat') }}</b> {{ getJsonLocalization('generalfaq', 'programmingLanguages') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', '3DEngine-cat') }}</b> {{ getJsonLocalization('generalfaq', '3DEngine') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'AIandML-cat') }}</b> {{ getJsonLocalization('generalfaq', 'AIandML') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'scienceAndEngineering-cat') }}</b> {{ getJsonLocalization('generalfaq', 'scienceAndEngineering') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'databases-cat') }}</b> {{ getJsonLocalization('generalfaq', 'databases') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'jsFrameworks-cat') }}</b> {{ getJsonLocalization('generalfaq', 'jsFrameworks') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'pythonFrameworks-cat') }}</b> {{ getJsonLocalization('generalfaq', 'pythonFrameworks') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'javaFrameworks-cat') }}</b> {{ getJsonLocalization('generalfaq', 'javaFrameworks') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'csharpFrameworks-cat') }}</b> {{ getJsonLocalization('generalfaq', 'csharpFrameworks') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'phpFrameworks-cat') }}</b> {{ getJsonLocalization('generalfaq', 'phpFrameworks') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'videoEditing-cat') }}</b> {{ getJsonLocalization('generalfaq', 'videoEditing') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'cybersecurity-cat') }}</b> {{ getJsonLocalization('generalfaq', 'cybersecurity') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'adobeSuite-cat') }}</b> {{ getJsonLocalization('generalfaq', 'adobeSuite') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'musicSound-cat') }}</b> {{ getJsonLocalization('generalfaq', 'musicSound') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'spokenLanguages-cat') }}</b> {{ getJsonLocalization('generalfaq', 'spokenLanguages') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'officeSoftware-cat') }}</b> {{ getJsonLocalization('generalfaq', 'officeSoftware') }}</p>
                                            <p><b>{{ getJsonLocalization('generalfaq', 'cms-cat') }}</b> {{ getJsonLocalization('generalfaq', 'cms') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFour" aria-expanded="false" aria-controls="doing-online-exams-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'connectionOrWebcamIssue') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseFour" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFour" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'connectionOrWebcamIssueText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseFive" aria-expanded="false" aria-controls="doing-online-exams-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'failedExamRetry') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseFive" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingFive" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'failedExamRetryText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSix" aria-expanded="false" aria-controls="doing-online-exams-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'serverDownIssue') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseSix" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSix" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            {{ getJsonLocalization('generalfaq', 'serverDownIssueText') }}
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseSeven" aria-expanded="false" aria-controls="doing-online-exams-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'headingSeven') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseSeven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingSeven" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven_2') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'bodySeven_3') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEight" aria-expanded="false" aria-controls="doing-online-exams-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'headingEight') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseEight" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEight" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyEight') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseNine" aria-expanded="false" aria-controls="doing-online-exams-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'headingNine') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseNine" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingNine" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyNine') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTen" aria-expanded="false" aria-controls="doing-online-exams-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'headingTen') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTen" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <h6>{{ getJsonLocalization('generalfaq', 'headingTen_strict') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'strictOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictSix') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictSeven') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'strictEight') }}</li>
                                            </ul>
                                            <h6>{{ getJsonLocalization('generalfaq', 'headingTen_allowed') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'allowedFive') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseEleven" aria-expanded="false" aria-controls="doing-online-exams-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'headingEleven') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseEleven" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingEleven" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <h6>{{ getJsonLocalization('generalfaq', 'bodyEleven') }}</h6>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationSix') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'recommendationSeven') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseTwelve" aria-expanded="false" aria-controls="doing-online-exams-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'headingTwelve') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseTwelve" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingTwelve" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyTwelve') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="doing-online-exams-headingThirteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#doing-online-exams-collapseThirteen" aria-expanded="false" aria-controls="doing-online-exams-collapseThirteen">
                                            {{ getJsonLocalization('generalfaq', 'headingThirteen') }}
                                        </button>
                                    </h2>
                                    <div id="doing-online-exams-collapseThirteen" class="accordion-collapse collapse" aria-labelledby="doing-online-exams-headingThirteen" data-bs-parent="#doing-online-exams">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'bodyThirteen') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
