<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'videoCallsTitle') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item position-relative">
                    <div class="faq-target" id="video-calls"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingThree">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseThree" aria-expanded="true" aria-controls="faqCategories-accordion-collapseThree">
                            {{ getJsonLocalization('generalfaq', 'videoCallsTitle') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseThree" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingThree" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="video-calls">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseOne" aria-expanded="false" aria-controls="video-calls-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'videoCallWithoutAccount') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseOne" class="accordion-collapse collapse" aria-labelledby="video-calls-headingOne" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'videoCallWithoutAccountAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseTwo" aria-expanded="false" aria-controls="video-calls-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'recordingVideoCalls') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseTwo" class="accordion-collapse collapse" aria-labelledby="video-calls-headingTwo" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'recordingVideoCallsAnswer') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'recordingRestriction') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseThree" aria-expanded="false" aria-controls="video-calls-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'shareScreenDuringCall') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseThree" class="accordion-collapse collapse" aria-labelledby="video-calls-headingThree" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'screenSharingExplanation') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'screenSharingLimitations') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFour" aria-expanded="false" aria-controls="video-calls-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'findRecordedVideos') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseFour" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFour" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'recordedVideosLocation') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseFive" aria-expanded="false" aria-controls="video-calls-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'videoCallWindowChat') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseFive" class="accordion-collapse collapse" aria-labelledby="video-calls-headingFive" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'chatFunctionalityAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSix" aria-expanded="false" aria-controls="video-calls-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'browserSupport') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseSix" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSix" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'browserSupportAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseSeven" aria-expanded="false" aria-controls="video-calls-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'webcamSupport') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseSeven" class="accordion-collapse collapse" aria-labelledby="video-calls-headingSeven" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'webcamSupportAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="video-calls-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#video-calls-collapseEight" aria-expanded="false" aria-controls="video-calls-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'pluginRequirement') }}
                                        </button>
                                    </h2>
                                    <div id="video-calls-collapseEight" class="accordion-collapse collapse" aria-labelledby="video-calls-headingEight" data-bs-parent="#video-calls">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'pluginRequirementAnswer') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
