<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Fees And Subscription | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('fees-and-subscription', 'heading') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('fees-and-subscription', 'description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('fees-and-subscription', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('fees-and-subscription', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img25.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <h2 class="stylish-heading mx-auto text-center">
                {{ getJsonLocalization('fees-and-subscription', 'products_heading') }}
            </h2>
            <div class="text-center">
                <p>
                    {{ getJsonLocalization('fees-and-subscription', 'free_account_description') }}
                </p>
                <p>
                    {{ getJsonLocalization('fees-and-subscription', 'visit_functionalities_description') }}
                    <a href="/public/professional-network" class="no-decoration text-secondary">
                        {{ getJsonLocalization('fees-and-subscription', 'functionalities_link') }}
                    </a>.
                </p>
            </div>
        </div>
    </section>


    <section class="section-padding bg-white">
    <div class="container">
        <div class="section-title-area text-center mx-auto">
            <h2 class="text-center mb-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                {{ getJsonLocalization('fees-and-subscription', 'products_for_employers_heading') }}
            </h2>
            <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <p>{{ getJsonLocalization('fees-and-subscription', 'products_for_employers_description') }}</p>
            </div>
        </div>
        <div class="row gy-4 justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card mb-3 h-100">
                    <img src="images/fee-n-subscription-img1.jpg" class="card-img-top" alt="img">
                    <div class="card-body">
                        <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'video_exam_title') }}</h4>
                        <h5 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'video_exam_price') }}</h5>
                        <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'video_exam_description') }}</p>
                        <p class="card-text">
                            {{ getJsonLocalization('fees-and-subscription', 'more_details_text') }}
                            <a href="/" class="no-decoration text-secondary">
                                {{ getJsonLocalization('fees-and-subscription', 'more_details_link') }}
                            </a>
                        </p>
                    </div>
                </div>    
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card mb-3 h-100">
                    <img src="images/fee-n-subscription-img2.jpg" class="card-img-top" alt="img">
                    <div class="card-body">
                        <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'video_interview_title') }}</h4>
                        <h5 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'video_interview_price') }}</h5>
                        <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'video_interview_description') }}</p>
                        <p class="card-text">
                            {{ getJsonLocalization('fees-and-subscription', 'more_details_text') }}
                            <a href="/public/revolutionary-interview-system" class="no-decoration text-secondary">
                                {{ getJsonLocalization('fees-and-subscription', 'more_details_link') }}
                            </a>
                        </p>
                    </div>
                </div>    
            </div>
            <div class="col-md-6 col-lg-4">
                <div class="card mb-3 h-100">
                    <img src="images/fee-n-subscription-img3.jpg" class="card-img-top" alt="img">
                    <div class="card-body">
                        <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'advanced_search_title') }}</h4>
                        <h5 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'advanced_search_price') }}</h5>
                        <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'advanced_search_description') }}</p>
                    </div>
                </div>    
            </div>
        </div>
    </div>
</section>


    <section class="section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 stylish-heading mx-auto wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('fees-and-subscription', 'list_of_plans_heading') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('fees-and-subscription', 'plans_description') }}</p>
                </div>
            </div>
            <div class="payment-plans-box">
                <div class="row gy-4 align-items-end justify-content-center">
                    <div class="col-lg-3 d-lg-block d-none">
                        <h2 class="text-center mb-5">{{ getJsonLocalization('fees-and-subscription', 'features_heading') }}</h2>
                        <div class="plan-card plan-category">
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'video_pdf_exams') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'video_interviews') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'send_exam_to_non_member') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'advanced_search_filter') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'advanced_job_offer_report_pdf') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'partial_job_offer_report') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'record_video_call') }}</div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'free_plan_heading') }}</h3>
                                <h3 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'free_plan_price') }}<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'video_pdf_exams_label') }}</div>
                                        <div>{{ getJsonLocalization('fees-and-subscription', 'video_pdf_exams_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'video_interviews_label') }}</div>
                                        <div>{{ getJsonLocalization('fees-and-subscription', 'video_interviews_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'send_exam_to_non_member_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'send_exam_to_non_member_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'advanced_search_filter_label') }}</div>
                                        <div>{{ getJsonLocalization('fees-and-subscription', 'advanced_search_filter_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'advanced_job_offer_report_label') }}</div>
                                        <div class="text-danger">{{ getJsonLocalization('fees-and-subscription', 'not_available') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'partial_job_offer_report_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'partial_job_offer_report_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'record_video_call_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'record_video_call_duration') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'gold_plan_heading') }}</h3>
                                <h3 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_plan_price') }}<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month_for_gold_plan') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_video_pdf_exams_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_video_pdf_exams_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_video_interviews_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_video_interviews_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_send_exam_to_non_member_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_send_exam_to_non_member_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_advanced_search_filter_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_advanced_search_filter_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_advanced_job_offer_report_label') }}</div> 
                                        <div class="text-danger">{{ getJsonLocalization('fees-and-subscription', 'gold_not_available') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_partial_job_offer_report_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_partial_job_offer_report_price') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'gold_record_video_call_label') }}</div> 
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'gold_record_video_call_duration') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'premium_plan_heading') }}</h3>
                                <h3 class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_plan_price') }}<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month_for_premium_plan') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_video_pdf_exams_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_video_pdf_exams_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_video_interviews_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_video_interviews_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_send_exam_to_non_member_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_send_exam_to_non_member_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_advanced_search_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_advanced_search_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_advanced_job_offer_report_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_advanced_job_offer_report_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_partial_job_offer_report_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_partial_job_offer_report_value') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'premium_record_video_call_label') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'premium_record_video_call_value') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section> 

    <section class="section-padding bg-white">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('fees-and-subscription', 'section_heading') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('fees-and-subscription', 'section_description') }}</p>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <div class="col-md-6 col-lg-4">
                    <div class="card mb-3 h-100">
                        <img src="images/fee-n-subscription-img4.jpg" class="card-img-top" alt="img">
                        <div class="card-body">
                            <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'online_classrooms_title') }}</h4>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'online_classrooms_description') }}</p>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'for_more_details') }} <a href="/public/school-and-students" class="no-decoration text-secondary">{{ getJsonLocalization('fees-and-subscription', 'click_here') }}</a></p>
                        </div>
                    </div>    
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card mb-3 h-100">
                        <img src="images/fee-n-subscription-img5.jpg" class="card-img-top" alt="img">
                        <div class="card-body">
                            <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'monitor_students_title') }}</h4>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'monitor_students_description') }}</p>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'for_more_details') }} <a href="/public/school-and-students" class="no-decoration text-secondary">{{ getJsonLocalization('fees-and-subscription', 'click_here') }}</a></p>
                        </div>
                    </div>    
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="card mb-3 h-100">
                        <img src="images/fee-n-subscription-img6.jpg" class="card-img-top" alt="img">
                        <div class="card-body">
                            <h4 class="card-title">{{ getJsonLocalization('fees-and-subscription', 'create_advanced_exams_title') }}</h4>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'create_advanced_exams_description') }}</p>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'create_advanced_exams_description2') }}</p>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'create_advanced_exams_description3') }}</p>
                            <p class="card-text">{{ getJsonLocalization('fees-and-subscription', 'for_more_details') }} <a href="/public/school-and-students" class="no-decoration text-secondary">{{ getJsonLocalization('fees-and-subscription', 'click_here') }}</a></p>
                        </div>
                    </div>    
                </div>
            </div>
        </div>
    </section>



    <section class="section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
            <h2 class="text-center mb-3 stylish-heading mx-auto wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                {{ getJsonLocalization('fees-and-subscription', 'subscription_plans_title') }}
            </h2>
            <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <p>{{ getJsonLocalization('fees-and-subscription', 'subscription_plans_description') }}</p>
            </div>
            </div>
            <div class="payment-plans-box">
                <div class="row gy-4 align-items-end justify-content-center">
                    <div class="col-lg-3 d-lg-block d-none">
                        <h2 class="text-center mb-5">
                            {{ getJsonLocalization('fees-and-subscription', 'features_title') }}
                        </h2>
                        <div class="plan-card plan-category">
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'classrooms_creation_feature') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'max_students_feature') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'video_monitoring_feature') }}</div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">{{ getJsonLocalization('fees-and-subscription', 'online_exams_feature') }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'free_plan_title') }}</h3>
                                <h3 class="text-success">0$<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month_text_for_free_plan2') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'classrooms_creation_feature2') }}</div>
                                        <h3 class="mb-0">3</h3>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'max_students_online_classrooms') }}</div>
                                        <div class="text-success">15 students</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'video_monitoring_unavailable') }}</div>
                                        <div class="text-danger">{{ getJsonLocalization('fees-and-subscription', 'not_available_text') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'online_exams_unavailable') }}</div>
                                        <div class="text-danger">{{ getJsonLocalization('fees-and-subscription', 'not_available_text') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'gold_plan_title') }}</h3>
                                <h3 class="text-success">299$<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month_text_gold_plan2') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'classrooms_creation_feature3') }}</div>
                                        <h3 class="mb-0">10</h3>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'max_students_online_classrooms2') }}</div>
                                        <div class="text-success">25 students</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'video_monitoring_feature2') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'available_text') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'online_exams_feature2') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'available_text') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 col-lg-3">
                        <div class="plan-card">
                            <div class="plan-card-head">
                                <h3>{{ getJsonLocalization('fees-and-subscription', 'premium_plan_title') }}</h3>
                                <h3 class="text-success">499$<span class="text-mini d-block w-100">{{ getJsonLocalization('fees-and-subscription', 'per_month_text') }}</span></h3>
                            </div>
                            <div class="plan-card-body">
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'classrooms_creation_feature4') }}</div>
                                        <h3 class="mb-0">20</h3>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'max_students_online_classrooms3') }}</div>
                                        <div class="text-success">100 students</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'video_monitoring_feature3') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'available_text') }}</div>
                                    </div>
                                </div>
                                <div class="single-row">
                                    <div class="row-text">
                                        <div class="row-title d-lg-none d-block">{{ getJsonLocalization('fees-and-subscription', 'online_exams_feature3') }}</div>
                                        <div class="text-success">{{ getJsonLocalization('fees-and-subscription', 'available_text') }}</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section> 

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
