<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Staffing | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('staffing-agencies', 'heading') }}
                    </h1>
                    <div class="description mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <p>{{ getJsonLocalization('staffing-agencies', 'description') }}</p>
                    </div>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('find-a-job', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('find-a-job', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img23.jpg" class="banner-img" alt="{{ getJsonLocalization('joinourteam', 'image_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white border-top">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center stylish-heading wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('staffing-agencies', 'how_it_works_heading') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('staffing-agencies', 'how_it_works_description') }}</p>
                </div>
            </div>
            <div class="row gy-5 gx-lg-5">
                <div class="col-lg-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded py-4 px-3 h-100">
                        <img src="images/staffing-agencies-img1.jpg" class="mb-4 rounded" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'candidate_selection_description') }}</p>
                    </div>
                </div>
                <div class="col-lg-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded py-4 px-3 h-100">
                        <img src="images/staffing-agencies-img2.jpg" class="mb-4 rounded" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'employer_frustration_description') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="section-padding bg-white border-top">
    <div class="container">
        <div class="section-title-area text-center mx-auto">
            <h2 class="text-center stylish-heading wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('staffing-agencies', 'how_it_works_title') }}</h2>
            <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <p>{{ getJsonLocalization('staffing-agencies', 'how_it_works_description2') }}</p>
            </div>
        </div>
        <div class="row gy-5 gx-lg-5 justify-content-center">
            <!-- Step 1 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">1</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step1_title') }}</h4>
                        <img src="images/staffing-agencies-img3.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step1_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 2 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow d-md-none d-lg-block">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">2</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step2_title') }}</h4>
                        <img src="images/staffing-agencies-img4.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step2_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 3 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow d-block d-lg-none">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">3</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step3_title') }}</h4>
                        <img src="images/staffing-agencies-img5.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step3_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 4 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow d-md-none d-lg-block">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">4</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step4_title') }}</h4>
                        <img src="images/staffing-agencies-img6.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step4_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 5 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">5</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step5_title') }}</h4>
                        <img src="images/staffing-agencies-img7.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step5_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 6 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="step-arrow d-md-none">
                        <img src="images/step-arrow.png" alt="img" />
                    </div>
                    <div class="card-content">
                        <div class="step-num">6</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step6_title') }}</h4>
                        <img src="images/staffing-agencies-img8.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step6_description') }}</p>
                    </div>
                </div>
            </div>
            <!-- Step 7 -->
            <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <div class="step-card h-100">
                    <div class="card-content">
                        <div class="step-num">7</div>
                        <h4 class="mb-3">{{ getJsonLocalization('staffing-agencies', 'step7_title') }}</h4>
                        <img src="images/staffing-agencies-img9.jpg" alt="img" />
                        <p>{{ getJsonLocalization('staffing-agencies', 'step7_description') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
