<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
</head>

<body style="background-color:#E0E0E0;">
    @include('header')
    <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
        <div class="container">
            <div class="form-box mx-auto" style="max-width:767px;">
                <div class="text-center mb-4">
                    <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
                </div>
                <h2>{{ getJsonLocalization('signup', 'Personal Information') }}</h2>
                <form method="POST" action="{{route('action_signingOrg')}}" onsubmit="return validate(this);">
                    @csrf
                    <div class="row mb-3 gy-2">
                        <div class="col-sm-4">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'First Name') }}: <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="first_name" id="first_name" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'Second Name') }}: <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="second_name" id="second_name" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'City') }}: <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="city_name" id="city_name" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'Phone Number') }}:</label>
                            <input type="number" class="form-control" name="phone_number" id="phone_number" value="">
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'Country') }}: <span class="text-danger">*</span></label>
                            <select class="selectpicker form-control" name="country_name" id="country_name" required>
                                <option value="USA">{{ getJsonLocalization('signup', 'USA') }}</option>
                                <option value="Canada">{{ getJsonLocalization('signup', 'Canada') }}</option>
                            </select>
                        </div>

                        <script>
                            function checkEmail() {
                                var emailId = document.getElementById("personal_email").value;
                                if (!emailId.includes("@")) {
                                    document.getElementById("validEmail").style.display = "block";
                                } else {
                                    document.getElementById("validEmail").style.display = "none";
                                }
                            }
                        </script>
                        <div class="col-sm-4" style="display:none;">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'Email') }}: <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="EntrepriseEmail" id="EntrepriseEmail" value="not set">
                            <label class="text-danger text-mini" for="message" style="display:none;" id="validEmail" name="validEmail"><b>
                                    {{ getJsonLocalization('signup', 'Not a valid email') }}
                                </b></label>

                        </div>
                        <div class="col-12">
                            <label class="text-mini">{{ getJsonLocalization('signup', 'Date of Birth') }}: <span class="text-danger">*</span></label>
                            <div class="row g-0">
                                <div class="col-4">
                                    <select class="form-select" placeholder="Day" style="border-radius: 4px 0px 0px 4px" id="day" name="day">
                                        <option value="" disabled selected>{{ getJsonLocalization('signup', 'Day') }}</option>
                                        <?php
                                        for ($i = 1; $i < 32; $i++) {
                                        ?>
                                            <option value="<?php echo $i; ?>"> <?php echo $i; ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                    <!--<input type="text" id="day"  name="day" class="form-control" placeholder="Day" list="dayList1" style="width:90%;height:40px;margin-left:7%;" editable="true" required autocomplete="off">-->
                                </div>
                                <div class="col-4">
                                    <select class="form-select" placeholder="month" style="border-radius: 0px" id="month" name="month">
                                        <option value="" disabled selected>{{ getJsonLocalization('signup', 'Month') }}</option>
                                        <option value="Jan">Jan</option>
                                        <option value="Feb">Feb</option>
                                        <option value="Mar">Mar</option>
                                        <option value="Apr">Apr</option>
                                        <option value="May">May</option>
                                        <option value="Jun">Jun</option>
                                        <option value="Jul">Jul</option>
                                        <option value="Aug">Aug</option>
                                        <option value="Sep">Sep</option>
                                        <option value="Oct">Oct</option>
                                        <option value="Nov">Nov</option>
                                        <option value="Dec">Dec</option>
                                    </select>
                                    <!--<input type="text" id="month" name="month" class="form-control"  placeholder="Month" list="monthList" style="width:110%;height:40px;" editable="true" required autocomplete="off">-->
                                </div>
                                <div class="col-4">
                                    <select class="form-select" placeholder="year" style="border-radius: 0px 4px 4px 0px" id="year" name="year">
                                        <option value="" disabled selected>{{ getJsonLocalization('signup', 'Year') }}</option>
                                        <?php
                                        $year = (int)date("Y");
                                        for ($i = 0; $i < 104; $i++) {

                                            $yearr = $year - $i;

                                        ?>
                                            <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                                        <?php
                                        }


                                        ?>
                                    </select>
                                    <!--<input type="text" id="year" name="year" class="form-control"  placeholder="Year" list="yearList" style="width:95%;height:40px;" editable="true" required autocomplete="off">-->
                                </div>
                                <label for="message" style="color:red;margin-top:5px;;display:none;" id="varifyDate" name="varifyDate">
                                    {{ getJsonLocalization('signup', 'Select Date Of Birth') }}
                                </label>
                            </div>
                            <script>
                                var mySelect = document.getElementById('month');
                                mySelect.onchange = (event) => {
                                    var selectedMonth = event.target.value;
                                    if (selectedMonth == 'Sep' || selectedMonth == 'Apr' || selectedMonth == 'Jun' || selectedMonth == 'Nov') {
                                        var selectedDay = document.getElementById('day').value;
                                        document.getElementById("day").remove(31);
                                        if (selectedDay != 'Day') {
                                            var sDay = parseInt(selectedDay);
                                            if (sDay > 30) {
                                                document.getElementById('day').selectedIndex = 0;
                                            } else {
                                                document.getElementById('day').selectedIndex = sDay;
                                            }
                                        }

                                    } else if (selectedMonth == 'Feb') {
                                        var selectedDay = document.getElementById('day').value;
                                        document.getElementById("day").remove(31);
                                        document.getElementById("day").remove(30);
                                        document.getElementById("day").remove(29);
                                        if (selectedDay != 'Day') {
                                            var sDay = parseInt(selectedDay);
                                            if (sDay > 28) {
                                                document.getElementById('day').selectedIndex = 0;
                                            } else {
                                                document.getElementById('day').selectedIndex = sDay;
                                            }
                                        }
                                    } else {

                                        if (document.getElementById("day").length == 29) {
                                            var opt = document.createElement('option');
                                            opt.value = 29;
                                            opt.innerHTML = 29;
                                            document.getElementById("day").appendChild(opt);
                                            opt = document.createElement('option');
                                            opt.value = 30;
                                            opt.innerHTML = 30;
                                            document.getElementById("day").appendChild(opt);
                                            opt = document.createElement('option');
                                            opt.value = 31;
                                            opt.innerHTML = 31;
                                            document.getElementById("day").appendChild(opt);
                                        } else if (document.getElementById("day").length == 31) {
                                            var opt = document.createElement('option');
                                            opt.value = 31;
                                            opt.innerHTML = 31;
                                            document.getElementById("day").appendChild(opt);
                                        }
                                    }


                                }
                            </script>
                        </div>
                    </div>
                    <div class="mb-3">{{ getJsonLocalization('signup', "Your personal informations  won't be displayed") }}</div>
                    <div class="row">
                        <div class="col-6">
                            <a href="{{route('signup')}}" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Go Back') }}</a>
                        </div>
                        <div class="col-6 text-end">
                            <button type="submit" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Next') }}</button>
                        </div>
                    </div>
                </form>
                <script>
                    function validate(form) {

                        if (document.getElementById('day').value == '') {
                            document.getElementById('varifyDate').style.display = 'block';
                            return false;
                        } else if (document.getElementById('month').value == '') {
                            document.getElementById('varifyDate').style.display = 'block';
                            return false;
                        } else if (document.getElementById('year').value == '') {
                            document.getElementById('varifyDate').style.display = 'block';
                            return false;
                        } else {
                            return true;
                        }
                    }
                </script>
            </div>
        </div>
    </section>

</body>

</html>