<style>
    .custom-pagination {
        list-style: none;
        display: flex;
        padding: 0;
        background-color: #010930;
        border-radius: 0.25rem;
        justify-content: center;
    }

    .custom-pagination li {
        margin: 0;
    }

    .custom-pagination li a {
        display: block;
        padding: 0.5rem 1rem;
        text-decoration: none;
        color: #010930;
        background-color: #ffc107;
        border: 1px solid #ffc107;
        border-radius: 0.25rem;
        margin: 0.125rem;
        transition: background-color 0.3s, color 0.3s;
    }

    .custom-pagination li.active span {
        display: block;
        padding: 0.5rem 1rem;
        background-color: #ffc107;
        border: 1px solid #e9ebee;
        border-radius: 0.25rem;
        margin: 0.125rem;
        cursor: not-allowed;
        color: #010930;
        font-weight: bold;
    }

    .custom-pagination li.disabled span {
        display: block;
        padding: 0.5rem 1rem;
        text-decoration: none;
        color: #010930;
        background-color: #e9ebee;
        border: 1px solid #e9ebee;
        border-radius: 0.25rem;
        margin: 0.125rem;
        cursor: not-allowed;
    }
</style>
<ul class="custom-pagination">
    @if ($paginator->onFirstPage())
    <!-- Previous Page Link -->
    <li class="disabled"><span>&laquo;</span></li>
    @else
    <!-- Previous Page Link -->
    <li><a href="{{ $paginator->previousPageUrl() }}" rel="prev">&laquo;</a></li>
    @endif

    <!-- Pagination Elements -->
    @foreach ($elements as $element)
    <!-- "Three Dots" Separator -->
    @if (is_string($element))
    <li class="disabled"><span>{{ $element }}</span></li>
    @endif

    <!-- Array of Links -->
    @if (is_array($element))
    @foreach ($element as $page => $url)
    @if ($page == $paginator->currentPage())
    <li class="active"><span>{{ $page }}</span></li>
    @else
    <li><a href="{{ $url }}">{{ $page }}</a></li>
    @endif
    @endforeach
    @endif
    @endforeach

    @if ($paginator->hasMorePages())
    <!-- Next Page Link -->
    <li><a href="{{ $paginator->nextPageUrl() }}" rel="next">&raquo;</a></li>
    @else
    <!-- Next Page Link -->
    <li class="disabled"><span>&raquo;</span></li>
    @endif
</ul>