<?php
session_start();

use App\Models\Education;
use App\Models\FollowerCount;
use App\Models\Individual;
use App\Models\Organisation;
use App\Models\PostData;
use App\Models\PostLike;
use App\Models\Follower;
use App\Models\PostJob;
use App\Models\comments_adds;
use App\Models\social_media_link;
use App\Models\profile_images;
use App\Models\diploma_education;
use App\Models\WorkingExperience;
use App\Models\JobsApplyData;
use App\Models\JobExamList;
use App\Models\profile_image_change_record;
use Illuminate\Support\Facades\Session;
use App\Models\PostJobFilterData;

$collapserCounter = 0;
$email_id = Session::get('emailId');

$message = Session::get('message');

$userInfo = Session::get('userInfo');

// Remove Query here and paste it on home controller

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script src="/path/to/bootstrap-select.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <style type="text/css">
        .ui-autocomplete-row {
            padding: 8px;
            background-color: #f4f4f4;
            border-bottom: 1px solid #ccc;
            font-weight: bold;
        }

        .ui-autocomplete-row:hover {
            background-color: #ddd;
        }

        /* hide scrollbar but allow scrolling */
        .postPanel {
            -ms-overflow-style: none;
            /* for Internet Explorer, Edge */
            scrollbar-width: none;
            /* for Firefox */
            overflow-y: scroll;
        }

        .postPanel::-webkit-scrollbar {
            display: none;
            /* for Chrome, Safari, and Opera */
        }

        .postPanel {
            color: #2D3E50;
            font-family: 'Avenir';
            font-size: 26px;
            font-weight: bold;
        }
    </style>
</head>

<body onscroll="scrolling();" >
    <script>


        function scrollToBottomAuto() {

            var refreshIntervalId = setInterval(function () {
                //resizeComponents();


                var sc = document.getElementById('MessageHistory1');
                sc.scrollTop = sc.scrollHeight;
                sc = document.getElementById('MessageHistory2');
                sc.scrollTop = sc.scrollHeight;
                sc = document.getElementById('MessageHistory1');
                sc.scrollTop = sc.scrollHeight;
                const element = document.getElementById('ChatModel1');

                element.scrollTop = element.scrollHeight;




                clearInterval(refreshIntervalId);


            }, 1000);
        }
    </script>
    <?php


if (session()->has('emailId')) {
    ?>
    @include('homedesktopheader');
    <?php
} else {

    ?>
    @include('header')
    <?php
}


   ?>
    <div class="container-fluid app-wrapper-container">
        <form method="POST" action="{{ route('filterJobs') }}">
            @csrf
            <div class="row row-with-left-sidebar">
                <div class="col-md-3 loginPanel left-col">
                    <div class="sidebar-header border-bottom">
                        <div class="sidebar-logo-box">
                            <img src="logos//logo1.png" alt="" />
                        </div>

                        <h3 class="text-center text-primary mb-3">{{ getJsonLocalization('viewjobs', 'Job Offers') }}
                        </h3>

                    </div>
                    <div class="sidebar-body pt-4">
                        <div class="mb-2">
                            <input type="text" class="form-control" autocomplete="off" id="job_name" name="job_name"
                                aria-describedby="emailHelp" placeholder="job's name">
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="field" name="field">
                                <option value="">Type</option>
                                <option value="Health">Health</option>
                                <option value="Finances">Finances</option>
                                <option value="T.I programming">T.I programming</option>
                                <option value="T.I tech support">T.I tech support</option>
                                <option value="T.I data analyst">T.I data analyst</option>
                                <option value="T.i video games and 3D">T.i video games and 3D</option>
                                <option value="T.i video games and 3D">T.i video games and 3D</option>
                                <option value="Engineering">Engineering</option>
                                <option value="Calling center">Calling center</option>
                                <option value="Office">Office </option>
                                <option value="Infography and design">Infography and design</option>
                                <option value="General cleaning">General cleaning</option>
                                <option value="General sales">General sales</option>
                                <option value="General warehouses">General warehouses</option>
                                <option value="Factory and industry">Factory and industry</option>
                                <option value="Marketing and sales">Marketing and sales</option>
                                <option value="Web Marketing">Web Marketing</option>
                                <option value="Recruitement">Recruitement</option>
                                <option value="stores">stores</option>
                                <option value="construction">construction</option>
                                <option value="Security guard">Security guard</option>
                                <option value="Human resources">Human resources</option>
                                <option value="Management">Management</option>
                                <option value="Science">Science</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="country_name" name="country_name">
                                <option value="">Country</option>
                                <option value="USA">USA</option>
                                <option value="CANADA">CANADA</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <input type="text" class="form-control" id="city_name" name="city_name"
                                aria-describedby="emailHelp" placeholder="City Name">
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="schedule" name="schedule">
                                <option value="">Select Schedule</option>
                                <option value="Full-time">Full-time</option>
                                <option value="Part-time">Part-time</option>
                                <option value="On-call">On-call</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="mode" name="mode">
                                <option value="">Select Mode</option>
                                <option value="On-site">On-site</option>
                                <option value="Hybrid">Hybrid</option>
                                <option value="Home">Home</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="duration" name="duration">
                                <option value="">Select Duration</option>
                                <option value="Permanent">Permanent</option>
                                <option value="temporary">temporary</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <select class="form-select" id="oldday" name="oldday">
                                <option value="">Posted Date</option>
                                <option value="Today">Today</option>
                                <option value="The past 7 days">The past 7 days</option>
                                <option value="The past 14 days">The past 14 days</option>
                                <option value="The past months">The past months</option>
                                <option value="More than 30 days">More than 30 days</option>
                            </select>
                        </div>
                        <div class="mb-2">
                            <button type="submit" class="wf-btn wf-btn-primary w-100"
                                style="width:50%;">{{ getJsonLocalization('viewjobs', 'Update') }}</button>
                        </div>
                    </div>
                </div>
</form>
                <div class="col-md-9 loginPanel center-col">
                    <div>
                        <div>
                            <h2 class="mb-3 text-center">{{ getJsonLocalization('viewjobs', 'Results') }}</h2>

                            @if(isset($CanNotApply))

                                                        <div class="loginPanel">
                                                            <div class="wf-card1 mb-4">
                                                                <div class="wf-card1-header">
                                                                    <div class="header-left">
                                                                        <div class="img-box">
                                                                            <img src="ProfileImages/Images/{{$UserInfo[0]}}" alt="img" />
                                                                        </div>
                                                                        <div>
                                                                            <div class="name">
                                                                                <b><?php    echo $UserInfo[1]; ?></b>
                                                                            </div>
                                                                            <div class="date">
                                                                                <b>{{ getJsonLocalization('viewjobs', 'Posted') }}:</b>
                                                                                <?php    echo $JobDetails->created_at; ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="header-right">
                                                                        <div class="img-box">
                                                                            <img src="PostImages/<?php    echo $JobDetails->email_address . '/' . $JobDetails->job_id . '/' . $JobDetails->job_img_name; ?>"
                                                                                alt="img" />
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="wf-card-body">
                                                                    <div class="row">
                                                                        <div class="col-md-4">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Title') }}:
                                                                                </div>
                                                                                <div class="inner2"><?php    echo $JobDetails->job_title; ?></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Mode') }}:
                                                                                </div>
                                                                                <div class="inner2"><?php    echo $JobDetails->job_mode; ?></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Schedule') }}:
                                                                                </div>
                                                                                <div class="inner2"><?php    echo $JobDetails->job_schedule; ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Type') }}:
                                                                                </div>
                                                                                <div class="inner2"><?php    echo $JobDetails->job_field; ?></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-md-4">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Duration') }}:
                                                                                </div>
                                                                                <div class="inner2"><?php    echo $JobDetails->job_duration; ?>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    </div><br>
                                                                    <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Exam') }}:
                                                                                </div>
                                                                                <div class="inner2">
                                                                                    <table class="table">
                                                                                        <tbody>
                                                                                            <?php

                                                                                            foreach ($ExamList as $roww) {
                                                                                             $email_add = $roww["email_address"];
                                                                                                                 ?>
                                                                                            <tr>
                                                                                                <td><img src="ProfileImages/exam_logos/<?php        echo $roww['exam_logo_name']; ?>"
                                                                                                        alt="" width="40" height="40"
                                                                                                        style="border-radius: 50%;"></td>
                                                                                                <td>

                                                                                                    <?php        echo $roww['exam_name']; ?>

                                                                                                </td>
                                                                                            </tr>
                                                                                            <?php
                                                                                            }

                                                                                                                 ?>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="wf-card-footer">
                                                                    <div class="row">
                                                                        <!-- Column 1: Form -->
                                                                        <div class="col-md-6">
                                                                            <form id="applyForm"  method="POST" action="{{ route('submitApplyForJob') }}">
                                                                                @csrf
                                                                                <input type="hidden" value="{{ $JobDetails->job_title }}"
                                                                                    id="job_title" name="job_title">
                                                                                <input type="hidden" value="{{ $JobDetails->job_id }}" id="job_id"
                                                                                    name="job_id">

                                                                                <input type="hidden" value="{{ $JobDetails->email_address }}"
                                                                                    id="email_add_who_post_job" name="email_add_who_post_job">
                                                                                    @if($IsAlreadyApplied==TRUE)
                                                                                <button type="button" class="wf-btn wf-btn-primary">
                                                                                    {{ getJsonLocalization('viewjobs', 'alreadyApply') }}
                                                                                </button>
                                                                                   @elseif($CanNotApply==TRUE)

                                                                                   <button type="button" class="wf-btn wf-btn-danger">
                                                                                    {{ getJsonLocalization('viewjobs', 'notapply') }}
                                                                                </button>
                                                                                   @else
                                                                                <button type="submit" class="wf-btn wf-btn-primary">
                                                                                    {{ getJsonLocalization('viewjobs', 'apply') }}
                                                                                </button>
                                                                                @endif
                                                                            </form>
                                                                        </div>
                                                                          @if(isset($appliedSuccessfully))
                                                                        <div class="col-md-5">
                                                                            <div id="successMessage" class="alert alert-success alert-dismissible" >

                                                                                <strong>Success!</strong> You have applied successfully for this
                                                                                job!

                                                                            </div>
                                                                        </div>
                                                                        @endif

                                                                    </div>
                                                                </div>



                                                            </div>
                            @else

                                                            <div>
                                                                <?php
                                $session_emailId = Session::get('emailId');
                                $oldays = "";
                                $job_name = Session::get('job_name');
                                $job_field = Session::get('field');
                                $country_name = Session::get('country_name');
                                $city_name = Session::get('city_name');
                                $mode = Session::get('mode');
                                $duration = Session::get('duration');
                                $oldays = Session::get('olddays');
                                $daysShow = 0;

                                if ($oldays == 'Today') {
                                    $daysShow = 1;
                                    $date = date('Y-m-d H:i:s');
                                    $date = strtotime($date);
                                    $date = strtotime("-0 day", $date);
                                    $dateeShow = date('Y-m-d H:i:s', $date);
                                    $dateeShow = date('Y-m-d H:i:s');
                                } else if ($oldays == 'The past 7 days') {
                                    $daysShow = 7;
                                    $date = date('Y-m-d H:i:s');
                                    $date = strtotime($date);
                                    $date = strtotime("-7 day", $date);
                                    $dateeShow = date('Y-m-d H:i:s', $date);
                                } else if ($oldays == 'The past 14 days') {
                                    $daysShow = 14;
                                    $date = date('Y-m-d H:i:s');
                                    $date = strtotime($date);
                                    $date = strtotime("-14 day", $date);
                                    $dateeShow = date('Y-m-d H:i:s', $date);
                                } else if ($oldays == 'The past months') {
                                    $date = date('Y-m-d H:i:s');
                                    $date = strtotime($date);
                                    $date = strtotime("-30 day", $date);
                                    $dateeShow = date('Y-m-d H:i:s', $date);
                                    $daysShow = 30;
                                } else if ($oldays == 'More than 30 days') {
                                    $daysShow = 31;
                                    $date = date('Y-m-d H:i:s');
                                    $date = strtotime($date);
                                    $date = strtotime("-31 day", $date);
                                    $dateeShow = date('Y-m-d H:i:s', $date);
                                }

                                $query = PostJob::select('*');

                                if (strlen($job_name) > 0) {
                                    $query->where('job_title', 'like', "%$job_name%");
                                }

                                if (strlen($job_field) > 0) {
                                    $query->where('job_field', 'like', "%$job_field%");
                                }
                                if (strlen($country_name) > 0) {
                                    $query->where('country_name', 'like', "%$country_name%");
                                }

                                if (strlen($city_name) > 0) {
                                    $query->where('city_name', 'like', "%$city_name%");
                                }

                                if (strlen($mode) > 0) {
                                    $query->where('job_mode', '=', $mode);
                                }

                                if (strlen($duration) > 0) {
                                    $query->where('job_duration', '=', $duration);
                                }

                                $job_id = "";
                                $resultjobs = $query->latest()->paginate(15);

                                if (count($resultjobs) > 0) {
                                    foreach ($resultjobs as $roww) {
                                        $isAlreadyApplied=FALSE;
                                        $email_add = $roww["email_address"];
                                        $job_id = $roww["created_at"];

                                        if ($daysShow > 0) {
                                            if ($daysShow == 1) {
                                                if ($dateeShow != $job_id) {
                                                    continue;
                                                }
                                            } else if ($dateeShow > $job_id) {
                                                continue;
                                            }
                                        }

                                        $profilePic = "";
                                        $name = "";

                                        $resultpic = Organisation::where('email_id', $email_add)->get();
                                        if (count($resultpic) > 0) {
                                            foreach ($resultpic as $rowpic) {
                                                $profilePic = $rowpic["profile_picture"];
                                                //  $name = $rowpic["first_name"] . ' ' . $rowpic["second_name"];
                                                $name = $rowpic["entreprise_name"];
                                            }
                                        }

                                        $existingApplication = JobsApplyData::where('job_id', $job_id)
                                        ->where('applied_person_email', $session_emailId)
                                        ->where('post_job_email_address', $email_add )
                                        ->first();

                                        if( $existingApplication){
                                            $isAlreadyApplied=TRUE;
                                            }

                                          //checking is user can apply for job

                                          $PostedJobDetail= PostJobFilterData::where([['job_id', $job_id]])->first();
                                          $result = Individual::where('email_id', $session_emailId)->get();
                                          if ($result) {
                                              foreach($result as $row) {
                                                  $ethnicity = $row["ethnicity"];
                                                  $gender = $row["gender"];
                                                  $status = $row["status"];
                                                  $birth_date = $row["birth_date"];
                                                 break;
                                              }

                                          }

                                          //First Check BirthDate...............................

                                          $birthDate = new \DateTime($birth_date);
                                          $currentDate = new \DateTime();
                                          $interval = $currentDate->diff($birthDate);
                                          $age = $interval->y;
                                          $startAge=NULL;
                                          $endAge=NULL;


                                          if(!empty($PostedJobDetail->sAge)){
                                            $startAge=(int) $PostedJobDetail->sAge;
                                          }
                                          if(!empty($PostedJobDetail->eAge)){
                                          $endAge= (int) $PostedJobDetail->eAge;
                                          }

                                          $canNotApply=TRUE;
                                          if($startAge!=NULL && $endAge!=NULL){
                                          if($age>=$startAge && $age<= $endAge){
                                            $canNotApply=FALSE;
                                          }
                                        }
                                        if(!empty($PostedJobDetail->Gender)){

                                          if($gender==$PostedJobDetail->Gender){
                                            $canNotApply=FALSE;
                                          }
                                        }
                                        if(!empty($PostedJobDetail->status)){

                                            if($status==$PostedJobDetail->status){
                                              $canNotApply=FALSE;
                                            }
                                          }
                                          if(!empty($PostedJobDetail->Ethnicity)){

                                            if (stripos($PostedJobDetail->Ethnicity,  $ethnicity) !== false) {
                                              $canNotApply=FALSE;
                                            }
                                          }

                                          //....................
                                         ?>
                                                                <div class="loginPanel">
                                                                    <div class="wf-card1 mb-4">
                                                                        <div class="wf-card1-header">
                                                                            <div class="header-left">
                                                                                <div class="img-box">
                                                                                    <img src="ProfileImages/Images/<?php            echo $profilePic; ?>"
                                                                                        alt="img" />
                                                                                </div>
                                                                                <div>
                                                                                    <div class="name">
                                                                                        <b><?php            echo $name; ?></b>
                                                                                    </div>
                                                                                    <div class="date">
                                                                                        <b>{{ getJsonLocalization('viewjobs', 'Posted') }}:</b>
                                                                                        <?php            echo $roww['created_at']; ?>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="header-right">
                                                                                <div class="img-box">
                                                                                    <img src="PostImages/<?php            echo $email_add . '/' . $roww['job_id'] . '/' . $roww['job_img_name']; ?>"
                                                                                        alt="img" />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="wf-card-body">
                                                                            <div class="row">
                                                                                <div class="col-md-4">
                                                                                    <div class="job-feature">
                                                                                        <div class="inner1">
                                                                                            {{ getJsonLocalization('viewjobs', 'Title') }}:
                                                                                        </div>
                                                                                        <div class="inner2">
                                                                                            <?php            echo $roww['job_title']; ?></div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="job-feature">
                                                                                        <div class="inner1">
                                                                                            {{ getJsonLocalization('viewjobs', 'Mode') }}:
                                                                                        </div>
                                                                                        <div class="inner2">
                                                                                            <?php            echo $roww['job_mode']; ?></div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="job-feature">
                                                                                        <div class="inner1">
                                                                                            {{ getJsonLocalization('viewjobs', 'Schedule') }}:
                                                                                        </div>
                                                                                        <div class="inner2">
                                                                                            <?php            echo $roww['job_schedule']; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="job-feature">
                                                                                        <div class="inner1">
                                                                                            {{ getJsonLocalization('viewjobs', 'Type') }}:
                                                                                        </div>
                                                                                        <div class="inner2">
                                                                                            <?php            echo $roww['job_field']; ?></div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-4">
                                                                                    <div class="job-feature">
                                                                                        <div class="inner1">
                                                                                            {{ getJsonLocalization('viewjobs', 'Duration') }}:
                                                                                        </div>
                                                                                        <div class="inner2">
                                                                                            <?php            echo $roww['job_duration']; ?>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>

                                                                            </div>
                                                                            <div class="row">
                                                                        <div class="col-md-6">
                                                                            <div class="job-feature">
                                                                                <div class="inner1">
                                                                                    {{ getJsonLocalization('viewjobs', 'Exam') }}:
                                                                                </div>
                                                                                <div class="inner2">
                                                                                    <table class="table">
                                                                                        <tbody>
                                                                                            <?php
                                                                                                  $ExamList = JobExamList::join('exam_list', 'exam_list.exam_name', '=', 'jobs_exam_list_table.exam_name')
                                                                                                  ->where('jobs_exam_list_table.job_id', $job_id)
                                                                                                  ->select('jobs_exam_list_table.*', 'exam_list.exam_logo_name') // Selecting all fields from job_exam_list and the jobexamicon from job_exam_icons
                                                                                                  ->get();
                                                                                            foreach ($ExamList as $roww) {
                                                                                             $email_add = $roww["email_address"];
                                                                                                                 ?>
                                                                                            <tr>
                                                                                                <td><img src="ProfileImages/exam_logos/<?php        echo $roww['exam_logo_name']; ?>"
                                                                                                        alt="" width="40" height="40"
                                                                                                        style="border-radius: 50%;"></td>
                                                                                                <td>

                                                                                                    <?php        echo $roww['exam_name']; ?>

                                                                                                </td>
                                                                                            </tr>
                                                                                            <?php
                                                                                            }

                                                                                                                 ?>
                                                                                        </tbody>
                                                                                    </table>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                        </div>

                                                                        <div class="wf-card-footer">
                                                                            <form method="POST" action="{{ route('submitApplyForJob') }}">
                                                                                @csrf
                                                                                <input type="hidden" value="<?php  echo $roww['job_title']; ?>" id="job_title" name="job_title">
                                                                                <input type="hidden" value="<?php echo $job_id; ?>" id="job_id" name="job_id">

                                                                                <input type="hidden" value="<?php  echo $roww['email_address'] ;?>"
                                                                                    id="email_add_who_post_job" name="email_add_who_post_job">
                                                                                    <?php if($isAlreadyApplied==TRUE){?>
                                                                                <button type="button" class="wf-btn wf-btn-primary">
                                                                                    {{ getJsonLocalization('viewjobs', 'alreadyApply') }}
                                                                                </button>
                                                                                <?php
                                                                                    }else if($canNotApply==TRUE){?>
                                                                                    <button type="button" class="wf-btn wf-btn-danger">
                                                                                    {{ getJsonLocalization('viewjobs', 'notapply') }}
                                                                                    </button>
                                                                                <?php  }else{?>
                                                                                <button type="submit" class="wf-btn wf-btn-primary">{{ getJsonLocalization('viewjobs', 'apply') }}
                                                                                </button>
                                                                                <?php } ?>


                                                                            </form>

                                                                        </div>
                                                                    </div>
                                                                    <?php
                                    }
                                }
                                                                                   ?>
                                                                </div>
                                                                {{ $resultjobs->links('pagination') }}
                                                            </div>
                            @endif
                                <div class="modal-body text-center" style="display:none;">
                                    <h5 class="text-danger mb-3">
                                        {{ getJsonLocalization('viewjobs', 'You are Already Applied For This Job') }}
                                    </h5>
                                    <form method="GET" action="{{ url('home') }}">
                                        <button type="submit" class="wf-btn wf-btn-secondary"
                                            style="margin-left:40px;">{{ getJsonLocalization('viewjobs', 'Return to profile') }}</button>
                                    </form>
                                </div>
                            </div>
                        </div>

        </form>
    </div>
    <div class="modal fade" id="login" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" id="examModelCloseButton" class="close" data-dismiss="modal"
                        aria-hidden="true" style="position: absolute;
                        z-index: 1111;
                        top: 0;
                        right: 0;
                        margin-top: 10px;
                        margin-right: 10px;
                        border-radius: 10px;
                        display: flex;
                        align-items: center;">&times;
                    </button>
                    <div class="row d-flex justify-content-center" style="text-align: center ;">
                        <img src="logos//logo1.png" alt="" style="width: 252px; object-fit: cover;" width="130"
                            height="100" style="margin-left:30px;"><br>
                        <div class="row pt-3" style="text-align: center;color:red;"><b>You must be logged to see this
                                job offer.</b></div>
                    </div>
                </div>
                <div class="modal-body">
                    <form action="{{ route('action_login_job_view') }}" method="POST">
                        @csrf
                        <div class="row d-flex justify-content-center">
                            <div class="col-8 d-flex justify-content-center">
                                <input type="text" style="width:100%;" id="login_email" autocomplete="off" name="login_email" required
                                    placeholder="Enter email">
                            </div>
                        </div><br>
                        <div class="row d-flex justify-content-center">
                            <div class="col-8 d-flex justify-content-center">
                                <input type="password" style="width:100%;" id="login_pass" name="login_pass" required
                                    placeholder="Enter password">
                            </div>
                        </div><br>
                        <div class="row">
                            <div class="col-sm-4"></div>
                            <div class="col-sm-4"> <button type="submit" style="width:100%;"
                                    class="btn btn-warning">Login</button></div>
                        </div>
                        <br>
                    </form>
                </div>
                <div class="modal-footer">
                    <div class="row">
                        <div class="col-sm-3"></div>
                        <div class="col-12 d-flex justify-content-end">
                            <div class="d-flex justify-content-end">
                                <button type="button" style="width:100%;" class="btn btn-warning"><a
                                        href="{{ route('signup') }}" style="color:white"
                                        class="text-decoration-none"><span class="glyphicon glyphicon-user"></span>
                                        Create
                                        a new account</a></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    <input type="button" id="showNotApplied" data-bs-toggle="modal" data-bs-target="#cannotapplyDialog"
        style="display:none;">
    <input type="button" id="successfullySubmitted" data-bs-toggle="modal" data-bs-target="#successfullySumbitted"
        style="display:none;">
    <input type="button" id="alreadyApplied" data-bs-toggle="modal" data-bs-target="#allready" style="display:none;">

    <div class="modal fade" id="cannotapplyDialog" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">



                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-5">
                    <div class="text-center">
                        <img src="logos//logo1.png" alt="" width="100">
                    </div>
                    <div class="text-center">
                        <h5 class="text-danger my-4">You can not apply for this job</h5>
                        <form method="GET" action="{{ url('home') }}">
                            <button type="submit" class="wf-btn wf-btn-primary">Return to profile</button>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="modal fade" id="successfullySumbitted" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-5">
                    <div class="text-center">
                        <img src="logos//logo1.png" alt="" width="100" />
                    </div>

                    <?php
$jobProfileImage = Session::get('job_profile_image');
$jobpostedby = Session::get('job_posted_by_email');
$job_img = $jobpostedby . '/' . $jobProfileImage;
                    ?>
                    <div class="text-center">
                        <h5 class="text-success my-4">You have successfully applied as programmer at Workfrater!</h5>
                        <form method="GET" action="{{ url('home') }}">
                            <button type="submit" class="wf-btn wf-btn-primary">Return to profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="allready" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-5">
                    <div class="text-center">
                        <img src="logos//logo1.png" alt="" width="100" />
                    </div>
                    <div class="text-center">
                        <h5 class="text-danger my-4">You are Already Applied For This Job</h5>
                        <form method="GET" action="{{ url('home') }}">
                            <button type="submit" class="wf-btn wf-btn-primary">Return to profile</button>
                        </form>
                    </div>
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="successfullySumbitted" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-5">
                    <div class="text-center">
                        <img src="logos//logo1.png" alt="" width="100" />
                    </div>

                    <?php
$jobProfileImage = Session::get('job_profile_image');
$jobpostedby = Session::get('job_posted_by_email');
$job_img = $jobpostedby . '/' . $jobProfileImage;
                    ?>
                    <div class="text-center">
                        <h5 class="text-success my-4">You have successfully applied as programmer at Workfrater!</h5>
                        <form method="GET" action="{{ url('home') }}">
                            <button type="submit" class="wf-btn wf-btn-primary">Return to profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="allready" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body py-5">
                    <div class="text-center">
                        <img src="logos//logo1.png" alt="" width="100" />
                    </div>
                    <div class="text-center">
                        <h5 class="text-danger my-4">You are Already Applied For This Job</h5>
                        <form method="GET" action="{{ url('home') }}">
                            <button type="submit" class="wf-btn wf-btn-primary">Return to profile</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    </div>
    </div>
    </div>
    </div>
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
        integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
        </script>

    <script type="text/javascript" src="js//url.js"></script>
    <script type="text/javascript">
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });

        $(document).ready(function () {

            $('#search_data').autocomplete({
                source: "{{ route('searchResult.get') }}",
                minLength: 1,
                select: function (event, ui) {
                    $('#search_data').val(ui.item.value);
                }
            }).data('ui-autocomplete')._renderItem = function (ul, item) {
                return $("<li class='ui-autocomplete-row'></li>")
                    .data("item.autocomplete", item)
                    .append(item.label)

                    .appendTo(ul);
            };

        });
    </script>

</body>


<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
    integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
    </script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
    integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
    </script>
<script type="text/javascript" src="js//url.js"></script>
<script type="text/javascript">
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });

    $(document).ready(function () {

        $('#search_data').autocomplete({
            source: "{{ route('searchResult.get') }}",
            minLength: 1,
            select: function (event, ui) {
                $('#search_data').val(ui.item.value);
            }
        }).data('ui-autocomplete')._renderItem = function (ul, item) {
            return $("<li class='ui-autocomplete-row'></li>")
                .data("item.autocomplete", item)
                .append(item.label)

                .appendTo(ul);
        };

    });
</script>





<!-- HEADER SIDEBAR -->
<div class="sidebar-profile-info-slide">

    <div class="slide-close-icon"><img src="logos/cross.png" alt="img" width="20" /></div>
    <div class="sidebar-profile-info-slide-scroller">
        <div class="sidebar-header border-bottom">
            <div class="sidebar-logo-box mb-3 text-center">
                <img src="logos//logo1.png" alt="" style="width:100px;" />
            </div>
            <h3 class="text-center text-primary mb-3">{{ getJsonLocalization('viewjobs', 'Job Offers') }}</h3>
        </div>
        <div class="sidebar-body pt-4">
            <div class="mb-2">
                <input type="text" class="form-control" autocomplete="off" id="job_post" name="job_post" aria-describedby="emailHelp"
                    placeholder="job's name">
            </div>
            <div class="mb-2">
                <select class="form-select" id="field" name="field">
                    <option value="">Type</option>
                    <option value="Health">Health</option>
                    <option value="Finances">Finances</option>
                    <option value="T.I programming">T.I programming</option>
                    <option value="T.I tech support">T.I tech support</option>
                    <option value="T.I data analyst">T.I data analyst</option>
                    <option value="T.i video games and 3D">T.i video games and 3D</option>
                    <option value="T.i video games and 3D">T.i video games and 3D</option>
                    <option value="Engineering">Engineering</option>
                    <option value="Calling center">Calling center</option>
                    <option value="Office">Office </option>
                    <option value="Infography and design">Infography and design</option>
                    <option value="General cleaning">General cleaning</option>
                    <option value="General sales">General sales</option>
                    <option value="General warehouses">General warehouses</option>
                    <option value="Factory and industry">Factory and industry</option>
                    <option value="Marketing and sales">Marketing and sales</option>
                    <option value="Web Marketing">Web Marketing</option>
                    <option value="Recruitement">Recruitement</option>
                    <option value="stores">stores</option>
                    <option value="construction">construction</option>
                    <option value="Security guard">Security guard</option>
                    <option value="Human resources">Human resources</option>
                    <option value="Management">Management</option>
                    <option value="Science">Science</option>
                    <option value="Other">Other</option>
                </select>
            </div>
            <div class="mb-2">
                <select class="form-select" id="country_name" name="country_name">
                    <option value="">Country</option>
                    <option value="USA">USA</option>
                    <option value="CANADA">CANADA</option>
                </select>
            </div>
            <div class="mb-2">
                <input type="text" class="form-control" autocomplete="off" id="city_name" name="city_name" aria-describedby="emailHelp"
                    placeholder="City Name">
            </div>
            <div class="mb-2">
                <select class="form-select" id="schedule" name="schedule">
                    <option value="">Select Schedule</option>
                    <option value="Full-time">Full-time</option>
                    <option value="Part-time">Part-time</option>
                    <option value="On-call">On-call</option>
                </select>
            </div>
            <div class="mb-2">
                <select class="form-select" id="mode" name="mode">
                    <option value="">Select Mode</option>
                    <option value="On-site">On-site</option>
                    <option value="Hybrid">Hybrid</option>
                    <option value="Home">Home</option>
                </select>
            </div>
            <div class="mb-2">
                <select class="form-select" id="duration" name="duration">
                    <option value="">Select Duration</option>
                    <option value="Permanent">Permanent</option>
                    <option value="temporary">temporary</option>
                </select>
            </div>
            <div class="mb-2">
                <select class="form-select" id="oldday" name="oldday">
                    <option value="">Posted Date</option>
                    <option value="Today">Today</option>
                    <option value="The past 7 days">The past 7 days</option>
                    <option value="The past 14 days">The past 14 days</option>
                    <option value="The past months">The past months</option>
                    <option value="More than 30 days">More than 30 days</option>
                </select>
            </div>
            <div class="mb-2">
                <button type="submit" class="wf-btn wf-btn-primary w-100"
                    style="width:50%;">{{ getJsonLocalization('viewjobs', 'Update') }}</button>
            </div>
        </div>
    </div>

</div>

</body>


</html>