<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Virtual Classroom Conference | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section virtual-classroom-banner-section bg-white" style="background-image:url('images/banner-img4.jpg')">
        <div class="container py-5">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-5 text-md-start text-center">
                    <div class="virtual-classroom-banner-content-box py-4 px-3 p-sm-5 p-md-0 rounded-x-lg">
                        <div class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                            <img src="logos/header-logo2.png" alt="logo" width="150px" />
                        </div>
                        <h1 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('virtual-classroom-conference', 'you_can_create_a_video_meeting_on_our_platform_without_logging_in') }}</h1>
                        <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                            <a href="javascript:void(0)" class="wf-btn wf-btn-secondary me-2 mb-2">{{ getJsonLocalization('virtual-classroom-conference', 'create_an_instant_meeting') }}</a>
                            <a href="javascript:void(0)" class="wf-btn wf-btn-secondary mb-2">{{ getJsonLocalization('virtual-classroom-conference', 'join_a_meeting') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="section-padding bg-white">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('virtual-classroom-conference', 'use_our_platform_as_a_conference_and_classroom_tool') }}</h2>
            </div>
            <div class="container-large">
                <div class="row align-items-center g-5">
                    <div class="col-md-6">
                        <div class="text-md-start text-center">
                            <p>{{ getJsonLocalization('virtual-classroom-conference', 'platforms_like_google_meet_and_zoom') }}</p>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <img src="images/video-call-img.jpg" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Alternative rows section -->
    <section class="section-padding bg-white overflow-hidden border-top">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <div class="description wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('virtual-classroom-conference', 'why_use_our_platform') }}</p>
                </div>
            </div>
            <div class="alternative-rows-container">
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('virtual-classroom-conference', 'record_your_viewers') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('virtual-classroom-conference', 'record_participants') }}</p>
                            </div>
                            <a href="/public/video-calls" class="wf-btn wf-btn-primary">{{ getJsonLocalization('virtual-classroom-conference', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-use-our-platform-img1.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('virtual-classroom-conference', 'in_video_files') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('virtual-classroom-conference', 'create_documents_during_calls') }}</p>
                            </div>
                            <a href="/public/video-calls" class="wf-btn wf-btn-primary">{{ getJsonLocalization('virtual-classroom-conference', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-use-our-platform-img2.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('virtual-classroom-conference', 'classrooms') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('virtual-classroom-conference', 'create_virtual_classrooms') }}</p>
                            </div>
                            <a href="/public/education-accounts-and-online-classrooms" class="wf-btn wf-btn-primary">{{ getJsonLocalization('virtual-classroom-conference', 'read_more') }}</a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-use-our-platform-img3.jpg" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4>{{ getJsonLocalization('virtual-classroom-conference', 'online_exams') }}</h4>
                            <div class="description">
                                <p>{{ getJsonLocalization('virtual-classroom-conference', 'create_online_exams') }}</p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary">{{ getJsonLocalization('virtual-classroom-conference', 'read_more') }}</a>
                        </div>
                    </div>    
                    <div class="col-md-6 inner2">
                        <img src="images/why-use-our-platform-img4.jpg" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
