<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\FollowerController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PostController;
use App\Http\Controllers\ChatController;
use App\Http\Controllers\WebcamAndScreenSharing;
use App\Http\Controllers\LanguageController;
use App\Http\Controllers\VideoChat;
use App\Http\Controllers\PeerToPeerVideoChat;
use App\Http\Controllers\NormalMeetingVideoChat;
use App\Http\Controllers\ChatifyPopupController;
use App\Models\Education;
use App\Models\Individual;
use App\Models\Organisation;
use App\Http\Controllers\PostJobs;
use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use App\Models\UserModel;
use Illuminate\Support\Facades\Auth;

/* Change Language */

Route::get('lang/{lang}', [LanguageController::class, 'switchLang'])->name('lang.switch');


// Default Index Page || Default Login Form
Route::get('/', function () {
    return view('index');
})->name('index');

Route::get('/TestingOrg', function () {
    return view('MessageIssue');
})->name('TestingOrg');


Route::get('/indexmob', function () {
    return view('indexmob');
})->name('indexmob');

Route::get('/joincall', function () {
    return view('JoinCall');
})->name('joincall');
//chat routes
Route::middleware('auth')->group(function () {
    Route::get('/chatify-popup',  [ChatifyPopupController::class,'index'])->name('chatify.popup');
    Route::get('/chatify-popup/contacts', [ChatifyPopupController::class,'getContacts'])->name('chatify.contact');
    Route::get('/chatify-popup/messages', [ChatifyPopupController::class,'getMessages'])->name('chatify.messages');
    Route::post('/chatify-popup/send', [ChatifyPopupController::class,'sendMessage'])->name('chatify.send');
    Route::get('/download/{file}',  [ChatifyPopupController::class,'download'])->name('chatify.download');
});
//end chat routes
// Default Login form Action Page
Route::post('/action_login', [AuthController::class, 'action_login'])->name('action_login');
Route::post('/action_login_job_view', [AuthController::class, 'action_login_job_view'])->name('action_login_job_view');
Route::post('/action_login_webmob', [AuthController::class, 'action_login_webmob'])->name('action_login_webmob');

Route::post("/joinVideoCallByUrl", [VideoChat::class, 'joinVideoCallByUrl'])->name('joinVideoCallByUrl');;

Route::post('/filterJobs', [PostJobs::class, 'filterJobs'])->name('filterJobs');
Route::post('/applyforjob', [PostJobs::class, 'applyforjob'])->name('applyforjob');
// Default SignUp Page
Route::get('/signup', function () {
    return view('signup');
})->name('signup');

Route::post('/checkUserJoinVideoCallByUrl', [VideoChat::class, 'checkUserJoinVideoCallByUrl'])->name('checkUserJoinVideoCallByUrl');

Route::post('/deleteChatGroupPeerToPeer', [ChatController::class, 'deleteChatGroupPeerToPeer'])->name('deleteChatGroupPeerToPeer.post');
Route::post('/deleteUserFromChatGroup', [ChatController::class, 'deleteUserFromChatGroup'])->name('deleteUserFromChatGroup.post');
Route::post('/blockUserFromChatGroup', [ChatController::class, 'blockUserFromChatGroup'])->name('blockUserFromChatGroup.post');


//Routes for Signup Individuals...............................
Route::get('/basicInfo', function () {
    return view('individualsignup/basicInfo');
})->name('basicInfo');
Route::post('/actionBasicInfo', [AuthController::class, 'actionBasicInfo'])->name('actionBasicInfo');
Route::get('/diplomaInfo', function () {
    return view('individualsignup/diplomaInfo');
})->name('diplomaInfo');

Route::post('/actionSocialLinks', [AuthController::class, 'actionSocialLinks'])->name('actionSocialLinks');
Route::get('/addsocialmedialinks', function () {
    return view('individualsignup/socialmedialinks');
})->name('addsocialmedialinks');
Route::post('/action_diplomaInfo', [AuthController::class, 'action_diplomaInfo'])->name('action_diplomaInfo');
Route::get('/tellaboutus', function () {
    return view('individualsignup/aboutus');
})->name('tellaboutus');
Route::post('/action_aboutus', [AuthController::class, 'action_aboutus'])->name('action_aboutus');
Route::get('/aditionalInformation', function () {
    return view('aditionalInformation');
})->name('aditionalInformation');
Route::get('/workexperience', function () {
    return view('workexperience');
})->name('workexperience');

//...............................................................

//Route for Originational signup ..................................................

Route::get('/psersonalInfomation', function () {
    return view('orgsignup/psersonalInfomation');
})->name('psersonalInfomation');


Route::get('/businessOrgInfo', function () {
    return view('orgsignup/businessOrgInfo');
})->name('businessOrgInfo');

Route::post('/action_businessOrg_info', [AuthController::class, 'action_businessOrg_info'])->name('action_businessOrg_info');

//.................................................................................


//JOB POSING REALTED ROUTES........................................................



Route::get('/PostJob', function () {
    return view('postjob');
})->name('PostJob');


//..................................................................................


Route::get('/UserProfilePage', function () {
    if(Auth::user()->role == 'individual'){
        return view('ProfileInd');
    }
    if(Auth::user()->role == 'organization'){
        return view('ProfileOrg');
    }
})->name('UserProfilePage');


Route::get('/startTest', function () {
    return view('examTest');
})->name('startTest');


Route::post('/uploadScreenCapture', [WebcamAndScreenSharing::class, 'uploadScreenSharingVideo'])->name('uploadScreenCapture.post');
Route::post('/uploadWebCamVideo', [WebcamAndScreenSharing::class, 'uploadCamVideoToServer'])->name('uploadWebCamVideo.post');
Route::post('/uploadScreenCaptureVideoCallPageCaller', [WebcamAndScreenSharing::class, 'uploadScreenCaptureVideoCallPageCaller'])->name('uploadScreenCaptureVideoCallPageCaller.post');
Route::post('/uploadScreenCaptureVideoCallPageCalling', [WebcamAndScreenSharing::class, 'uploadScreenCaptureVideoCallPageCalling'])->name('uploadScreenCaptureVideoCallPageCalling.post');
Route::post('addingVideoRecordingEntryToDB', [WebcamAndScreenSharing::class, 'addingVideoRecordingEntryToDB'])->name('addingVideoRecordingEntryToDB.post');


// Default Signup form Action Page Redirect if credetials already exist
Route::post('/signup', [AuthController::class, 'signup'])->name('action_signup');


// If Type OF Account is == "Individual"
// ====================================

// SignUp Page 2 => Individual
Route::get('/signup2', function () {
    return view('signup2');
})->name('signup2');

// Signup2 form Action Page If First Signup Page Fill => Individual
Route::post('/signup2', [AuthController::class, 'signup2'])->name('action_signup2');
Route::get('/Logout', [HomeController::class, 'Logout']);
Route::post('/VideChatInfo', [VideoChat::class, 'VideChatInfo'])->name('VideChatInfo.post');
Route::post('/VideChatInfoMeeting', [VideoChat::class, 'VideChatInfoMeeting'])->name('VideChatInfoMeeting.post');
Route::get('/deleteMeetingLink', [NormalMeetingVideoChat::class, 'deleteMeetingLink'])->name('deleteMeetingLink');
Route::post('/AcceptCall', [VideoChat::class, 'AcceptCall'])->name('AcceptCall.post');
Route::get('/videocalldashboard', [VideoChat::class, 'videocalldashboard'])->name('videocalldashboard');;
Route::post('/GenerateClassRoomLinksForStudents', [VideoChat::class, 'GenerateClassRoomLinksForStudents'])->name('GenerateClassRoomLinksForStudents');;


Route::get('/videocalldashboardmobile', [VideoChat::class, 'videocalldashboardmobile'])->name('videocalldashboardmobile');;

// SignUp Page 3 => Individual
Route::get('/ScheduleMeeting', function () {
    return view('MeetingSchedule');
})->name('ScheduleMeeting');

Route::get('/videocalldashboardaccept', [VideoChat::class, 'videocalldashboardaccept'])->name('videocalldashboardaccept');
Route::get('/audiocalldashboard', [VideoChat::class, 'audiocalldashboard'])->name('audiocalldashboard');;
Route::get('/audiocalldashboardmobile', [VideoChat::class, 'audiocalldashboardmobile'])->name('audiocalldashboardmobile');;


// SignUp Page 3 => Individual
Route::get('/signup3', function () {
    return view('signup3');
})->name('signup3');

// Signup3 form Action Page If First Signup2 Page Fill => Individual
Route::post('/signup3', [AuthController::class, 'signup3'])->name('action_signup3');

Route::post('/submitJobApplication', [PostJobs::class, 'submitJobApplication'])->name('submitJobApplication');


Route::get('/UserSearchResultmob', function () {
    return view('UserSearchResultmob');
})->name('UserSearchResultmob');

Route::get('/viewjobs', function () {
    $job_post = request('job_post');
    $job_city = request('job_city');
    $job_country = request('job_country');
    $job_field = request('job_field');
    Session::put('job_name', $job_post);
    Session::put('field', $job_field);
    Session::put('country_name', $job_country);
    Session::put('city_name', $job_city);
    Session::put('mode', '');
    Session::put('duration', '');
    return view('viewjobs');
})->name('viewjobs');

Route::get('/viewjobswithfilter', function () {
    if (
        isset($_SERVER['HTTP_SEC_CH_UA_MOBILE']) &&
        $_SERVER['HTTP_SEC_CH_UA_MOBILE'] == '?1'
    ) {

        return view('mobile/viewjobs');
    } else {
        return view('viewjobs');
    }
})->name('viewjobswithfilter');



Route::get('/applyforjob', function () {
    if (isset($_SERVER['HTTP_SEC_CH_UA_MOBILE']) && $_SERVER['HTTP_SEC_CH_UA_MOBILE'] == '?1')
    {
        return view('mobile/applyforjob');
    } else {
        return view('applyforjob');
    }
})->name('applyforjob');


// Workexperience form Action Page If First Signup3 Page Fill => Individual
Route::post('/action_adding_exp', [AuthController::class, 'action_adding_exp'])->name('action_adding_exp');


// Exam Page
Route::get('/exams', function () {
    $searchQuery = request('exam_search');
    return view('examPage', compact('searchQuery'));
})->name('exams');


/* Entreprenur page */
Route::get('/entrepreneur', function () {
    return view('entrepreneur');
})->name('entrepreneur');

// Interview Page
Route::get('/interview', function () {
    return view('interviewPage');
})->name('interview');


/* Entreprenur page */
Route::get('/videocallnewguiclassroom', function () {
    return view('videocallnewguiclassroom');
})->name('videocallnewguiclassroom');

// AditionalInformation form Action Page If First Workexperience Page Fill => Individual
Route::post('/uploadCVProfile', [AuthController::class, 'uploadCVProfile'])->name('uploadCVProfile');
Route::post('/uploadUpdatedProfile', [AuthController::class, 'uploadUpdatedProfile'])->name('uploadUpdatedProfile');
Route::post('/uploadCoverPhoto', [AuthController::class, 'uploadCoverPhoto'])->name('uploadCoverPhoto');
// If Type OF Account is == "Individual"
// ====================================

// If Type OF Account is == "Organisation"
// =======================================

// signingOrg Page => Organisation
Route::get('/signingOrg', function () {
    return view('signingOrg');
})->name('signingOrg');


Route::get('/jobpost', function () {
    return view('postjob');
})->name('postjob');
// signingOrg form Action Page If First Signup Page Fill => Organisation
Route::post('/action_signingOrg', [AuthController::class, 'action_signingOrg'])->name('action_signingOrg');

// signingOrg2 Page => Organisation
Route::get('/signingOrg2', function () {
    return view('signingOrg2');
})->name('signingOrg2');

// signingOrg2 form Action Page If First signingOrg2 Page Fill => Organisation
Route::post('/action_signuporg2', [AuthController::class, 'action_signuporg2'])->name('action_signuporg2');

// If Type OF Account is == "Organisation"
// =======================================


Route::get('/SearchPageCount', function () {
    $pageNumber = $_GET['pageNumber'];


    session::put('PageCount', $pageNumber);

    return view("UserSearchResult");
});
Route::get('/SearchPagePrevious', function () {
    $pageNumber = session::get('PageCount');

    $pageNumber = str_replace("'", '', $pageNumber);

    if ($pageNumber > 0) {
        $pageNumber = $pageNumber - 1;
        if ($pageNumber == 0) {
            $pageNumber = 1;
        }
    }

    session::put('PageCount', $pageNumber);

    return view("UserSearchResult");
});
Route::get('/SearchPageNext', function () {
    $pageNumber = session::get('PageCount');

    $pageNumber = str_replace("'", '', $pageNumber);

    if ($pageNumber > 0) {
        $pageNumber = $pageNumber + 1;
    }
    echo $pageNumber;

    session::put('PageCount', $pageNumber);

    return view("UserSearchResult");
});

Route::get('/Individuals', function () {
    $myValue = session::get('ViewSearch');
    if ($myValue != 'ByCity') {
        session::put('ViewSearch', 'Ind');
    }
    $pageNumber = (int)session::get('PageCount');
    $pageNumber = 1;
    session::put('PageCount', $pageNumber);
    if ($myValue == 'ByCity') {
        $countyName = session::get('countryName');
        $cityName = session::get('cityName');
        $data = [
            'countyName'  => $countyName,
            'cityName' =>  $cityName
        ];

        session::put('ViewSearchByTag', 'Ind');
        return view("UserSearchResult")->withData($data);
    } else {
        session::put('ViewSearch', 'Ind');
        return view("UserSearchResult");
    }
});

Route::get('/Education', function () {
    $myValue = session::get('ViewSearch');
    if ($myValue != 'ByCity') {
        session::put('ViewSearch', 'Edu');
    }
    $pageNumber = (int)session::get('PageCount');
    $pageNumber = 1;
    session::put('PageCount', $pageNumber);
    if ($myValue == 'ByCity') {
        $countyName = session::get('countryName');
        $cityName = session::get('cityName');
        $data = [
            'countyName'  => $countyName,
            'cityName' =>  $cityName
        ];
        session::put('ViewSearchByTag', 'Edu');
        return view("UserSearchResult")->withData($data);;
    } else {
        session::put('ViewSearch', 'Edu');
        return view("UserSearchResult");
    }
});


Route::get('/Organization', function () {

    $myValue = session::get('ViewSearch');
    if ($myValue != 'ByCity') {
        session::put('ViewSearch', 'Org');
    }
    $pageNumber = (int)session::get('PageCount');
    $pageNumber = 1;

    session::put('PageCount', $pageNumber);
    if ($myValue == 'ByCity') {

        $countyName = session::get('countryName');
        $cityName = session::get('cityName');
        $data = [
            'countyName'  => $countyName,
            'cityName' =>  $cityName
        ];
        session::put('ViewSearchByTag', 'Org');

        return view("UserSearchResult")->withData($data);
    } else {
        return view("UserSearchResult");
    }
});
Route::get('/All', function () {


    $pageNumber = (int)session::get('PageCount');
    session::put('ViewSearchByTag', '');
    session::put('ViewSearch', 'All');
    $pageNumber = 1;



    session::put('PageCount', $pageNumber);

    return view("UserSearchResult");
});

Route::post('/searchbycityname', function (Request $request) {
    $pageNumber = (int)session::get('PageCount');
    session::put('ViewSearchByTag', 'All');
    $data = [
        'countyName'  => $request->contryName,

        'cityName' =>  $request->cityName
    ];

    session::put('ViewSearch', 'ByCity');
    $pageNumber = 1;
    session::put('countyName', $request->contryName);
    session::put('cityName', $request->cityName);

    session::put('PageCount', $pageNumber);

    return view("UserSearchResult")->withData($data);
});

Route::post('/UserSearchResult', function (Request $request) {

    session::put('searchName', $request->searchName);
    session::put('type', $request->type);
    session::put('cityName', $request->cityName);
    session::put('countryName', $request->countryName);
    $pageNumber = 1;
    session::put('ViewSearch', 'ByCity');
    session::put('PageCount', $pageNumber);


    return view("UserSearchResult");
});

// If Type OF Account is == "Education"
// ====================================

// edusignup Page => Education
Route::get('/edusignup', function () {
    return view('edusignup');
})->name('edusignup');

// edusignup form Action Page If First Signup Page Fill => Education
Route::post('/action_edusignup', [AuthController::class, 'action_edusignup'])->name('action_edusignup');


// edusignup2 Page => Education
Route::get('/edusignup2', function () {
    return view('edusignup2');
})->name('edusignup2');

// edusignup2 form Action Page If First edusignup Page Fill => Education
Route::post('/action_edusignup2', [AuthController::class, 'action_edusignup2'])->name('action_edusignup2');

// If Type OF Account is == "Education"
// ====================================

// Search Fetch Main
Route::get('/fetchMain', [HomeController::class, 'fetchMain'])->name('fetchMain');
// On Click User To Redirect
Route::get('/RedirectToPersonFollowerPage', [HomeController::class, 'RedirectToPersonFollowerPage'])->name('RedirectToPersonFollowerPage');
// Search View More Redirection
Route::get('/ViewAll', [HomeController::class, 'ViewAll'])->name('ViewAll');
// Free Search in View All Page
Route::post('/FreeSearchCriteria', [HomeController::class, 'FreeSearchCriteria'])->name('FreeSearchCriteria');
// Search Criteria On View All
Route::get('/SearchCriteria', [HomeController::class, 'SearchCriteria'])->name('SearchCriteria');
// Search Criteria1 On Follower Info
Route::get('/SearchCriteria1', [HomeController::class, 'SearchCriteria1'])->name('SearchCriteria1');

Route::post('/submitJobInfo', [PostJobs::class, 'submitJobInfo'])->name('submitJobInfo');

// Home
//Route::get('/home', [HomeController::class, 'home'])->name('home');

Route::get('/home', function () {
    if (Auth::user()->role == 'individual') {
        return view('homeind');
    }elseif(Auth::user()->role == 'organization') {
        return view('homeorg');
    }else{
        return view('homeind');
    }

})->name('home')->middleware('auth');


Route::get('/meeting-schedule', function () {
    return view('MeetingSchedule');  // Or use a controller to return the view
})->name('meeting.schedule');
Route::get('/inboxmessages', [ChatController::class, 'inboxmessages'])->name('inboxmessages');
Route::get('/inboxmessagesmobile', [ChatController::class, 'inboxmessagesmobile'])->name('inboxmessagesmobile');
Route::get('/homemob', [HomeController::class, 'homemob'])->name('homemob');
// View User Profile
Route::get('/UserProfile', [HomeController::class, 'UserProfile'])->name('UserProfile');

Route::post('/ShowUserMessages', [ChatController::class, 'ShowUserMessages'])->name('ShowUserMessages');
Route::get('/ShowUserMessagesMobile', [ChatController::class, 'ShowUserMessagesMobile'])->name('ShowUserMessagesMobile');
Route::post('/DeleteChatGroup', [ChatController::class, 'DeleteChatGroup'])->name('DeleteChatGroup');

// Check Followers
Route::get('/CheckFollower', [FollowerController::class, 'CheckFollower']);
// Add To Followers
Route::get('/FollowsAddToDb', [FollowerController::class, 'FollowsAddToDb']);
// Remove To Followers
Route::get('/UnFollowsAddToDb', [FollowerController::class, 'UnFollowsAddToDb']);
Route::get('/UserSearchResult', [PostController::class, 'UserSearchResult']);
// Followers Info Page
Route::get('/FollowersInfo', [FollowerController::class, 'FollowersInfo'])->name('FollowersInfo');




// Upload Post
Route::post('/UploadPost', [PostController::class, 'UploadPost'])->name('UploadPost');
Route::post('/UploadPostMobile', [PostController::class, 'UploadPostMobile'])->name('UploadPostMobile');
// Upload Image
Route::post('/UploadPostImg', [PostController::class, 'UploadPostImg']);


//like post
Route::post('LikePost', [PostController::class, 'LikePost'])->name('LikePost.post');
Route::post('DisLikePost', [PostController::class, 'DisLikePost'])->name('DisLikePost.post');
Route::post('submitChat', [ChatController::class, 'submitChat'])->name('submitChat.post');
Route::post('submitVideoChat', [VideoChat::class, 'submitVideoChat'])->name('submitVideoChat.post');
Route::post('/generateNormalMeeting', [VideoChat::class, 'generateNormalMeeting'])->name('generateNormalMeeting');
Route::post('/generateClassRoomLink', [VideoChat::class, 'generateClassRoomLink'])->name('generateClassRoomLink');
Route::post('/addStudentToClassroom', [VideoChat::class, 'addStudentToClassroom'])->name('addStudentToClassroom.post');
Route::post('searchUser', [ChatController::class, 'searchUser'])->name('searchUser.post');
Route::post('addUserToGroup', [ChatController::class, 'addUserToGroup'])->name('addUserToGroup.post');
Route::post('addQuestion', [PostJobs::class, 'addQuestion'])->name('addQuestion.post');
Route::post('addQuestionOption', [PostJobs::class, 'addQuestionOption'])->name('addQuestionOption.post');
Route::post('addSocialLink', [PostController::class, 'addSocialLink'])->name('addSocialLink.post');

Route::post('AddingComments', [PostController::class, 'AddingComments'])->name('AddingComments.post');
Route::get('searchResult', [PostController::class, 'searchResult'])->name('searchResult.get');
Route::post('addFollows', [PostController::class, 'addFollows'])->name('addFollows.post');
Route::post('set_status_live', [ChatController::class, 'set_status_live'])->name('set_status_live.post');
Route::post('check_live', [ChatController::class, 'check_live'])->name('check_live.post');
Route::post('checkVideoCallLink', [VideoChat::class, 'checkVideoCallLink'])->name('checkVideoCallLink.post');
Route::post('RejectVideoCall', [VideoChat::class, 'RejectVideoCall'])->name('RejectVideoCall.post');


Route::post('GetUserName', [VideoChat::class, 'GetUserName'])->name('GetUserName.post');





Route::post('checkRecMessageCount', [ChatController::class, 'checkRecMessageCount'])->name('checkRecMessageCount.post');
Route::post('checkMessageForInboxPage', [ChatController::class, 'checkMessageForInboxPage'])->name('checkMessageForInboxPage.post');
Route::post('checkMessageForVideoCallPage', [VideoChat::class, 'checkMessageForVideoCallPage'])->name('checkMessageForVideoCallPage.post');
Route::post('check_replay_back', [ChatController::class, 'check_replay_back'])->name('check_replay_back.post');
Route::post('deleteReadedChat', [ChatController::class, 'deleteReadedChat'])->name('deleteReadedChat.post');
Route::post('getOldChatForDialogOne', [ChatController::class, 'getOldChatForDialogOne'])->name('getOldChatForDialogOne.post');
Route::get('getNewMessageCount', [ChatController::class, 'getNewMessageCount'])->name('getNewMessageCount.get');



Route::post('addUnFollows', [PostController::class, 'addUnFollows'])->name('addUnFollows.post');
Route::post('deleteLink', [PostController::class, 'deleteLink'])->name('deleteLink.post');
Route::post('updateDiplomaInfo', [AuthController::class, 'updateDiplomaInfo'])->name('updateDiplomaInfo.post');
Route::post('updateWorkExperience', [AuthController::class, 'updateWorkExperience'])->name('updateWorkExperience.post');
Route::post('UpdateProfileImageFromOldImages', [AuthController::class, 'UpdateProfileImageFromOldImages'])->name('UpdateProfileImageFromOldImages');
Route::post("/CheckCallerAcceptCall", [PeerToPeerVideoChat::class, 'CheckCallerAcceptCall'])->name('CheckCallerAcceptCall.post');

// Footer Pages
Route::get('innovations', function () {
    return view('footer.about_us.innovations');
})->name('innovations');
Route::get('/goals-and-culture', function () {
    return view('footer.about_us.goalsandculture');
})->name('goalsandculture');
Route::get('/our-customers', function () {
    return view('footer.about_us.ourcustomers');
})->name('ourcustomers');
Route::get('/join-our-team', function () {
    return view('footer.about_us.joinourteam');
})->name('joinourteam');
Route::get('/book-an-online-presentation', function () {
    return view('footer.about_us.book-an-online-presentation');
})->name('book-an-online-presentation');
Route::get('/our-team', function () {
    return view('footer.about_us.ourteam');
})->name('ourteam');
Route::get('/contact-us', function () {
    return view('footer.about_us.contactus');
})->name('contactus');

Route::get('/general-inquiries', function () {
    return view('footer.contact_us.generalinquiries');
})->name('generalinquiries');
Route::get('/tech-support', function () {
    return view('footer.contact_us.techsupport');
})->name('techsupport');
Route::get('/billing', function () {
    return view('footer.contact_us.billing');
})->name('billing');
Route::get('/customer-service', function () {
    return view('footer.contact_us.customerservice');
})->name('customerservice');
Route::get('/join-us-on-social-media', function () {
    return view('footer.contact_us.joinusonsocialmedia');
})->name('joinusonsocialmedia');

Route::get('/job-offers-hiring', function () {
    return view('footer.our_services.joboffershiring');
})->name('joboffershiring');
Route::get('/school-and-students', function () {
    return view('footer.our_services.school-and-students');
})->name('school-and-students');
Route::get('/staffing', function () {
    return view('footer.our_services.staffing');
})->name('staffing');
Route::get('/service-for-entrepreneurs', function () {
    return view('footer.our_services.serviceforentrepreneurs');
})->name('serviceforentrepreneurs');
Route::get('/ti-exams', function () {
    return view('footer.our_services.tiexams');
})->name('tiexams');
Route::get('/interviews', function () {
    return view('footer.our_services.interviews');
})->name('interviews');
Route::get('/fees-and-subscription', function () {
    return view('footer.our_services.fees-and-subscription');
})->name('fees-and-subscription');

Route::get('/general-questions', function () {
    return view('footer.faqs.general-questions');
})->name('general-questions');
Route::get('/basic-functionalities', function () {
    return view('footer.faqs.basic-functionalities');
})->name('basic-functionalities');
Route::get('/video-calls', function () {
    return view('footer.faqs.video-calls');
})->name('video-calls');
Route::get('/doing-online-exams', function () {
    return view('footer.faqs.doing-online-exams');
})->name('doing-online-exams');
Route::get('/creating-job-offers', function () {
    return view('footer.faqs.creating-job-offers');
})->name('creating-job-offers');
Route::get('/buying-exams-and-pdf', function () {
    return view('footer.faqs.buying-exams-and-pdf');
})->name('buying-exams-and-pdf');
Route::get('/automatic-video-interviews', function () {
    return view('footer.faqs.automatic-video-interviews');
})->name('automatic-video-interviews');
Route::get('/education-accounts-and-online-classrooms', function () {
    return view('footer.faqs.education-accounts-and-online-classrooms');
})->name('education-accounts-and-online-classrooms');
Route::get('/becoming-an-entrepreneur-on-platform', function () {
    return view('footer.faqs.becoming-an-entrepreneur-on-platform');
})->name('becoming-an-entrepreneur-on-platform');
Route::get('/confidentiality-safety-and-payment', function () {
    return view('footer.faqs.confidentiality-safety-and-payment');
})->name('confidentiality-safety-and-payment');


// Route::get('/questions-on-job/offers', function () {
//     return view('footer.faqs.questionsonjob');
// })->name('questionsonjob');
// Route::get('/questions-on-staffing', function () {
//     return view('footer.faqs.questionsonstaffing');
// })->name('questionsonstaffing');
// Route::get('/questions-exams', function () {
//     return view('footer.faqs.questionsexams');
// })->name('questionsexams');
// Route::get('/questions-on-interviews', function () {
//     return view('footer.faqs.questionsoninterviews');
// })->name('questionsoninterviews');
// Route::get('/questions-on-premium-account', function () {
//     return view('footer.faqs.questionsonpremiumaccount');
// })->name('questionsonpremiumaccount');


Route::get('/dummy-pg', function () {
    return view('dummy');
})->name('dummy');

Route::get('/find-a-job', function () {
    return view('find-a-job');
})->name('find-a-job');

Route::get('/post-a-job', function () {
    return view('post-a-job');
})->name('post-a-job');

Route::get('/search-an-online-test', function () {
    return view('search-an-online-test');
})->name('search-an-online-test');

Route::get('/virtual-classroom-conference', function () {
    return view('virtual-classroom-conference');
})->name('virtual-classroom-conference');

Route::get('/become-an-entrepreneur', function () {
    return view('become-an-entrepreneur');
})->name('become-an-entrepreneur');

Route::get('/find-a-person', function () {
    return view('find-a-person');
})->name('find-a-person');


Route::get('/search-interviews', function () {
    return view('search-interviews');
})->name('search-interviews');


Route::get('/professional-network', function () {
    return view('professional-network');
})->name('professional-network');

Route::get('/assessments-tests', function () {
    return view('assessments-tests');
})->name('assessments-tests');

Route::get('/revolutionary-interview-system', function () {
    return view('revolutionary-interview-system');
})->name('revolutionary-interview-system');

Route::get('/job-offers', function () {
    return view('job-offers');
})->name('job-offers');

Route::get('/platform-for-entrepreneurs', function () {
    return view('platform-for-entrepreneurs');
})->name('platform-for-entrepreneurs');

Route::get('/video-conference-system', function () {
    return view('video-conference-system');
})->name('video-conference-system');





//Video Calling Peer To Peer Routes....................................................................................
Route::post('/PeerToPeerVideoCall', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCall'])->name('PeerToPeerVideoCall.post');
Route::get('/PeerToPeerVideoCallDesktopView', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCallDesktopView'])->name('PeerToPeerVideoCallDesktopView');
Route::get('/PeerToPeerVideoCallReceiverDesktopView', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCallReceiverDesktopView'])->name('PeerToPeerVideoCallReceiverDesktopView');
Route::get('/videocalldashboardmobilePeerToPeer', [PeerToPeerVideoChat::class, 'videocalldashboardmobilePeerToPeer'])->name('videocalldashboardmobilePeerToPeer');
Route::get('/videocalldashboardmobileReceiverPeerToPeer', [PeerToPeerVideoChat::class, 'videocalldashboardmobileReceiverPeerToPeer'])->name('videocalldashboardmobileReceiverPeerToPeer');
Route::post('submitVideoChatPeerToPeer', [PeerToPeerVideoChat::class, 'submitVideoChatPeerToPeer'])->name('submitVideoChatPeerToPeer.post');
Route::post('checkMessageForVideoCallPeerToPeer', [PeerToPeerVideoChat::class, 'checkMessageForVideoCallPeerToPeer'])->name('checkMessageForVideoCallPeerToPeer.post');
//.........................................................................................................................

//Video Calling Normal Meeting Routes.....................................................................................

//Video Calling Normal Meeting Routes.....................................................................................

Route::post('GetNormalVideoCallChannelInfo', [NormalMeetingVideoChat::class, 'GetNormalVideoCallChannelInfo'])->name('GetNormalVideoCallChannelInfo.post');
Route::get('/NormalMeetingVideoCallDesktopView', [NormalMeetingVideoChat::class, 'NormalMeetingVideoCallDesktopView'])->name('NormalMeetingVideoCallDesktopView');
Route::get('/NormalMeetingVideoCallReceiverDesktopView', [NormalMeetingVideoChat::class, 'NormalMeetingVideoCallReceiverDesktopView'])->name('NormalMeetingVideoCallReceiverDesktopView');
Route::get('/NormalMeetingVideoCallReceiverMobileView', [NormalMeetingVideoChat::class, 'NormalMeetingVideoCallReceiverMobileView'])->name('NormalMeetingVideoCallReceiverMobileView');
Route::post('deleteReadedChatMessagePeerToPeer', [PeerToPeerVideoChat::class, 'deleteReadedChatMessagePeerToPeer'])->name('deleteReadedChatMessagePeerToPeer.post');
Route::post('countUnreadMessaageCount', [ChatController::class, 'countUnreadMessaageCount'])->name('countUnreadMessaageCount.post');
Route::post('deleteReadedChatMessageGroupVideoCall', [NormalMeetingVideoChat::class, 'deleteReadedChatMessageGroupVideoCall'])->name('deleteReadedChatMessageGroupVideoCall.post');
Route::post('/VideChatInfoNormalMeeting', [NormalMeetingVideoChat::class, 'VideChatInfoNormalMeeting'])->name('VideChatInfoNormalMeeting');
Route::get('/NormalMeetingVideoCallMobileView', [NormalMeetingVideoChat::class, 'NormalMeetingVideoCallMobileView'])->name('NormalMeetingVideoCallMobileView');
Route::post('submitVideoChatNormalMeeting', [NormalMeetingVideoChat::class, 'submitVideoChatNormalMeeting'])->name('submitVideoChatNormalMeeting.post');
Route::post('submitVideoChatNormalMeetingIndividual', [NormalMeetingVideoChat::class, 'submitVideoChatNormalMeetingIndividual'])->name('submitVideoChatNormalMeetingIndividual.post');
Route::post('checkMessageForVideoCallNormalMeeting', [NormalMeetingVideoChat::class, 'checkMessageForVideoCallNormalMeeting'])->name('checkMessageForVideoCallNormalMeeting.post');
Route::post("/joinVideoCallByUrlNormalMeeting", [NormalMeetingVideoChat::class, 'joinVideoCallByUrlNormalMeeting'])->name('joinVideoCallByUrlNormalMeeting');
Route::get('/JoinNormalMeetingUrl', function () {
    return view('JoinNormalMeetingUrl');
})->name('JoinNormalMeetingUrl');
Route::get('PeerToPeerMobileVideoCallLoby', [PeerToPeerVideoChat::class, 'PeerToPeerMobileVideoCallLoby'])->name('PeerToPeerMobileVideoCallLoby');
Route::post('/generateNormalMeeting', [NormalMeetingVideoChat::class, 'generateNormalMeeting'])->name('generateNormalMeeting');
Route::post('/getCallerInformationForNewJoiningUser', [NormalMeetingVideoChat::class, 'getCallerInformationForNewJoiningUser'])->name('getCallerInformationForNewJoiningUser.post');
Route::get('PeerToPeerVideoCallLoby', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCallLoby'])->name('PeerToPeerVideoCallLoby');
Route::get('PeerToPeerVideoCallMobileParticipantLoby', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCallMobileParticipantLoby'])->name('PeerToPeerVideoCallMobileParticipantLoby');
Route::get('PeerToPeerVideoCallParticipantLoby', [PeerToPeerVideoChat::class, 'PeerToPeerVideoCallParticipantLoby'])->name('PeerToPeerVideoCallParticipantLoby');
Route::get('NormalMeetingMobileParticipantLoby', [NormalMeetingVideoChat::class, 'NormalMeetingMobileParticipantLoby'])->name('NormalMeetingMobileParticipantLoby');
Route::get('NormalMeetingCallParticipantLoby', [NormalMeetingVideoChat::class, 'NormalMeetingCallParticipantLoby'])->name('NormalMeetingCallParticipantLoby');
Route::get('NormalMeetingVideoCallMobileLoby', [NormalMeetingVideoChat::class, 'NormalMeetingVideoCallMobileLoby'])->name('NormalMeetingVideoCallMobileLoby');
Route::get('NormalMeetingVideoLoby', [NormalMeetingVideoChat::class, 'NormalMeetingVideoLoby'])->name('NormalMeetingVideoLoby');
Route::get('/ChatGroupLeft', [ChatController::class, 'ChatGroupLeft'])->name('ChatGroupLeft');
Route::post('/GroupVidoeCallFromChatRoom', [NormalMeetingVideoChat::class, 'GroupVidoeCallFromChatRoom'])->name('GroupVidoeCallFromChatRoom.post');
Route::post("uploadlobbyIntroductionVideo", [LobbyPageController::class, 'uploadlobbyIntroductionVideo'])->name('uploadlobbyIntroductionVideo.post');
Route::post('/submitApplyForJob', [PostJobs::class, 'submitApplyForJob'])->name('submitApplyForJob');
Route::post("uploadlobbyIntroductionVideoRecorded", [LobbyPageController::class, 'uploadlobbyIntroductionVideoRecorded'])->name('uploadlobbyIntroductionVideoRecorded.post');
Route::post('CheckLobyWaitingClients', [PeerToPeerVideoChat::class, 'CheckLobyWaitingClients'])->name('CheckLobyWaitingClients.post');
Route::post("NotAllowingToJoinVideoCallingRoom", [NormalMeetingVideoChat::class, 'NotAllowingToJoinVideoCallingRoom'])->name('NotAllowingToJoinVideoCallingRoom.post');
Route::post('DeleteLobyWaitingClientEntry', [PeerToPeerVideoChat::class, 'DeleteLobyWaitingClientEntry'])->name('DeleteLobyWaitingClientEntry');
Route::post("AcceptParticipantRequestForJoiningVideoCallRoom", [NormalMeetingVideoChat::class, 'AcceptParticipantRequestForJoiningVideoCallRoom'])->name('AcceptParticipantRequestForJoiningVideoCallRoom.post');
Route::get('videocalldashboardmobileReceiverNormalMeeting', [NormalMeetingVideoChat::class, 'videocalldashboardmobileReceiverNormalMeeting'])->name('videocalldashboardmobileReceiverNormalMeeting');
