<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Home Hero Section -->
    <!-- <section class="home-hero-section bg-cover-center" style="background-image:url('images/home-banner.jpg')"> -->
    <section class="home-hero-section bg-cover-center" style="background-color:#f6f3f2">
        <div class="container py-5">
            <div class="row align-items-center gy-5">
                <div class="col-lg-6">
                    <!-- <h5 class="heading-with-left-border left-border-secondary mb-4 fw-bold mx-lg-0 mx-auto w-fit-content ">Join and</h5> -->
                    <h2 class="home-hero-section-title fw-bold mb-5 text-lg-start text-center">
                        <?php echo e(getJsonLocalization('index', 'join and connect')); ?>

                    </h2>
                    <div class="form-box box-shadow mx-lg-0 mx-auto">
                        <div class="text-center"><img src="logos//logo1.png" class="logo-image mb-4" alt="img">
                        </div>
                        <!-- <div class="text-large mb-4">
              <p>join and connect to a diversity centered professional network.</p>
            </div> -->
                        <h2><?php echo e(getJsonLocalization('index', 'signin')); ?></h2>
                        <p class="mb-4"><?php echo e(getJsonLocalization('index', 'new user')); ?> <a
                                class="no-decoration text-secondary text-mini"
                                href="<?php echo e(route('signup')); ?>"><?php echo e(getJsonLocalization('index', 'create account')); ?></a>
                        </p>
                        <div class="loginPanel">
                            <!-- Custom Addition -->
                            <?php if(session()->has('success')): ?>
                                <div class="alert alert-success" role="alert">
                                    <?php echo e(session()->get('success')); ?>

                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>
                            <?php if(session()->has('failed')): ?>
                                <div class="alert alert-danger" role="alert">
                                    <?php echo e(session()->get('failed')); ?>

                                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                            <?php endif; ?>
                            <!-- Custom Addition -->

                            <form action="<?php echo e(route('action_login')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <input type="text" class="form-control mb-2"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'email or phone')); ?>" id="login_email"
                                    name="login_email">
                                <input type="password" class="form-control mb-2"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'password')); ?>" id="login_pass"
                                    name="login_pass">
                                <button type="submit"
                                    class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('index', 'signin')); ?></button>
                            </form>
                            <div class="d-flex flex-wrap justify-content-between mt-2">
                                <div class="px-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value=""
                                            id="flexCheckDefault">
                                        <label class="form-check-label" for="flexCheckDefault">
                                            <?php echo e(getJsonLocalization('index', 'remember me')); ?>

                                        </label>
                                    </div>
                                </div>
                                <div class="px-2">
                                    <a href="#"
                                        class="text-secondary text-mini"><i><?php echo e(getJsonLocalization('index', 'forgot credentials')); ?></i></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-center"><img src="logos//test.gif" class="girl-image" alt="img"></div>
                </div>
            </div>
        </div>
    </section>

    <!-- Mission Section -->
    <!-- <section class="section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3"><?php echo e(getJsonLocalization('index', 'our mission')); ?></h2>
                <div class="description">
                    <p><?php echo e(getJsonLocalization('index', 'our mission paragraph signup')); ?></p>
                </div>
            </div>
            <div class="lcd-screen mx-auto">
                <img src="images/lcd-screen.png" alt="screen" />
                <video src="<?php echo e(URL::to('/')); ?>/videos//singn-in-video.mp4" controls></video>
            </div>
        </div>
    </section> -->

    <!-- Services section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'what we can do')); ?></h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p><?php echo e(getJsonLocalization('index', 'what we can do short desc')); ?></p>
                </div>
            </div>
            <div class="services-boxes-container mx-auto">
                <a href="/public/find-a-job" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/2.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'find a job')); ?></h6>
                </a>
                <a href="/public/post-a-job" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/9.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'post a job')); ?></h6>
                </a>
                <a href="/public/search-an-online-test" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/4.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'search online test')); ?></h6>
                </a>
                <a href="/public/virtual-classroom-conference" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/5.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'create classroom conference')); ?></h6>
                </a>
                <a href="/public/become-an-entrepreneur" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/8.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'become entrepreneur')); ?></h6>
                </a>
                <a href="/public/find-a-person" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/1.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'search people')); ?></h6>
                </a>
                <a href="/public/search-interviews" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/7.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title"><?php echo e(getJsonLocalization('index', 'search interviews')); ?></h6>
                </a>
            </div>
        </div>
    </section>

    <!-- Who are we section -->
    <section class="who-are-we-section px-md-3 py-md-5 d-flex justify-content-center">
        <div class=" wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
            <video src="<?php echo e(URL::to('/')); ?>/videos/who-we-are-video.mp4" controls autoplay loop muted></video>
        </div>
    </section>

    <!-- Words abous workfrater -->
    <section class="section-padding bg-white">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="stylish-heading text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'workfrater in words')); ?></h2>
            </div>
            <div class="row gx-lg-5 gy-5">
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-network-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'professional network')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'professional network - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/professional-network" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-test-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'number of assessments')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'number of assessments - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/assessments-tests" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-interview-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'revolutionnary interview system')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'revolutionnary interview system - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/revolutionary-interview-system" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-job-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'number of job offers')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'number of job offers - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/job-offers" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-entrepreneurs-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'platform for entrepreneurs')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'platform for entrepreneurs - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/platform-for-entrepreneurs" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/yellow-video-conference-icon.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'innovative video conference system')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'innovative video conference system - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/video-conference-system" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Search Section To search job rapidly -->
    <section class="section-padding bg-lightgrey position-relative text-white">
        <div class="bg-video-layer">
            <video src="<?php echo e(URL::to('/')); ?>/videos/coding-video.mp4" autoplay loop muted></video>
        </div>
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'Search for a job')); ?></h2>
            </div>
            <div class="container-large px-0">
                <form id="searchjobs" class="mb-lg-5 mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" action="<?php echo e(route('viewjobs')); ?>" method="get">
                    <div class="row gx-2 gx-md-4 gy-3 justify-content-center">
                        <div class="col-sm-6 col-md-3">
                            <!-- <input type="text" class="form-control" id="job_post" name="job_post" placeholder="<?php echo e(getJsonLocalization('index', 'Job post')); ?>"> -->
                            <input list="job-title" class="form-select" placeholder="<?php echo e(getJsonLocalization('index', 'Job title')); ?>" />
                            <datalist id="job-title">
                                <option value="Frontend">
                                <option value="Backend">
                                <option value="React JS">
                                <option value="Dot Net">
                                <option value="ROR">
                            </datalist>
                        </div>
                        <div class="col-sm-6 col-md-3">
                            <!-- <input type="text" class="form-control" id="job_city" name="job_city" placeholder="<?php echo e(getJsonLocalization('index', 'City')); ?>"> -->
                            <input list="location" class="form-select" placeholder="<?php echo e(getJsonLocalization('index', 'location')); ?>" />
                            <datalist id="location">
                                <option value="Pakistan">
                                <option value="America">
                                <option value="London">
                                <option value="Dubai">
                                <option value="Canada">
                            </datalist>
                        </div>
                        <!-- <div class="col-md-3">
                            <select class="form-select form-select" id="job_country" name="job_country" aria-label=".form-select example">
                                <option selected value=""><?php echo e(getJsonLocalization('index', 'Country')); ?>

                                </option>
                                <option value="USA"><?php echo e(getJsonLocalization('index', 'USA')); ?></option>
                                <option value="Canada"><?php echo e(getJsonLocalization('index', 'Canada')); ?></option>
                            </select>
                        </div> -->
                        <div class="col-md-3"><button type="submit" class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('index', 'search')); ?></button></div>
                    </div>
                </form>
                <div id="counter-section-container">
                    <div id="sa-counter-box-container">
                        <div id="counter-box">
                            <div class="d-flex justify-content-center">
                                <h3 class="counter text-parrot" data-number="50"></h3>
                                <h3 class="text-parrot">+</h3>
                            </div>
                            <h6 class="text-center mb-0"><?php echo e(getJsonLocalization('index', 'education institution')); ?></h6>
                        </div>
                        <div id="counter-box">
                            <div class="d-flex justify-content-center">
                                <h3 class="counter text-parrot" data-number="3000"></h3>
                                <h3 class="text-parrot">+</h3>
                            </div>
                            <h6 class="text-center mb-0"><?php echo e(getJsonLocalization('index', 'users')); ?></h6>
                        </div>
                        <div id="counter-box">
                            <div class="d-flex justify-content-center">
                                <h3 class="counter text-parrot" data-number="100"></h3>
                                <h3 class="text-parrot">+</h3>
                            </div>
                            <h6 class="text-center mb-0"><?php echo e(getJsonLocalization('index', 'employers')); ?></h6>
                        </div>
                        <div id="counter-box">
                            <div class="d-flex justify-content-center">
                                <h3 class="counter text-parrot" data-number="300"></h3>
                                <h3 class="text-parrot">+</h3>
                            </div>
                            <h6 class="text-center mb-0"><?php echo e(getJsonLocalization('index', 'job offers')); ?></h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- <section class="section-padding" style="background: #F6F3F2">
        <div class="container">
            <div class="row">
                <div class="content col-12 p-0 px-sm-0 px-3">
                    <h2 class="text-center"><?php echo e(getJsonLocalization('index', 'Search job rapidly')); ?></h2>
                    <form id="searchjobs" action="<?php echo e(route('viewjobs')); ?>" method="get">
                        <div class="row d-flex justify-content-center my-3">
                            <div class="col-md-4 mt-md-0 mt-2">
                                <input type="text" class="form-control" id="job_post" name="job_post"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'Job post')); ?>">
                            </div>
                            <div class="col-md-4 mt-md-0 mt-2">
                                <input type="text" class="form-control" id="job_city" name="job_city"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'City')); ?>">
                            </div>
                            <div class="col-md-4 mt-md-0 mt-2">
                                <select class="form-select form-select" id="job_country" name="job_country"
                                    aria-label=".form-select example">

                                    <option selected value=""><?php echo e(getJsonLocalization('index', 'Country')); ?>

                                    </option>
                                    <option value="USA"><?php echo e(getJsonLocalization('index', 'USA')); ?></option>
                                    <option value="Canada"><?php echo e(getJsonLocalization('index', 'Canada')); ?></option>

                                </select>
                            </div>

                        </div>
                        <div class="row d-flex justify-content-center">
                            <div class="submit-btn col-3 mx-md-auto me-auto">

                                <button type="submit"
                                    class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('index', 'Search')); ?></button>

                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section> -->

    <!-- Alternative rows section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center stylish-heading mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'Why should you post your job')); ?></h2>
                <div class="description wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                    <h4><?php echo e(getJsonLocalization('index', 'Why should you post your job - short desc')); ?></h4>
                </div>
            </div>
            <div class="alternative-rows-container">
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'automatised interview')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'automatised interview - paragraph')); ?></p>
                            </div>
                            <a href="/public/automatic-video-interviews" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image1.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'diverse range of tests')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'diverse range of tests - paragraph')); ?></p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image2.png" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'secured tests')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'secured tests - paragraph')); ?></p>
                            </div>
                            <a href="/public/doing-online-exams" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image3.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                        <h4><?php echo e(getJsonLocalization('index', 'advanced filters')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'advanced filters - paragraph')); ?></p>
                            </div>
                            <a href="/public/creating-job-offers" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>    
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image4.png" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                    <div class="content-box">
                        <h4><?php echo e(getJsonLocalization('index', 'video conference and classrooms')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'video conference and classrooms - paragraph')); ?></p>
                            </div>
                            <a href="/public/education-accounts-and-online-classrooms" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                        
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image5.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                    <div class="content-box">
                        <h4><?php echo e(getJsonLocalization('index', 'personalized video interviews')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'personalized video interviews - paragraph')); ?></p>
                            </div>
                            <a href="/public/revolutionary-interview-system/#interview-in-three-ways" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                        
                    <div class="col-md-6 inner2">
                        <img src="images/why-post-job-image6.png" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Search for exam section -->
    <section class="section-padding bg-lightgrey position-relative text-white">
        <div class="bg-video-layer">
            <video src="<?php echo e(URL::to('/')); ?>/videos//coding-video.mp4" autoplay loop muted></video>
        </div>
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'Search for an exam rapidly')); ?></h2>
            </div>
            <div class="container-large px-0">
                <form id="searchjobs" class="mb-4 mb-md-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" action="<?php echo e(route('viewjobs')); ?>" method="get">
                    <div class="row gx-2 gx-md-4 gy-3 justify-content-center">
                        <div class="col-sm-6 col-md-3 position-relative">
                            <input type="text" class="form-select exam_search" id="exam_search" name="exam_search" placeholder="<?php echo e(getJsonLocalization('index', 'exam')); ?>" onkeyup="suggestSearch(this.value)" />
                            <div id="result" class="list-group suggested-search position-absolute w-100"></div>
                        </div>
                        <div class="col-sm-6 col-md-3"><button type="submit" class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('index', 'search')); ?></button></div>
                    </div>
                </form>
            </div>
            <div class="slider-box">
                <div class="wf-logo-slider">
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/angular.png" class="single-logo" alt="img" />
                            <h6>Angular</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/aws.png" class="single-logo" alt="img" />
                            <h6>AWS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/azure.png" class="single-logo" alt="img" />
                            <h6>Azure</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/html.png" class="single-logo" alt="img" />
                            <h6>HTML</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/css.png" class="single-logo" alt="img" />
                            <h6>CSS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/bootstrap.png" class="single-logo" alt="img" />
                            <h6>Bootstrap</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/java.png" class="single-logo" alt="img" />
                            <h6>Java</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/javascript.png" class="single-logo" alt="img" />
                            <h6>Javascript</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/jquery.png" class="single-logo" alt="img" />
                            <h6>JQuery</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/laravel.png" class="single-logo" alt="img" />
                            <h6>Laravel</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/mysql.png" class="single-logo" alt="img" />
                            <h6>MySql</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/next-js.png" class="single-logo" alt="img" />
                            <h6>Next JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/node-js.png" class="single-logo" alt="img" />
                            <h6>Node JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/php.png" class="single-logo" alt="img" />
                            <h6>PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/python.png" class="single-logo" alt="img" />
                            <h6>Python</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/react.png" class="single-logo" alt="img" />
                            <h6>React</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ruby.png" class="single-logo" alt="img" />
                            <h6>Ruby</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/3ds-max.png" class="single-logo" alt="img" />
                            <h6>3DS Max</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-ai.png" class="single-logo" alt="img" />
                            <h6>Adobe AI</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-fr.png" class="single-logo" alt="img" />
                            <h6>Adobe FR</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/adobe-lightroom.png" class="single-logo" alt="img" />
                            <h6>Adobe LI</h6>
                        </div>
                    </div><div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/alibaba.png" class="single-logo" alt="img" />
                            <h6>Alibaba</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/autocad-2d.png" class="single-logo" alt="img" />
                            <h6>Autocad 2D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/autocad-3d.png" class="single-logo" alt="img" />
                            <h6>Autocad 3D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/c.png" class="single-logo" alt="img" />
                            <h6>C</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/caffe.png" class="single-logo" alt="img" />
                            <h6>Caffe</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cake-php.png" class="single-logo" alt="img" />
                            <h6>Cake PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cinema-4d.png" class="single-logo" alt="img" />
                            <h6>Cinema 4D</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cntk.png" class="single-logo" alt="img" />
                            <h6>CNTK</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/codeignetor.png" class="single-logo" alt="img" />
                            <h6>Codeignetor</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/cryengine.png" class="single-logo" alt="img" />
                            <h6>Cryengine</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ember.png" class="single-logo" alt="img" />
                            <h6>Ember</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/Excel.png" class="single-logo" alt="img" />
                            <h6>Excel</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/Express-js.png" class="single-logo" alt="img" />
                            <h6>Express JS</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/fasion-360.png" class="single-logo" alt="img" />
                            <h6>Fasion 360</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/figma.png" class="single-logo" alt="img" />
                            <h6>Figma</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/fuel-php.png" class="single-logo" alt="img" />
                            <h6>Fuel PHP</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/google-cloud.png" class="single-logo" alt="img" />
                            <h6>Google Cloud</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/ibm-cloud.png" class="single-logo" alt="img" />
                            <h6>IBM Cloud</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/jason.png" class="single-logo" alt="img" />
                            <h6>Jason</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/kearas.png" class="single-logo" alt="img" />
                            <h6>Kearas</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/mathematica.png" class="single-logo" alt="img" />
                            <h6>Mathematica</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/matlab.png" class="single-logo" alt="img" />
                            <h6>Matlab</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/nosql.png" class="single-logo" alt="img" />
                            <h6>NoSql</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/oracle.png" class="single-logo" alt="img" />
                            <h6>Oracle</h6>
                        </div>
                    </div>
                    <div class="slider-slide">
                        <div class="logo-box">
                            <img src="images/icons/tech-icons/phalcon.png" class="single-logo" alt="img" />
                            <h6>Phalcon</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Exams Icons section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'our most popular tests')); ?></h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p><?php echo e(getJsonLocalization('index', 'our most popular tests - desc')); ?></p>
                </div>
            </div>
            <div class="services-boxes-container mx-auto">
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/python.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Python</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/javascript.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Javascript</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/html.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">HTML</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/css.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">CSS</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/php.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">PHP</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/c-sharp.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">C Sharp</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/java.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">JAVA</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/c++.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">C++</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/swift.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Swift</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/ruby.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Ruby</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/dart.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Dart</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/go.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Go</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/kotlin.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Kotlin</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/maya.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Maya</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/unreal-engine4.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Unreal Engine</h6>
                </a>
                <a href="javascript:void(0)" class="single-service-box wow fadeIn" data-wow-delay="0s" data-wow-duration="1.5s">
                    <img src="images/icons/tech-icons/blender.png" class="service-icon" alt="img" />
                    <h6 class="service-box-title">Blender</h6>
                </a>
            </div>
        </div>
    </section>

    <!-- Enterpenure video will be sent by phill -->
    <section>
        <div class=" wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
            <video src="<?php echo e(URL::to('/')); ?>/videos/technologies-videos.mp4" class="w-100" autoplay loop muted></video>
        </div>
    </section>

    <!-- Use platform section -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="stylish-heading text-center wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'platform to become the entrepreneur')); ?></h2>
                <div class="description wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s">
                    <p><?php echo e(getJsonLocalization('index', 'platform to become the entrepreneur - desc')); ?></p>
                </div>
            </div>
            <div class="row gx-md-5 gy-5">
                <div class="col-md-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/become-enterprenure-icon1.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'crowdfunding')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'crowdfunding - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/platform-for-entrepreneurs#get-croudfunded" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'learn more')); ?></a>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/become-enterprenure-icon2.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'pitch your project')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'pitch your project - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/platform-for-entrepreneurs#pitch-project" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'learn more')); ?></a>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="about-us-card text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <img src="images/icons/become-enterprenure-icon3.png" class="card-icon" alt="img" />
                        <div class="about-us-card-body">
                            <h5 class="card-title"><?php echo e(getJsonLocalization('index', 'networking')); ?></h5>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'networking - paragraph')); ?></p>
                            </div>
                        </div>
                        <a href="/public/platform-for-entrepreneurs#link-up" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'learn more')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Register education section -->
    <section class="section-padding bg-lightgrey position-relative text-white">
        <div class="bg-video-layer">
            <video src="<?php echo e(URL::to('/')); ?>/videos//coding-video.mp4" autoplay loop muted></video>
        </div>
        <div class="container py-5 d-flex align-items-center justify-content-center">
            <div class="py-5 text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <a href="#" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('index', 'register your education institution')); ?></a>
            </div>
        </div>
    </section>

    <!-- Alternative rows section 2 -->
    <section class="section-padding bg-white overflow-hidden">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s"><?php echo e(getJsonLocalization('index', 'join your school to our plateform')); ?></h2>
                <div class="description wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                    <p><?php echo e(getJsonLocalization('index', 'join your school to our plateform - desc')); ?></p>
                </div>
            </div>
            <div class="alternative-rows-container">
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'plateform offer to your school and your students')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'plateform offer to your school and your students - paragraph')); ?></p>
                            </div>
                            <a href="/public/school-and-students" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/join-school-image1.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'advanced recording capabilities')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'advanced recording capabilities - paragraph')); ?></p>
                            </div>
                            <a href="/public/education-accounts-and-online-classrooms" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/join-school-image2.png" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                            <h4><?php echo e(getJsonLocalization('index', 'helping students to find internship')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'helping students to find internship - paragraph')); ?></p>
                            </div>
                            <a href="/public/education-accounts-and-online-classrooms" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 inner2">
                        <img src="images/join-school-image3.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                        <div class="content-box">
                        <h4><?php echo e(getJsonLocalization('index', 'ai interview students')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'ai interview students - paragraph')); ?></p>
                            </div>
                            <a href="/public/school-and-students" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>    
                    <div class="col-md-6 inner2">
                        <img src="images/join-school-image4.png" class="wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
                <div class="row gy-4 gx-lg-5 single-row">
                    <div class="col-md-6 inner1">
                    <div class="content-box">
                        <h4><?php echo e(getJsonLocalization('index', 'automatic exam')); ?></h4>
                            <div class="description">
                                <p><?php echo e(getJsonLocalization('index', 'automatic exam - paragraph')); ?></p>
                            </div>
                            <a href="/public/school-and-students" class="wf-btn wf-btn-primary"><?php echo e(getJsonLocalization('index', 'read more')); ?></a>
                        </div>
                    </div>
                        
                    <div class="col-md-6 inner2">
                        <img src="images/join-school-image5.png" class="wow fadeInRight" data-wow-delay="0s" data-wow-duration="1s" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Remove (phill said) Section for search a job by theme -->
    <!-- <section class="section-padding">
        <div class="container themes px-md-0 px-3">
            <h2 class="text-center mb-3"><?php echo e(getJsonLocalization('index', 'Search a job by themes')); ?></h2>
            <div class="row d-flex justify-content-start p-0 mb-2">
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Health"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Health')); ?></a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Finances"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Finances')); ?></a>

                </div>
                <div class="col-md-4 col-10 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="T.I programming"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'TI programming')); ?></a>

                </div>
                <div class="col-md-6 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="T.I tech support"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'TI tech support')); ?></a>

                </div>
                <div class="col-md-6 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="T.I data analyst"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'TI data analyst')); ?></a>

                </div>
                <div class="col-md-4 col-8 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="T.I video games and 3D"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'TI video games and 3D')); ?></a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="T.I cybersecurity"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'TI cybersecurity')); ?></a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Engineering"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Engineering')); ?></a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Calling center"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Calling center')); ?> </a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Office"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Office')); ?></a>

                </div>
                <div class="col-md-6 col-8 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Infography and design"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Infography and design')); ?></a>

                </div>
                <div class="col-md-6 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="General cleaning"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'General cleaning')); ?></a>

                </div>
                <div class="col-md-4 col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="General sales"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'General sales')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="General warehouses"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'General warehouses')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-8 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Factory and industory"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Factory and industory')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Marketing and sales"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Marketing and sales')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Web marketing"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Web marketing')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Recruitment"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Recruitment')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="stores"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'stores')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Construction"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Construction')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Security guard"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Security guard')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Human resource"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Human resource')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Management"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Management')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Sciences"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Sciences')); ?></a>

                </div>
                <div id="toggleTheme" class="col-md-4 collapse col-6 p-1">
                    <a href="#"
                        class="btn rounded-pill btn-transparent text-dark border-secondary border-1 theme-btn w-100"

                        data-theme="Others"
                        onClick="searchByTheme(event)"><?php echo e(getJsonLocalization('index', 'Others')); ?></a>

                </div>
            </div>
            <div class="row">
                <div class="ps-1">
                    <a href="javascript(0);" onClick="toggleText(this)" id="loadMoreTheme"
                        class="wf-btn wf-btn-secondary fst-italic" data-bs-toggle="collapse"
                        data-bs-target="#toggleTheme">Show More...</a>
                </div>
            </div>
        </div>
    </section> -->

    <!-- Search Section To search person rapidly -->
    <!-- <section class="section-padding" style="background: #F6F3F2">
        <div class="container">
            <div class="row">
                <div class="content col-12 p-0 px-sm-0 px-3">
                    <h2 class="text-center"><?php echo e(getJsonLocalization('index', 'Search for a person rapidly')); ?></h2>
                    <form action="#" method="get">
                        <div class="row d-flex justify-content-center my-3">
                            <div class="col-md-4 mt-md-0 mt-2">
                                <input type="text" class="form-control" id="person_name" name="person_name"
                                    placeholder="Person">
                            </div>
                            <div class="col-md-4 mt-md-0 mt-2">
                                <input type="text" class="form-control" id="person_city" name="person_city"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'City')); ?>">
                            </div>
                            <div class="col-md-4 mt-md-0 mt-2">
                                <select class="form-select form-select" id="person_country" name="person_country"
                                    aria-label=".form-select example">

                                    <option selected><?php echo e(getJsonLocalization('index', 'Country')); ?></option>
                                    <option value="USA"><?php echo e(getJsonLocalization('index', 'USA')); ?></option>
                                    <option value="Canada"><?php echo e(getJsonLocalization('index', 'Canada')); ?></option>

                                </select>
                            </div>

                        </div>
                        <div class="row d-flex justify-content-center">
                            <div class="submit-btn col-3 mx-md-auto me-auto">
                                <button type="submit"
                                    class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('index', 'Search')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section> -->
    

    <!-- Remove (phill said) Search Section To search exam rapidly -->
    <!-- <section class="section-padding">
        <div class="container">
            <div class="row">
                <div class="content col-12 p-0 px-sm-0 px-3">
                    <h2 class="text-center"><?php echo e(getJsonLocalization('index', 'Search for an exam rapidly')); ?></h2>
                    <form id="searchExam" action="<?php echo e(route('exams')); ?>" method="get">
                        <div class="row d-flex justify-content-center my-3 gap-2 align-items-center">
                            <div class="col-md-6 col-sm-8 col-7 mt-md-0 position-relative ps-0 pe-0">
                                <input type="text" class="form-control exam_search" id="exam_search"
                                    name="exam_search" placeholder="Exam" onkeyup="suggestSearch(this.value)">
                                <div id="result" class="list-group suggested-search position-absolute w-100"></div>
                            </div>
                            <div class="col-3 d-flex justify-content-start ps-0">
                                <div class="submit-btn me-md-auto me-auto p-0 w-100">
                                    <button type="submit"
                                        class="wf-btn wf-btn-secondary w-100 my-auto"><?php echo e(getJsonLocalization('index', 'Search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section> -->
    
    <!-- Remove (phill said) Search Section To search for entrepreneur rapidly -->
    <!-- <section class="section-padding" style="background: #F6F3F2">
        <div class="container">
            <div class="row">
                <div class="content col-12 p-0 px-sm-0 px-3">
                    <h2 class="text-center"><?php echo e(getJsonLocalization('index', 'Search for an entrepreneur')); ?></h2>
                    <form action="#" method="get">
                        <div class="row d-flex justify-content-center my-3 align-items-center">
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <input type="text" class="form-control" id="entrepreneur_name"
                                    name="entrepreneur_name"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'Entrepreneur name')); ?>">
                            </div>
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <input type="text" class="form-control" id="entrepreneur_city"
                                    name="entrepreneur_city"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'Entrepreneur city')); ?>">
                            </div>
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <select class="form-select form-select" id="entrepreneur_country"
                                    name="entrepreneur_country" aria-label=".form-select example">

                                    <option selected><?php echo e(getJsonLocalization('index', 'Country')); ?></option>
                                    <option value="USA"><?php echo e(getJsonLocalization('index', 'USA')); ?></option>
                                    <option value="Canada"><?php echo e(getJsonLocalization('index', 'Canada')); ?></option>

                                </select>
                            </div>
                            <div class="col-6 d-flex justify-content-center align-items-center p-1 mt-2">
                                <div class="submit-btn me-md-auto me-auto p-0 w-100">
                                    <button type="submit"
                                        class="wf-btn wf-btn-secondary w-100 my-auto"><?php echo e(getJsonLocalization('index', 'Search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>  -->

    <!-- Search Section To search for video interview -->
    <!-- <section class="section-padding">
        <div class="container">
            <div class="row">
                <div class="content col-12 p-0 px-sm-0 px-3">
                    <h2 class="text-center"><?php echo e(getJsonLocalization('index', 'Search for a video interview')); ?></h2>
                    <form action="#" method="get">
                        <div class="row d-flex my-3 align-items-center">
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <input type="text" class="form-control" id="video_name" name="video_name"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'Name')); ?>">
                            </div>
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <input type="text" class="form-control" id="video_field" name="video_field"
                                    placeholder="<?php echo e(getJsonLocalization('index', 'Field')); ?>">
                            </div>
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <input type="text" class="form-control" id="video_city" name="video_city"
                                    placeholder="City">
                            </div>
                            <div class="col-6 mt-md-0 p-1 mt-2">
                                <select class="form-select form-select" id="video_country" name="video_country"
                                    aria-label=".form-select example">

                                    <option selected><?php echo e(getJsonLocalization('index', 'Country')); ?></option>
                                    <option value="USA"><?php echo e(getJsonLocalization('index', 'USA')); ?></option>
                                    <option value="Canada"><?php echo e(getJsonLocalization('index', 'Canada')); ?></option>

                                </select>
                            </div>
                            <div class="col-6 d-flex justify-content-center align-items-center p-1 mt-2">
                                <div class="submit-btn me-md-auto me-auto p-0 w-100">
                                    <button type="submit"
                                        class="wf-btn wf-btn-secondary w-100 my-auto"><?php echo e(getJsonLocalization('index', 'Search')); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section> -->

    <!-- Site Footer -->
    <?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>

<script>
    /* Toggle the text of show more/less button of themes on login page  */
    function toggleText(e) {
        let txt = e.innerText;
        e.innerText = txt == 'Show More...' ? 'Show Less...' : 'Show More...';
    }
    /* ----------------------------------------------------------- */



    /* ------------------ Suggest search ------------------------ */
    var people = [
        'Java level1',
        'C++ level1',
        'Python level1',
        'C# level1',
        'Javascript level1',
        'Go level1',
        'Sql level1',
        'kotlin level1',
        'Ruby level1',
        'Swift level1',
        'C level1',
        'Typescript level1',
        'Html /css level1',
        'Excel level1',
        'Word level1',
        'Powerpoint level1',
        'Skype level1',
        'Photoshop level1',
        'Illustrator level1',
        'Lightroom level1',
        'Fresco level1',
        'Aero level1',
        'Figma level1',
        'Blender level1',
        'Unreal engine 4 level1',
        'Unity level1',
        'Cryengine level1',
        'Maya level1',
        '3ds max level1',
        'Amazon web services level1',
        'Azure level1',
        'Google cloud level1',
        'Alibaba cloud level1',
        'Oracle cloud level1',
        'IBM cloud level1',
        'Matlab level1',
        'Mathematica level1',
        'Autocad 2d level1',
        'Autocad 3d level1',
        'Fusion 360 level1',
        'Vue.js level1',
        'Angular.js level1',
        'Jquery level1',
        'Next level1',
        'Bootstrap level1',
        'React native level1',
        'Ember.js level1',
        'Node.js level1',
        'Express level1',
        'Laravel code igniter level1',
        'Symphony level1'
    ];

    function matchPeople(input) {
        var reg = new RegExp(input.split("").join("\\w*").replace(/\W/, ""), "i");
        var res = [];
        if (input.trim().length === 0) {
            return res;
        }
        for (var i = 0, len = people.length; i < len; i++) {
            if (people[i].match(reg)) {
                res.push(people[i]);
            }
        }
        return res;
    }

    function suggestSearch(val) {
        var autoCompleteResult = matchPeople(val);
        document.getElementById("result").innerHTML = "";
        for (var i = 0, limit = 10, len = autoCompleteResult.length; i < len && i < limit; i++) {
            document.getElementById("result").innerHTML +=
                "<a class='list-group-item list-group-item-action' href='javascript:void(0);' onclick='setSearch(\"" +
                autoCompleteResult[i] + "\")'>" + autoCompleteResult[i] + "</a>";
        }
    }


    function setSearch(value) {
        document.getElementById('exam_search').value = value;
        document.getElementById("result").innerHTML = "";
        return 0;
    }
    /* ---------------------------------------------------------------------- */

    function searchByTheme(e) {
        e.preventDefault();
        let job_field = e.target.dataset.theme;
        let url = '/public/viewjobs?job_field=' + job_field;
        window.location.href = url;
    }
</script>

<script>
    // counter home page
    var counterInitVal = 0;
    $(window).scroll(function () {
        var oTop = $("#counter-box").offset().top - window.innerHeight;
        if (counterInitVal == 0 && $(window).scrollTop() > oTop) {
            $(".counter").each(function () {
                var $this = $(this),
                    countTo = $this.attr("data-number");
                $({
                    countNum: $this.text()
                }).animate(
                    {
                        countNum: countTo
                    },

                    {
                        duration: 850,
                        easing: "swing",
                        step: function () {
                            //$this.text(Math.ceil(this.countNum));
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                        },
                        complete: function () {
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                            //alert('finished');
                        }
                    }
                );
            });
            counterInitVal = 1;
        }
    });
</script>

</html>
<?php /**PATH C:\xampp\htdocs\phil_web\resources\views/index.blade.php ENDPATH**/ ?>