<!DOCTYPE html>
<html lang="en">

<head>
  <!-- links and scripts -->
  <title>Workfrater</title>
  <meta charset="utf-8">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="css/utils.css">
  <link rel="stylesheet" href="css/ui-elements.css">
  <link rel="stylesheet" href="css/bootstrap-overrides.css">
  <link rel="stylesheet" href="css/home.css">
  <link rel="stylesheet" href="css/index.css">
  <link rel="stylesheet" href="css/responsive.css">

  <script src="js/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

  <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
  <script src="js/countrypicker.js"></script>

  <script type="text/javascript" src="js/custom.js"></script>
  <script type="text/javascript" src="js//url.js"></script>
  <script type="text/javascript">
    function PreviewImage() {
      var fileName = document.getElementById('customFile').value;

      if (fileName.includes(".png") || fileName.includes(".jpg") || fileName.includes(".jpeg")) {
        var oFReader = new FileReader();
        oFReader.readAsDataURL(document.getElementById("customFile").files[0]);

        oFReader.onload = function(oFREvent) {
          document.getElementById("profile_img").src = oFREvent.target.result;
        };
      } else {
        document.getElementById('customFile').value = null;
      }



    };
  </script>
</head>

<body>
  <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
    <div class="container">
      <div class="form-box mx-auto" style="max-width:767px;">
        <div class="text-center mb-4">
          <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
        </div>
        <h2><?php echo e(getJsonLocalization('signup', 'Business/Org information')); ?></h2>
        <form action="<?php echo e(route('action_businessOrg_info')); ?>" method="POST" enctype="multipart/form-data">
          <?php echo csrf_field(); ?>
          <div class="row gy-3 mb-3">
            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Entreprise Name')); ?>: <span class="text-danger">*</span></label>
              <input type="text" class="form-control" id="entreprise_name" name="entreprise_name" required>
            </div>
            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Structure')); ?>: <span class="text-danger">*</span></label>
              <select class="form-select" aria-label="Default select example" style="height:40px;width: 100%;" id="structure" name="structure" required>
                <option value="Enterprise" selected><?php echo e(getJsonLocalization('signup', 'Enterprise')); ?> </option>
                <option value="Organisation"><?php echo e(getJsonLocalization('signup', 'Organisation')); ?></option>
                <option value="NGO" selected><?php echo e(getJsonLocalization('signup', 'NGO')); ?></option>
                <option value="Political Party" selected><?php echo e(getJsonLocalization('signup', 'Political Party')); ?></option>
                <option value="Start Up<" selected><?php echo e(getJsonLocalization('signup', 'Start Up')); ?></option>
                <option value=" " selected></option>
              </select>
            </div>
            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'City')); ?>: <span class="text-danger">*</span> </label>
              <input type="text" class="form-control" id="city_name" name="city_name" required>
            </div>
            <script>
              function checkEmail() {
                var emailId = document.getElementById("org_email").value;
                if (!emailId.includes("@")) {
                  document.getElementById("validEmail").style.display = "block";
                } else {
                  document.getElementById("validEmail").style.display = "none";
                }
              }
            </script>
            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Civic address')); ?>: <span class="text-danger">*</span> </label>
              <input type="text" class="form-control" id="civic_address" name="civic_address" required>

            </div>
            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'add profile picture')); ?>: <span class="text-danger">*</span> </label>
              <input type="file" class="form-control" id="customFile" name="customFile" accept=".png,.jpg,.jpeg" onchange="PreviewImage();" required />
            </div>

            <div class="col-sm-4">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Country')); ?>: <span class="text-danger">*</span> </label>
              <select class="selectpicker form-control" id="country_name" name="country_name" required>
                <option value="USA"><?php echo e(getJsonLocalization('signup', 'USA')); ?></option>
                <option value="Canada"><?php echo e(getJsonLocalization('signup', 'Canada')); ?></option>
              </select>
              </select>
            </div>


            <div class="col-sm-6">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Organisation Email')); ?>: <span class="text-danger">*</span> </label>
              <input type="email" class="form-control" id="org_email" name="org_email" required onfocusout="checkEmail()" />
              <label class="text-danger text-mini" for="message" style="display:none;" id="validEmail" name="validEmail"><b><?php echo e(getJsonLocalization('signup', 'Not a valid email')); ?></b></label>
            </div>

            <div class="col-sm-6">
              <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Organisation Website')); ?>: </label>
              <input type="text" class="form-control" id="org_web_url" name="org_web_url" autocomplete="off">
            </div>

          </div>
          <div class="row">
            <div class="col-6">
              <a href="<?php echo e(route('psersonalInfomation')); ?>" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('signup', 'Go Back')); ?></a>
            </div>
            <div class="col-6 text-end">
              <button type="submit" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('signup', 'Submit')); ?></button>
            </div>
          </div>
      </div>
      </form>
    </div>
    </div>
  </section>

</body>

</html><?php /**PATH C:\xampp\htdocs\phil_web\resources\views/orgsignup/businessOrgInfo.blade.php ENDPATH**/ ?>