<!DOCTYPE html>
<html lang="en">

<head>
  <!-- links and scripts -->
  <title>Workfrater</title>
  <meta charset="utf-8">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="css/utils.css">
  <link rel="stylesheet" href="css/ui-elements.css">
  <link rel="stylesheet" href="css/bootstrap-overrides.css">
  <link rel="stylesheet" href="css/home.css">
  <link rel="stylesheet" href="css/index.css">
  <link rel="stylesheet" href="css/responsive.css">

  <script src="js/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

  <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
  <script src="js/countrypicker.js"></script>

  <script type="text/javascript" src="js/custom.js"></script>
  <script type="text/javascript" src="js//url.js"></script>



  <script>
    function verifyPassword() {
      var agrement = document.getElementById("agrement");
      // If the checkbox is checked, display the output text
      if (agrement.checked == true) {

      } else {
        document.getElementById("agrementMessage").style.visibility = 'visible';
        return false;
      }

      var accountType = document.getElementById("accountType").value;
      if (accountType == 4) {
        document.getElementById("accountTypeSelect").style.visibility = 'visible';

        return false;
      }
      var pw = document.getElementById("login_passwd").value;
      var pwconfirm = document.getElementById("confirm_pass").value;
      //check empty password field  
      if (pw == "") {
        document.getElementById("login_passwd").style.color = 'RED';
        document.getElementById("error_message_pass_toosmall").style.visibility = 'visible';
        return false;
      }

      //minimum password length validation  
      if (pw.length < 8) {
        document.getElementById("login_passwd").style.color = 'RED';
        document.getElementById("error_message_pass_toosmall").style.visibility = 'visible';
        return false;
      }

      //maximum length of password validation  
      if (pw == pwconfirm) {

        return true;
      } else {
        document.getElementById("confirm_pass").style.color = 'RED';
        document.getElementById("error_message_pass_notmatch").style.visibility = 'visible';

        return false;
      }
    }

    function Reset() {
      document.getElementById("confirm_pass").style.color = 'BLACK';
      document.getElementById("error_message_pass_notmatch").style.visibility = 'hidden';
      document.getElementById("login_passwd").style.color = 'BLACK';
      document.getElementById("error_message_pass_toosmall").style.visibility = 'hidden';
    }

    function ResetSelect() {
      document.getElementById("accountTypeSelect").style.visibility = 'hidden';
    }
  </script>

</head>

<body>
  <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
    <div class="container">
      <div class="form-box mx-auto">
        <?php if(session()->has('success')): ?>
        <div class="alert alert-success" role="alert">
          <?php echo e(session()->get('success')); ?>

          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <?php endif; ?>
        <?php if(session()->has('failed')): ?>
        <div class="alert alert-danger" role="alert">
          <?php echo e(session()->get('failed')); ?>

          <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <?php endif; ?>
        <!-- Custom Addition -->

        <div class="text-center mb-4">
          <img src="logos//logo1.png" alt="Responsive image" style="max-width:150px;">
        </div>
        <h2><?php echo e(getJsonLocalization('signup','sign up')); ?></h2>
        <p class="mb-4"><?php echo e(getJsonLocalization('signup','new user')); ?> ? <a class="no-decoration text-secondary text-mini" href="#"><?php echo e(getJsonLocalization('signup','create an account')); ?></a></p>

        <form onsubmit="return verifyPassword()" method="POST" action="<?php echo e(route('action_signup')); ?>">
          <?php echo csrf_field(); ?>

          <script>
            function checkEmail() {
              var emailId = document.getElementById("email_id").value;

              if (!emailId.includes("@")) {

                document.getElementById("validEmail").style.display = "block";
              } else {
                document.getElementById("validEmail").style.display = "none";
              }
            }
          </script>

          <div class="mb-2">
            <input type="email" class="form-control" placeholder="<?php echo e(getJsonLocalization('signup','enter email')); ?>" name="email_id" id="email_id" required onfocusout="checkEmail()">
            <label for="message" class="text-danger text-mini" style="display:none;" id="validEmail" name="validEmail"><b><?php echo e(getJsonLocalization('signup','not a valid email')); ?></b></label>
          </div>

          <script>
            function checkPasswordLength() {
              var passLeng = document.getElementById("login_passwd").value;

              if (passLeng.length < 8) {
                document.getElementById("error_message_pass_toosmall").style.display = 'block';
                //  $('#modal1').modal('show');
                //     setTimeout( function(){ $('#modal1').modal('hide'); } , 1000 );

              } else {
                document.getElementById("error_message_pass_toosmall").style.display = 'none';
              }
            }
          </script>

          <div class="mb-2">
            <input type="password" class="form-control" placeholder="<?php echo e(getJsonLocalization('signup','enter password')); ?>" name="login_passwd" id="login_passwd" required onfocusout="checkPasswordLength()">
            <label class="text-danger text-mini" style="display:none;" for="message" id="error_message_pass_toosmall" name="error_message_pass_toosmall"><b><?php echo e(getJsonLocalization('signup','the password is too short')); ?></b></label>
          </div>

          <div class="mb-2">
            <script>
              function matchPassword() {
                var firstAttemp = document.getElementById("login_passwd").value;
                var secondPass = document.getElementById("confirm_pass").value;
                if (firstAttemp != secondPass) {
                  document.getElementById("error_message_pass_notmatch").style.display = 'block';
                } else {
                  document.getElementById("error_message_pass_notmatch").style.display = 'none';
                }
              }
            </script>
            <input type="password" class="form-control" placeholder="<?php echo e(getJsonLocalization('signup','confirm password')); ?>" name="confirm_pass" id="confirm_pass" required onfocusout="matchPassword()">
            <label for="message" class="text-danger text-mini" style="display:none;" id="error_message_pass_notmatch" name="error_message_pass_notmatch"><b><?php echo e(getJsonLocalization('signup','the password is too short')); ?></b></label>
          </div>

          <label for="message" class="text-danger d-none text-mini" id="accountTypeSelect" name="accountTypeSelect"><b><?php echo e(getJsonLocalization('signup','please select account type')); ?></b></label>
          <div class="mb-2">
            <select class="form-select" aria-label="Default select example" style="height:40px;width: 100%;" id="accountType" name="accountType" onchange="ResetSelect()">
              <option selected><?php echo e(getJsonLocalization('signup','type of account')); ?></option>
              <option value="1"><?php echo e(getJsonLocalization('signup','individual')); ?></option>
              <option value="2"><?php echo e(getJsonLocalization('signup','organisation/recruiter')); ?></option>
              <option value="3"><?php echo e(getJsonLocalization('signup','education')); ?></option>
              <option value="4"><?php echo e(getJsonLocalization('signup','entrepreneur')); ?></option>
              <option value="5"></option>
            </select>
          </div>
          <div class="form-check mb-4">
            <label for="message" class="text-danger d-none text-mini" id="agrementMessage" name="agrementMessage"><b><?php echo e(getJsonLocalization('signup',"you haven't agreed to our terms of use and privacy")); ?></b></label>
            <input class="form-check-input" type="checkbox" value="" id="agrement" name="agrement">
            <label class="form-check-label" for="flexCheckChecked">
              <?php echo e(getJsonLocalization('signup',"I agree to workfrater's term of services and privacy policy")); ?>

            </label>
          </div>

          <div>
            <button type="submit" class="wf-btn wf-btn-secondary w-100"><?php echo e(getJsonLocalization('signup','join')); ?></button>
          </div>
        </form>



        <div>
        </div>
  </section>

  <!-- Modal -->
  <div class="modal fade" id="modal1" role="dialog">
    <div class="modal-dialog">

      <!-- Modal content-->
      <div class="modal-content" style="width:300px;margin-top:200px;margin-left:50px;">

        <div class="modal-body">
          <p><b><?php echo e(getJsonLocalization('signup','the password is too short')); ?></b></p>
        </div>

      </div>

    </div>
  </div>
</body>

</html><?php /**PATH C:\xampp\htdocs\phil_web\resources\views/signup.blade.php ENDPATH**/ ?>