<!DOCTYPE html>
<html lang="en">

<head>
  <!-- links and scripts -->
  <title>Workfrater</title>
  <meta charset="utf-8">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="css/utils.css">
  <link rel="stylesheet" href="css/ui-elements.css">
  <link rel="stylesheet" href="css/bootstrap-overrides.css">
  <link rel="stylesheet" href="css/home.css">
  <link rel="stylesheet" href="css/index.css">
  <link rel="stylesheet" href="css/responsive.css">

  <script src="js/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

  <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
  <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
  <script src="js/countrypicker.js"></script>

  <script type="text/javascript" src="js/custom.js"></script>
  <script type="text/javascript" src="js//url.js"></script>
</head>

<body style="background-color:#E0E0E0;">
  <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

  <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
    <div class="container">
      <div class="form-box mx-auto">
        <div class="text-center mb-5">
          <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
        </div>
        <h4 class="text-center"><?php echo e(getJsonLocalization('signup', 'Diploma')); ?></h4>
        <fieldset>

          <form method="POST" action="<?php echo e(route('action_diplomaInfo')); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" class="form-control" id="job_title_1" name="job_title_1">
            <input type="hidden" class="form-control" id="job_title_2" name="job_title_2">
            <input type="hidden" class="form-control" id="job_title_3" name="job_title_3">
            <input type="hidden" class="form-control" id="company_name_1" name="company_name_1">
            <input type="hidden" class="form-control" id="company_name_2" name="company_name_2">
            <input type="hidden" class="form-control" id="company_name_3" name="company_name_3">
            <input type="hidden" class="form-control" id="year_from_1" name="year_from_1">
            <input type="hidden" class="form-control" id="year_from_2" name="year_from_2">
            <input type="hidden" class="form-control" id="year_from_3" name="year_from_3">
            <input type="hidden" class="form-control" id="year_to_1" name="year_to_1">
            <input type="hidden" class="form-control" id="year_to_2" name="year_to_2">
            <input type="hidden" class="form-control" id="year_to_3" name="year_to_3">

            <div class="mb-3 diplomas-box" id="myDIV"></div>

            <div id="addRow" name="addRow" style="display:none;">
              <div class="row gy-2 mb-3">
                <div class="col-md-12">
                  <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Institution name')); ?>:</label>
                  <input type="text" autocomplete="off" class="form-control" id="job_title1" name="job_title1" value="">
                </div>
                <div class="col-md-12">
                  <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Diploma')); ?>:</label>
                  <input type="text" autocomplete="off" class="form-control" id="company_name1" name="company_name1" value="">
                </div>
                <div class="col-md-6">
                  <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'From Year')); ?>:</label>

                  <select class="form-select" style="height:40px;background-color:white;" id="year_from1" name="year_from1">
                    <option value="" disabled selected><?php echo e(getJsonLocalization('signup', 'Year')); ?></option>
                    <?php
                    $year = (int)date("Y");
                    for ($i = 0; $i < 104; $i++) {
                      $yearr = $year - $i;
                    ?>
                      <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                    <?php
                    }
                    ?>
                  </select>
                </div>
                <div class="col-md-6">
                  <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'To Year')); ?>:</label>
                  <select class="form-select" style="height:40px;background-color:white;" id="year_to1" name="year_to1">
                    <option value="" disabled selected><?php echo e(getJsonLocalization('signup', 'Year')); ?></option>
                    <?php
                    $year = (int)date("Y");
                    for ($i = 0; $i < 104; $i++) {
                      $yearr = $year - $i;
                    ?>
                      <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                    <?php
                    }
                    ?>
                  </select>
                </div>
                <div class="col-md-12" style="text-align: left;display:none;">
                  <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Still Working')); ?>:</label>
                  <input class="form-check-input" type="checkbox" value="" id="stillworking" onclick="stillWorking();">
                </div>
              </div>
            </div>

            <div id="buttonAddRec" name="buttonAddRec" style="display:none;">
              <div class="row mb-3">
                <div class="col-6"> <button type="button" class="wf-btn wf-btn-danger" onclick="cancelRec();"><?php echo e(getJsonLocalization('signup', 'Cancel')); ?></button></div>
                <div class="col-6 text-end"> <button type="button" class="wf-btn wf-btn-primary" onclick="takeValues();"><?php echo e(getJsonLocalization('signup', 'Add')); ?></button> </div>
              </div>
            </div>

            <input type="hidden" id="iamstudent" name="iamstudent" value="no">

            <div>
              <div class="text-center" id="addExpButton" name="addExpButton">
                <button type="button" class="wf-btn wf-btn-primary" onclick="showRow();"><img src="ProfileImages/icons/addsocaillink.png" style="width:20px;" alt="add icon" /> <?php echo e(getJsonLocalization('signup', 'Add Previous Diploma')); ?></button>
              </div>
              <div><img src="logos/good.png" id="goodImg" name="goodImg" style="visibility:hidden" alt="" width="40" height="40"></div>
            </div>

            <div class="row mt-3">
              <div class="col-6">
                <a href="<?php echo e(route('basicInfo')); ?>" type="button" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('signup', 'Go Back')); ?></a>
              </div>
              <div class="col-6 text-end">
                <button type="submit" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('signup', 'Next')); ?></button>
                <div>
                </div>
          </form>

        </fieldset>
      </div>
    </div>
  </section>

</body>
<script type="text/javascript" src="js//url.js"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
<link rel="stylesheet" href="css//index.css">
<script>
  var rowCount = 0;
  var getValue = 0;
  var dataListArray = [];
  // function showRow(){

  //      document.getElementById("stillworking").checked=false;
  //      document.getElementById('year_to1').style.display='block';
  //      document.getElementById('addRow').style.display='block';
  //      document.getElementById('buttonAddRec').style.display='block';

  //      document.getElementById('addExpButton').style.display='none';

  // }
  function stillWorking() {
    if (document.getElementById("stillworking").checked == true) {
      document.getElementById('year_to1').value = null;
      document.getElementById('year_to1').style.display = 'none';
    } else if (document.getElementById("stillworking").checked == false) {
      document.getElementById('year_to1').value = null;
      document.getElementById('year_to1').style.display = 'block';
    }
  }

  function cancelRec() {

    document.getElementById('addRow').style.display = 'none';
    document.getElementById('buttonAddRec').style.display = 'none';
    document.getElementById('addExpButton').style.visibility = 'visible';



  }

  function openExperience() {

    window.location.href = "workexperience.php";

  }


  function iamStudent() {
    if (document.getElementById("iamstudent").value == "yes") {
      document.getElementById("iamstudent").value = "no";
      document.getElementById("goodImg").style.visibility = 'hidden';
    } else {
      document.getElementById("iamstudent").value = "yes";
      document.getElementById("goodImg").style.visibility = 'visible';
    }

  }


  function showRow() {
    document.getElementById("stillworking").checked = false;
    document.getElementById('year_to1').style.display = 'block';
    document.getElementById('addRow').style.display = 'block';
    document.getElementById('buttonAddRec').style.display = 'block';
    document.getElementById('addExpButton').style.visibility = 'hidden';

  }

  function takeValues() {


    if (dataListArray.length == 3) {
      alert("You Can Add Max 3 Record");
      return;
    }
    let i = 0;
    document.getElementById("myDIV").innerHTML = '';

    if (getValue == 0) {
      var jobTitle = document.getElementById('job_title1').value;
      var companyName = document.getElementById('company_name1').value;
      var yearFrom = document.getElementById('year_from1').value;
      var yearTo = document.getElementById('year_to1').value;

      if (!jobTitle) {
        alert("Please Add Job Title");
        return;
      }
      if (!companyName) {
        alert("Please Add Company Name");
        return;
      }
      if (!yearFrom) {
        alert("Please Add Year From");
        return;
      }

      if (!yearTo) {



        if (document.getElementById("stillworking").checked == true) {
          yearTo = "now";
          document.getElementById("stillworking").checked = false;
        } else {

          alert("Please Add Year To");
          return;
        }
      }

      dataListArray.push(companyName + ',            ' + jobTitle + '            ' + yearFrom + '-' + yearTo);
    }


    document.getElementById('job_title_1').value = null;
    document.getElementById('company_name_1').value = null;
    document.getElementById('year_from_1').value = null;
    document.getElementById('year_to_1').value = null;

    document.getElementById('job_title_2').value = null;
    document.getElementById('company_name_2').value = null;
    document.getElementById('year_from_2').value = null;
    document.getElementById('year_to_2').value = null;

    document.getElementById('job_title_3').value = null;
    document.getElementById('company_name_3').value = null;
    document.getElementById('year_from_3').value = null;
    document.getElementById('year_to_3').value = null;

    while (i < dataListArray.length) {
      var v = i + 1;

      if (v == 1) {

        const myArray = dataListArray[i].split("            ");
        document.getElementById('job_title_1').value = myArray[1];
        document.getElementById('company_name_1').value = myArray[0];
        var vvv = myArray[2];
        const myArray2 = vvv.split("-");
        document.getElementById('year_from_1').value = myArray2[0];
        document.getElementById('year_to_1').value = myArray2[1];
      }
      if (v == 2) {

        const myArray = dataListArray[i].split("            ");
        document.getElementById('job_title_2').value = myArray[1];
        document.getElementById('company_name_2').value = myArray[0];
        var vvv = myArray[2];
        const myArray2 = vvv.split("-");
        document.getElementById('year_from_2').value = myArray2[0];
        document.getElementById('year_to_2').value = myArray2[1];
      }
      if (v == 3) {

        const myArray = dataListArray[i].split("            ");
        document.getElementById('job_title_3').value = myArray[1];
        document.getElementById('company_name_3').value = myArray[0];
        var vvv = myArray[2];
        const myArray2 = vvv.split("-");
        document.getElementById('year_from_3').value = myArray2[0];
        document.getElementById('year_to_3').value = myArray2[1];
      }

      let newbtn = document.createElement("appendText");
      newbtn.innerHTML = v + '.' + dataListArray[i];
      i++;




      //newbtn.innerHTML = rowCount+'.    '+companyName+',       '+jobTitle+'       '+yearFrom+'-'+yearTo;

      var br = document.createElement("br");
      // the remove button
      let xspan = document.createElement('span');
      xspan.innerHTML = '<a href="javascript:FunctionCall();" style="display:inline-flex;"><img src="logos/cross.png" style="filter:invert(1);" alt="cross icon" /></a>'; //this gives it superscript text
      xspan.id = 'close'; //this was not necessary but it is nice to have
      xspan.onclick = function() {
        var value = newbtn.innerHTML;
        const streetAddress = value.substring(2, value.indexOf("<span id"));
        getValue = 1;
        newbtn.remove();
        rowCount = 0;
        br.remove();
        let index = dataListArray.indexOf(streetAddress);


        dataListArray.splice(index, 1);
        document.getElementById("myDIV").innerHTML = '';

        var k = 0;
        while (k < dataListArray.length) {

          k = k + 1;
        }
        takeValues();




      };
      newbtn.appendChild(xspan);


      document.getElementById("myDIV").appendChild(newbtn);
      //  document.getElementById("myDIV").appendChild(br);
    }


    document.getElementById('addRow').style.display = 'none';
    document.getElementById('buttonAddRec').style.display = 'none';
    document.getElementById('addExpButton').style.visibility = 'visible';
    document.getElementById('job_title1').value = "";
    document.getElementById('company_name1').value = "";
    document.getElementById('year_from1').value = "";
    document.getElementById('year_to1').value = "";
    getValue = 0;
  };
</script>

</html><?php /**PATH C:\xampp\htdocs\phil_web\resources\views/individualsignup/diplomaInfo.blade.php ENDPATH**/ ?>