<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
</head>

<body>
    <?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
        <div class="container">

            <div class="form-box mx-auto" style="max-width:767px;">
                <div class="text-center mb-4">
                    <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
                </div>
                <h2><?php echo e(getJsonLocalization('signup', 'Basic Information')); ?></h2>
                <form method="POST" action="<?php echo e(route('actionBasicInfo')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="row mb-3 gy-2">
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'First Name')); ?>: <span class="text-danger">*</span></label>
                            <input type="text" autocomplete="off" class="form-control" name="first_name" id="first_name" value="" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Second Name')); ?>: <span class="text-danger">*</span></label>
                            <input type="text" autocomplete="off" class="form-control" id="second_name" name="second_name" value="" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Country')); ?>: <span class="text-danger">*</span></label><br>

                            <select class="selectpicker form-select" id="country_picker" name="country_picker" value="" required>
                                <option value="USA" selected><?php echo e(getJsonLocalization('signup', 'USA')); ?></option>
                                <option value="Canada"><?php echo e(getJsonLocalization('signup', 'Canada')); ?></option>

                            </select>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup','Ethnicity')); ?>: <span class="text-danger">*</span></label>
                            <select class="selectpicker form-select" id="Ethnicity" name="Ethnicity" value="" required>
                                <option value="Caucasian" selected><?php echo e(getJsonLocalization('signup', 'Caucasian')); ?>

                                </option>
                                <option value="African"><?php echo e(getJsonLocalization('signup', 'African')); ?></option>
                                <option value="Asian"><?php echo e(getJsonLocalization('signup', 'Asian')); ?></option>
                                <option value="South Asian"><?php echo e(getJsonLocalization('signup', 'South Asian')); ?></option>
                                <option value="Middle-Eastern"><?php echo e(getJsonLocalization('signup', 'MiddleEastern')); ?>

                                </option>
                                <option value="North-African"><?php echo e(getJsonLocalization('signup', 'NorthAfrican')); ?>

                                </option>
                                <option value="Hispanic"><?php echo e(getJsonLocalization('signup', 'Hispanic')); ?></option>
                                <option value="AfroLatin"><?php echo e(getJsonLocalization('signup', 'Afro-Latin')); ?></option>
                                <option value="Native American"><?php echo e(getJsonLocalization('signup', 'Native American')); ?>

                                </option>
                                <option value="Mixed"><?php echo e(getJsonLocalization('signup', 'Mixed')); ?></option>
                                <option value="Other"><?php echo e(getJsonLocalization('signup', 'Other')); ?></option>
                            </select>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Country of Origin')); ?>: <span class="text-danger">*</span></label>
                            <select class="selectpicker countrypicker form-select" id="contry_of_origin" name="contry_of_origin"></select>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Status')); ?>: <span class="text-danger">*</span></label>
                            <select class="selectpicker form-select" id="status_picker" name="status_picker" value="" required>
                                <option value="Citizen" selected><?php echo e(getJsonLocalization('signup', 'Citizen')); ?>

                                </option>
                                <option value="Permanent Resident">
                                    <?php echo e(getJsonLocalization('signup', 'Permanent Resident')); ?>

                                </option>
                                <option value="Refugee"><?php echo e(getJsonLocalization('signup', 'Refugee')); ?></option>
                                <option value="Other"><?php echo e(getJsonLocalization('signup', 'Other')); ?></option>
                            </select>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Gender')); ?>: <span class="text-danger">*</span></label>
                            <select class="selectpicker form-select" id="gender_picker" name="gender_picker" value="" required>
                                <option value="Male" selected><?php echo e(getJsonLocalization('signup', 'Male')); ?></option>
                                <option value="Female"><?php echo e(getJsonLocalization('signup', 'Female')); ?> </option>
                                <option value="Other"><?php echo e(getJsonLocalization('signup', 'Other')); ?></option>
                            </select>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'City')); ?>: <span class="text-danger">*</span></label>
                            <input type="text" autocomplete="off" class="form-control" id="city_name" name="city_name" value="" required>
                        </div>
                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Zip Code')); ?>: <span class="text-danger">*</span></label>
                            <input type="text" autocomplete="off" class="form-control" id="zip_code" name="zip_code" value="" required>
                        </div>

                        <div class="col-sm-4">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'PhoneNumber')); ?>: </label>
                            <input type="text" autocomplete="off" class="form-control" id="phone_no" name="phone_no" value="" placeholder="+00 123 456 789">
                        </div>
                        <div class="col-sm-8">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'address')); ?>: </label>
                            <input type="text" autocomplete="off" class="form-control" id="full_address" name="full_address" value=""  placeholder="">
                        </div>

                        <div class="col-sm-12">
                            <label class="text-mini"><?php echo e(getJsonLocalization('signup', 'Date of Birth')); ?>: <span class="text-danger">*</span></label>
                            <div class="row g-0">
                                <div class="col-4">
                                    <select class="form-select" style="border-radius:4px 0 0 4px;" placeholder="Day" id="day" name="day">
                                        <option value="" disabled selected><?php echo e(getJsonLocalization('signup', 'Day')); ?></option>
                                        <?php
                                        for ($i = 1; $i < 32; $i++) {
                                        ?>
                                            <option value="<?php echo $i; ?>"> <?php echo $i; ?></option>
                                        <?php
                                        }
                                        ?>
                                    </select>
                                </div>
                                <div class="col-4">
                                    <select class="form-select" style="border-radius:0;" placeholder="month" id="month" name="month">
                                        <option value="" disabled selected><?php echo e(getJsonLocalization('signup', 'Month')); ?></option>
                                        <option value="Jan">Jan</option>
                                        <option value="Feb">Feb</option>
                                        <option value="Mar">Mar</option>
                                        <option value="Apr">Apr</option>
                                        <option value="May">May</option>
                                        <option value="Jun">Jun</option>
                                        <option value="Jul">Jul</option>
                                        <option value="Aug">Aug</option>
                                        <option value="Sep">Sep</option>
                                        <option value="Oct">Oct</option>
                                        <option value="Nov">Nov</option>
                                        <option value="Dec">Dec</option>
                                    </select>
                                    <!--<input type="text" id="month" name="month" class="form-control"  placeholder="Month" list="monthList" style="width:110%;height:40px;" editable="true" required autocomplete="off">-->
                                </div>
                                <div class="col-4">
                                    <select class="form-select" style="border-radius:0px 4px 4px 0" placeholder="year" id="year" name="year">
                                        <option value="" disabled selected><?php echo e(getJsonLocalization('signup', 'Year')); ?></option>
                                        <?php
                                        $year = (int)date("Y");
                                        for ($i = 0; $i < 104; $i++) {

                                            $yearr = $year - $i;

                                        ?>
                                            <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                                        <?php
                                        }


                                        ?>
                                    </select>
                                </div>
                                <script>
                                    var mySelect = document.getElementById('month');
                                    mySelect.onchange = (event) => {
                                        var selectedMonth = event.target.value;
                                        if (selectedMonth == 'Sep' || selectedMonth == 'Apr' || selectedMonth == 'Jun' || selectedMonth == 'Nov') {
                                            var selectedDay = document.getElementById('day').value;
                                            document.getElementById("day").remove(31);
                                            if (selectedDay != 'Day') {
                                                var sDay = parseInt(selectedDay);
                                                if (sDay > 30) {
                                                    document.getElementById('day').selectedIndex = 0;
                                                } else {
                                                    document.getElementById('day').selectedIndex = sDay;
                                                }
                                            }

                                        } else if (selectedMonth == 'Feb') {
                                            var selectedDay = document.getElementById('day').value;
                                            document.getElementById("day").remove(31);
                                            document.getElementById("day").remove(30);
                                            document.getElementById("day").remove(29);
                                            if (selectedDay != 'Day') {
                                                var sDay = parseInt(selectedDay);
                                                if (sDay > 28) {
                                                    document.getElementById('day').selectedIndex = 0;
                                                } else {
                                                    document.getElementById('day').selectedIndex = sDay;
                                                }
                                            }
                                        } else {

                                            if (document.getElementById("day").length == 29) {
                                                var opt = document.createElement('option');
                                                opt.value = 29;
                                                opt.innerHTML = 29;
                                                document.getElementById("day").appendChild(opt);
                                                opt = document.createElement('option');
                                                opt.value = 30;
                                                opt.innerHTML = 30;
                                                document.getElementById("day").appendChild(opt);
                                                opt = document.createElement('option');
                                                opt.value = 31;
                                                opt.innerHTML = 31;
                                                document.getElementById("day").appendChild(opt);
                                            } else if (document.getElementById("day").length == 31) {
                                                var opt = document.createElement('option');
                                                opt.value = 31;
                                                opt.innerHTML = 31;
                                                document.getElementById("day").appendChild(opt);
                                            }
                                        }


                                    }
                                </script>

                                <datalist id="dayList">
                                    <option value="1">
                                    <option value="2">
                                    <option value="3">
                                    <option value="4">
                                    <option value="5">
                                    <option value="6">
                                    <option value="7">
                                    <option value="8">
                                    <option value="9">
                                    <option value="10">
                                    <option value="11">
                                    <option value="12">
                                    <option value="13">
                                    <option value="14">
                                    <option value="15">
                                    <option value="16">
                                    <option value="17">
                                    <option value="18">
                                    <option value="19">
                                    <option value="20">
                                    <option value="21">
                                    <option value="22">
                                    <option value="23">
                                    <option value="24">
                                    <option value="25">
                                    <option value="26">
                                    <option value="27">
                                    <option value="28">
                                    <option value="29">
                                    <option value="30">
                                    <option value="31">
                                </datalist>
                                <datalist id="monthList">
                                    <option value="Jan">
                                    <option value="Feb">
                                    <option value="Mar">
                                    <option value="Apr">
                                    <option value="May">
                                    <option value="Jun">
                                    <option value="Jul">
                                    <option value="Aug">
                                    <option value="Sep">
                                    <option value="Oct">
                                    <option value="Nov">
                                    <option value="Dec">
                                </datalist>
                                <datalist id="yearList">
                                    <?php
                                    $year = (int)date("Y");
                                    for ($i = 0; $i < 34; $i++) {

                                        $yearr = $year - $i;

                                    ?>
                                        <option value="<?php echo $yearr; ?>">
                                        <?php
                                    }


                                        ?>
                                </datalist>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <a href="<?php echo e(route('signup')); ?>" type="button" class="wf-btn wf-btn-secondary">
                                <?php echo e(getJsonLocalization('signup', 'Go Back')); ?>

                            </a>
                        </div>
                        <div class="col-6 text-end">
                            <button type="submit" class="wf-btn wf-btn-secondary"><?php echo e(getJsonLocalization('signup', 'Next')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </section>
</body>

</html><?php /**PATH C:\xampp\htdocs\phil_web\resources\views/individualsignup/basicInfo.blade.php ENDPATH**/ ?>