<?php

use Illuminate\Support\Facades\Config;

$languages = Config::get('languages');
?>

<footer id="workfrater-footer" class="section-padding position-relative overflow-hidden">
    <!-- particles.js container -->
    <div id="particles-js"></div>

    <div class="footer-top">
        <div class="container">
            <div class="row gy-5">
                <div class="col-sm-6 col-md-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h3 class="mb-3 text-secondary"><?php echo e(getJsonLocalization('footer', 'AboutUs')); ?></h3>
                    <ul class="normal-list">
                        <li class="footer-list-head"></li>
                        <li><a href="<?php echo e(route('innovations')); ?>"><?php echo e(getJsonLocalization('footer', 'innovations')); ?></a></li>
                        <li><a href="<?php echo e(route('goalsandculture')); ?>"><?php echo e(getJsonLocalization('footer', 'goals and culture')); ?></a></li>
                        <li><a href="<?php echo e(route('ourcustomers')); ?>"><?php echo e(getJsonLocalization('footer', 'our customers')); ?></a></li>
                        <li><a href="<?php echo e(route('joinourteam')); ?>"><?php echo e(getJsonLocalization('footer', 'join our team')); ?></a></li>
                        <li><a href="<?php echo e(route('book-an-online-presentation')); ?>"><?php echo e(getJsonLocalization('footer', 'book an online presentation')); ?></a></li>
                    </ul>
                </div>
                <div class="col-sm-6 col-md-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h3 class="mb-3 text-secondary"><?php echo e(getJsonLocalization('footer', 'contact us')); ?></h3>
                    <ul class="normal-list">
                        <li class="footer-list-head"></li>
                        <li><a href="<?php echo e(route('generalinquiries')); ?>"><?php echo e(getJsonLocalization('footer', 'general inquiries')); ?></a></li>
                        <li><a href="<?php echo e(route('techsupport')); ?>"><?php echo e(getJsonLocalization('footer', 'tech support')); ?></a></li>
                        <li><a href="<?php echo e(route('customerservice')); ?>"><?php echo e(getJsonLocalization('footer', 'customer service')); ?></a></li>
                    </ul>
                </div>
                <div class="col-sm-6 col-md-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h3 class="mb-3 text-secondary"><?php echo e(getJsonLocalization('footer', 'our services')); ?></h3>
                    <ul class="normal-list">
                        <li class="footer-list-head"></li>
                        <li><a href="<?php echo e(route('post-a-job')); ?>"><?php echo e(getJsonLocalization('footer', 'jobs posting')); ?></a></li>
                        <li><a href="<?php echo e(route('school-and-students')); ?>"><?php echo e(getJsonLocalization('footer', 'school and students')); ?></a></li>
                        <li><a href="<?php echo e(route('staffing')); ?>"><?php echo e(getJsonLocalization('footer', 'staffing')); ?></a></li>
                        <li><a href="<?php echo e(route('become-an-entrepreneur')); ?>"><?php echo e(getJsonLocalization('footer', 'service for entrepreneurs')); ?></a></li>
                        <li><a href="<?php echo e(route('search-an-online-test')); ?>"><?php echo e(getJsonLocalization('footer', 'online exams')); ?></a></li>
                        <li><a href="<?php echo e(route('search-interviews')); ?>"><?php echo e(getJsonLocalization('footer', 'online interviews')); ?></a></li>
                        <li><a href="<?php echo e(route('fees-and-subscription')); ?>"><?php echo e(getJsonLocalization('footer', 'fees-and-subscription')); ?></a></li>
                    </ul>
                </div>
                <div class="col-sm-6 col-md-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h3 class="mb-3 text-secondary"><?php echo e(getJsonLocalization('footer', 'faqs')); ?></h3>
                    <ul class="normal-list">
                        <li class="footer-list-head"></li>
                        <li><a href="<?php echo e(route('general-questions')); ?>"><?php echo e(getJsonLocalization('footer', 'general-questions')); ?></a></li>
                        <li><a href="<?php echo e(route('basic-functionalities')); ?>"><?php echo e(getJsonLocalization('footer', 'basic-functionalities')); ?></a></li>
                        <li><a href="<?php echo e(route('video-calls')); ?>"><?php echo e(getJsonLocalization('footer', 'video-calls')); ?></a></li>
                        <li><a href="<?php echo e(route('doing-online-exams')); ?>"><?php echo e(getJsonLocalization('footer', 'doing-online-exams')); ?></a></li>
                        <li><a href="<?php echo e(route('creating-job-offers')); ?>"><?php echo e(getJsonLocalization('footer', 'creating-job-offers')); ?></a></li>
                        <li><a href="<?php echo e(route('buying-exams-and-pdf')); ?>"><?php echo e(getJsonLocalization('footer', 'buying-exams-and-pdf-of-candidates')); ?></a></li>
                        <li><a href="<?php echo e(route('automatic-video-interviews')); ?>"><?php echo e(getJsonLocalization('footer', 'automatic-video-interviews')); ?></a></li>
                        <li><a href="<?php echo e(route('education-accounts-and-online-classrooms')); ?>"><?php echo e(getJsonLocalization('footer', 'education-accounts-and-online-classrooms')); ?></a></li>
                        <li><a href="<?php echo e(route('becoming-an-entrepreneur-on-platform')); ?>"><?php echo e(getJsonLocalization('footer', 'becoming-an-entrepreneur-on-platform')); ?></a></li>
                        <li><a href="<?php echo e(route('confidentiality-safety-and-payment')); ?>"><?php echo e(getJsonLocalization('footer', 'confidentiality-safety-and-payment')); ?></a></li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <div class="footer-bottom">
        <div class="container">
            <div class="social-icons-list justify-content-center mt-5">
                <a href="https://www.facebook.com/Workfrater"><img
                        src="<?php echo e(URL::to('/')); ?>/logos/Social/Facebook/Facebook-PNG.png" width="40px"
                        height="40px" class="img-responsive" alt=""></a>
                <a href="https://www.instagram.com/workfrater/"><img
                        src="<?php echo e(URL::to('/')); ?>/logos/Social/Instagram/instagram-PNG.png" width="40px"
                        height="40px" class="img-responsive" alt=""></a>
                <a href="https://www.youtube.com/@workfrater/"><img
                        src="<?php echo e(URL::to('/')); ?>/logos/Social/Youtube/youtube-PNG-01.png" width="40px"
                        height="40px" class="img-responsive" alt=""></a>
                <a href="https://www.tiktok.com/@workfrater"><img
                        src="<?php echo e(URL::to('/')); ?>/logos/Social/tiktok/Tiktok-PNG-01.png" width="40px"
                        height="40px" class="img-responsive" alt=""></a>
                <a href="https://twitter.com/workfrater"><img
                        src="<?php echo e(URL::to('/')); ?>/logos/Social/Twitter/Twitter-PNG-01.png" width="40px"
                        height="40px" class="img-responsive" alt=""></a>
            </div>
        </div>
    </div>
</footer>

<style>
    .responsive-div {
        position: fixed;
        bottom: 10px;
        left: 50%;
        transform: translateX(-50%);
        z-index: 5000;
        background-color: rgba(255, 255, 255, 0.5);
        border-radius: 100px;
        width: 100%;
        backdrop-filter: blur(20px);
        max-width: 450px;
        border: 1px solid #dee2e6;
    }
</style>
<div class="responsive-div">
    <div class="row align-items-center m-0">
        <div class="col-3 ps-0">
            <img src="logos/watermark.png">
        </div>
        <div class="col-9 py-2">
            <h5>This is only a beta version of the site. the site is not ready yet.</h5>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\phil_web\resources\views/footer.blade.php ENDPATH**/ ?>