<?php


$callInformationSession = Session::get('VideoCallInfo');

?>
<!DOCTYPE html>
<html>

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://cdn.webrtc-experiment.com/MediaStreamRecorder.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/loby.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src='js//AgoraRTC_N-4.11.0.js'></script>
    <script src='js//agora-rtm-sdk-1.5.1.js'></script>
    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <script src="https://www.webrtc-experiment.com/MultiStreamsMixer.js"></script>
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <style>
        /* Container for the ticker */
        .ticker-container {
            width: 100%;
            /* Ensure it's responsive */
            overflow: hidden;
            /* Hide anything that goes outside of the container */
            position: relative;
            background-color: #2d3e50;
            color: #ffffff;
            padding: 10px 0;

        }

        .ticker {
            display: flex;
            /* Flexbox for continuous inline elements */
            white-space: nowrap;
            /* Prevent line breaks */
            animation: ticker-animation 60s linear;
            font-size: 20px;
            padding-left: 30%;
            font-weight: bold;
        }

        .ticker span {
            padding-right: 20px;
            /* Optional: space between ticker items */
        }

        @keyframes ticker-animation {
            0% {
                transform: translateX(100%);
                /* Start from the right side (off-screen) */
            }

            100% {
                transform: translateX(-100%);
                /* Move to the left side (off-screen) */
            }
        }
    </style>
</head>

<!-- <body style="background-color: #f0f8ff;"> -->

<body>
    <section class="section" style="background-image: url('{{ $callInformationSession['lobby_background_pic'] }}'); background-size: cover; background-position: center; background-repeat: no-repeat;height:400px;">
    </section>
    <section class="section">
        <div class="heading">
            <div class="row">
                <h2 class="title">Loby</h2>
            </div>
            <div class="row">
                <h3 class="subtitle">Group Call Loby Room {{ $callInformationSession['lobby_meeting_name'] }}</h3>
            </div>
        </div>
    </section>
    <section>
        <div class="heading mt-5">
            <div class="row">
                <div class="col-1 offset-2">
                    @if($callInformationSession['lobby_profile_pic'] == 'no')
                        <img src="ProfileImages/Images/<?php    echo $callInformationSession['caller_picture'];?>"
                            style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                    @else
                        <img src="<?php    echo $callInformationSession['lobby_profile_pic'];?>"
                            style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                    @endif
                </div>
                <div class="col-2">
                    <p style="font-size: 30px; font-weight: bold; color:#090a01;">Created By:</p>
                    <p style="font-size: 25px; font-weight: bold; color:#090a01;">
                        <?php    echo $callInformationSession['caller_name']; ?></p>
                </div>
            </div>

        </div>
    </section>
    <section>
        <div class="video_call_box mt-3">
            <div class="row">
                <div class="col-5 offset-1">
                    <div class="row">
                        <div class="col-12" id="video-container">
                            <video id="video" width="530" height="360" autoplay
                                style="background-color:black; border-radius: 10px;"></video>
                        </div>
                    </div>
                    <div class="row mt-1">
                        <div class="col-4" style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn btn-success" style="width:180px;height:50px;"
                                onclick="setMicOnOff();" id="micButton">mic-hd</button>
                        </div>
                        <div class="col-4" style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn btn-success" style="width:180px;height:50px;"
                                onclick="setCamOnOff();" id="cameraButton">lg
                                camera</button>
                        </div>
                    </div>
                </div>
                <div class="col-6" id="joiner_panel" style="display:none;">

                    <div class="row">
                        <div class="col-2 offset-2">
                            <img src="" style="width:80px;height:80px;border-radius: 50%;" id="join_person_pic">
                        </div>
                        <div class="col-6 ">
                            <p style="font-size: 30px; font-weight: bold; color:#090a01;">Joiner Name:</p>
                            <p id="joiner_name" style="font-size: 25px; font-weight: bold; color:#090a01;">Joiner Name:
                            </p>
                        </div>
                    </div>
                    <div class="row mt-5">
                        <div class="col-3 offset-2"
                            style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn  btn-primary" style="width:180px;height:50px;"
                                onclick="OpenVideoCallingWindow();">
                                Ask To Join
                            </button>
                        </div>
                        <div class="col-3" style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn btn-danger" style="width:180px;height:50px;"
                                onclick="RejectCall();">
                                Reject
                            </button>
                        </div>
                    </div>


                </div>
            </div>

        </div>
    </section>
<br>
    <?php  if ($callInformationSession['lobby_intro_video'] != 'no_file') {?>
        <section class="d-flex justify-content-center align-items-center w-100">
        <div class="row">
        <div class="col-md-12 ">
        <h2 class="title">Introductory Video</h2>
        </div>
    </div>
        </section>
     <section class="d-flex justify-content-center align-items-center w-100">

        <div class="row">
            <div class="col-md-6 offset-md-3">
        <video class="video-player" controls style="border-radius: 20px; border: 2px solid black;" muted autoplay>
            <source src="{{ $callInformationSession['lobby_intro_video'] }}" type="video/mp4">

        </video>
        </div>
        </div>
    </section>
    <?php } ?>
    <section>
        <?php if ($callInformationSession['is_text_ticker'] == 'yes') { ?>
        <div class="row">
            <div class="ticker-container">
                <div class="ticker" id="ticker">
                    <!-- Initial ticker content -->
                    <?php
                         $content = $callInformationSession['text_ticker_content'];
                         echo  "<span>" . $content . "</span>"; // Initially load the content
                    ?>
                </div>
            </div>
        </div>
        <?php } ?>
    </section>


</body>


<script>
    var videoElement = document.getElementById('video');
    var startCameraButton = document.getElementById('start-camera');
    var camStatus = true;
    var micStatus = true;
    var stream = null;


    // Select the ticker container and get the initial ticker text content
    const tickerElement = document.getElementById('ticker');
    const tickerText = '<?php echo addslashes($callInformationSession['text_ticker_content']); ?>'; // Ensure the content is properly escaped for JavaScript
    // Function to continuously append text to the ticker
    function appendTickerText() {
        if(tickerElement){
            const newTickerItem = document.createElement('span'); // Create a new span for the new ticker text
        newTickerItem.textContent = tickerText; // Add the ticker content to the new span
        tickerElement.appendChild(newTickerItem); // Append the new span to the ticker
        }

    }
    setInterval(appendTickerText, 500);


    // Function to start the camera and display video
    // Request access to the user's webcam
    // navigator.mediaDevices.getUserMedia({ video: true })
    //     .then(stream => {
    //         this.stream = stream;
    //         // Set the video element's source to the webcam stream
    //         videoElement.srcObject = stream;
    //     })
    //     .catch(error => {
    //         console.error('Error accessing webcam: ', error);
    //     });
    window.onload = function () {
        window.scrollTo(0, document.body.scrollHeight);
        checkLobyWaitingClients();
    };

    var participant_email = "";
    function checkLobyWaitingClients() {
        setInterval(function () {

            console.log('checking clients waiting in loby:<?php echo $callInformationSession['channelID']; ?>');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('CheckLobyWaitingClients.post')}}",
                data: { 'channelId': '<?php echo $callInformationSession['channelID']; ?>' },
                success: function (data) {
                    var obj = JSON.parse(data);
                    if ('profile_pic' in obj) {
                        participant_email = obj.user_eamil;
                        document.getElementById("join_person_pic").src = "ProfileImages/Images/" + obj.profile_pic;
                        document.getElementById("joiner_name").innerHTML = obj.user_name;
                        document.getElementById("joiner_panel").style.display = "block";
                        var button = document.querySelector('.btn-danger');
                        // Add the vibrate class to trigger the shaking effect
                        button.classList.add('vibrate');
                        // Optional: Remove the vibrate class after the animation ends so it can be triggered again
                        deleteLobyWaitingUserEntryFromDB('<?php echo $callInformationSession['channelID']; ?>');
                        setInterval(function () {
                            button.classList.remove('vibrate');
                        }, 500); // Duration of the shake animation (0.5s)
                    }
                }, error: function (xhr, status, error) {
                    //  alert(xhr.responseText);
                }
            });

        }, 4000);
    }//...................................................

    function RejectCall() {


        var formData = new FormData();
        formData.append('participant_email', participant_email);
        formData.append('channelId', '<?php echo $callInformationSession['channelID']; ?>');
        $.ajax({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: 'POST',
            url: "{{ route('NotAllowingToJoinVideoCallingRoom.post') }}",
            data: formData,
            processData: false, // Prevent jQuery from processing the data
            contentType: false,
            success: function (response) {
                window.close();
            },
            error: function (xhr, status, error) {

            }
        });
        // $('#newClientModal' + id).modal('hide');
    }
    function deleteLobyWaitingUserEntryFromDB(channelId) {
        setInterval(function () {
            console.log('checking video call..............');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('DeleteLobyWaitingClientEntry')}}",
                data: { 'channelId': channelId },
                success: function (data) {

                }, error: function (xhr, status, error) {
                    //  alert(xhr.responseText);
                }
            });

        }, 4000);
    }//...................................................


    function setCamOnOff() {
        var button = document.getElementById("cameraButton");

        if (camStatus == true) {
            videoElement.srcObject = null;
            camStatus = false;
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");

        } else {
            videoElement.srcObject = stream;
            camStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }

    }
    function setMicOnOff() {
        var button = document.getElementById("micButton");
        if (micStatus == true) {
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");
            micStatus = false;
        } else {

            micStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }
    }
    function OpenVideoCallingWindow() {
        window.open("{{route('NormalMeetingVideoCallDesktopView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channelId=" + encodeURIComponent('<?php echo $callInformationSession['channelID']; ?>') + "&user_email=" + encodeURIComponent(participant_email), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000,height=1000");
        window.close();
    }


</script>



<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
    integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
    </script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
    integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
    </script>
<script type="text/javascript" src="js//url.js"></script>


</body>


</html>