<?php


$callInformationSession = Session::get('VideoCallInfo');



?>
<!DOCTYPE html>
<html>
<style>
    .message {
        font-size: 30px;
        /* Larger text */
        color: #fff;
        /* White text */
        font-weight: bold;
        /* Bold text */
        text-transform: uppercase;
        /* Make it uppercase */
        letter-spacing: 2px;
        /* Space out the letters */
        background: linear-gradient(45deg, #ff007f, #ff7f00);
        /* Beautiful gradient */
        -webkit-background-clip: text;
        /* Clip gradient to text */
        background-clip: text;
        /* Clip gradient to text */
        padding: 20px 40px;
        /* Spacious padding around text */
        border-radius: 10px;
        /* Rounded corners */
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
        /* Shadow for depth */
        text-align: center;
        /* Centered text */
        animation: glamMessage 3s ease-in-out infinite;
        /* Add an animation */
    }

    /* Glamorous animation */
    @keyframes glamMessage {
        0% {
            transform: scale(1);
            opacity: 0.8;
        }

        50% {
            transform: scale(1.1);
            opacity: 1;
        }

        100% {
            transform: scale(1);
            opacity: 0.8;
        }
    }

    /* Container for the ticker */
    .ticker-container {
        width: 100%;
        /* Ensure it's responsive */
        overflow: hidden;
        /* Hide anything that goes outside of the container */
        position: relative;
        background-color: #2d3e50;
        color: #ffffff;
        padding: 10px 0;

    }

    .ticker {
        display: flex;
        /* Flexbox for continuous inline elements */
        white-space: nowrap;
        /* Prevent line breaks */
        animation: ticker-animation 60s linear;
        font-size: 20px;
        padding-left: 30%;
        font-weight: bold;
    }

    .ticker span {
        padding-right: 20px;
        /* Optional: space between ticker items */
    }

    @keyframes ticker-animation {
        0% {
            transform: translateX(100%);
            /* Start from the right side (off-screen) */
        }

        100% {
            transform: translateX(-100%);
            /* Move to the left side (off-screen) */
        }
    }

    .video-player {
        max-width: 60%;
        /* Limits the video width */
        max-height: 60%;
        /* Limits the video height */
    }
</style>

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <script src="https://cdn.webrtc-experiment.com/MediaStreamRecorder.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/loby.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src='js//AgoraRTC_N-4.11.0.js'></script>
    <script src='js//agora-rtm-sdk-1.5.1.js'></script>
    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <script src="https://www.webrtc-experiment.com/MultiStreamsMixer.js"></script>
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
</head>

<body>
    <section class="section" style="background-image: url('{{ $callInformationSession['lobby_background_pic'] }}'); background-size: cover; background-position: center; background-repeat: no-repeat;height:400px;">
    </section>
    <section class="section">
        <div class="heading">
            <div class="row">
                <h2 class="title">Loby</h2>
            </div>
            <div class="row">
                <h3 class="subtitle">Group Call Loby Room {{ $callInformationSession['lobby_meeting_name'] }}</h3>
            </div>
        </div>
    </section>

    <section>
        <div class="heading">
            <div class="row">
                <div class="col-3 col-sm-2 offset-2 col-md-1 ">
                    <img src="ProfileImages/Images/<?php echo $rec_profile_img;?>"
                        style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                </div>
                <div class="col-6 ">
                    <p style="font-size: 30px; font-weight: bold; color:#090a01;">Participant:</p>
                    <p style="font-size: 25px; font-weight: bold; color:#090a01;"><?php echo $rec_name;?></p>
                </div>
            </div>
        </div>
    </section>

    <section>
        <div class="video_call_box">
            <div class="row">
                <!-- Video Section -->
                <div class="col-12 col-md-6 offset-md-1">
                    <div class="row">
                        <div class="col-12" id="video-container">
                            <video id="video" width="100%" height="auto" autoplay
                                style="background-color:black; border-radius: 10px;height:220px;"></video>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6 text-center">
                            <button type="button" class="btn btn-success"
                                style="width:100%; max-width:180px;height:50px;" onclick="setMicOnOff();"
                                id="micButton">mic-hd</button>
                        </div>
                        <div class="col-6 text-center">
                            <button type="button" class="btn btn-success"
                                style="width:100%; max-width:180px;height:50px;" onclick="setCamOnOff();"
                                id="cameraButton">lg camera</button>
                        </div>
                    </div>
                </div>

                <!-- Joiner Panel Section -->
                <div class="col-12 col-md-5" id="joiner_panel">
                    <div class="row">
                        <div class="col-4 offset-4 col-sm-2 offset-sm-2  text-center">

                            @if($callInformationSession['lobby_profile_pic'] == 'no')
                                <img src="ProfileImages/Images/<?php    echo $caller_profile_pic;?>"
                                    style="width:80px;height:80px;border-radius: 50%;" id="join_person_pic">

                            @else
                                <img src="<?php    echo $callInformationSession['lobby_profile_pic'];?>"
                                    style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                            @endif
                        </div>
                        <div class="col-12 col-sm-6">
                            <p class="text-center" style="font-size: 30px; font-weight: bold; color:#090a01;">Caller
                                Name:</p>
                            <p class="text-center" id="joiner_name"
                                style="font-size: 25px; font-weight: bold; color:#090a01;"><?php echo $caller_name;?>:
                            </p>
                        </div>
                    </div>
                    <?php  if ($callInformationSession['is_direct_entry'] == 'no') {?>
                    <div class="row mt-4" id="moving_circle_row">
                        <div class="col-10 offset-1 text-center d-flex justify-content-center">
                            <div class="circle-wrapper-mobile">
                                <div class="moving-circle-mobile"></div>
                            </div>
                        </div>
                    </div>
                    <?php  }?>
                    <div class="row mt-4" id="Joining_message" style="display:none;">
                        <div class="col-12 border" style="display: flex; justify-content: center; align-items: center;">
                            <!-- The glamorous message -->
                            <div class="message" style="color:red;">You cannot join for now</div>
                        </div>
                    </div>
                    @if(!isset($message))
                        <div class="row mt-5" id="join_call_button"
                            style="display: <?php    echo ($callInformationSession['is_direct_entry'] == 'yes') ? 'block' : 'none'; ?>;">
                            <div class="col-12" style="display: flex; justify-content: center; align-items: center;">
                                <button type="button" class="btn  btn-success" onclick="joinVideoCallRomm();"
                                    style="width:180px;height:50px;">
                                    Join Video Call
                                </button>
                            </div>
                        </div>
                    @endif

                    @if(isset($message))
                        <div class="row mt-4">
                            <div class="col-12 border" style="display: flex; justify-content: center; align-items: center;">
                                <!-- The glamorous message -->
                                <div class="message" style="color:red;">{{ $message }}</div>
                            </div>
                        </div>

                    @endif


                </div>
            </div>
        </div>
    </section>
    <?php  if ($callInformationSession['lobby_intro_video'] != 'no_file') {?>
    <section class="d-flex justify-content-center align-items-center w-100">
        <video class="video-player" controls>
            <source src="{{ $callInformationSession['lobby_intro_video'] }}" type="video/mp4">

        </video>
    </section>
    <?php } ?>

    <section>
        <?php
if ($callInformationSession['is_text_ticker'] == 'yes') {?>
        <div class="row">
            <div class="ticker-container">
                <div class="ticker" id="ticker">
                    <?php
    $content = $callInformationSession['text_ticker_content'];
    echo "<span>" . $content . "</span>"; // Initially load the content
                    ?>
                </div>
            </div>
        </div>
        <?php  }?>

    </section>
</body>


<script>
    var videoElement = document.getElementById('video');
    var startCameraButton = document.getElementById('start-camera');
    var camStatus = true;
    var micStatus = true;
    var stream = null;

    function joinVideoCallRomm() {
        window.open("{{route('videocalldashboardmobileReceiverNormalMeeting')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channel_id=" + encodeURIComponent('<?php echo $channel_id; ?>'), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=400, height=1000");
        window.close();
    }
    // Function to start the camera and display video
    // Select the ticker container and get the initial ticker text content
    const tickerElement = document.getElementById('ticker');
    const tickerText = '<?php echo addslashes($callInformationSession['text_ticker_content']); ?>'; // Ensure the content is properly escaped for JavaScript
    // Function to continuously append text to the ticker
    function appendTickerText() {
        if(tickerElement){
            const newTickerItem = document.createElement('span');
            newTickerItem.textContent = tickerText;
            tickerElement.appendChild(newTickerItem);
        }

    }
    setInterval(appendTickerText, 500);
    // Request access to the user's webcam
    navigator.mediaDevices.getUserMedia({ video: true })
        .then(stream => {
            this.stream = stream;
            // Set the video element's source to the webcam stream
            videoElement.srcObject = stream;
        })
        .catch(error => {
            console.error('Error accessing webcam: ', error);
        });


    window.onload = function () {
        window.scrollTo(0, document.body.scrollHeight);
        checkLobyWaitingClients();
    };
    function checkLobyWaitingClients() {
        setInterval(function () {
            console.log('checking clients waiting in loby');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('CheckCallerAcceptCall.post')}}",
                data: { 'channelId': '<?php echo $channel_id; ?>' },
                success: function (data) {
                    var obj = JSON.parse(data);

                    if ('is_call_accepted' in obj) {

                        if (obj.is_call_accepted == 'yes') {
                            document.getElementById("join_call_button").style.display = 'block';
                            document.getElementById("moving_circle_row").style.display = 'none';
                            // window.open("{{route('videocalldashboardmobileReceiverNormalMeeting')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channel_id=" + encodeURIComponent('<?php echo $channel_id; ?>'), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=400, height=1000");

                        }
                    }
                    if ('is_call_rejected' in obj) {
                        if (obj.is_call_rejected == 'yes') {

                            document.getElementById("moving_circle_row").style.display = "none";
                            document.getElementById("Joining_message").style.display = "block";
                        }
                    }








                }, error: function (xhr, status, error) {
                    //  alert(xhr.responseText);
                }
            });

        }, 4000);
    }//...................................................


    function deleteLobyWaitingUserEntryFromDB(channelId) {
        setInterval(function () {
            console.log('checking video call..............');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('DeleteLobyWaitingClientEntry')}}",
                data: { 'channelId': channelId },
                success: function (data) {

                }, error: function (xhr, status, error) {
                    //  alert(xhr.responseText);
                }
            });

        }, 4000);
    }//...................................................


    function setCamOnOff() {
        var button = document.getElementById("cameraButton");

        if (camStatus == true) {
            videoElement.srcObject = null;
            camStatus = false;
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");

        } else {
            videoElement.srcObject = stream;
            camStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }

    }
    function setMicOnOff() {
        var button = document.getElementById("micButton");
        if (micStatus == true) {
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");
            micStatus = false;
        } else {

            micStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }
    }
    function OpenVideoCallingWindow() {
        window.open("{{route('NormalMeetingVideoCallMobileView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000,height=1000");

        window.close();
    }


</script>



<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
    integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
    </script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
    integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
    </script>
<script type="text/javascript" src="js//url.js"></script>


</body>


</html>