<?php

$callInformationSession = Session::get('VideoCallInfo');

?>
<!DOCTYPE html>
<html>

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://cdn.webrtc-experiment.com/MediaStreamRecorder.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/loby.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src='js//AgoraRTC_N-4.11.0.js'></script>
    <script src='js//agora-rtm-sdk-1.5.1.js'></script>
    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <script src="https://www.webrtc-experiment.com/MultiStreamsMixer.js"></script>
    <!-- Font Awesome CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        .message {
            font-size: 30px;
            /* Larger text */
            color: #fff;
            /* White text */
            font-weight: bold;
            /* Bold text */
            text-transform: uppercase;
            /* Make it uppercase */
            letter-spacing: 2px;
            /* Space out the letters */
            background: linear-gradient(45deg, #ff007f, #ff7f00);
            /* Beautiful gradient */
            -webkit-background-clip: text;
            /* Clip gradient to text */
            background-clip: text;
            /* Clip gradient to text */
            padding: 20px 40px;
            /* Spacious padding around text */
            border-radius: 10px;
            /* Rounded corners */
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            /* Shadow for depth */
            text-align: center;
            /* Centered text */
            animation: glamMessage 3s ease-in-out infinite;
            /* Add an animation */
        }

        /* Glamorous animation */
        @keyframes glamMessage {
            0% {
                transform: scale(1);
                opacity: 0.8;
            }

            50% {
                transform: scale(1.1);
                opacity: 1;
            }

            100% {
                transform: scale(1);
                opacity: 0.8;
            }
        }

        /* Container for the ticker */
        .ticker-container {
            width: 100%;
            /* Ensure it's responsive */
            overflow: hidden;
            /* Hide anything that goes outside of the container */
            position: relative;
            background-color: #2d3e50;
            color: #ffffff;
            padding: 10px 0;

        }

        .ticker {
            display: flex;
            /* Flexbox for continuous inline elements */
            white-space: nowrap;
            /* Prevent line breaks */
            animation: ticker-animation 60s linear;
            font-size: 20px;
            padding-left: 30%;
            font-weight: bold;
        }

        .ticker span {
            padding-right: 20px;
            /* Optional: space between ticker items */
        }

        @keyframes ticker-animation {
            0% {
                transform: translateX(100%);
                /* Start from the right side (off-screen) */
            }

            100% {
                transform: translateX(-100%);
                /* Move to the left side (off-screen) */
            }
        }

        .video-player {
            max-width: 60%;
            /* Limits the video width */
            max-height: 60%;
            /* Limits the video height */
        }
    </style>
</head>

<body>
    <section class="section" style="background-image: url('{{ $callInformationSession['lobby_background_pic'] }}'); background-size: cover; background-position: center; background-repeat: no-repeat;height:400px;">
    </section>
    <section class="section">
        <div class="heading">
            <div class="row">
                <h2 class="title">Loby</h2>
            </div>
            <div class="row">
                <h3 class="subtitle">Group Call Loby Room {{ $callInformationSession['lobby_meeting_name'] }}</h3>
            </div>
        </div>
    </section>

    <section>
        <div class="heading mt-5">
            <div class="row">
                <div class="col-1 offset-2">
                    @if($callInformationSession['lobby_profile_pic'] == 'no')
                        <img src="ProfileImages/Images/<?php    echo $rec_profile_img;?>"
                            style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                    @else
                        <img src="<?php    echo $callInformationSession['lobby_profile_pic'];?>"
                            style="width:80px;height:80px;border-radius: 50%;" id="caller_profile_pic">
                    @endif
                </div>
                <div class="col-2">
                    <p style="font-size: 30px; font-weight: bold; color:#090a01;">Participant:</p>
                    <p style="font-size: 25px; font-weight: bold; color:#090a01;"><?php echo $rec_name;?></p>
                </div>
            </div>

        </div>
    </section>
    <section>
        <div class="video_call_box mt-3">
            <div class="row">
                <div class="col-4 offset-1">
                    <div class="row">
                        <div class="col-12" id="video-container">
                            <video id="video" width="530" height="360" autoplay
                                style="background-color:black; border-radius: 10px;"></video>
                        </div>
                    </div>
                    <div class="row mt-1">
                        <div class="col-3 offset-2"
                            style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn btn-success" style="width:180px;height:50px;"
                                onclick="setMicOnOff();" id="micButton">mic-hd</button>
                        </div>
                        <div class="col-3" style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn btn-success" style="width:180px;height:50px;"
                                onclick="setCamOnOff();" id="cameraButton">lg
                                camera</button>
                        </div>
                    </div>
                </div>
                <div class="col-5" id="joiner_panel" style="display:block;">

                    <div class="row">
                        <div class="col-2 offset-2">
                            <img src="ProfileImages/Images/<?php echo $caller_profile_pic;?>"
                                style="width:80px;height:80px;border-radius: 50%;" id="join_person_pic">
                        </div>
                        <div class="col-4 ">
                            <p style="font-size: 30px; font-weight: bold; color:#090a01;">Caller Name:</p>
                            <p id="joiner_name" style="font-size: 25px; font-weight: bold; color:#090a01;">
                                <?php echo $caller_name;?></p>
                        </div>
                    </div>
                    <?php  if ($callInformationSession['is_direct_entry'] == 'no') {?>
                    <div class="row mt-5" id="moving_circle_row">
                        <div class="col-10" style="display: flex; justify-content: center; align-items: center;">
                            <div class="circle-wrapper">
                                <div class="moving-circle"></div>
                            </div>
                        </div>
                    </div>
                    <?php  }?>
                    <div class="row mt-5" id="Joining_message" style="display:none;">
                        <div class="col-10" style="display: flex; justify-content: center; align-items: center;">
                            <!-- The glamorous message -->
                            <div class="message" style="color:red;">You cannot join for now</div>
                        </div>
                    </div>

                    <div class="row mt-4" id="join_call_button"
                        style="display: <?php echo ($callInformationSession['is_direct_entry'] == 'yes') ? 'block' : 'none'; ?>;">
                        <div class="col-4 offset-2"
                            style="display: flex; justify-content: center; align-items: center;">
                            <button type="button" class="btn  btn-primary" onclick="joinVideoCallRomm();"
                                style="width:180px;height:50px;">
                                Join Video Call
                            </button>
                        </div>
                    </div>


                </div>
                <?php  if ($callInformationSession['can_see_waiting_people'] == 'yes') {?>
                <div class="col-md-2">
                    <div class="row"><div class="col-md-11 titlemob">Waiting Area Users</div></div>
                     <div class="row">
                    <div class="col-md-12" id="waiting_area_list">

                     </div>
                     </div>

                </div>
                <?php } ?>
            </div>

        </div>
    </section>
 <?php  if ($callInformationSession['lobby_intro_video'] != 'no_file') {?>
        <section class="d-flex justify-content-center align-items-center w-100">
        <div class="row">
        <div class="col-md-12 ">
        <h2 class="title">Introductory Video</h2>
        </div>
    </div>
        </section>
     <section class="d-flex justify-content-center align-items-center w-100">

        <div class="row">
            <div class="col-md-12 text-center">
        <video class="video-player" controls style="border-radius: 20px; border: 2px solid black;" muted autoplay>
            <source src="{{ $callInformationSession['lobby_intro_video'] }}" type="video/mp4">

        </video>
        </div>
        </div>
    </section>
    <?php } ?>
    <br><br>
    <section>
        <?php
if ($callInformationSession['is_text_ticker'] == 'yes') {?>
        <div class="row">
            <div class="ticker-container">
                <div class="ticker" id="ticker">
                    <?php
                     $content = $callInformationSession['text_ticker_content'];
                     echo "<span>" . $content . "</span>"; // Initially load the content
                    ?>
                </div>
            </div>
        </div>
        <?php  }?>

    </section>
</body>


<script>
    var videoElement = document.getElementById('video');
    var startCameraButton = document.getElementById('start-camera');
    var camStatus = true;
    var micStatus = true;
    var stream = null;


    // Select the ticker container and get the initial ticker text content
    const tickerElement = document.getElementById('ticker');
    const tickerText = '<?php echo addslashes($callInformationSession['text_ticker_content']); ?>'; // Ensure the content is properly escaped for JavaScript
    // Function to continuously append text to the ticker
    function appendTickerText() {
        if(tickerElement){
            const newTickerItem = document.createElement('span'); // Create a new span for the new ticker text
        newTickerItem.textContent = tickerText; // Add the ticker content to the new span
        tickerElement.appendChild(newTickerItem); // Append the new span to the ticker
        }

    }
    setInterval(appendTickerText, 500);
    // Function to start the camera and display video

    // Request access to the user's webcam
    navigator.mediaDevices.getUserMedia({ video: true })
        .then(stream => {
            this.stream = stream;
            // Set the video element's source to the webcam stream
            videoElement.srcObject = stream;
        })
        .catch(error => {
            console.error('Error accessing webcam: ', error);
        });


    window.onload = function () {
        window.scrollTo(0, document.body.scrollHeight);
        checkLobyWaitingClients();
    };

    function joinVideoCallRomm() {
        window.open("{{route('NormalMeetingVideoCallReceiverDesktopView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channel_id=" + encodeURIComponent('<?php echo $channel_id; ?>'), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000, height=1000");
        window.close();
    }
    function checkLobyWaitingClients() {
        setInterval(function () {
            console.log('checking clients waiting in loby');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('CheckCallerAcceptCall.post')}}",
                data: { 'channelId': '<?php echo $channel_id; ?>' },
                success: function (data) {
                    var obj = JSON.parse(data);







                    if ('is_call_accepted' in obj) {
                        if (obj.is_call_accepted == 'yes') {
                            document.getElementById("join_call_button").style.display = 'block';

                            if (document.getElementById("moving_circle_row")) {
                                document.getElementById("moving_circle_row").style.display = 'none';
                            }
                            //   window.open("{{route('NormalMeetingVideoCallReceiverDesktopView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channel_id=" + encodeURIComponent('<?php echo $channel_id; ?>'), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000, height=1000");
                            //   window.close();
                        }
                        // window.close();
                    }

                    // if (obj.is_call_accepted == 'yes') {
                    //     window.open("{{route('NormalMeetingVideoCallReceiverDesktopView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus) + "&channel_id=" + encodeURIComponent('<?php echo $channel_id; ?>'), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000, height=1000");
                    //     window.close();
                    // } else
                    if ('is_call_rejected' in obj) {

                        if (obj.is_call_rejected == 'yes') {
                            if (document.getElementById("moving_circle_row")) {
                                document.getElementById("moving_circle_row").style.display = 'none';
                            }
                            document.getElementById("Joining_message").style.display = "block";
                        }

                    }


                    if (obj.waitingParticipant) {
                            if( document.getElementById("waiting_area_list")){
                                document.getElementById("waiting_area_list").innerHTML = '';
                            }

                            var dataObjUser = obj.waitingParticipant;
                             dataObjUser.forEach(function (dataObjrow) {

                                 createModalNewClientJoingRoomForParticipant(0, dataObjrow.participant_name, dataObjrow.participant_profile_pic, dataObjrow.email_id, 00);
                             });

                        }

                }, error: function (xhr, status, error) {

                }
            });

        }, 4000);
    }//


    function deleteLobyWaitingUserEntryFromDB(channelId) {
        setInterval(function () {
            console.log('checking video call..............');
            $.ajax({
                type: 'POST',
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{ route('DeleteLobyWaitingClientEntry')}}",
                data: { 'channelId': channelId },
                success: function (data) {

                }, error: function (xhr, status, error) {
                    //  alert(xhr.responseText);
                }
            });

        }, 4000);
    }//...................................................
    function createModalNewClientJoingRoomForParticipant(modelId, participantName, participantProfile, participant_email, channel_id) {
            // Create a div for the row
            var rowDiv = document.createElement("div");
            rowDiv.classList.add("row");
            rowDiv.id = modelId;
            // Create the first column (Image)
            var col1 = document.createElement("div");
            col1.classList.add("col-6");
            var img = document.createElement("img");
            img.src = "ProfileImages/Images/" + participantProfile;  // Add the image URL
            img.style.height = "75px";
            img.style.width = "74px";
            img.style.borderRadius = "50%";
            img.classList.add("img-fluid");
            col1.appendChild(img);

            // Create the second column (Name)
            var col2 = document.createElement("div");
            col2.classList.add("col-6");
            col2.classList.add("d-flex");
            col2.classList.add("justify-content-center");
            col2.classList.add("align-items-center");
            var name = document.createElement("h5");
            name.style.fontWeight = "bold";
            name.textContent = participantName;  // Replace with dynamic name if needed
            col2.appendChild(name);

            // Create the third column (Accept Button)
            var col3 = document.createElement("div");
            col3.classList.add("col-3");
            var acceptButton = document.createElement("button");
            acceptButton.classList.add("btn", "btn-success");
            acceptButton.textContent = "Accept";
            acceptButton.disabled = true;
            acceptButton.style.opacity = "0.5";
            acceptButton.style.width = "100%";  // Set a specific width (e.g., 100px)
            acceptButton.style.height = "50px"; // Set a specific height (e.g., 30px)

            col3.appendChild(acceptButton);


            var col4 = document.createElement("div");
            col4.classList.add("col-3");
            var rejectButton = document.createElement("button");
            rejectButton.classList.add("btn", "btn-danger");
            rejectButton.textContent = "Reject";
            rejectButton.disabled = true;
            rejectButton.style.opacity = "0.5";
            rejectButton.style.width = "100%";  // Set a specific width (e.g., 100px)
            rejectButton.style.height = "50px"; // Set a specific height (e.g., 30px)

            col4.appendChild(rejectButton);

            // Append the columns to the row
            rowDiv.appendChild(col1);
            rowDiv.appendChild(col2);
            // rowDiv.appendChild(col3);
            // rowDiv.appendChild(col4);
             if(document.getElementById("waiting_area_list")){
            // Append the row to the modal body (or any other container you want)
               document.getElementById("waiting_area_list").appendChild(rowDiv);
             }

            //   $('#WaitingAreaUserModel').modal('show');

        }
    function setCamOnOff() {
        var button = document.getElementById("cameraButton");
        if (camStatus == true) {
            videoElement.srcObject = null;
            camStatus = false;
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");

        } else {
            videoElement.srcObject = stream;
            camStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }
    }
    function setMicOnOff() {
        var button = document.getElementById("micButton");
        if (micStatus == true) {
            button.classList.remove("btn-success");
            button.classList.add("btn-danger");
            micStatus = false;
        } else {

            micStatus = true;
            button.classList.remove("btn-danger");
            button.classList.add("btn-success");
        }
    }
    function OpenVideoCallingWindow() {
        window.open("{{route('NormalMeetingVideoCallDesktopView')}}?camStatus=" + encodeURIComponent(camStatus) + "&micStatus=" + encodeURIComponent(micStatus), "_blank", "toolbar=yes, scrollbars=yes, resizable=yes, top=500,left=500,width=1000,height=1000");
        window.close();
    }
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"
    integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous">
    </script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"
    integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous">
    </script>
<script type="text/javascript" src="js//url.js"></script>
</body>

</html>