<?php

use App\Models\Follower;
use App\Models\Organisation;
use App\Models\Education;
use App\Models\Individual;
use App\Models\comments_adds;
use App\Models\PostLike;
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">
    <link rel="stylesheet" href="css/videocall.css">
    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>

    <script src="js/countrypicker.js"></script>


    <script type="text/javascript" src="js//url.js"></script>

</head>
    <body>
        @include('homedesktopheader')

        <div class="container">
            <div class="profile-banner">
                <div class="cover-img-box">

                    <img src="ProfileImages/Images/{{$userProfileVisiterData['CoverPic']}}" alt="img" />

                </div>
                <div class="profile-banner-content">
                    <div class="content-header">
                        <div class="inner1">
                            <div class="profile-img-and-info-box">
                                <div class="profile-img-box">

                                    <img src="ProfileImages\Images\{{$userProfileVisitedUser['profile_picture']}}" alt="img" />

                                </div>
                                <div class="user-name-box">
                                    <h3 class="user-name mb-0"><?php  echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name'] ; ?></h3>
                                    <div class="text-mini">{{$userProfileVisiterData['followerCount']}} Followers | {{$userProfileVisiterData['followingCount']}} Following</div>
                                </div>
                            </div>
                        </div>
                        <div class="inner2">
                        <a href="javascript:void(0)" id="followLink<?php echo $userProfileVisitedUser['email_id']; ?>" onclick="addFollows('<?php echo $userProfileVisitedUser['email_id']; ?>');" class="wf-btn wf-btn-outline-primary min-w-unset text-mini">{{$userProfileVisiterData['IsFollow']}}</a>
                            <a href="javascript:void(0)" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-commenting" aria-hidden="true" onclick="popupChat('<?php echo $userProfileVisitedUser['email_id']; ?>','<?php echo $userProfileVisitedUser['profile_picture'];?>','<?php echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name']?>');"></i></a>
                            <a href="javascript:void(0);" onclick="OpenVideoChatDialog('<?php echo $userProfileData['first_name'].'  '. $userProfileData['second_name'];?>','<?php echo $userProfileData['profile_picture'];?>','<?php echo $userProfileVisitedUser['first_name'].'  '. $userProfileVisitedUser['second_name'];?>','<?php echo $userProfileVisitedUser['profile_picture'];?>','<?php echo $userProfileVisitedUser['email_id'];?>' );" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-video-camera" aria-hidden="true"></i></a>


                            <a href="#" class="wf-btn wf-btn-primary min-w-unset"><i class="fa fa-ellipsis-v" aria-hidden="true"></i></a>
                        </div>
                    </div>
                    <div class="content-footer">
                        <ul class="nav nav-tabs wf-nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="posts-tab" data-bs-toggle="tab" data-bs-target="#posts" type="button" role="tab" aria-controls="posts" aria-selected="true">Posts</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="about-tab" data-bs-toggle="tab" data-bs-target="#about" type="button" role="tab" aria-controls="about" aria-selected="false">About</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="followers-tab" data-bs-toggle="tab" data-bs-target="#followers" type="button" role="tab" aria-controls="followers" aria-selected="false">Followers</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="exams-tab" data-bs-toggle="tab" data-bs-target="#exams" type="button" role="tab" aria-controls="exams" aria-selected="false">Examss</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="interviews-tab" data-bs-toggle="tab" data-bs-target="#interviews" type="button" role="tab" aria-controls="interviews" aria-selected="false">Interviews</button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="posts" role="tabpanel" aria-labelledby="posts-tab">
                    <div class="px-lg-5 pt-5 py-lg-5">
                        <div class="commnader-grid">
                            <div class="inner2">

                                <div class="posts-container">
                                    @foreach ($UserPostDataVisitedUser as $userpostdata)
                                    <div class="single-post mb-3">
                                        <div class="profile-avatar-box p-0 border-0">
                                            <div class="img-box">
                                                <img class="user-img" src="ProfileImages\Images\{{$userProfileVisitedUser['profile_picture']}}" alt="img">
                                            </div>
                                            <div class="user-info-box">
                                                <h4 class="fw-bold mb-1"><?php  echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name'] ; ?></h4>
                                                <p class="mb-0 text-mini">Time: {{$userpostdata['created_at']}}</p>
                                            </div>
                                        </div>
                                        <div class="post-bottom-content">
                                            <div class="post-description">
                                                <p>{{$userpostdata['PostText']}}</p>
                                            </div>
                                            <div class="post-image-box post-image-box2" data-bs-toggle="modal" data-bs-target="#post-images-modal2<?php echo $userpostdata['id'];?>">
                                                <?php
                                                       $imageArraySize=0;
                                                       $path = public_path("PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] );
                                                     try {
                                                       $files = array_slice(scandir($path), 2);
                                                         $imageArraySize = count($files);
                                                     }
                                                       catch(Exception $e) {

                                                     }

                                                if ($imageArraySize == 1) {
                                                    $postImgeUrl = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $files[0];
                                                  ?>
                                                <div>
                                                    <img src="{{$postImgeUrl}}" alt="post-img">
                                                </div>
                                                  <?php
                                                  }else if  ($imageArraySize == 2){
                                                    $postImgeUrl1 = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName']  . "/" . $files[0];
                                                    $postImgeUrl2 = "PostImages/" . $userpostdata['email_id']. "/" . $userpostdata['PostImgeName']  . "/" . $files[1];
                                                 ?>
                                                <div>
                                                    <img src="{{$postImgeUrl1}}" alt="post-img">
                                                </div>
                                                <div>
                                                    <img src="{{$postImgeUrl2}}" alt="post-img">
                                                </div>
                                                 <?php
                                                  }else if  ($imageArraySize > 2){

                                                    $postImge = "PostImages/" . $userpostdata['email_id'] . "/" . $userpostdata['PostImgeName']  . "/" . $files[0];
                                                    $postImgeUrl2 = "PostImages/" . $userpostdata['email_id']. "/" . $userpostdata['PostImgeName']  . "/" . $files[1];
                                                  ?>
                                                <div>
                                                    <img src="{{$postImge}}" alt="post-img">

                                                </div>
                                                <div class="img-count">+<?php echo $imageArraySize - 2; ?>   </div>
                                                <div>
                                                <img src="{{$postImgeUrl2}}" alt="post-img" >

                                                </div>

                                                    <?php

                                                  }
                                                  ?>


                                            </div>
                                            <!-- post images modal for 2 images -->
                                            <div class="modal fade" id="post-images-modal2<?php echo $userpostdata['id'];?>" tabindex="-1" aria-labelledby="post-images-modalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered modal-lg ui-draggable ui-draggable-handle">
                                                    <div class="modal-content bg-dark ui-resizable">
                                                        <div class="modal-header border-0 pb-0">
                                                            <button type="button" style="filter: contrast(0);" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div id="post-images-carousel2<?php echo $userpostdata['id'];?>" data-interval="false" class="carousel slide pointer-event" data-bs-ride="carousel">
                                                                <div class="carousel-inner" style="text-align:center;">
                                                                <?php
                                                                if (empty($files) == false) {
                                                                    $imgCount=0;
                                                                    foreach ($files as $imgURL) {
                                                                    $postImgeUrl = "PostImages/" .$userpostdata['email_id'] . "/" . $userpostdata['PostImgeName'] . "/" . $imgURL;
                                                                if($imgCount==0){
                                                                    $imgCount=$imgCount+1;
                                                                    ?>
                                                                <div class="carousel-item active">
                                                                        <img src="{{$postImgeUrl}}" alt="post-img">
                                                                </div>
                                                                    <?php
                                                                }else{
                                                                    ?>
                                                                <div class="carousel-item">
                                                                        <img src="{{$postImgeUrl}}" alt="post-img">
                                                                </div>
                                                                    <?php

                                                                }
                                                                ?>

                                                                 <?php
                                                                    }
                                                                }
                                                                 ?>


                                                                </div>
                                                                <button class="carousel-control-prev" type="button" data-bs-target="#post-images-carousel2<?php echo $userpostdata['id'];?>" data-bs-slide="prev">
                                                                    <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                                                    <span class="visually-hidden">Previous</span>
                                                                </button>
                                                                <button class="carousel-control-next" type="button" data-bs-target="#post-images-carousel2<?php echo $userpostdata['id'];?>" data-bs-slide="next">
                                                                    <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                                                    <span class="visually-hidden">Next</span>
                                                                </button>
                                                            </div>
                                                        </div>
                                                    <div class="ui-resizable-handle ui-resizable-e" style="z-index: 90;"></div><div class="ui-resizable-handle ui-resizable-s" style="z-index: 90;"></div><div class="ui-resizable-handle ui-resizable-se ui-icon ui-icon-gripsmall-diagonal-se" style="z-index: 90;"></div></div>
                                                </div>
                                            </div>
                                            <!-- post images modal end -->

                                            <div class="post-actions">
                                                <div class="post-like-action">
                                                <?php
                                                   $LikeInfo =   GetPostLikeCheck::getPostLikeCount($userpostdata['created_at'],$userProfileData['email_id']);
                                                   $linkeCC= GetPostLikeCheck::getPostLikeCountValue($userpostdata['created_at']);

                                                    if ($LikeInfo == 'Like') {
                                                     ?>

                                                    <span class="cursor-pointer"><i class="fa fa-thumbs-up" id="likeSymble<?php echo $userpostdata['created_at']; ?>" style="font-size:24px" onclick="LikeFunction('<?php echo $userpostdata['created_at']; ?>');" ></i> </span>
                                                    <span class="ms-2 text-mini" id="likeCounting<?php echo $userpostdata['created_at']; ?>">{{$linkeCC}}</span>
                                                    <?php
                                                      }else{
                                                    ?>
                                                    <span class="cursor-pointer"><i class="fa fa-thumbs-o-up" id="likeSymble<?php echo $userpostdata['created_at']; ?>" style="font-size:24px" onclick="LikeFunction('<?php echo $userpostdata['created_at']; ?>');" data-bs-toggle="tooltip" title="Like" aria-hidden="true"></i></span>
                                                    <span class="ms-2 text-mini" id="likeCounting<?php echo $userpostdata['created_at']; ?>">{{$linkeCC}}</span>
                                                    <?php
                                                      }
                                                    ?>
                                                </div>
                                                <div class="post-comments-action ms-auto text-mini">
                                                    <a class="text-decoration-none cursor-pointer text-secondary" data-bs-toggle="modal" data-bs-target="#commentsModel<?php echo $userpostdata['id'];?>">Comments</a>
                                                </div>
                                            </div>

                                            <!-- comments modal -->


                                            <!-- Modal -->
                                            <div class="modal fade" id="commentsModel<?php echo $userpostdata['id'];?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                                <div class="modal-dialog modal-dialog-centered">
                                                    <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel">Comments</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="all-comments">
                                                        <?php
                                                             $result6 = comments_adds::where('post_id',  $userpostdata['created_at'])->orderBy('id', 'DESC')->get();
                                                             if (count($result6) > 0) {
                                                              foreach ($result6 as $roww) {
                                                                $commentsTxt = $roww["comments_txt"];
                                                                $liker_Email = $roww["liker_email"];
                                                                $comments_date_time = $roww["created_at"];
                                                                $profile_image_liker = "";
                                                                $fullNameShow = "";
                                                                $result7 = Education::where('email_id', $liker_Email)->get();
                                                                if (count($result7) > 0) {
                                                                  foreach ($result7 as $roww) {
                                                                      $profile_image_liker = $roww["profile_picture"];
                                                                      $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                              }
                                                             } else {
                                                                       $result7 = Individual::where('email_id', $liker_Email)->get();
                                                                          if (count($result7) > 0) {
                                                                                foreach ($result7 as $roww) {
                                                                                         $profile_image_liker = $roww["profile_picture"];
                                                                                            $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                                                }
                                                                          } else {


                                                                                   $result7 = Organisation::where('email_id', $liker_Email)->get();
                                                                                      if (count($result7) > 0) {
                                                                                           foreach ($result7 as $roww) {
                                                                                                 $profile_image_liker = $roww["profile_picture"];
                                                                                                 $fullNameShow = $roww["first_name"] . ' ' . $roww["second_name"];
                                                                                           }
                                                                                         }
                                                                                    }
                                                                        }

                                                                      ?>

                                                            <div class="single-commnet">
                                                                <div class="user-img">
                                                                    <img src="ProfileImages/Images/{{ $profile_image_liker}}" class="img-circle">
                                                                </div>
                                                                <div class="commnets-content">
                                                                    <div class="commnet-content-header">
                                                                        <div class="user-name">{{$fullNameShow}} </div>
                                                                        <div class="comment-date">{{ $comments_date_time}}</div>
                                                                    </div>
                                                                    <div class="commnet-text">{{$commentsTxt}}</div>
                                                                </div>
                                                            </div>
                                                            <?php
                                                                  }
                                                                  }

                                                            ?>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <div class="commnet-writing-area m-0 w-100">
                                                            <div class="inner1">
                                                                <input type="text" id="commentsBox<?php echo $userpostdata['created_at']; ?>" class="form-control" placeholder="Write comment">
                                                            </div>
                                                            <div class="inner2">
                                                                <button class="wf-btn wf-btn-primary" type="button" onclick="addComments('<?php echo $userpostdata['created_at']; ?>');">Post</button>
                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    @endforeach
                                    {{$UserPostDataVisitedUser->links()}}
                                </div>

                            </div>
                            <div class="inner3 d-lg-block d-none">
                                <div class="white-box mb-3">
                                    <h6 class="mb-3 fw-bold">Suggestions</h6>
                                   <?php


                                    foreach ($SuggestionsData as $dataArray) {

                                        $isFollowe = Follower::where([['email_id', '=', $dataArray['email_id']], ['follower_email_id', '=', $userProfileData['email_id']]])->get();
                                        $isFolloww = 'Follow';
                                        if (count($isFollowe) > 0) {
                                            $isFolloww = 'UnFollow';
                                        } else {
                                            $isFolloww = 'Follow';
                                        }


                                     ?>
                                    <div class="profile-avatar-box align-items-start mb-2">
                                        <div class="img-box">
                                            <img class="user-img" src="ProfileImages/Images/<?php echo $dataArray['ProfilePic'];?>" alt="" name="profile_img" id="profile_img" style="border-radius: 50%;">
                                        </div>
                                        <div class="user-info-box">
                                            <h6 class="fw-bold mb-0 text-capitalize">
                                                <a class="text-primary no-decoration d-block mb-2 cursor-pointer" href="{{ route('UserProfile') }}?profileUserEmailID=<?php echo $dataArray['email_id']; ?>"><?php echo $dataArray['FullName'];?></a>
                                                <div class="text-mini"><?php echo $dataArray['AccountType'];?> (<span id="countFollow<?php echo $dataArray['email_id']; ?>"><?php echo $dataArray['FollowCount'];?> </span>Followers)</div>
                                            </h6>
                                            <p class="mb-0 text-mini"><?php echo $dataArray['CityCountry'];?></p>
                                            <p class="mb-0 text-mini text-start">
                                                <a class="text-success no-decoration fw-bold" href="javascript:void(0);" style="color:blue" onclick="popupChat('<?php echo $dataArray['email_id']; ?>','<?php echo $dataArray['ProfilePic'];?>','<?php echo $dataArray['FullName'] ?>');">Start Chat</a>
                                            </p>
                                            <p class="mb-0 text-mini text-end">
                                                <a class="text-secondary no-decoration fw-bold" href="javascript:void(0);" id="followLink<?php echo $dataArray['email_id']; ?>" onclick="addFollows('<?php echo $dataArray['email_id']; ?>');">{{$isFolloww}}</a>
                                            </p>
                                        </div>
                                    </div>
                                    <?php
                                      }
                                    ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="about" role="tabpanel" aria-labelledby="about-tab">
                    <div class="px-lg-5 pt-5 py-lg-5">
                        <div class="commnader-grid">
                            <div class="inner1">
                                <div class="white-box mb-3">
                                    <a href="#" class="wf-btn wf-btn-primary w-100 mb-4" data-bs-toggle="modal" data-bs-target="#cvModal">CV</a>

                                    <!-- Modal -->
                                    <div class="modal fade" id="cvModal" tabindex="-1" aria-labelledby="cvModalLabel" aria-hidden="true">
                                        <div class="modal-dialog modal-xl ">
                                            <div class="modal-content" >
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="cvModalLabel"><?php  echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name'] ; ?>  CV</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                <!-- <iframe src="ProfileImages/CV/<?php echo $userProfileVisitedUser['cv'];?>" style="width: 100%; height: 800px;border: none;"></iframe> -->

                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <h6 class="fw-bold mb-3">Education</h6>

                                    @if(isset($diplomaEduVisitedUser) && count($diplomaEduVisitedUser) > 0)
                                    @foreach($diplomaEduVisitedUser as $userDiplomaEdu)
                                    @if(strlen($userDiplomaEdu['diploma_name']) > 0)
                                    <div class="mb-4">
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-graduation-cap" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Diploma: <span class="text-grey text-mini"> {{ $userDiplomaEdu['diploma_name'] }} </span></div>
                                        </div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-university" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Institute: <span class="text-grey text-mini">{{ $userDiplomaEdu['Institution_name'] }}</span></div>
                                        </div>
                                        <div class="d-flex flex-wrap justify-content-between gap-2 text-mini">
                                            <div>{{ $userDiplomaEdu['from_year'] }} to {{ $userDiplomaEdu['to_year'] }}</div>
                                            <div><a href="#" class="text-secondary no-decoration" data-bs-toggle="modal" data-bs-target="#editDiploma"></a></div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                    @endif

                                </div>
                                <div class="white-box mb-3">
                                    <h6 class="fw-bold mb-3">Work Experience</h6>

                                    @if(isset($workingExpVisitedUser) && count($workingExpVisitedUser) > 0)
                                    @foreach($workingExpVisitedUser as $userWorkingExp)
                                    @if(strlen($userWorkingExp['company']) > 0)
                                    <div class="mb-4">
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-briefcase" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Job Title: <span class="text-grey text-mini">{{ $userWorkingExp['job_title'] }}</span></div>
                                        </div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Institute: <span class="text-grey text-mini">{{ $userWorkingExp['company'] }}</span></div>
                                        </div>
                                        <div class="d-flex flex-wrap justify-content-between gap-2 text-mini">
                                            <div>{{ $userWorkingExp['from_year'] }} to {{ $userWorkingExp['to_year'] }}</div>
                                            <div><a href="#"  data-bs-toggle="modal" data-bs-target="#editWorkExperience" class="text-secondary no-decoration"></a></div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                    @endif
                                    <!-- <div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-briefcase" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Job Title: <span class="text-grey text-mini">Backend Development</span></div>
                                        </div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-building" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box">Institute: <span class="text-grey text-mini">Abekas | Lahore</span></div>
                                        </div>
                                        <div class="d-flex flex-wrap justify-content-between gap-2 text-mini">
                                            <div>2018 to current</div>
                                            <div><a href="#" class="text-secondary no-decoration"><i class="fa fa-pencil" aria-hidden="true"></i></a></div>
                                        </div>
                                    </div> -->
                                </div>
                            </div>
                            <div class="inner2">
                                <div class="white-box mb-3">
                                    <h4 class="mb-3">About</h4>
                                    @if(isset($userProfileVisitedUser['about_us']))
                                    <div>{{$userProfileVisitedUser['about_us']}}</div>
                                    @endif
                                </div>
                                <div class="white-box mb-3">
                                    <div class="mb-4">
                                        <h6 class="fw-bold mb-3">Overview</h6>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-envelope" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box text-secondary">Email: <span class="text-primary">{{$userProfileVisitedUser['email_id']}}</span></div>
                                        </div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-phone" aria-hidden="true"></i>
                                            </div>

                                            <div class="text-box text-secondary">Phone: <span class="text-primary">{{$userProfileVisitedUser['phone_number']}}</span></div>
                                        </div>
                                        <div class="icon-bar pb-2 mb-2 border-bottom">
                                            <div class="icon-box text-secondary">
                                                <i class="fa fa-map-marker" aria-hidden="true"></i>
                                            </div>
                                            <div class="text-box text-secondary">Address: <span class="text-primary">{{$userProfileVisitedUser['full_address']}}</span></div>
                                        </div>
                                    </div>
                                    <div>
                                        <h6 class="fw-bold mb-3">Social Connections</h6>
                                        <ul class="social-icons-list d-block mb-3 ms-4">
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['facebook']}}" class="me-2" id="facebookImageUrl"><i class="footer-social-icon fa fa-facebook"></i></i></a>
                                                <a href="{{$userProfileVisiterData['facebook']}}" class="text-primary no-decoration" id="personalFacebookUrl">{{$userProfileVisiterData['facebook']}}</a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['twiter']}}" class="me-2" id="twiterImageUrl"><i class="footer-social-icon fa fa-twitter"></i></i></a>
                                                <a href="{{$userProfileVisiterData['twiter']}}" class="text-primary no-decoration" id="personaltwiterUrl">{{$userProfileVisiterData['twiter']}}</a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['linkedin']}}" class="me-2" id="linkedinImageUrl"><i class="footer-social-icon fa fa-linkedin"></i></i></a>
                                                <a href="{{$userProfileVisiterData['linkedin']}}" class="text-primary no-decoration" id="personalLinkdinUrl">{{$userProfileVisiterData['linkedin']}}</a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['Instagram']}}" class="me-2" id="instagramImageUrl"><i class="footer-social-icon fa fa-instagram"></i></i></a>
                                                <a href="{{$userProfileVisiterData['Instagram']}}" class="text-primary no-decoration" id="personalInstagramUrl">{{$userProfileVisiterData['Instagram']}}</a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['youtube']}}" class="me-2" id="youtubeImageUrl"><i class="footer-social-icon fa fa-youtube"></i></i></a>
                                                <a href="{{$userProfileVisiterData['youtube']}}" class="text-primary no-decoration" id="personalYoutubeUrl">{{$userProfileVisiterData['youtube']}}</a>
                                            </li>
                                            <li class="mb-2">
                                                <a href="{{$userProfileVisiterData['githubube']}}" class="me-2" id="githubImageUrl"><i class="footer-social-icon fa fa-github"></i></i></a>
                                                <a href="{{$userProfileVisiterData['githubube']}}" class="text-primary no-decoration" id="personalGithubUrl">{{$userProfileVisiterData['githubube']}}</a>
                                            </li>
                                        </ul>

                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="followers" role="tabpanel" aria-labelledby="followers-tab">
                    <div class="px-lg-5 pt-5 py-lg-5">
                        <div class="commnader-grid">
                            <div class="inner2">
                                <div class="white-box">
                                    <ul class="nav nav-tabs" id="myTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="myFollowers-tab" data-bs-toggle="tab" data-bs-target="#myFollowers" type="button" role="tab" aria-controls="myFollowers" aria-selected="true">Followers<span class="text-mini ms-2 p-1 px-2 rounded-large bg-primary text-white fw-bold">{{$userProfileVisiterData['followerCount']}}</span></button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="myFollowings-tab" data-bs-toggle="tab" data-bs-target="#myFollowings" type="button" role="tab" aria-controls="myFollowings" aria-selected="false">Following<span class="text-mini ms-2 p-1 px-2 rounded-large bg-primary text-white fw-bold">{{$userProfileVisiterData['followingCount']}}</span></button>
                                        </li>
                                    </ul>
                                    <div class="tab-content pt-3" id="myTabContent">
                                        <div class="tab-pane fade show active" id="myFollowers" role="tabpanel" aria-labelledby="myFollowers-tab">
                                            <div class="row gx-md-3 gy-3">
                                            @foreach ($followerDataVistedUser as $followerPerson)
                                            @if(strlen($followerPerson['email_id']) > 0)

                                                <div class="col-md-6 col-lg-4" id="unfollowUser<?php echo $followerPerson['email_id'];?>">
                                                    <div class="profile-avatar-box align-items-start mb-0">
                                                        <div class="img-box">
                                                            <img class="user-img" src="ProfileImages/Images/{{$followerPerson['ProfilePic']}}" alt="" name="profile_img" id="profile_img" style="border-radius: 50%;">
                                                        </div>
                                                        <div class="user-info-box">
                                                            <h6 class="fw-bold mb-0 text-capitalize">
                                                                <a class="text-primary no-decoration d-block mb-2 cursor-pointer">{{$followerPerson['FullName']}}</a>
                                                                <div class="text-mini">{{$followerPerson['AccountType']}} (<span id="countFollowaamir@gmail.com">{{$followerPerson['FollowCount']}} </span>Followers)</div>
                                                            </h6>
                                                            <p class="mb-0 text-mini">{{$followerPerson['CityCountry']}}</p>
                                                            <p class="mb-0 text-mini text-start">
                                                                <a class="text-success no-decoration fw-bold" href="javascript:void(0);" style="color:blue" onclick="popupChat('<?php echo $followerPerson['email_id']; ?>','<?php echo $followerPerson['ProfilePic'];?>','<?php echo $followerPerson['FullName'] ?>')">Start Chat</a>
                                                            </p>

                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @endforeach
                                            </div>
                                            <div class="mt-8">
                                         {{ $followerDataVistedUser ->withPath(url()->current())->links() }}
                                         </div>
                                        </div>
                                        <div class="tab-pane fade" id="myFollowings" role="tabpanel" aria-labelledby="myFollowings-tab">
                                            <div class="row gx-md-3 gy-3">

                                            @foreach ($followingDataVistedUser as $followingPerson)
                                            @if(strlen($followingPerson['email_id']) > 0)

                                                <div class="col-md-4">
                                                    <div class="profile-avatar-box align-items-start mb-0">
                                                        <div class="img-box">
                                                            <img class="user-img" src="ProfileImages/Images/{{$followingPerson['ProfilePic']}}" alt="" name="profile_img" id="profile_img" style="border-radius: 50%;">
                                                        </div>
                                                        <div class="user-info-box">
                                                            <h6 class="fw-bold mb-0 text-capitalize">
                                                                <a class="text-primary no-decoration d-block mb-2 cursor-pointer">{{$followingPerson['FullName']}}</a>
                                                                <div class="text-mini">{{$followingPerson['AccountType']}} (<span id="countFollowaamir@gmail.com">{{$followingPerson['FollowCount']}}</span>Followers)</div>
                                                            </h6>
                                                            <p class="mb-0 text-mini">{{$followingPerson['CityCountry']}}</p>
                                                            <p class="mb-0 text-mini text-start">
                                                                <a class="text-success no-decoration fw-bold" href="javascript:void(0);" style="color:blue" onclick="popupChat('<?php echo $followingPerson['email_id']; ?>','<?php echo $followingPerson['ProfilePic'];?>','<?php echo $followingPerson['FullName'] ?>')">Start Chat</a>
                                                            </p>
                                                            <p class="mb-0 text-mini text-end" style="visibility: hidden;">
                                                                <a class="text-secondary no-decoration fw-bold" href="javascript:void(0);">Unfollow</a>
                                                            </p>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @endforeach
                                            </div>
                                            <div class="mt-8">
                                         {{ $followingDataVistedUser ->withPath(url()->current())->links() }}
                                         </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="exams" role="tabpanel" aria-labelledby="exams-tab">
                    sdfsdfdsfdsfsdsdf
                    <div class="px-lg-5 pt-5 py-lg-5">
                        <div class="commnader-grid">
                            <div class="inner2">
                                <div class="white-box">
                                    <div class="row gy-4">
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <div class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="box-rounded-50px mb-2">
                                                        <!-- <img src="ProfileImages/Images/khawaja.jpg" alt="img" /> -->
                                                    </div>
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>React Javascript</b></div>
                                                    </div>
                                                    <div class="row gy-1 py-2 my-2 border-top border-bottom text-mini">
                                                        <div class="col-6">Level 1</div>
                                                        <div class="col-6 text-end">Status <span class="text-mini text-success">Completed</span></div>
                                                    </div>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini"><span class="me-2"><i class="fa fa-play" aria-hidden="true"></i></span>Play</a>
                                                        <a href="#" class="no-decoration text-white bg-primary rounded py-1 px-2 text-mini">Details</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="mt-5">
                                        <nav aria-label="Page navigation example">
                                            <ul class="pagination wf-pagination w-fit-content mx-auto">
                                                <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                                </li>
                                                <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                                <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade" id="interviews" role="tabpanel" aria-labelledby="interviews-tab">
                    <div class="px-lg-5 pt-5 py-lg-5">
                        <div class="commnader-grid">
                            <div class="inner2">
                                <div class="white-box mb-3">
                                    <div class="row gy-4">
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                        <div class="col-md-6 col-xl-4 col-xxl-3">
                                            <a href="#" class="interview-card rounded-large border d-block overflow-hidden no-decoration text-primary">
                                                <!-- <iframe width="100%" height="200" src="https://www.youtube.com/embed/asJ1kiSF-d4?si=-vlinGQJbMgdo7Ei" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe> -->
                                                <div class="p-3">
                                                    <div class="d-flex flex-wrap justify-content-between">
                                                        <div><b>John Doe</b></div>
                                                        <div class="text-mini text-secondary pt-1">13-03-2014</div>
                                                    </div>
                                                    <div class="row gx-2 gy-1 py-2 my-2 border-top border-bottom">
                                                        <div class="col-5"><b>Views:</b> <span class="text-secondary text-mini">100k</span></div>
                                                        <div class="col-7 text-end"><b>Previews:</b> <span class="text-secondary text-mini">22.3k</span></div>
                                                    </div>
                                                    <div><b>Type:</b> <span class="text-secondary text-mini">Automatic interview</span></div>
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="mt-5">
                                        <nav aria-label="Page navigation example">
                                            <ul class="pagination wf-pagination w-fit-content mx-auto">
                                                <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Previous">
                                                    <span aria-hidden="true">&laquo;</span>
                                                </a>
                                                </li>
                                                <li class="page-item active"><a class="page-link" href="#">1</a></li>
                                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                                <li class="page-item">
                                                <a class="page-link" href="#" aria-label="Next">
                                                    <span aria-hidden="true">&raquo;</span>
                                                </a>
                                                </li>
                                            </ul>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>



<!-- Write Your Post Modal......................................................... -->
    <div class="modal fade" id="addPostModel" tabindex="-1" role="dialog"
        aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5>Create Post</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" action="{{ route('UploadPost') }}" enctype="multipart/form-data">
                        @csrf

                        <div class="profile-avatar-box">
                            <div class="img-box bg-light">


                                <img class="user-img" src="ProfileImages\Images\{{$userProfileVisitedUser['profile_picture']}}" id="original_profile_image"
                                    alt="user image...">


                            </div>
                            <div class="user-info-box">
                                <h4 class="fw-bold mb-1" id="post"><?php  echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name'] ; ?></h4>

                            </div>
                        </div>



                        <div class="mb-3">
                            <textarea class="form-control" id="postboxx" name="postboxx" rows="4" placeholder="write your post..."></textarea>
                            <input type="hidden" class="form-control" value="<?php  echo $userProfileVisitedUser['email_id'];?>"
                                name="postEmailid" id="postEmailid">
                            <input type="hidden" class="form-control" value="<?php  echo $userProfileVisitedUser['first_name'].' '. $userProfileVisitedUser['second_name'] ; ?>"
                                name="fullname" id="fullname">
                        </div>

                        <div id="placehere" class="bg-lightgrey p-3 rounded text-center mb-3">
                            <div id="imgUploaderView" onclick="UploadClick();">
                                <div>
                                    <img src="logos/uploadIcon.png" class="mb-2" style="opacity:.5"
                                        alt="" width="30" id="viewImgPost" />
                                </div>
                                <div>{{ getJsonLocalization('home', "Upload Photo's") }}</div>
                            </div>
                            <div class="text-start" id="subPanelHolderImg" style="display:none;">
                                <button type="button" class="btn-close mb-2" onclick="clearImages();"></button>
                                <div id="imageAppender"
                                    class="stylish-scroll stylish-scroll-thin post-image-uploader"
                                    style="max-height:208px;
                    overflow-y: auto;">
                                </div>
                            </div>
                        </div>

                        <div class="border rounded mb-3">
                            <div class="row pb-2 px-2">
                                <div class="col-6">
                                    <label style="margin-top:10px;margin-left:4px;"
                                        onclick="UploadClick();">{{ getJsonLocalization('home', 'Add to your post') }}</label>
                                </div>
                                <div class="col-6" style="text-align: right;">
                                    <input type="file" multiple style="display:none;" id="uploadImg"
                                        name="uploadImg[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg1"
                                        name="uploadImg1[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg2"
                                        name="uploadImg2[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg3"
                                        name="uploadImg3[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg4"
                                        name="uploadImg4[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg5"
                                        name="uploadImg5[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg6"
                                        name="uploadImg6[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg7"
                                        name="uploadImg7[]" onchange="PreviewImage();">
                                    <input type="file" multiple style="display:none;" id="uploadImg8"
                                        name="uploadImg8[]" onchange="PreviewImage();">
                                    <img src="logos/imgicon.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;" onclick="UploadClick();">
                                    <img src="logos/person.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;" onclick="UploadClick();">
                                    <img src="logos/smilly.png" alt="" width="20" height="20"
                                        style="margin-top:10px;margin-left:4px;margin-right:2px;"
                                        onclick="UploadClick();">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer border-0 p-0">
                            <button type="submit"
                                class="wf-btn wf-btn-secondary">{{ getJsonLocalization('home', 'Post') }}</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<!-- End Write Your Post Modal......................................................... -->


<!-- Edit Work Experence Modal ..............................................................-->
<div id="editWorkExperience" class="modal fade" tabindex="-1" role="dialog"
        aria-labelledby="myModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{getJsonLocalization("home","Edit Work Experience")}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <form method="POST" action="updateWorkExperience">
                    <div class="modal-body">
                        <div class="text-center mb-3">
                            <img src="logos//logo1.png" alt="" width="100">
                        </div>

                        <div class="table-box scroll-from-ipad">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th scope="col">{{ getJsonLocalization('home', 'SNO') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Diploma') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Institution name') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'From year') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'To year') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Now') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @csrf

                                    <?php
                                      $recCounter=0;
                                        foreach ($workingExpVisitedUser as $wexperience)
                                        {
                                            $recCounter=$recCounter+1;

                                     ?>

                                    <tr>
                                        <td><?php echo $recCounter; ?></td>
                                        <td><input type="text" class="form-control"
                                                id="jobtitle<?php echo $recCounter; ?>"
                                                name="jobtitle<?php echo $recCounter; ?>" value="<?php echo $wexperience['job_title']; ?>">
                                        </td>
                                        <td><input type="text" class="form-control"
                                                id="company<?php echo $recCounter; ?>"
                                                name="company<?php echo $recCounter; ?>" value="<?php echo $wexperience['company']; ?>">
                                        </td>
                                        <td><input type="text" class="form-control"
                                                id="yearfromWorkExp<?php echo $recCounter; ?>"
                                                name="yearfromWorkExp<?php echo $recCounter; ?>"
                                                value="<?php echo $wexperience['from_year']; ?>"></td>
                                        <td><input type="text" class="form-control"
                                                id="yeartoWorkExp<?php echo $recCounter; ?>"
                                                name="yeartoWorkExp<?php echo $recCounter; ?>"
                                                value="<?php echo $wexperience['to_year']; ?>"></td>
                                        <td><input class="form-check-input" type="checkbox" value=""
                                                id="stillWorkingWorkingExp<?php echo $recCounter; ?>" value="0"
                                                name="stillWorkingWorkingExp<?php echo $recCounter; ?>"
                                                onclick="stillWorkingWorkingExp(this.id);"></td>
                                    </tr>


                                   <?php
                                            }

                                    ?>

                                </tbody>
                            </table>
                        </div>

                    </div>

                    <div class="modal-footer">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary">{{ getJsonLocalization('home', 'Update') }}</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
<!-- End Edit Work Experence Modal ..............................................................-->

<!-- Edit Education Modal.........................................................................-->
<div id="editDiploma" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="mb-0">{{ getJsonLocalization('home', 'Edit Education') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                        aria-label="Close"></button>
                </div>
                <form method="POST" action="updateDiplomaInfo">
                    <div class="modal-body">
                        <div class="text-center mb-3">
                            <img src="logos//logo1.png" alt="" width="100">
                        </div>
                        <div class="table-box scroll-from-ipad">
                            <table class="table table-striped" sodium_crypto_kx_client_session_keys>
                                <thead>
                                    <tr>
                                        <th scope="col">{{ getJsonLocalization('home', 'SNO') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Diploma') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Institution name') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'From year') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'To year') }}</th>
                                        <th scope="col">{{ getJsonLocalization('home', 'Now') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @csrf
                                    <?php
                                      $recCounter=0;
                                        foreach ($diplomaEduVisitedUser as $diplomaObj)
                                        {
                                            $recCounter=$recCounter+1;

                                     ?>
                                  <tr>
                                        <td><?php echo $recCounter; ?></td>
                                        <td><input type="text" class="form-control"
                                                id="dipname<?php echo $recCounter; ?>"
                                                name="dipname<?php echo $recCounter; ?>" value="<?php echo $diplomaObj['diploma_name']; ?>">
                                        </td>
                                        <td><input type="text" class="form-control"
                                                id="insname<?php echo $recCounter; ?>"
                                                name="insname<?php echo $recCounter; ?>" value="<?php echo $diplomaObj['Institution_name']; ?>">
                                        </td>
                                        <td><input type="text" class="form-control"
                                                id="yearfrom<?php echo $recCounter; ?>"
                                                name="yearfrom<?php echo $recCounter; ?>" value="<?php echo $diplomaObj['from_year']; ?>">
                                        </td>
                                        <td><input type="text" class="form-control"
                                                id="yearto<?php echo $recCounter; ?>" name="yearto<?php echo $recCounter; ?>"
                                                value="<?php echo $diplomaObj['to_year']; ?>"></td>
                                        <td><input class="form-check-input" type="checkbox" value=""
                                                id="stillworking<?php echo $recCounter; ?>" value="0"
                                                name="stillworking<?php echo $recCounter; ?>"
                                                onclick="stillWorking(this.id);"></td>
                                    </tr>

                                    <?php
                                            }

                                    ?>

                                </tbody>
                            </table>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="submit" class="wf-btn wf-btn-secondary">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

<!-- End Edit Education Modal.........................................................................-->














<script>
    //Adding Social Links To DataBase...........................................
function addSocialLinkToDB(url, type) {

    $.ajax({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        type: 'POST',
        url: "{{ route('addSocialLink.post') }}",
        data: {
            'urlLink': url,
            'urlType': type
        },
        success: function(data) {
            alert("Link Updated Successfully!")
        },
        error: function(xhr, status, error) {
            alert(xhr.responseText);
        }
    });


}
// End Adding Social Links To Database................................................


// Adding Follows ..........................................................................
function addFollows(personEmail) {
        var valueShow = document.getElementById('followLink' + personEmail).innerHTML;


        if (valueShow == 'Follow') {
            $.ajax({
                headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('addFollows.post') }}",
                data: {
                    'email_id': personEmail
                },
                success: function(response) {
                    document.getElementById('followLink' + personEmail).innerHTML = 'UnFollow';
                    var countt = document.getElementById('countFollow' + personEmail).innerHTML;
                    if (countt.includes("k")) {

                    } else {
                        var d = parseInt(countt);
                        d = d + 1;
                        document.getElementById('countFollow' + personEmail).innerHTML = d + ' ';

                    }

                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });
        } else if (valueShow == 'UnFollow') {
            $.ajax({
                headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('addUnFollows.post') }}",
                data: {
                    'email_id': personEmail
                },
                success: function(response) {
                    document.getElementById('followLink' + personEmail).innerHTML = 'Follow';
                    var countt = document.getElementById('countFollow' + personEmail).innerHTML;
                    if (countt.includes("k")) {

                    } else {
                        var d = parseInt(countt);
                        d = d - 1;
                        document.getElementById('countFollow' + personEmail).innerHTML = d + ' ';

                    }

                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });


        }
    }
//..............................................................................................

//Unfollow the user ............................................................................
function UnaddFollows(personEmail) {


            $.ajax({
                headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                type: 'POST',
                url: "{{ route('addUnFollows.post') }}",
                data: {
                    'email_id': personEmail
                },
                success: function(response) {
                    document.getElementById("unfollowUser"+personEmail).style.display="none";

                },
                error: function(xhr, status, error) {
                    alert(xhr.responseText);
                }
            });



    }

//end unfollow the user................................................................











//Adding Comments Against Each Post.............................................................
function addComments(postID) {

var email_id = document.getElementById("postEmailid").value;
var commentsTxt = document.getElementById("commentsBox" + postID).value;
document.getElementById("commentsBox" + postID).value = '';

var dateTimee = '<?php echo date('Y-m-d H:i:s'); ?>';

$.ajax({
    headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
             },
    type: 'POST',
    url: "{{ route('AddingComments.post') }}",
    data: {
        'email_id': email_id,
        'commentsTxt': commentsTxt,
        'post_id': postID
    },
    success: function(data) {

        if (data == 'done') {
            window.location.reload();
        }

    },
    error: function(xhr, status, error) {
        alert(xhr.responseText);
    }
});
}
//..........................................................................................
//Adding LinkeFunction Against Each Post.............................................................
function LikeFunction(postID) {
        var email_id = document.getElementById("postEmailid").value;
        var post_liker_email_id = document.getElementById("postEmailid").value;


        $.ajax({
            headers: {
                 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
             },
            type: 'POST',
            url: "{{ route('LikePost.post') }}",

            data: {
                'email_id': email_id,
                'postID': postID
            },
            success: function(data) {


                if (data == 'done') {


                    document.getElementById('likeSymble'+postID).setAttribute("class", "fa fa-thumbs-up");
                   // document.getElementById("likeButton" + postID).src =
                     //   "ProfileImages/icons/likegreen.png";

                    var countt = document.getElementById("likeCounting" + postID).textContent;
                    if (countt.length == 0) {
                        countt = "1";
                    } else {
                        var b = parseInt(countt);
                        b = b + 1;
                        countt = b + "";
                    }
                    document.getElementById("likeCounting" + postID).textContent = countt;

                }
                if (data == 'unlike') {

                 //   document.getElementById("likeButton" + postID).src = "ProfileImages/icons/like.png";
                 document.getElementById('likeSymble'+postID).setAttribute("class", "fa fa-thumbs-o-up");
                    var countt = document.getElementById("likeCounting" + postID).textContent;
                    if (countt.length == 0) {
                        countt = "1";
                    } else {
                        var b = parseInt(countt);
                        b = b - 1;
                        countt = b + "";
                    }
                    document.getElementById("likeCounting" + postID).textContent = countt;
                }

            },
            error: function(xhr, status, error) {
                alert(xhr.responseText);
            }
        });


    }
//Ending  LinkeFunction Against Each Post.............................................................
    </script>
    </body>

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js" integrity="sha384-IQsoLXl5PILFhosVNubq5LC7Qb9DXgDA9i+tQ8Zj3iwWAwPtgFTxbJ8NT4GN1R8p" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js" integrity="sha384-cVKIPhGWiC2Al4u+LWgxfKTRIcfu0JTxR+EQDz/bgldoEyl4H0zUF0QKbrJ0EcQF" crossorigin="anonymous"></script>
    <script type="text/javascript" src="js//url.js"></script>

    @include('messageAjaxHomePage')
    @include('checkvideocallstatus')
</html>