<?php

use Illuminate\Support\Facades\Config;

$languages = Config::get('languages');
?>

<section id="contact-section" class="contact-section section-padding bg-white">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('contact-section', 'title') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('contact-section', 'description') }}</p>
                </div>
            </div>
            <div class="row gy-4 justify-content-center">
                <div class="col-md-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded bg-white py-4 px-3 p-md-4 text-center h-100 box-shadow">
                        <h4 class="mb-4">{{ getJsonLocalization('contact-section', 'customer-support') }}</h4>
                        <img src="images/contact-section-img1.jpg" alt="img" class="mb-4" />
                        <ul class="bulleted-list text-start mb-5">
                            <li>{{ getJsonLocalization('contact-section', 'billing-issues') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'payment-methods') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'personal-info-issues') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'safety-issues') }}</li>
                        </ul>
                        <a href="/public/customer-service" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('contact-section', 'visit') }}</a>
                    </div>
                </div>
                <div class="col-md-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded bg-white py-4 px-3 p-md-4 text-center h-100 box-shadow">
                        <h4 class="mb-4">{{ getJsonLocalization('contact-section', 'tech-support') }}</h4>
                        <img src="images/contact-section-img2.jpg" alt="img" class="mb-4" />
                        <ul class="bulleted-list text-start mb-5">
                            <li>{{ getJsonLocalization('contact-section', 'website-issues') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'tests-issues') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'job-posting-issues') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'chat-issues') }}</li>
                        </ul>
                        <a href="/public/tech-support" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('contact-section', 'visit') }}</a>
                    </div>
                </div>
                <div class="col-md-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded bg-white py-4 px-3 p-md-4 text-center h-100 box-shadow">
                        <h4 class="mb-4">{{ getJsonLocalization('contact-section', 'general-inquiries') }}</h4>
                        <img src="images/contact-section-img3.jpg" alt="img" class="mb-4" />
                        <ul class="bulleted-list text-start mb-5">
                            <li>{{ getJsonLocalization('contact-section', 'about-our-team') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'advantages') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'accounts-pricing') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'discuss-with-team') }}</li>
                        </ul>
                        <a href="/public/general-inquiries" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('contact-section', 'visit') }}</a>
                    </div>
                </div>
                <div class="col-md-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded bg-white py-4 px-3 p-md-4 text-center h-100 box-shadow">
                        <h4 class="mb-4">{{ getJsonLocalization('contact-section', 'faq') }}</h4>
                        <img src="images/contact-section-img4.jpg" alt="img" class="mb-4" />
                        <ul class="bulleted-list text-start mb-5">
                            <li>{{ getJsonLocalization('contact-section', 'general-questions') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'job-offers-questions') }}</li>
                            <li>{{ getJsonLocalization('contact-section', 'exams-questions') }}</li>
                        </ul>
                        <a href="/public/general-questions" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('contact-section', 'visit') }}</a>
                    </div>
                </div>
                <div class="col-md-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded bg-white py-4 px-3 p-md-4 text-center h-100 box-shadow">
                        <h4 class="mb-4">{{ getJsonLocalization('contact-section', 'free-presentation') }}</h4>
                        <img src="images/contact-section-img5.jpg" alt="img" class="mb-4" />
                        <ul class="bulleted-list text-start mb-5">
                            <li>{{ getJsonLocalization('contact-section', 'free-presentation-description') }}</li>
                        </ul>
                        <a href="/public/book-an-online-presentation" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('contact-section', 'visit') }}</a>
                    </div>
                </div>
            </div>
        </div>
    </section>