<!DOCTYPE html>
<html lang="en">

<head>
   <!-- links and scripts -->
   <title>Workfrater</title>
   <meta charset="utf-8">
   <meta name="csrf-token" content="{{ csrf_token() }}">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
   <link rel="stylesheet" href="css/utils.css">
   <link rel="stylesheet" href="css/ui-elements.css">
   <link rel="stylesheet" href="css/bootstrap-overrides.css">
   <link rel="stylesheet" href="css/home.css">
   <link rel="stylesheet" href="css/index.css">
   <link rel="stylesheet" href="css/responsive.css">

   <script src="js/jquery.min.js"></script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

   <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
   <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
   <script src="js/countrypicker.js"></script>

   <script type="text/javascript" src="js/custom.js"></script>
   <script type="text/javascript" src="js//url.js"></script>

</head>

<body>
   @include('header')
   <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
      <div class="container">
         <div class="form-box mx-auto" style="max-width:767px;">
            <div class="text-center mb-4">
               <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
            </div>
            <h2>{{ getJsonLocalization('signup', 'Personal Information') }}</h2>
            <form action="{{route('action_personalInfo_Edu')}}" method="POST">
               @csrf
               <div class="row gy-3">
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'First Name') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <input type="text" autocomplete="off" class="form-control" id="first_name" name="first_name" required>
                  </div>
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Second Name') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <input type="text" autocomplete="off" class="form-control" id="second_name" name="second_name" required>
                  </div>
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'City') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <input type="text" autocomplete="off" class="form-control" id="city_name" name="city_name" required>
                  </div>
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Phone Number') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <input type="number" class="form-control" id="phone_number" name="phone_number" required>
                  </div>
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Country') }}: <span style="color:red ;font-size:20x;">*</span></label>

                     <select class="selectpicker form-control" id="country_name" name="country_name" required>
                        <option value="USA">{{ getJsonLocalization('signup', 'USA') }}</option>
                        <option value="Canada">{{ getJsonLocalization('signup', 'Canada') }}</option>

                     </select>
                  </div>

                  <script>
                     function checkEmail() {
                        var emailId = document.getElementById("personal_email").value;
                        if (!emailId.includes("@")) {
                           document.getElementById("validEmail").style.display = "block";
                        } else {
                           document.getElementById("validEmail").style.display = "none";
                        }
                     }
                  </script>
                  <div class="col-sm-4" style="display:none;">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Email') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <input type="text" autocomplete="off" class="form-control" name="personal_email" id="personal_email" value="not set">
                     <label class="text-danger text-mini" for="message" style="display:none;" id="validEmail" name="validEmail"><b>{{ getJsonLocalization('signup', 'Not a valid email') }}</b></label>
                  </div>
                  <div class="col-12">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Date of Birth') }}: <span style="color:red ;font-size:20x;">*</span></label>
                     <div class="row g-0">
                        <div class="col-4">
                           <select class="form-select" placeholder="Day" style="border-radius: 4px 0px 0px 4px" id="day" name="day">
                              <option value="" disabled selected>{{ getJsonLocalization('signup', 'Day') }}</option>
                              <?php
                              for ($i = 1; $i < 32; $i++) {
                              ?>
                                 <option value="<?php echo $i; ?>"> <?php echo $i; ?></option>
                              <?php
                              }
                              ?>
                           </select>
                        </div>
                        <div class="col-4">
                           <select class="form-select" placeholder="month" style="border-radius: 0px" id="month" name="month">
                              <option value="" disabled selected>{{ getJsonLocalization('signup', 'Month') }}</option>
                              <option value="Jan">{{ getJsonLocalization('signup', 'Jan') }}</option>
                              <option value="Feb">{{ getJsonLocalization('signup', 'Feb') }}</option>
                              <option value="Mar">{{ getJsonLocalization('signup', 'Mar') }}</option>
                              <option value="Apr">{{ getJsonLocalization('signup', 'Apr') }}</option>
                              <option value="May">{{ getJsonLocalization('signup', 'May') }}</option>
                              <option value="Jun">{{ getJsonLocalization('signup', 'Jun') }}</option>
                              <option value="Jul">{{ getJsonLocalization('signup', 'Jul') }}</option>
                              <option value="Aug">{{ getJsonLocalization('signup', 'Aug') }}</option>
                              <option value="Sep">{{ getJsonLocalization('signup', 'Sep') }}</option>
                              <option value="Oct">{{ getJsonLocalization('signup', 'Oct') }}</option>
                              <option value="Nov">{{ getJsonLocalization('signup', 'Nov') }}</option>
                              <option value="Dec">{{ getJsonLocalization('signup', 'Dec') }}</option>
                           </select>
                        </div>
                        <div class="col-4">
                           <select class="form-select" placeholder="year" style="border-radius: 0px 4px 4px 0px" id="year" name="year">
                              <option value="" disabled selected>{{ getJsonLocalization('signup', 'Year') }}</option>
                              <?php
                              $year = (int)date("Y");
                              for ($i = 0; $i < 104; $i++) {

                                 $yearr = $year - $i;

                              ?>
                                 <option value="<?php echo $yearr; ?>"><?php echo $yearr; ?></option>
                              <?php
                              }


                              ?>
                           </select>
                        </div>
                     </div>
                     <script>
                        var mySelect = document.getElementById('month');
                        mySelect.onchange = (event) => {
                           var selectedMonth = event.target.value;
                           if (selectedMonth == 'Sep' || selectedMonth == 'Apr' || selectedMonth == 'Jun' || selectedMonth == 'Nov') {
                              var selectedDay = document.getElementById('day').value;
                              document.getElementById("day").remove(31);
                              if (selectedDay != 'Day') {
                                 var sDay = parseInt(selectedDay);
                                 if (sDay > 30) {
                                    document.getElementById('day').selectedIndex = 0;
                                 } else {
                                    document.getElementById('day').selectedIndex = sDay;
                                 }
                              }

                           } else if (selectedMonth == 'Feb') {
                              var selectedDay = document.getElementById('day').value;
                              document.getElementById("day").remove(31);
                              document.getElementById("day").remove(30);
                              document.getElementById("day").remove(29);
                              if (selectedDay != 'Day') {
                                 var sDay = parseInt(selectedDay);
                                 if (sDay > 28) {
                                    document.getElementById('day').selectedIndex = 0;
                                 } else {
                                    document.getElementById('day').selectedIndex = sDay;
                                 }
                              }
                           } else {

                              if (document.getElementById("day").length == 29) {
                                 var opt = document.createElement('option');
                                 opt.value = 29;
                                 opt.innerHTML = 29;
                                 document.getElementById("day").appendChild(opt);
                                 opt = document.createElement('option');
                                 opt.value = 30;
                                 opt.innerHTML = 30;
                                 document.getElementById("day").appendChild(opt);
                                 opt = document.createElement('option');
                                 opt.value = 31;
                                 opt.innerHTML = 31;
                                 document.getElementById("day").appendChild(opt);
                              } else if (document.getElementById("day").length == 31) {
                                 var opt = document.createElement('option');
                                 opt.value = 31;
                                 opt.innerHTML = 31;
                                 document.getElementById("day").appendChild(opt);
                              }
                           }


                        }
                     </script>

                     <datalist id="dayList">
                        <option value="1">
                        <option value="2">
                        <option value="3">
                        <option value="4">
                        <option value="5">
                        <option value="6">
                        <option value="7">
                        <option value="8">
                        <option value="9">
                        <option value="10">
                        <option value="11">
                        <option value="12">
                        <option value="13">
                        <option value="14">
                        <option value="15">
                        <option value="16">
                        <option value="17">
                        <option value="18">
                        <option value="19">
                        <option value="20">
                        <option value="21">
                        <option value="22">
                        <option value="23">
                        <option value="24">
                        <option value="25">
                        <option value="26">
                        <option value="27">
                        <option value="28">
                        <option value="29">
                        <option value="30">
                        <option value="31">
                     </datalist>
                     <datalist id="monthList">
                        <option value="Jan">
                        <option value="Feb">
                        <option value="Mar">
                        <option value="Apr">
                        <option value="May">
                        <option value="Jun">
                        <option value="Jul">
                        <option value="Aug">
                        <option value="Sep">
                        <option value="Oct">
                        <option value="Nov">
                        <option value="Dec">
                     </datalist>
                     <datalist id="yearList">
                        <?php
                        $year = (int)date("Y");
                        for ($i = 0; $i < 36; $i++) {

                           $yearr = $year - $i;

                        ?>
                           <option value="<?php echo $yearr; ?>">
                           <?php
                        }


                           ?>
                     </datalist>
                  </div>
               </div>
               <div class="my-3">{{ getJsonLocalization('signup', "Your personal informations won't be displayed") }}</div>
               <div class="row">

                  <div class="col-6">
                     <a href="{{route('signup')}}" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Go Back') }}</a>
                  </div>


                  <div class="col-6 text-end">
                     <button type="submit" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Next') }}</button>
                  </div>
               </div>
            </form>
         </div>
      </div>
   </section>


</body>

</html>