<!DOCTYPE html>
<html lang="en">

<head>
   <!-- links and scripts -->
   <title>Workfrater</title>
   <meta charset="utf-8">
   <meta name="csrf-token" content="{{ csrf_token() }}">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
   <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
   <link rel="stylesheet" href="css/utils.css">
   <link rel="stylesheet" href="css/ui-elements.css">
   <link rel="stylesheet" href="css/bootstrap-overrides.css">
   <link rel="stylesheet" href="css/home.css">
   <link rel="stylesheet" href="css/index.css">
   <link rel="stylesheet" href="css/responsive.css">

   <script src="js/jquery.min.js"></script>
   <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
   <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js" integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous"></script>
   <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
   <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
   <script src="js/countrypicker.js"></script>

   <script type="text/javascript" src="js/custom.js"></script>
   <script type="text/javascript" src="js//url.js"></script>


   <script type="text/javascript">
      function PreviewImage() {
         var fileName = document.getElementById('customFile').value;

         if (fileName.includes(".png") || fileName.includes(".jpg") || fileName.includes(".jpeg")) {
            var oFReader = new FileReader();
            oFReader.readAsDataURL(document.getElementById("customFile").files[0]);

            oFReader.onload = function(oFREvent) {
               document.getElementById("profile_img").src = oFREvent.target.result;
            };
         } else {
            document.getElementById('customFile').value = null;
         }



      };
   </script>
</head>

<body style="background-color:#E0E0E0;">
   @include('header')
   <section class="initial-screen py-4 bg-cover-center" style="background-image:url('images/home-banner.jpg')">
      <div class="container">
         <div class="form-box mx-auto" style="max-width:767px;">
            <div class="text-center mb-4">
               <img src="logos//logo1.png" class="img-fluid" alt="Responsive image" style="max-width:150px;">
            </div>
            <h2>{{ getJsonLocalization('signup', 'Education Institution information') }}</h2>

            <form action="{{route('action_edusignup2')}}" method="POST" enctype="multipart/form-data">
               @csrf
               <div class="row gy-2 mb-3">
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Institution') }} <span class="text-danger">*</span></label>
                     <select class="form-select" aria-label="Default select example" style="height:40px;width: 100%;" id="instituation" name="instituation" required>
                        <option value="College" selected>{{ getJsonLocalization('signup', 'College') }}</option>
                        <option value="vocational college">{{ getJsonLocalization('signup', 'vocational college') }}</option>
                        <option value="university">{{ getJsonLocalization('signup', 'university') }}</option>
                     </select>
                  </div>
                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Civic address') }}: <span class="text-danger">*</span></label>
                     <input type="text" class="form-control input-lg" id="civic_address" name="civic_address" required>
                  </div>

                  <div class="col-sm-4">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Country') }}: <span class="text-danger">*</span></label>

                     <select class="selectpicker form-control" id="country_name_instituation" name="country_name_instituation" required>
                        <option value="USA">{{ getJsonLocalization('signup', 'USA') }}</option>
                        <option value="Canada">{{ getJsonLocalization('signup', 'Canada') }}</option>

                     </select>
                  </div>
                  <div class="col-sm-6">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'City') }}: <span class="text-danger">*</span></label>
                     <input type="text" class="form-control input-lg" id="city_name_instituation" name="city_name_instituation" required>
                  </div>
                  <div class="col-sm-6">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'add profile picture') }}: <span class="text-danger">*</span></label>
                     <input type="file" class="form-control" id="customFile" name="customFile" accept=".png,.jpg,.jpeg" onchange="PreviewImage();" />
                  </div>
                  <div class="col-sm-6">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Company Phone Number') }}: <span class="text-danger">*</span></label>
                     <input type="number" class="form-control input-lg" id="instituation_phone_number" name="instituation_phone_number" required>
                  </div>
                  <script>
                     function checkEmail() {
                        var emailId = document.getElementById("instituation_email").value;
                        if (!emailId.includes("@")) {
                           document.getElementById("validEmail").style.display = "block";
                        } else {
                           document.getElementById("validEmail").style.display = "none";
                        }
                     }
                  </script>
                  <div class="col-sm-6">
                     <label class="text-mini">{{ getJsonLocalization('signup', 'Email') }}: <span class="text-danger">*</span></label>
                     <input type="email" class="form-control input-lg" id="instituation_email" name="instituation_email" required onfocusout="checkEmail()">
                     <label for="message" style="color:red;display:none;margin-top:5px;" id="validEmail" name="validEmail"><b>{{ getJsonLocalization('signup', 'Not a valid email') }}</b></label>
                  </div>
               </div>

               <div class="row">
                  <div class="col-6">

                     <a href="{{route('edusignup')}}" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Go Back') }}</a>

                  </div>

                  <div class="col-6 text-end">
                     <button type="submit" class="wf-btn wf-btn-secondary">{{ getJsonLocalization('signup', 'Submit') }}</button>
                  </div>
               </div>
            </form>
         </div>
      </div>
   </section>



</body>

</html>