<?php

use Illuminate\Support\Facades\Session;

session_start();
$userInfo = Session::get('userInfo');
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <style>
        .fixed-left-sidebar {
            position: sticky;
            top: 0;
            height: 100vh;
            overflow: auto;
        }
    </style>
</head>

<body>
    <?php
    if (isset($userInfo["acountType"]) === false) {
    ?>
    @include('header')
    <?php
    } else {
        if ($userInfo["acountType"] == "org") {
        ?>
    @include('homedesktopheaderorg')
    <?php
        } else {
        ?>
    @include('homedesktopheader')
    <?php
        }
    }
    ?>
    <div class="container-fluid app-wrapper-container ">
        <!-- <div class="position-absolute d-flex justify-content-end entrep-hamburger d-xl-none d-md-none d-block">
            <button class="effect1">
                <span></span>
            </button>
        </div> -->
        <div class="row min-vh-100">
            <div class="col-md-4 col-12 p-3 text-center " style="border-right: 2px solid #ccc;">
                <div class="">
                    <img src="{{ URL::to('/') }}/logos//logo4.png" alt="" width="150" class="">
                </div>
                <h4 class="text-center my-2">{{ getJsonLocalization('entrepreneur', 'Search for an entrepreneur') }}
                </h4>
                <div class="">
                    <form id="searchForm">
                        <input type="text" class="form-control mt-2" id="entrep_name" name="entrep_name"
                            placeholder="Name" required>
                        <input type="text" class="form-control mt-2" id="searchInput" name="searchInput"
                            placeholder="Search" required>
                        <input type="text" class="form-control mt-2" id="entrep_city" name="entrep_city"
                            placeholder="City" required>
                        <select class="form-select form-select mt-2" id="entrep_country" name="entrep_country"
                            aria-label=".form-select example">
                            <option selected>Country</option>
                            <option value="USA">USA</option>
                            <option value="Canada">Canada</option>
                        </select>
                        <input type="text" class="form-control mt-2" id="entrep_country_region"
                            name="entrep_country_region" placeholder="Country of region" required>
                        <input type="text" class="form-control mt-2" id="entrep_ethnecity" name="entrep_ethnecity"
                            placeholder="Ethnicity" required>
                        <button type="submit"
                            class="wf-btn wf-btn-primary w-100 mt-4">{{ getJsonLocalization('entrepreneur', 'Search') }}</button>
                    </form>
                </div>
            </div>
            <div class="col-md-8 col-12 p-5 overflow-auto">
                <div class="row justify-content-start" id="cardContainer">
                    <div class="col-12 col-md-12 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex justify-content-center gap-2">
                                        <div>
                                            <img src="{{ URL::to('/') }}/persons/leon-elldot-f6HbVnGtNnY-unsplash.jpg"
                                                alt="person image"
                                                class="rounded-circle border border-secondary object-cover"
                                                width="65" height="65">
                                        </div>
                                        <div class="card-title text-dark my-auto ms-2 fw-bold">
                                            <span class="fs-6 lh-normal">John Doe</span><br>
                                            <span class="fs-6 lh-normal">Motreal, <span>Canada</span></span><br>
                                            <span class="fs-6 lh-normal"><span>0</span>
                                                {{ getJsonLocalization('entrepreneur', 'followers') }}</span>
                                        </div>
                                    </div>
                                    <div class="field fw-bold">
                                        <span class="fs-6">{{ getJsonLocalization('entrepreneur', 'Field') }}:
                                        </span><span>Construction</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end gap-3 mt-4">
                                    <a href="#"
                                        class="btn btn-sm btn-info fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Follow') }}</a>
                                    <a href="#"
                                        class="btn btn-sm btn-warning fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Message') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-12 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex justify-content-center gap-2">
                                        <div>
                                            <img src="{{ URL::to('/') }}/persons/leon-elldot-f6HbVnGtNnY-unsplash.jpg"
                                                alt="person image"
                                                class="rounded-circle border border-secondary object-cover"
                                                width="65" height="65">
                                        </div>
                                        <div class="card-title text-dark my-auto ms-2 fw-bold">
                                            <span class="fs-6 lh-normal">John Doe</span><br>
                                            <span class="fs-6 lh-normal">Motreal, <span>Canada</span></span><br>
                                            <span class="fs-6 lh-normal"><span>0</span>
                                                {{ getJsonLocalization('entrepreneur', 'followers') }}</span>
                                        </div>
                                    </div>
                                    <div class="field fw-bold">
                                        <span class="fs-6">{{ getJsonLocalization('entrepreneur', 'Field') }}:
                                        </span><span>Construction</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end gap-3 mt-4">
                                    <a href="#"
                                        class="btn btn-sm btn-info fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Follow') }}</a>
                                    <a href="#"
                                        class="btn btn-sm btn-warning fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Message') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-12 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex justify-content-center gap-2">
                                        <div>
                                            <img src="{{ URL::to('/') }}/persons/leon-elldot-f6HbVnGtNnY-unsplash.jpg"
                                                alt="person image"
                                                class="rounded-circle border border-secondary object-cover"
                                                width="65" height="65">
                                        </div>
                                        <div class="card-title text-dark my-auto ms-2 fw-bold">
                                            <span class="fs-6 lh-normal">John Doe</span><br>
                                            <span class="fs-6 lh-normal">Motreal, <span>Canada</span></span><br>
                                            <span class="fs-6 lh-normal"><span>0</span>
                                                {{ getJsonLocalization('entrepreneur', 'followers') }}</span>
                                        </div>
                                    </div>
                                    <div class="field fw-bold">
                                        <span class="fs-6">{{ getJsonLocalization('entrepreneur', 'Field') }}:
                                        </span><span>Construction</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end gap-3 mt-4">
                                    <a href="#"
                                        class="btn btn-sm btn-info fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Follow') }}</a>
                                    <a href="#"
                                        class="btn btn-sm btn-warning fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Message') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-12 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex justify-content-center gap-2">
                                        <div>
                                            <img src="{{ URL::to('/') }}/persons/leon-elldot-f6HbVnGtNnY-unsplash.jpg"
                                                alt="person image"
                                                class="rounded-circle border border-secondary object-cover"
                                                width="65" height="65">
                                        </div>
                                        <div class="card-title text-dark my-auto ms-2 fw-bold">
                                            <span class="fs-6 lh-normal">John Doe</span><br>
                                            <span class="fs-6 lh-normal">Motreal, <span>Canada</span></span><br>
                                            <span class="fs-6 lh-normal"><span>0</span>
                                                {{ getJsonLocalization('entrepreneur', 'followers') }}</span>
                                        </div>
                                    </div>
                                    <div class="field fw-bold">
                                        <span class="fs-6">{{ getJsonLocalization('entrepreneur', 'Field') }}:
                                        </span><span>Construction</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end gap-3 mt-4">
                                    <a href="#"
                                        class="btn btn-sm btn-info fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Follow') }}</a>
                                    <a href="#"
                                        class="btn btn-sm btn-warning fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Message') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-12 col-md-12 mb-4">
                        <div class="card" style="border: 2px solid #ccc; border-radius: 30px;">
                            <div class="card-body p-4">
                                <div class="d-flex justify-content-between">
                                    <div class="d-flex justify-content-center gap-2">
                                        <div>
                                            <img src="{{ URL::to('/') }}/persons/leon-elldot-f6HbVnGtNnY-unsplash.jpg"
                                                alt="person image"
                                                class="rounded-circle border border-secondary object-cover"
                                                width="65" height="65">
                                        </div>
                                        <div class="card-title text-dark my-auto ms-2 fw-bold">
                                            <span class="fs-6 lh-normal">John Doe</span><br>
                                            <span class="fs-6 lh-normal">Motreal, <span>Canada</span></span><br>
                                            <span class="fs-6 lh-normal"><span>0</span>
                                                {{ getJsonLocalization('entrepreneur', 'followers') }}</span>
                                        </div>
                                    </div>
                                    <div class="field fw-bold">
                                        <span class="fs-6">{{ getJsonLocalization('entrepreneur', 'Field') }}:
                                        </span><span>Construction</span>
                                    </div>
                                </div>
                                <div class="d-flex justify-content-end gap-3 mt-4">
                                    <a href="#"
                                        class="btn btn-sm btn-info fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Follow') }}</a>
                                    <a href="#"
                                        class="btn btn-sm btn-warning fw-bold text-white rounded-4 text-nowrap">{{ getJsonLocalization('entrepreneur', 'Message') }}</a>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</body>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"></script>
<script>
    $(document).ready(function() {
        var $cardContainer = $("#cardContainer"); /* Reference to the card container */
        var $cards = $cardContainer.find(".col-12.col-md-6.mb-4"); /* Reference to all cards */
        var $clonedCards = $cards.clone(); /* Clone all cards initially */
        var $row = $("<div class='row'></div>"); /* Create a row container for the cards */

        /* Function to filter cards based on search input */
        function filterCards(searchTerm) {
            searchTerm = searchTerm.toLowerCase();

            /* Remove all cards from the container */
            $cardContainer.empty();

            /* Iterate through the cloned cards and append matching cards */
            $clonedCards.each(function() {
                var cardTitle = $(this).find(".card-title").text().toLowerCase();
                if (cardTitle.includes(searchTerm)) {
                    $row.append(this); /* Append the column to the row */
                }
            });

            /* Append the row to the container */
            $cardContainer.append($row);
        }

        /* Handle form submission */
        $("#searchForm").on("submit", function(event) {
            event.preventDefault(); /* Prevent the default form submission */
            var searchTerm = $("#searchInput").val();
            filterCards(searchTerm);
        });

        /* Handle input change (clear search when input is empty) */
        $("#searchInput").on("input", function() {
            var searchTerm = $(this).val();
            if (searchTerm === "") {
                $cardContainer.empty(); /* If input is empty, show all cards */
                $cardContainer.append($clonedCards);
            }
        });
    });


    /* Hamburger menue */
    // $('.entrep-hamburger button.effect1').on('click',function(){
    //     $(this).find('span').toggleClass('active');
    //     $(".fixed-left-sidebar").toggleClass('entrep-fixed-left-sidebar');
    // });
</script>

</html>
