<?php

use Illuminate\Support\Facades\Session;

session_start();
$userInfo = Session::get('userInfo');

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->
    <title>Workfrater</title>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>

    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>
    <style>
    .fixed-left-sidebar {
        position: sticky;
        top: 0;
        height: 100vh;
        overflow: auto;
    }

    @import url('https://fonts.googleapis.com/css2?family=Montserrat&display=swap');

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {}

    .container {
        background-color: #555;
        color: #ddd;
        border-radius: 10px;
        padding: 20px;
        font-family: 'Montserrat', sans-serif;
        max-width: 700px;
    }

    .container>p {
        font-size: 32px;
    }

    .question {
        width: 75%;
    }

    .options {
        position: relative;
        padding-left: 40px;
    }

    #options label {
        display: block;
        margin-bottom: 15px;
        font-size: 14px;
        cursor: pointer;
    }

    .options input {
        opacity: 0;
    }

    .checkmark {
        position: absolute;
        top: -1px;
        left: 0;
        height: 25px;
        width: 25px;
        background-color: #555;
        border: 1px solid #ddd;
        border-radius: 50%;
    }

    .options input:checked~.checkmark:after {
        display: block;
    }

    .options .checkmark:after {
        content: "";
        width: 10px;
        height: 10px;
        display: block;
        background: white;
        position: absolute;
        top: 50%;
        left: 50%;
        border-radius: 50%;
        transform: translate(-50%, -50%) scale(0);
        transition: 300ms ease-in-out 0s;
    }

    .options input[type="radio"]:checked~.checkmark {
        background: #21bf73;
        transition: 300ms ease-in-out 0s;
    }

    .options input[type="radio"]:checked~.checkmark:after {
        transform: translate(-50%, -50%) scale(1);
    }

    .btn-primary {
        background-color: #555;
        color: #ddd;
        border: 1px solid #ddd;
    }

    .btn-primary:hover {
        background-color: #21bf73;
        border: 1px solid #21bf73;
    }

    .btn-success {
        padding: 5px 25px;
        background-color: #21bf73;
    }

    @media(max-width:576px) {
        .question {
            width: 100%;
            word-spacing: 2px;
        }
    }
    </style>
</head>

<body>
    <?php
if (isset($userInfo["acountType"]) === false) {
    ?>
    @include('header')
    <?php
} else {
    if ($userInfo["acountType"] == "org") {
        ?>
    @include('homedesktopheaderorg')
    <?php
} else {
        ?>
    @include('homedesktopheader')
    <?php
}
}
?>
    <div class="container-fluid app-wrapper-container">
        <div class="row min-vh-100">
            <div class="col-md-4 col-12 p-5 text-center" style="border-right: 2px solid #ccc;">
                <div class="my-5">
                    <img src="{{ URL::to('/') }}/logos//logo1.png" alt="" width="250">
                </div>
                <div>
                    <form action="{{ route('exams') }}" method="get" id="searchForm">
                        <input type="text" class="form-control" id="searchInput" name="exam_search" value=""
                            placeholder="Search" required>
                        <a href="{{ route('exams') }}" class="wf-btn wf-btn-secondary w-100 mt-4">{{
                            getJsonLocalization('exams', 'Clear Search') }}</a>
                        <button type="submit" class="wf-btn wf-btn-primary w-100 mt-4">{{ getJsonLocalization('exams',
                            'Search') }}</button>
                    </form>
                </div>
            </div>
            <div class="col-xl-8 col-12 p-5 overflow-auto">
                <div id="examDiv" style="display:none">
                    <div class="container mt-sm-5 my-1">
                        <div class="question ml-sm-5 pl-sm-5 pt-2">
                            <b>
                                <div class="py-2 h5" id="questionOption">Q 1. In Java, what is the default value of an
                                    integer variable?</div>
                            </b>
                            <img src="" id="image_file" style="width:600px; height:180px;display:none;"><br>


                            <div class="ml-md-3 ml-sm-3 pl-md-5 pt-sm-0 pt-3" id="options">
                                <label class="options" id="opt1">static
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt2">final
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt3">const
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt4">var
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt5">true
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt6">false
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                                <label class="options" id="opt7">42
                                    <input type="radio" name="radio">
                                    <span class="checkmark"></span>
                                </label>
                            </div>
                        </div>
                        <div class="d-flex align-items-center pt-3">

                            <div class="ml-auto mr-sm-5">
                                <button class="btn btn-success" onclick="nextQuestion();">Next</button>
                            </div>
                        </div>
                    </div>

















                </div>
                <div><button id="StartExam" onclick="startExamQuiz();">Start Exam</button></div>
                <div id="submitMessage" style="background-color: #21bf73;display:none;"> Your Exam Submitted Successfully, while videos are uploading to server Please Wait Do Not Close the Browser</div>
                <div><progress id="progressBar" style="display: none;" value="0" max="100"> 0% </progress></div>

                <div><button style="display:none;" id="SubmitRes" onclick="submitResult();">Submit Result</button></div>
                <div>







                </div>

            </div>
        </div>
    </div>


    <!-- Modal -->
    <div class="modal fade" id="messageModel" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel" style="font-size:26px;"><b>Alert</b></h5>


                    </button>
                </div>
                <div class="modal-body">
                    <div class="row">
                        <div class="col-3"><img src="logos//alert.png"
                                style="width:120px; height:120px;border-radius:50%;"></div>
                        <div class="col-9" style="font-size:20px;font-style:bold;"><b id="alertMessage">Exam Can Not
                                Start Please Select Full Screen Option.</b></div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"
                        onclick="closeDialog();">OK</button>

                </div>
            </div>
        </div>
    </div>




</body>
<script>
let mediaRecorder;
let recordedChunks = [];
let recordedChunks1 = [];
let mimeType;
let stream;
let stream1;
let count = 0;
let startIndex = 0;
let ended = 20;
let videoCount = 1;
let videoCountWeb = 1;
let webCamAvailable = false;
let screenCaptureStream;

let questionCount = 1;
let recordingThread;
let recordingThreadWebCam;
var timeoutRecording;
let streamVideo;
let videoFilesUploadingCount=0;
let screenSharingFilesUploadingCount=0;
let videoUploadedSucessfully=0;

function nextQuestion() {
    questionCount = questionCount + 1;
    if (questionCount == 2) {
        document.getElementById("questionOption").innerHTML = "Q 2. What is the scope of a local variable in Java?";
        document.getElementById("opt1").innerHTML = "Global " + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "Class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "Method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "Static" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "Object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "Instance" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "Parameter" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
    } else if (questionCount == 3) {
        document.getElementById("questionOption").innerHTML = "Q 3. What is a method in Java?";
        document.getElementById("opt1").innerHTML = "A variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "A class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "A loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "A function" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "A parameter" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "An object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "A scope" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 4) {
        document.getElementById("questionOption").innerHTML = "Q 4. What is the purpose of the 'if' statement in Java?";
        document.getElementById("opt1").innerHTML = "To declare a variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "To create a loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "To make a decision" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "To define a method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "To instantiate an object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "To initialize an array" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "To print output to the console" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 5) {
        document.getElementById("questionOption").innerHTML = "Q 5. What is the purpose of the 'for' loop in Java?";
        document.getElementById("opt1").innerHTML = "To create a decision" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "To define a method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "To repeat a block of code a specific number of times" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "To make a variable constant" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "To instantiate an object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "To initialize an array" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "To catch exceptions" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 6) {
        document.getElementById("questionOption").innerHTML = "Q 6. What is a parameter in Java?";
        document.getElementById("opt1").innerHTML = "A variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "A method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "A loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "A function" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "An object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "A class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "A conditional statement" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 7) {
        document.getElementById("questionOption").innerHTML = "Q 7. What is a class in Java?";
        document.getElementById("opt1").innerHTML = "A variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "A method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "A loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "A function" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "A data type" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "An object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "A conditional statement" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 8) {
        document.getElementById("questionOption").innerHTML = "Q 8. What is an array in Java?";
        document.getElementById("opt1").innerHTML = "A variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "A method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "A loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "A function" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "A data type" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "An object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "A conditional statement" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 9) {
        document.getElementById("questionOption").innerHTML = "Q 9. What is a string in Java?";
        document.getElementById("opt1").innerHTML = "A variable" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "A method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "A loop" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "A function" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "A data type" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "An object" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "A conditional statement" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 10) {
        document.getElementById("questionOption").innerHTML =
            "Q 10. How do you calculate the remainder of a division in Java?";
        document.getElementById("opt1").innerHTML = "Using the '/' operator" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "Using the '%' operator" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "Using the 'remainder' method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "Using the 'mod' method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "Using the 'modulo' method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "Using the 'divideAndRemainder' method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "Using the 'remainderOf' method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 11) {
        document.getElementById("questionOption").innerHTML =
            "Q 11. What is the result of the following code snippet in Java?";

        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q11.png';

        document.getElementById("opt1").innerHTML = "1" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "0" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "3" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "2" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "4" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "3.33" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "10" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 12) {
        document.getElementById("questionOption").innerHTML =
            "Q 12. What is the value of the variable 'num' after the following code snippet in Java?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q12.png';
        document.getElementById("opt1").innerHTML = "5" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "10" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "20" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "15" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "25" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "30" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "0" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 13) {
        document.getElementById("questionOption").innerHTML =
            "Q 13. What is the scope of the variable 'count' in the following Java code snippet?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q13.png';
        document.getElementById("opt1").innerHTML = "Local to the ‘main’ method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "Local to the ‘Example’ class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "Local to the ‘args’ parameter" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "Global to the ‘entire’ program" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "Local to the ‘System.out.println’ statement" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "Local to the ‘String’ class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "'count' is not defined in this code snippet" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 14) {
        document.getElementById("questionOption").innerHTML = "Q 14. What is the purpose of the following Java method?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q14.png';
        document.getElementById("opt1").innerHTML = "It prints the square of a given number" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "It calculates the square root of a given number" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "It initializes a variable with the square of a given number" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "It returns the square of a given number" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "It sets a variable to the value of a given number squared" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "It calculates the cube of a given number" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "'calculateSquare' is not a valid method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 15) {
        document.getElementById("questionOption").innerHTML =
            "Q 15. In the following Java code snippet, what is the value of the variable 'result'?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q15.png';
        document.getElementById("opt1").innerHTML = "5" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "10" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "20" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "15" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "25" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "30" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "0" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 16) {
        document.getElementById("questionOption").innerHTML =
            "Q 16. What is the output of the following code snippet in Java?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q16.png';
        document.getElementById("opt1").innerHTML = "1 2 3 4 5" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "5 4 3 2 1" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "1 3 5" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "2 4" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "1 2 3 4" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "It results in a compile-time error" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "It results in a runtime error" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 17) {
        document.getElementById("questionOption").innerHTML =
            "Q 17. In the following Java method, what is the parameter?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q17.png';
        document.getElementById("opt1").innerHTML = "printMessage" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "String" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "System.out.println" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "message" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "void" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "public" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "'printMessage' is not a valid method" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 18) {
        document.getElementById("questionOption").innerHTML =
            "Q 18. In the following Java code snippet, what is the name of the class?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q18.png';
        document.getElementById("opt1").innerHTML = "Student" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "public" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "main" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "Student.java" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "StudentClass" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "'Student' is not a valid class" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 19) {
        document.getElementById("questionOption").innerHTML =
            "Q 19. In the following Java code snippet, what is the type of the array 'numbers'?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q19.png';
        document.getElementById("opt1").innerHTML = "int" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "float" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "double" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "String" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "char" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "boolean" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "array" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 20) {
        document.getElementById("questionOption").innerHTML =
            "Q 20. In the following Java code snippet, what is the result of the string concatenation?";
        document.getElementById("image_file").style.display = 'block';
        document.getElementById("image_file").src = 'examImages/q20.png';
        document.getElementById("opt1").innerHTML = "John Doe" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt2").innerHTML = "Doe John" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt3").innerHTML = "JohnDoe" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt4").innerHTML = "John + Doe" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt5").innerHTML = "JohnDoe" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt6").innerHTML = "It results in a compile-time error" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;
        document.getElementById("opt7").innerHTML = "It results in a runtime error" + `<input type="radio" name="radio">
                     <span class="checkmark"></span>`;

    } else if (questionCount == 21) {

        document.getElementById("examDiv").style.display = 'none';
        document.getElementById("SubmitRes").style.display = 'block';


    }



}

function closeDialog() {
    $('#messageModel').modal('hide');
}

function submitResult() {
    clearInterval(recordingThread);
    clearInterval(recordingThreadWebCam);

    document.getElementById("progressBar").style.display = "block";
    document.getElementById("submitMessage").style.display = "block";
    
    screenCaptureStream.getTracks().forEach(function(track) {
        track.stop();
    });
    streamVideo.getTracks().forEach(function(track) {
        track.stop();
    });
    var g = document.getElementById("progressBar");
    // Set the maximum value of progress element
    let totalCount=videoFilesUploadingCount+videoFilesUploadingCount;
    g.setAttribute("max", totalCount+4);
    videoUploadedSucessfully=videoUploadedSucessfully+4;

    let progressValue = 0;
    let submitInterval = setInterval(() => {
      console.log("Remaining Video Uploaded:"+videoFilesUploadingCount);
      console.log("Remaining ScreenRecording Uploaded:"+videoFilesUploadingCount);
    

     if(videoFilesUploadingCount==0 && screenSharingFilesUploadingCount==0){
            clearInterval(submitInterval);
            document.getElementById("alertMessage").innerHTML =
                "Your Exam Submitted successfully, Redirecting to home page";
            $('#messageModel').modal('show');
            setTimeout(redirectHomePage, 3000);
         }else{
           
             //   totalCount=localTotal;
            //    progressValue = progressValue + 1;
            g.setAttribute("value", videoUploadedSucessfully);
           
       
         }
      
     
    }, 2000);
}





async function startExamQuiz() {
    detectWebcam(function(hasWebcam) {

        if (hasWebcam == true) {

            webCamAvailable = true;
        } else {
            document.getElementById("alertMessage").innerHTML =
                "You Have No Cam So Test Cannot be started.";
            $('#messageModel').modal('show');

            return;

        }

    });
    const isFirefox = typeof InstallTrigger !== 'undefined';
    var isChrome = /Chrome/.test(navigator.userAgent) && /Google Inc/.test(navigator.vendor);
    //const isChrome = !!window.chrome && (!!window.chrome.webstore || !!window.chrome.runtime);

    screenCaptureStream = await navigator.mediaDevices.getDisplayMedia({
        video: {
            width: {
                ideal: 640,
                max: 660
            },
            height: {
                ideal: 640,
                max: 660
            },
            frameRate: 30
        },
        audio: false, // Ask to capture audio; caveat follows.
        systemAudio: "exclude"

    });

    // somebody clicked on "Stop sharing"
    screenCaptureStream.getVideoTracks()[0].onended = function() {
        document.getElementById('examDiv').style.display = 'none';
        document.getElementById("alertMessage").innerHTML =
            "You have stop screen sharing, Exam can not be continue. You are redirecting to home page";
        $('#messageModel').modal('show');
        setTimeout(redirectHomePage, 3000);
    };
    if (isFirefox) {
        const videoTrack = screenCaptureStream.getVideoTracks()[0];
        if (videoTrack.label !== 'Primary Monitor') {
            screenCaptureStream.getTracks().forEach(function(track) {
                track.stop();
            });

            document.getElementById("alertMessage").innerHTML =
                "Exam Can Not Start Please Select Full Screen Option.";
            $('#messageModel').modal('show');
            return;
        }

    } else {

        let displaySurface = screenCaptureStream
            .getVideoTracks()[0]
            .getSettings().displaySurface;

        if (displaySurface !== "monitor") {

            screenCaptureStream.getTracks().forEach(function(track) {
                track.stop();
            });
            document.getElementById("alertMessage").innerHTML =
                "Exam Can Not Start Please Select Full Screen Option.";
            $('#messageModel').modal('show');

            return;
        }

    }

    document.getElementById('StartExam').style.display = 'none';
    document.getElementById('examDiv').style.display = 'block';


    var testDatee = new Date();
    var current_date = testDatee.getFullYear()+"-"+(testDatee.getMonth()+1)+"-"+ testDatee.getDate();
    var current_time = testDatee.getHours()+":"+testDatee.getMinutes()+":"+ testDatee.getSeconds();
    let testDate = current_date+' '+current_time;

   record_and_send(screenCaptureStream, videoCount,testDate);
    videoCount = videoCount + 1;
    screenSharingFilesUploadingCount=screenSharingFilesUploadingCount+1;
    recordingThread = setInterval(() => {
        screenSharingFilesUploadingCount=screenSharingFilesUploadingCount+1;
        record_and_send(screenCaptureStream, videoCount,testDate);
        //  console.log('printing');
        videoCount = videoCount + 1;
    }, 60000);



    //....................................................................
    try {
        streamVideo = await recordScreen();
    } catch (error) {

        document.getElementById("alertMessage").innerHTML =
            "Exam Can Not Be Start You Have Webcam Issue, Redirecting to Home";
        $('#messageModel').modal('show');
        setTimeout(redirectHomePage, 3000);
        // Only runs when there is an error/exception
    }


    record_webcam_and_send(streamVideo, videoCountWeb,testDate);
    videoCountWeb = videoCountWeb + 1;
    videoFilesUploadingCount=videoFilesUploadingCount+1;
    recordingThreadWebCam = setInterval(() => {
        videoFilesUploadingCount=videoFilesUploadingCount+1;
     record_webcam_and_send(streamVideo, videoCountWeb,testDate);
        // console.log('printing');
        videoCountWeb = videoCountWeb + 1;
    }, 60000 )


}



function redirectHomePage() {

    window.location.href = "{{ route('home')}}";

}

//function check is the web cam present or not.....................
function detectWebcam(callback) {
    let md = navigator.mediaDevices;
    if (!md || !md.enumerateDevices) return callback(false);
    md.enumerateDevices().then(devices => {
        callback(devices.some(device => 'videoinput' === device.kind));
    })
}
//.........................................................................
async function openScreenRecording() {
    return await navigator.mediaDevices.getDisplayMedia({
        audio: true,
        video: {
            cursor: "always",
            displaySurface: "monitor",
            logicalSurface: false
        },

    });

}
//...........................................................


function stop() {
    mediaRecorder.stop();
}
async function recordScreen() {
    return await navigator.mediaDevices.getUserMedia({
        video: {

            width: {
                exact: 240
            },
            height: {
                exact: 180
            },
            frameRate: 8
        },
        audio: true,

    });

}




//video recorder..............................................
function createRecorder(stream, mimeType) {
    // the stream data is stored in this array
    mediaRecorder = new MediaRecorder(stream);
    mediaRecorder.ondataavailable = function(e) {
        if (e.data.size > 0) {
            recordedChunks.push(e.data);
            //    console.log("writing .......");
            // console.log(recordedChunks.length);
        }
    };
    mediaRecorder.onstop = function() {};
    mediaRecorder.start(200); // For every 200ms the stream data will be stored in a separate chunk.
    return mediaRecorder;
}
//...............................................................

// Recording Screen capture and send to server........................
function record_and_send(stream, videoCount,testDate) {
    const recorder = new MediaRecorder(stream);
    const chunks = [];
    recorder.ondataavailable = e => chunks.push(e.data);
    recorder.onstop = e => sendToServer(new Blob(chunks), videoCount,testDate);
    timeoutRecording = setTimeout(() => recorder.stop(), 60000); // we'll have a 5s media file


    recorder.start();
}


function record_webcam_and_send(stream, videoCount,testDate) {
    const recorder = new MediaRecorder(stream);
    const chunks = [];
    recorder.ondataavailable = e => chunks.push(e.data);
    recorder.onstop = e => sendToServerWebCam(new Blob(chunks), videoCount,testDate);
    setTimeout(() => recorder.stop(), 60000); // we'll have a 5s media file
    recorder.start();
}

//...................................................
// Screen Recording video Upload to server................
function sendToServer(blob, videoCount,testDate) {
    var emailId='<?php echo Session::get('emailId');?>';
     var data = new FormData();
    data.append('video', blob); 
    data.append('videoCount', videoCount);
    data.append('clientEmail', emailId);
    data.append('testDate',testDate);
    data.append('testName', 'Java');
    
    
    
    fetch('http://31.220.107.107/workfratervideos/uploadExamScreenSharingVideo.php', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'ignore-ssl-errors': 'true',
    'rejectUnauthorized': 'false'
  },
   
  body: JSON.stringify({
    // Your request payload
  }),
})
.then(response => {
  // Handle the response
})
.catch(error => {
  // Handle errors
});
    
    
    
    
    
    
    
    
    
//   $.ajax({
//   url: 'http://31.220.107.107/workfratervideos/uploadExamScreenSharingVideo.php',
//   type: 'POST',
//   enctype: 'multipart/form-data',
//   data: data,
//      headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
//   success: function(data) {
//     // Handle the successful response
//   },
//   error: function(xhr, status, error) {
//     // Handle the error
//   },
 
//   // This is not recommended for production
//   xhrFields: {
//     withCredentials: true
//   },
//   crossDomain: true,
//   beforeSend: function(xhr) {
//     // This disables SSL certificate validation, which is not secure
//     // Do not use this in production code
//     // Reference: https://stackoverflow.com/a/2720010/5395087
//     xhr.xhrFields = { rejectUnauthorized: false };
//   }
// });
    
    
    
    
    
    
    
    
    
    
    
    
    
    
        
    
//      $.ajax({

//         xhr: function() {
//             var xhr = new window.XMLHttpRequest();

//             xhr.upload.addEventListener("progress", function(evt) {
//                 if (evt.lengthComputable) {
//                     var percentComplete = evt.loaded / evt.total;
//                     percentComplete = parseInt(percentComplete * 100);
//                     // Set the value of progress element
//                     //    g.setAttribute("value", percentComplete);
//                   if(percentComplete>99.5){
//                     videoUploadedSucessfully=videoUploadedSucessfully+1;
//                     videoFilesUploadingCount=videoFilesUploadingCount-1;
//                   }


//                       console.log('percentage Video UPloading:::No'+videoFilesUploadingCount +"%"+ + percentComplete);
//                 }
//             }, false);

//             return xhr;
//         },
//         headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
//         type: "POST",
//         enctype: 'multipart/form-data',
//       url: 'http://31.220.107.107/workfratervideos/uploadExamScreenSharingVideo.php',
//         data: data,
//         success: function(data) {
//             //      console.log(data);
//         },
//         error: function(e) {
//             console.log("ERROR : ", e);
//         },
//           xhrFields: {
//     withCredentials: true
//   },
//   crossDomain: true,
//   beforeSend: function(xhr) {
//     // This disables SSL certificate validation, which is not secure
//     // Do not use this in production code
//     // Reference: https://stackoverflow.com/a/2720010/5395087
//     xhr.xhrFields = { rejectUnauthorized: false };
//   }
//     });
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    console.log('Screen Sharing Video Uplading Started............');
    // var data = new FormData();
    // data.append('video', blob); 
    // data.append('videoCount', videoCount);
    // data.append('clientEmail', emailId);
    // data.append('testDate',testDate);
    // data.append('testName', 'Java');

    // var xhr = new XMLHttpRequest();
    // var url = 'http://31.220.107.107/workfratervideos/uploadExamScreenSharingVideo.php';
    // xhr.open('POST', url, true);
    //   xhr.rejectUnauthorized = false;
    // xhr.onreadystatechange = function () {
    //                 if (xhr.readyState == 4 && xhr.status == 200) {
    //                     // Handle the response from the server
    //                     console.log('Screen Capture Upload successful:', xhr.responseText);
    //                 }
    //             };


    //         xhr.upload.addEventListener("progress", function(evt) {
    //             if (evt.lengthComputable) {
    //                 var percentComplete = evt.loaded / evt.total;
    //                 percentComplete = parseInt(percentComplete * 100);
    //                 // Set the value of progress element
    //                 //   g.setAttribute("value", percentComplete);

    //                 if(percentComplete>99.5){
    //                     videoUploadedSucessfully=videoUploadedSucessfully+1;
    //                     screenSharingFilesUploadingCount=screenSharingFilesUploadingCount-1;
    //               }

    //                   console.log('percentage Video UPloading:::No'+screenSharingFilesUploadingCount +"%"+ percentComplete);
    //             }
    //         }, false);


    // xhr.send(data);

}

// Screen Recording video Upload to server................
function sendToServerWebCam(blob, videoCount,testDate) {
    var emailId='<?php echo Session::get('emailId');?>';
    
    
    
    
    
        var data = new FormData();
    data.append('video', blob); 
    data.append('videoCountWeb', videoCount);
    data.append('clientEmail', emailId);
    data.append('testDate',testDate);
    data.append('testName', 'Java');
    


fetch('http://31.220.107.107/workfratervideos/uploadExamVideoCamVideo.php', {
  method: 'POST',
  headers: {
    'Content-Type': 'application/json',
    'ignore-ssl-errors': 'true',
    'rejectUnauthorized': 'false'
  },
 
  body: JSON.stringify({
    // Your request payload
  }),
})
.then(response => {
  // Handle the response
})
.catch(error => {
  // Handle errors
});
    
    
        
    
//   $.ajax({
//   url: 'http://31.220.107.107/workfratervideos/uploadExamVideoCamVideo.php',
//   type: 'POST',
//   enctype: 'multipart/form-data',
//   data: data,
//   success: function(data) {
//     // Handle the successful response
//   },
//       headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
//   error: function(xhr, status, error) {
//     // Handle the error
//   },
//   // This is not recommended for production
//   xhrFields: {
//     withCredentials: true
//   },
//   crossDomain: true,
//   beforeSend: function(xhr) {
//     // This disables SSL certificate validation, which is not secure
//     // Do not use this in production code
//     // Reference: https://stackoverflow.com/a/2720010/5395087
//     xhr.xhrFields = { rejectUnauthorized: false };
//   }
// });
    
    
    
    
//      $.ajax({

//         xhr: function() {
//             var xhr = new window.XMLHttpRequest();

//             xhr.upload.addEventListener("progress", function(evt) {
//                 if (evt.lengthComputable) {
//                     var percentComplete = evt.loaded / evt.total;
//                     percentComplete = parseInt(percentComplete * 100);
//                     // Set the value of progress element
//                     //    g.setAttribute("value", percentComplete);
//                   if(percentComplete>99.5){
//                     videoUploadedSucessfully=videoUploadedSucessfully+1;
//                     videoFilesUploadingCount=videoFilesUploadingCount-1;
//                   }


//                       console.log('percentage Video UPloading:::No'+videoFilesUploadingCount +"%"+ + percentComplete);
//                 }
//             }, false);

//             return xhr;
//         },
//         headers: {
//             'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//         },
//         type: "POST",
//         enctype: 'multipart/form-data',
//         url: 'http://31.220.107.107/workfratervideos/uploadExamVideoCamVideo.php',
//         data: data,
//         success: function(data) {
//             //      console.log(data);
//         },
//         error: function(e) {
//             console.log("ERROR : ", e);
//         },
//           xhrFields: {
//     withCredentials: true
//   },
//   crossDomain: true,
//   beforeSend: function(xhr) {
//     // This disables SSL certificate validation, which is not secure
//     // Do not use this in production code
//     // Reference: https://stackoverflow.com/a/2720010/5395087
//     xhr.xhrFields = { rejectUnauthorized: false };
//   }
//     });
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    console.log('Cam Video Uplading Started............');
    // var data = new FormData();
    // data.append('video', blob); 
    // data.append('videoCountWeb', videoCount);
    // data.append('clientEmail', emailId);
    // data.append('testDate',testDate);
    // data.append('testName', 'Java');

    // var xhr = new XMLHttpRequest();
    
    // var url = 'http://31.220.107.107/workfratervideos/uploadExamVideoCamVideo.php';
    // xhr.open('POST', url, true);
    // xhr.rejectUnauthorized = false;
    // xhr.onreadystatechange = function () {
    //                 if (xhr.readyState == 4 && xhr.status == 200) {
    //                     // Handle the response from the server
    //                     console.log('Video Cam Upload successful:', xhr.responseText);
    //                 }
    //             };


    //         xhr.upload.addEventListener("progress", function(evt) {
    //             if (evt.lengthComputable) {
    //                 var percentComplete = evt.loaded / evt.total;
    //                 percentComplete = parseInt(percentComplete * 100);
    //                 // Set the value of progress element
    //                 //    g.setAttribute("value", percentComplete);
    //               if(percentComplete>99.5){
    //                 videoUploadedSucessfully=videoUploadedSucessfully+1;
    //                 videoFilesUploadingCount=videoFilesUploadingCount-1;
    //               }


    //                   console.log('percentage Video UPloading:::No'+videoFilesUploadingCount +"%"+ + percentComplete);
    //             }
    //         }, false);

    // xhr.send(data);
        

}

//..........................................................
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.1.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.min.js"></script>


</html>