<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Find a Person | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <section class="find-person-section">
        <div class="container">
            <div class="find-person-main-row">
                <div class="find-person-sidebar">
                    <div class="find-person-sidebar-inner">
                        <h2 class="mb-4">Find</h2>
                        <form action="">
                            <h6>{{ getJsonLocalization('find-a-person', 'name') }}</h6>
                            <div class="mb-3">
                                <input type="text" class="form-control" placeholder="{{ getJsonLocalization('find-a-person', 'enter_name') }}" />
                            </div>
                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault1" checked>
                                    <label class="form-check-label" for="flexRadioDefault1">
                                        Individual
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault2">
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        Company
                                    </label>
                                </div>
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault3">
                                    <label class="form-check-label" for="flexRadioDefault3">
                                        Education
                                    </label>
                                </div>
                            </div>
                            <h6>{{ getJsonLocalization('find-a-person', 'location') }}</h6>
                            <div class="mb-3">
                                <input type="text" class="form-control mb-2" placeholder="{{ getJsonLocalization('find-a-person', 'city') }}" />
                                <input type="text" class="form-control" placeholder="{{ getJsonLocalization('find-a-person', 'country') }}" />
                            </div>
                            <h6>{{ getJsonLocalization('find-a-person', 'age') }}</h6>

                            <div class="mb-4">20 - 50</div>

                            <div class="multi-range-slider mb-5">
                                <input type="range" id="input-left" min="0" max="100" value="25">
                                <input type="range" id="input-right" min="0" max="100" value="75">

                                <div class="slider">
                                    <div class="track"></div>
                                    <div class="range"></div>
                                    <div class="thumb left"></div>
                                    <div class="thumb right"></div>
                                </div>
                            </div>
                            <script>
                                var inputLeft = document.getElementById("input-left");
                                var inputRight = document.getElementById("input-right");

                                var thumbLeft = document.querySelector(".slider > .thumb.left");
                                var thumbRight = document.querySelector(".slider > .thumb.right");
                                var range = document.querySelector(".slider > .range");

                                function setLeftValue() {
                                var _this = inputLeft,
                                    min = parseInt(_this.min),
                                    max = parseInt(_this.max);

                                _this.value = Math.min(parseInt(_this.value), parseInt(inputRight.value) - 1);

                                var percent = ((_this.value - min) / (max - min)) * 100;

                                thumbLeft.style.left = percent + "%";
                                range.style.left = percent + "%";
                                }
                                setLeftValue();

                                function setRightValue() {
                                    var _this = inputRight,
                                        min = parseInt(_this.min),
                                        max = parseInt(_this.max);

                                        _this.value = Math.max(parseInt(_this.value), parseInt(inputLeft.value) + 1);

                                        var percent = ((_this.value - min) / (max - min)) * 100;

                                        thumbRight.style.right = (100 - percent) + "%";
                                        range.style.right = (100 - percent) + "%";
                                    }
                                    setRightValue();

                                    inputLeft.addEventListener("input", setLeftValue);
                                    inputRight.addEventListener("input", setRightValue);

                                    inputLeft.addEventListener("mouseover", function() {
                                        thumbLeft.classList.add("hover");
                                    });
                                    inputLeft.addEventListener("mouseout", function() {
                                        thumbLeft.classList.remove("hover");
                                    });
                                    // inputLeft.addEventListener("mousedown", function() {
                                    //     thumbLeft.classList.add("active");
                                    // });
                                    // inputLeft.addEventListener("mouseup", function() {
                                    //     thumbLeft.classList.remove("active");
                                    // });

                                    inputRight.addEventListener("mouseover", function() {
                                        thumbRight.classList.add("hover");
                                    });
                                    inputRight.addEventListener("mouseout", function() {
                                        thumbRight.classList.remove("hover");
                                    });
                                    // inputRight.addEventListener("mousedown", function() {
                                    //     thumbRight.classList.add("active");
                                    // });
                                    // inputRight.addEventListener("mouseup", function() {
                                    //     thumbRight.classList.remove("active");
                                    // });
                            </script>

                            <div class="search-accordion accordion mb-3" id="ethnicityAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#ethnicityAccordionCollapse" aria-expanded="false" aria-controls="ethnicityAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'ethnicity') }}
                                        </button>
                                    </h6>
                                    <div id="ethnicityAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#ethnicityAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox1">
                                                <label class="form-check-label" for="ethnicityCheckbox1">
                                                    {{ getJsonLocalization('find-a-person', 'asian') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox2">
                                                <label class="form-check-label" for="ethnicityCheckbox2">
                                                    {{ getJsonLocalization('find-a-person', 'black_african') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox3">
                                                <label class="form-check-label" for="ethnicityCheckbox3">
                                                    {{ getJsonLocalization('find-a-person', 'latin_hispanic') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox4">
                                                <label class="form-check-label" for="ethnicityCheckbox4">
                                                    {{ getJsonLocalization('find-a-person', 'east_indian') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox5">
                                                <label class="form-check-label" for="ethnicityCheckbox5">
                                                    {{ getJsonLocalization('find-a-person', 'middle_eastern_north_african') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox6">
                                                <label class="form-check-label" for="ethnicityCheckbox6">
                                                    {{ getJsonLocalization('find-a-person', 'mixed') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox7">
                                                <label class="form-check-label" for="ethnicityCheckbox7">
                                                    {{ getJsonLocalization('find-a-person', 'native_american') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox8">
                                                <label class="form-check-label" for="ethnicityCheckbox8">
                                                    {{ getJsonLocalization('find-a-person', 'white_caucasian') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="ethnicityCheckbox9">
                                                <label class="form-check-label" for="ethnicityCheckbox9">
                                                    {{ getJsonLocalization('find-a-person', 'other') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="search-accordion accordion mb-5" id="languageAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#languageAccordionCollapse" aria-expanded="false" aria-controls="languageAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'language') }}
                                        </button>
                                    </h6>
                                    <div id="languageAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#languageAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox1">
                                                <label class="form-check-label" for="languageCheckbox1">
                                                    {{ getJsonLocalization('find-a-person', 'english') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox2">
                                                <label class="form-check-label" for="languageCheckbox2">
                                                    {{ getJsonLocalization('find-a-person', 'french') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox3">
                                                <label class="form-check-label" for="languageCheckbox3">
                                                    {{ getJsonLocalization('find-a-person', 'spanish') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox4">
                                                <label class="form-check-label" for="languageCheckbox4">
                                                    {{ getJsonLocalization('find-a-person', 'mandarin') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox5">
                                                <label class="form-check-label" for="languageCheckbox5">
                                                    {{ getJsonLocalization('find-a-person', 'german') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox6">
                                                <label class="form-check-label" for="languageCheckbox6">
                                                    {{ getJsonLocalization('find-a-person', 'japanese') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox7">
                                                <label class="form-check-label" for="languageCheckbox7">
                                                    {{ getJsonLocalization('find-a-person', 'russian') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox8">
                                                <label class="form-check-label" for="languageCheckbox8">
                                                    {{ getJsonLocalization('find-a-person', 'portuguese') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox9">
                                                <label class="form-check-label" for="languageCheckbox9">
                                                    {{ getJsonLocalization('find-a-person', 'arabic') }}
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageCheckbox10">
                                                <label class="form-check-label" for="languageCheckbox10">
                                                    {{ getJsonLocalization('find-a-person', 'hindi') }}
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <h4 class="mb-4">{{ getJsonLocalization('find-a-person', 'completed_exams') }}</h4>
                            <div class="search-accordion accordion mb-3" id="BasicProgrammingLanguagesAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                    <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#BasicProgrammingLanguagesAccordionCollapse" aria-expanded="false" aria-controls="BasicProgrammingLanguagesAccordionCollapse">
                                        {{ getJsonLocalization('find-a-person', 'basic_programming_languages') }}
                                    </button>
                                    </h6>
                                    <div id="BasicProgrammingLanguagesAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#BasicProgrammingLanguagesAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox1">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox1">
                                                    Java
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox2">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox2">
                                                    Javascript
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox3">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox3">
                                                    C++
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox4">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox4">
                                                    C
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox5">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox5">
                                                    C#
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox6">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox6">
                                                    HTML
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox7">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox7">
                                                    CSS
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox8">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox8">
                                                    Python
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox9">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox9">
                                                    GO
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox10">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox10">
                                                    Php
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox11">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox11">
                                                    Ruby
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox12">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox12">
                                                    Swift
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox13">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox13">
                                                    Kotlin
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox14">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox14">
                                                    Typescript
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="basicProgrammingLanguagesCheckbox15">
                                                <label class="form-check-label" for="basicProgrammingLanguagesCheckbox15">
                                                    Dart
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="javascriptFrameworksAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#javascriptFrameworksAccordionCollapse" aria-expanded="false" aria-controls="javascriptFrameworksAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'javascript_frameworks') }}
                                        </button>
                                    </h6>
                                    <div id="javascriptFrameworksAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#javascriptFrameworksAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox1">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox1">
                                                    React
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox2">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox2">
                                                    Vue
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox3">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox3">
                                                    Angular
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox4">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox4">
                                                    Next
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox5">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox5">
                                                    Svelte
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox6">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox6">
                                                    Node
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javascriptFrameworksCheckbox7">
                                                <label class="form-check-label" for="javascriptFrameworksCheckbox7">
                                                    Express
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="phpFrameworksAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#phpFrameworksAccordionCollapse" aria-expanded="false" aria-controls="phpFrameworksAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'php_frameworks') }}
                                        </button>
                                    </h6>
                                    <div id="phpFrameworksAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#phpFrameworksAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox1">
                                                <label class="form-check-label" for="phpFrameworksCheckbox1">
                                                    Laravel
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox2">
                                                <label class="form-check-label" for="phpFrameworksCheckbox2">
                                                    Symphony
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox3">
                                                <label class="form-check-label" for="phpFrameworksCheckbox3">
                                                    CodeIgniter
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox4">
                                                <label class="form-check-label" for="phpFrameworksCheckbox4">
                                                    Zend
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox5">
                                                <label class="form-check-label" for="phpFrameworksCheckbox5">
                                                    Yii
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="phpFrameworksCheckbox6">
                                                <label class="form-check-label" for="phpFrameworksCheckbox6">
                                                    Phalcon
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="javaFrameworksAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#javaFrameworksAccordionCollapse" aria-expanded="false" aria-controls="javaFrameworksAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'java_frameworks') }}
                                        </button>
                                    </h6>
                                    <div id="javaFrameworksAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#javaFrameworksAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox1">
                                                <label class="form-check-label" for="javaFrameworksCheckbox1">
                                                    Spring
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox2">
                                                <label class="form-check-label" for="javaFrameworksCheckbox2">
                                                    Hibernate
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox3">
                                                <label class="form-check-label" for="javaFrameworksCheckbox3">
                                                    Struts
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox4">
                                                <label class="form-check-label" for="javaFrameworksCheckbox4">
                                                    JSF
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox5">
                                                <label class="form-check-label" for="javaFrameworksCheckbox5">
                                                    Grails
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox6">
                                                <label class="form-check-label" for="javaFrameworksCheckbox6">
                                                    Vaadin
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox7">
                                                <label class="form-check-label" for="javaFrameworksCheckbox7">
                                                    JavaFX
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="javaFrameworksCheckbox8">
                                                <label class="form-check-label" for="javaFrameworksCheckbox8">
                                                    Swing
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="cssFrameworksAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#cssFrameworksAccordionCollapse" aria-expanded="false" aria-controls="cssFrameworksAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'css_frameworks') }}
                                        </button>
                                    </h6>
                                    <div id="cssFrameworksAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#cssFrameworksAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox1">
                                                <label class="form-check-label" for="cssFrameworksCheckbox1">
                                                    Bootstrap
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox2">
                                                <label class="form-check-label" for="cssFrameworksCheckbox2">
                                                    Bulma
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox3">
                                                <label class="form-check-label" for="cssFrameworksCheckbox3">
                                                    Foundation
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox4">
                                                <label class="form-check-label" for="cssFrameworksCheckbox4">
                                                    Materialize
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox5">
                                                <label class="form-check-label" for="cssFrameworksCheckbox5">
                                                    Semantic
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox6">
                                                <label class="form-check-label" for="cssFrameworksCheckbox6">
                                                    Tailwind
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cssFrameworksCheckbox7">
                                                <label class="form-check-label" for="cssFrameworksCheckbox7">
                                                    UIkit
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="microsoftSuitAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#microsoftSuitAccordionCollapse" aria-expanded="false" aria-controls="microsoftSuitAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'microsoft_suite') }}
                                        </button>
                                    </h6>
                                    <div id="microsoftSuitAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#microsoftSuitAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox1">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox1">
                                                    Access
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox2">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox2">
                                                    OneNote
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox3">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox3">
                                                    Outlook
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox4">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox4">
                                                    Excel
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox5">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox5">
                                                    Word
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox6">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox6">
                                                    Project
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox7">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox7">
                                                    PowerPoint
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox8">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox8">
                                                    Publisher
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="microsoftSuiteCheckbox9">
                                                <label class="form-check-label" for="microsoftSuiteCheckbox9">
                                                    Visio
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="AiAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#AiAccordionCollapse" aria-expanded="false" aria-controls="AiAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'ai') }}
                                        </button>
                                    </h6>
                                    <div id="AiAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#AiAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox1">
                                                <label class="form-check-label" for="aiCheckbox1">
                                                    MX-Net
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox2">
                                                <label class="form-check-label" for="aiCheckbox2">
                                                    Scikit-Learn
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox3">
                                                <label class="form-check-label" for="aiCheckbox3">
                                                    TensorFlow
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox4">
                                                <label class="form-check-label" for="aiCheckbox4">
                                                    PyTorch
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox5">
                                                <label class="form-check-label" for="aiCheckbox5">
                                                    Keras
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="aiCheckbox6">
                                                <label class="form-check-label" for="aiCheckbox6">
                                                    Caffe
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="cSharpAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#cSharpAccordionCollapse" aria-expanded="false" aria-controls="cSharpAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'csharp_frameworks') }}
                                        </button>
                                    </h6>
                                    <div id="cSharpAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#cSharpAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox1">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox1">
                                                    .NET
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox2">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox2">
                                                    ASP.NET
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox3">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox3">
                                                    Xamarin
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox4">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox4">
                                                    Entity
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox5">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox5">
                                                    Blazor
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox6">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox6">
                                                    WPF
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="cSharpFrameworksCheckbox7">
                                                <label class="form-check-label" for="cSharpFrameworksCheckbox7">
                                                    MAUI
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="adobeSuitAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#adobeSuitAccordionCollapse" aria-expanded="false" aria-controls="adobeSuitAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'adobe_suite') }}
                                        </button>
                                    </h6>
                                    <div id="adobeSuitAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#adobeSuitAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox1">
                                                <label class="form-check-label" for="adobeSuiteCheckbox1">
                                                    Photoshop
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox2">
                                                <label class="form-check-label" for="adobeSuiteCheckbox2">
                                                    Illustrator
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox3">
                                                <label class="form-check-label" for="adobeSuiteCheckbox3">
                                                    Premiere
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox4">
                                                <label class="form-check-label" for="adobeSuiteCheckbox4">
                                                    After Effects
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox5">
                                                <label class="form-check-label" for="adobeSuiteCheckbox5">
                                                    Lightroom
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox6">
                                                <label class="form-check-label" for="adobeSuiteCheckbox6">
                                                    InDesign
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="adobeSuiteCheckbox7">
                                                <label class="form-check-label" for="adobeSuiteCheckbox7">
                                                    XD
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="threeD-EngineAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#threeD-EngineAccordionCollapse" aria-expanded="false" aria-controls="threeD-EngineAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'three_d_engine') }}
                                        </button>
                                    </h6>
                                    <div id="threeD-EngineAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#threeD-EngineAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox1">
                                                <label class="form-check-label" for="3dEngineCheckbox1">
                                                    Blender
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox2">
                                                <label class="form-check-label" for="3dEngineCheckbox2">
                                                    3ds Max
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox3">
                                                <label class="form-check-label" for="3dEngineCheckbox3">
                                                    Maya
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox4">
                                                <label class="form-check-label" for="3dEngineCheckbox4">
                                                    CryEngine
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox5">
                                                <label class="form-check-label" for="3dEngineCheckbox5">
                                                    Unreal Engine
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="3dEngineCheckbox6">
                                                <label class="form-check-label" for="3dEngineCheckbox6">
                                                    Unity
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="search-accordion accordion mb-3" id="languageExamsAccordion">
                                <div class="accordion-item border-0">
                                    <h6 class="accordion-header" id="accordionHeading">
                                        <button class="accordion-button collapsed p-0" type="button" data-bs-toggle="collapse" data-bs-target="#languageExamsAccordionCollapse" aria-expanded="false" aria-controls="languageExamsAccordionCollapse">
                                            {{ getJsonLocalization('find-a-person', 'language_exams') }}
                                        </button>
                                    </h6>
                                    <div id="languageExamsAccordionCollapse" class="accordion-collapse collapse" aria-labelledby="accordionHeading" data-bs-parent="#languageExamsAccordion">
                                        <div class="accordion-body px-2">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox1">
                                                <label class="form-check-label" for="languageExamsCheckbox1">
                                                    English
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox2">
                                                <label class="form-check-label" for="languageExamsCheckbox2">
                                                    French
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox3">
                                                <label class="form-check-label" for="languageExamsCheckbox3">
                                                    Spanish
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox4">
                                                <label class="form-check-label" for="languageExamsCheckbox4">
                                                    Mandarin
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox5">
                                                <label class="form-check-label" for="languageExamsCheckbox5">
                                                    German
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox6">
                                                <label class="form-check-label" for="languageExamsCheckbox6">
                                                    Japanese
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox7">
                                                <label class="form-check-label" for="languageExamsCheckbox7">
                                                    Russian
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox8">
                                                <label class="form-check-label" for="languageExamsCheckbox8">
                                                    Portuguese
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox9">
                                                <label class="form-check-label" for="languageExamsCheckbox9">
                                                    Arabic
                                                </label>
                                            </div>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" value="" id="languageExamsCheckbox10">
                                                <label class="form-check-label" for="languageExamsCheckbox10">
                                                    Hindi
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div>
                                <hr />
                            </div>
                            
                            <div class="row g-2">
                                <div class="col-12">
                                    <button class="wf-btn wf-btn-secondary w-100">
                                        {{ getJsonLocalization('find-a-person', 'view_results') }}
                                    </button>
                                </div>
                                <div class="col-md-7">
                                    <button class="wf-btn wf-btn-outline-secondary w-100">
                                        {{ getJsonLocalization('find-a-person', 'save_this_search') }}
                                    </button>
                                </div>
                                <div class="col-md-5">
                                    <button class="wf-btn wf-btn-outline-secondary w-100">
                                        {{ getJsonLocalization('find-a-person', 'reset') }}
                                    </button>
                                </div>
                            </div>

                        </form>
                    </div>
                </div>
                <div class="find-person-main-content">
                    <div class="find-person-main-content-inner">
                        <div class="row gy-4">
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/kotlin.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/php.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/python.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/maya.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/typescript.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/kotlin.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/kotlin.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/php.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/kotlin.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-6 col-xxl-4">
                                <div class="profile-card">
                                    <img src="images/user.jpg" class="card-img" alt="img" />
                                    <div class="profile-card-header">
                                        <div class="inner1">
                                            <h5 class="user-name mb-0">John Doe</h5>
                                            <div class="text-mini">San Francisco, USA</div>
                                        </div>
                                        <div class="inner2">
                                            <h5 class="user-name mb-0">Frontend</h5>
                                            <div class="text-mini">Mind Bridge</div>
                                        </div>
                                    </div>
                                    <div class="profile-card-body">
                                        <div class="right-sidebar">
                                            <div class="row justify-content-end g-1">
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/angular.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/adobe-ai.png" alt="img" />
                                                    </div>
                                                </div>
                                                <div class="col-6">
                                                    <div class="exam-icon">
                                                        <img src="images/icons/tech-icons/java.png" alt="img" />
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="profile-card-footer">
                                        <a href="#" class="icon me-2"><i class="fa fa-commenting-o" aria-hidden="true"></i></a>
                                        <a href="#" class="icon"><i class="fa fa-heart-o" aria-hidden="true"></i></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
