<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Book an online presentation | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('book-an-online-presentation', 'heading') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn mb-3" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('book-an-online-presentation', 'sub_heading_1') }}
                    </h5>
                    <h5 class="mb-4 wow fadeIn mb-5 text-secondary" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('book-an-online-presentation', 'sub_heading_2') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('find-a-job', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('find-a-job', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img18.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white border-top">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('book-an-online-presentation', 'section_title') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('book-an-online-presentation', 'description_1') }}</p>
                    <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('book-an-online-presentation', 'description_2') }}</p>
                    <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('book-an-online-presentation', 'description_3') }}</p>
                </div>
            </div>
            <div class="row justify-content-center gy-4">
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img1.jpg" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_1_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_1_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img2.jpg" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_2_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_2_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img3.jpg" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_3_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_3_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img4.jpg" class="mb-4" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_4_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_4_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img5.jpg" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_5_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_5_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img6.jpg" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_6_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_6_description') }}</p>
                    </div>
                </div>
                <div class="col-md-6 col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="border rounded p-3 h-100 text-md-start text-center">
                        <img src="images/book-online-presentation-img7.jpg" class="mb-4" alt="img" />
                        <h4 class="mb-3">{{ getJsonLocalization('book-an-online-presentation', 'feature_7_title') }}</h4>
                        <p>{{ getJsonLocalization('book-an-online-presentation', 'feature_7_description') }}</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white border-top">
        <div class="container">
            <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                <label class="form-label mb-3"><b>{{ getJsonLocalization('book-an-online-presentation', 'meeting_title') }}</b></label>
                <div class="row">
                    <div class="col-lg-9">
                        <div class="row mb-4">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault">
                                    <label class="form-check-label" for="flexCheckDefault">
                                        {{ getJsonLocalization('book-an-online-presentation', 'user_interface_basic_functionalities') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox2">
                                    <label class="form-check-label" for="checkbox2">
                                        {{ getJsonLocalization('book-an-online-presentation', 'video_calls') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox3">
                                    <label class="form-check-label" for="checkbox3">
                                        {{ getJsonLocalization('book-an-online-presentation', 'job_offers') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox4">
                                    <label class="form-check-label" for="checkbox4">
                                        {{ getJsonLocalization('book-an-online-presentation', 'automatic_interviews') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox5">
                                    <label class="form-check-label" for="checkbox5">
                                        {{ getJsonLocalization('book-an-online-presentation', 'online_exams') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox6">
                                    <label class="form-check-label" for="checkbox6">
                                        {{ getJsonLocalization('book-an-online-presentation', 'payments') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox7">
                                    <label class="form-check-label" for="checkbox7">
                                        {{ getJsonLocalization('book-an-online-presentation', 'online_classes') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="checkbox8">
                                    <label class="form-check-label" for="checkbox8">
                                        {{ getJsonLocalization('book-an-online-presentation', 'others') }}
                                    </label>
                                </div>
                            </div>
                        </div>
                        <div class="row gy-3">
                            <div class="col-md-6">
                                <input type="text" class="form-control" placeholder="{{ getJsonLocalization('book-an-online-presentation', 'first_name') }}" />
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control"  placeholder="{{ getJsonLocalization('book-an-online-presentation', 'last_name') }}" />
                            </div>
                            <div class="col-12">
                                <input type="date" class="form-control" />
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control"  placeholder="{{ getJsonLocalization('book-an-online-presentation', 'city') }}" />
                            </div>
                            <div class="col-md-6">
                                <input type="text" class="form-control"  placeholder="{{ getJsonLocalization('book-an-online-presentation', 'country') }}" />
                            </div>
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault1" checked>
                                    <label class="form-check-label" for="flexRadioDefault1">
                                        {{ getJsonLocalization('book-an-online-presentation', 'enterprise') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-check">
                                    <input class="form-check-input" type="radio" name="flexRadioDefault" id="flexRadioDefault2">
                                    <label class="form-check-label" for="flexRadioDefault2">
                                        {{ getJsonLocalization('book-an-online-presentation', 'school') }}
                                    </label>
                                </div>
                            </div>
                            <div class="col-12">
                                <input type="text" class="form-control"  placeholder="{{ getJsonLocalization('book-an-online-presentation', 'organization_name') }}" />
                            </div>
                            <div class="col-12">
                                <textarea class="form-control" row="5" placeholder="{{ getJsonLocalization('book-an-online-presentation', 'details') }}"></textarea>
                            </div>
                            <div class="col-12 mt-5">
                                <button class="wf-btn wf-btn-primary">{{ getJsonLocalization('book-an-online-presentation', 'send') }}</button>
                            </div>
                        </div>
                    </div>
                </div> 
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
