<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Innovations | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('innovations', 'section_title') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <span class="text-secondary">Workfrater,</span> {{ getJsonLocalization('innovations', 'section_subtitle') }}
                    </h5>
                    <div class="description mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <p>{{ getJsonLocalization('innovations', 'section_description') }}</p>
                    </div>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('find-a-job', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('find-a-job', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img14.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white overflow-hidden border-top">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('innovations', 'section_title2') }}
                </h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('innovations', 'section_description2') }}</p>
                </div>
            </div>
            <div class="row align-items-center gy-4 gx-lg-5 mb-5">
                <div class="col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/innovations-img1.jpg" alt="img" />
                </div>
                <div class="col-lg-8 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h4>{{ getJsonLocalization('innovations', 'online_assessments_title') }}</h4>
                    <div>
                        <p>{{ getJsonLocalization('innovations', 'online_assessments_paragraph1') }}</p>
                        <p>{{ getJsonLocalization('innovations', 'online_assessments_paragraph2') }}</p>
                        <p>{{ getJsonLocalization('innovations', 'online_assessments_paragraph3') }}</p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center gy-4 gx-lg-5 mb-5">
                <div class="col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/innovations-img2.jpg" alt="img" />
                </div>
                <div class="col-lg-8 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h4>{{ getJsonLocalization('innovations', 'online_interviews_title') }}</h4>
                    <div>
                        <p>{{ getJsonLocalization('innovations', 'online_interviews_paragraph1') }}</p>
                        <p>{{ getJsonLocalization('innovations', 'online_interviews_paragraph2') }}</p>
                        <p>{{ getJsonLocalization('innovations', 'online_interviews_paragraph3') }}</p>
                    </div>
                </div>
            </div>
            <div class="row align-items-center gy-4 gx-lg-5 mb-5">
                <div class="col-lg-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/innovations-img3.jpg" alt="img" />
                </div>
                <div class="col-lg-8 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <h4>{{ getJsonLocalization('innovations', 'advanced_video_system_title') }}</h4>
                    <p>{{ getJsonLocalization('innovations', 'advanced_video_system_description') }}</p>
                </div>
            </div>
        </div>
    </section>


    <section class="section-padding bg-white border-top">
        <div class="container">
            <div class="row g-4 g-lg-5">
                <div class="col-md-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded-large p-3 p-lg-4 border h-100">
                        <img src="images/innovations-img4.png" class="mb-5 mx-auto d-block" style="height:250px" alt="img" />
                        <h4>{{ getJsonLocalization('innovations', 'record_videos_title') }}</h4>
                        <div>
                            <p>{{ getJsonLocalization('innovations', 'record_videos_description') }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded-large p-3 p-lg-4 border h-100">
                        <img src="images/innovations-img5.jpg" class="mb-5 mx-auto d-block" style="height:250px" alt="img" />
                        <h4>{{ getJsonLocalization('innovations', 'record_screen_title') }}</h4>
                        <div>
                            <p>{{ getJsonLocalization('innovations', 'record_screen_description') }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded-large p-3 p-lg-4 border h-100">
                        <img src="images/innovations-img6.jpg" class="mb-5 mx-auto d-block" style="height:250px" alt="img" />
                        <h4>{{ getJsonLocalization('innovations', 'customizable_waiting_rooms_title') }}</h4>
                        <div>
                            <p>{{ getJsonLocalization('innovations', 'customizable_waiting_rooms_description1') }}</p>
                            <p>{{ getJsonLocalization('innovations', 'customizable_waiting_rooms_description2') }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <div class="rounded-large p-3 p-lg-4 border h-100">
                        <img src="images/innovations-img7.jpg" class="mb-5 mx-auto d-block" style="height:250px" alt="img" />
                        <h4>{{ getJsonLocalization('innovations', 'online_class_exams_title') }}</h4>
                        <div>
                            <p>{{ getJsonLocalization('innovations', 'online_class_exams_description1') }}</p>
                            <p>{{ getJsonLocalization('innovations', 'online_class_exams_description2') }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')
    

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
