<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>Our Customers | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'ourcustomers_title') }}</h1>
                    <h5 class="mb-4 wow fadeIn mb-5" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'ourcustomers_description') }}</h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('ourcustomers', 'sign_up') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('ourcustomers', 'contact') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img16.jpg" class="banner-img" alt="img" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-white overflow-hidden border-top">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center mb-3 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_support_title') }}</h2>
            </div>
            <div class="container-large px-0 text-center">
                <h4 class="mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'employers_title') }}</h4>
                <img src="images/our-customers-img1.jpg" class="mb-5 w-100 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" alt="img" style="max-width:700px;" />
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_description_1') }} <a href="/public/professional-network" class="text-secondary">{{ getJsonLocalization('ourcustomers', 'all-the-necessary-tools') }}</a>.</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_description_2a') }}
                    <a href="/public/assessments-tests/" class="text-secondary">{{ getJsonLocalization('ourcustomers', 'all-the-necessary-tools') }}</a>
                    {{ getJsonLocalization('ourcustomers', 'customers_description_2b') }}
                </p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_description_3') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_description_4') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'customers_description_5') }}</p>
            </div>  
        </div>
    </section>

    <section class="section-padding border-top bg-white">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('ourcustomers', 'intro_paragraph') }}</p>
                </div>
            </div> 
            <div class="row justify-content-center">
                <div class="col-lg-4 py-4 px-3 p-sm-5 text-lg-start text-center border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img2.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'filter_geographic_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'filter_geographic_description') }}</p>
                </div>
                <div class="col-lg-4 py-4 px-3 p-sm-5 text-lg-start text-center border-start border-end border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img3.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'filter_age_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'filter_age_description') }}</p>
                </div>
                <div class="col-lg-4 py-4 px-3 p-sm-5 text-lg-start text-center border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img4.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'filter_ethnicity_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'filter_ethnicity_description') }}</p>
                </div>
                <div class="col-lg-4 py-4 px-3 p-sm-5 text-lg-start text-center border-start border-end border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img5.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'filter_education_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'filter_education_description') }}</p>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-primary text-white overflow-hidden">
        <div class="container">
            <div class="container-large px-0 text-center">
                <img src="images/our-customers-img6.jpg" class="mb-5 w-100 rounded-large wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" alt="img" style="max-width:700px;" />
                <h4 class="mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'schools_title') }}</h4>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'schools_intro_paragraph') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'schools_difficulty_paragraph1') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'schools_difficulty_paragraph2') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'schools_solution_paragraph') }}</p>
            </div>  
        </div>
    </section>

    <section class="section-padding border-top bg-white">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-4 p-5 border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img7.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'device_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'device_description') }}</p>
                </div>
                <div class="col-lg-4 p-5 border-start border-end border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img8.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'record_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'record_description') }}</p>
                </div>
                <div class="col-lg-4 p-5 border-bottom border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img9.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'waiting_page_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'waiting_page_description') }}</p>
                </div>
                <div class="col-lg-4 p-5 border-start border-end border-secondary wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <img src="images/our-customers-img10.jpg" class="mb-4" alt="img" />
                    <h4 class="mb-3">{{ getJsonLocalization('ourcustomers', 'exam_settings_title') }}</h4>
                    <p>{{ getJsonLocalization('ourcustomers', 'exam_settings_description') }}</p>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding bg-primary text-white overflow-hidden">
        <div class="container">
            <div class="container-large px-0 text-center">
                <img src="images/our-customers-img10.jpg" class="mb-5 w-100 rounded-large wow fadeIn" data-wow-delay="0s" data-wow-duration="1s" alt="img" style="max-width:700px;" />
                <h4 class="mb-5 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'business_school_title') }}</h4>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    {{ getJsonLocalization('ourcustomers', 'dedicated_platform_description') }}
                    <a href="/public/become-an-entrepreneur" class="text-secondary">
                        {{ getJsonLocalization('ourcustomers', 'dedicated_platform_link') }}
                    </a>
                    {{ getJsonLocalization('ourcustomers', 'dedicated_platform_continued') }}
                </p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'search_engine_description') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'crowdfunding_option_description') }}</p>
                <p class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('ourcustomers', 'school_account_description') }}</p>
            </div>  
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Contact Section -->
    @include('contactSection')
    

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
