<?php
session_start();

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <!-- links and scripts -->


    <title>General FAQ | Workfrater</title>

    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/x-icon" href="/images/favicon.ico">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.css" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css"
        integrity="sha512-SfTiTlX6kk+qitfevl/7LibUOeJWlt9rbyDn92a1DqWOw9vWG2MFoays0sgObmWazO5BQPiFucnnEAjpAB+/Sw=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="css/animate.css">    
    <link rel="stylesheet" href="css/slick.css">
    <link rel="stylesheet" href="css/slick-theme.css">
    <link rel="stylesheet" href="css/utils.css">
    <link rel="stylesheet" href="css/ui-elements.css">
    <link rel="stylesheet" href="css/bootstrap-overrides.css">
    <link rel="stylesheet" href="css/home.css">
    <link rel="stylesheet" href="css/index.css">
    <link rel="stylesheet" href="css/responsive.css">

    <script src="js/jquery.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.1/dist/js/bootstrap.min.js"
        integrity="sha384-Atwg2Pkwv9vp0ygtn1JAojH0nYbwNJLPhwyoVbhoPwBhjQPR5VtM2+xf0Uwh9KtT" crossorigin="anonymous">
    </script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script type="text/javascript" src="https://threejs.org/examples/js/libs/stats.min.js"></script>
    <script src="js/countrypicker.js"></script>

    <script type="text/javascript" src="js/wow.min.js"></script>
    <script type="text/javascript" src="js/slick.min.js"></script>
    <script type="text/javascript" src="js/custom.js"></script>
    <script type="text/javascript" src="js//url.js"></script>

</head>

<body>

    @include('header')

    <!-- Banner Section -->
    <section class="banner-section section-padding bg-white">
        <div class="container">
            <div class="row gy-5 align-items-center flex-md-row flex-column-reverse">
                <div class="col-md-6 text-md-start text-center">
                    <h1 class="stylish-heading mb-4 wow fadeInLeft" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'heading') }}
                    </h1>
                    <h5 class="mb-4 wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        {{ getJsonLocalization('generalfaq', 'faq_description') }}
                    </h5>
                    <div class="wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                        <a href="#auth-section" class="wf-btn wf-btn-secondary me-2">
                            {{ getJsonLocalization('generalfaq', 'sign_up_button') }}
                        </a>
                        <a href="#contact-section" class="wf-btn wf-btn-outline-secondary">
                            {{ getJsonLocalization('generalfaq', 'contact_button') }}
                        </a>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="text-center">
                        <img src="images/banner-img24.jpg" class="banner-img" alt="{{ getJsonLocalization('generalfaq', 'banner_alt') }}" />
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="section-padding">
        <div class="container">
            <h2 class="text-center mb-5">
                {{ getJsonLocalization('generalfaq', 'faq_heading') }} 
                <span class="text-secondary">
                    <i>{{ getJsonLocalization('generalfaq', 'faq_subheading') }}</i>
                </span>
            </h2>
            <div class="accordion wf-accordion" id="faqCategories-accordion">
                <div class="accordion-item position-relative">
                    <div class="faq-target" id="creating-job-offers"></div>
                    <h2 class="accordion-header" id="faqCategories-accordion-headingFive">
                        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faqCategories-accordion-collapseFive" aria-expanded="true" aria-controls="faqCategories-accordion-collapseFive">
                            {{ getJsonLocalization('generalfaq', 'heading') }}
                        </button>
                    </h2>
                    <div id="faqCategories-accordion-collapseFive" class="accordion-collapse collapse show" aria-labelledby="faqCategories-accordion-headingFive" data-bs-parent="#faqCategories-accordion">
                        <div class="accordion-body">
                            <div class="accordion" id="creating-job-offers">
                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingOne">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseOne" aria-expanded="false" aria-controls="creating-job-offers-collapseOne">
                                            {{ getJsonLocalization('generalfaq', 'headingOne') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseOne" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingOne" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphOne') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTwo">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseTwo" aria-expanded="false" aria-controls="creating-job-offers-collapseTwo">
                                            {{ getJsonLocalization('generalfaq', 'headingTwo') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTwo" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingTwo" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphTwo') }}</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemOne') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemTwo') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemThree') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemFour') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemFive') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'listItemSix') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingThree">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseThree" aria-expanded="false" aria-controls="creating-job-offers-collapseThree">
                                            {{ getJsonLocalization('generalfaq', 'headingThree') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseThree" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingThree" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphThree') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingFour">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#creating-job-offers-collapseFour" aria-expanded="false" aria-controls="creating-job-offers-collapseFour">
                                            {{ getJsonLocalization('generalfaq', 'headingFour') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseFour" class="accordion-collapse collapse" aria-labelledby="creating-job-offers-headingFour" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'paragraphFour') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingFive">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseFive" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseFive">
                                            {{ getJsonLocalization('generalfaq', 'test_candidate_without_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseFive" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingFive" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'test_candidate_explanation_1') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'test_candidate_explanation_2') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingSix">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseSix" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseSix">
                                            {{ getJsonLocalization('generalfaq', 'job_offer_board') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseSix" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingSix" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'job_offer_board_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_list') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_results') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_statistics') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_summary') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_videos') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'job_offer_board_documents') }}</b></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingSeven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseSeven" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseSeven">
                                            {{ getJsonLocalization('generalfaq', 'individual_candidate_pdf') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseSeven" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingSeven" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_identity') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_site_info') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_test_results') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'individual_candidate_pdf_availability') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingEight">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseEight" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseEight">
                                            {{ getJsonLocalization('generalfaq', 'global_job_offer_pdf') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseEight" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingEight" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_applicants') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_test_results') }}</b></li>
                                                <li><b>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_statistics') }}</b></li>
                                            </ul>
                                            <p>{{ getJsonLocalization('generalfaq', 'global_job_offer_pdf_summary') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingNine">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseNine" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseNine">
                                            {{ getJsonLocalization('generalfaq', 'selecting_right_candidate') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseNine" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingNine" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_intro') }}</p>
                                            <ul class="bulleted-list">
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_video_interviews') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_suggested_questions') }}</li>
                                                <li>{{ getJsonLocalization('generalfaq', 'selecting_right_candidate_test_assessments') }}</li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseTen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseTen">
                                            {{ getJsonLocalization('generalfaq', 'terminate_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingTen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'terminate_job_offer_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingEleven">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseEleven" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseEleven">
                                            {{ getJsonLocalization('generalfaq', 'pause_job_offer') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseEleven" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingEleven" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'pause_job_offer_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingTwelve">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseTwelve" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseTwelve">
                                            {{ getJsonLocalization('generalfaq', 'create_job_offer_mobile') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseTwelve" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingTwelve" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'create_job_offer_mobile_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingThirteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseThirteen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseThirteen">
                                            {{ getJsonLocalization('generalfaq', 'watch_video_exams_mobile') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseThirteen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingThirteen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'watch_video_exams_mobile_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                                <div class="accordion-item">
                                    <h2 class="accordion-header" id="creating-job-offers-headingForteen">
                                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" 
                                            data-bs-target="#creating-job-offers-collapseForteen" aria-expanded="false" 
                                            aria-controls="creating-job-offers-collapseForteen">
                                            {{ getJsonLocalization('generalfaq', 'prevent_someone_apply') }}
                                        </button>
                                    </h2>
                                    <div id="creating-job-offers-collapseForteen" class="accordion-collapse collapse" 
                                        aria-labelledby="creating-job-offers-headingForteen" data-bs-parent="#creating-job-offers">
                                        <div class="accordion-body">
                                            <p>{{ getJsonLocalization('generalfaq', 'prevent_someone_apply_desc') }}</p>
                                            <p>{{ getJsonLocalization('generalfaq', 'block_user_desc') }}</p>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Auth Section -->
    <section id="auth-section" class="auth-section section-padding">
        <div class="container">
            <div class="section-title-area text-center mx-auto">
                <h2 class="text-center wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">{{ getJsonLocalization('index', 'do_you_have_an_account') }}</h2>
                <div class="description wow fadeIn" data-wow-delay="0s" data-wow-duration="1s">
                    <p>{{ getJsonLocalization('index', 'sign_in_exclusive_benefits') }}</p>
                </div>
            </div>
            <div class="form-box box-shadow mx-auto">
                <div class="text-center">
                    <img src="logos//logo1.png" class="logo-image mb-4" alt="img" width="150px">
                </div>
                <h2>{{ getJsonLocalization('index', 'signin') }}</h2>
                <p class="mb-4">{{ getJsonLocalization('index', 'new user') }} <a
                        class="no-decoration text-secondary text-mini"
                        href="{{ route('signup') }}">{{ getJsonLocalization('index', 'create account') }}</a>
                </p>
                <div class="loginPanel">
                    <!-- Custom Addition -->
                    @if (session()->has('success'))
                        <div class="alert alert-success" role="alert">
                            {{ session()->get('success') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    @if (session()->has('failed'))
                        <div class="alert alert-danger" role="alert">
                            {{ session()->get('failed') }}
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                    @endif
                    <!-- Custom Addition -->

                    <form action="{{ route('action_login') }}" method="POST">
                        @csrf
                        <input type="text" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'email or phone') }}" id="login_email"
                            name="login_email">
                        <input type="password" class="form-control mb-2"
                            placeholder="{{ getJsonLocalization('index', 'password') }}" id="login_pass"
                            name="login_pass">
                        <button type="submit"
                            class="wf-btn wf-btn-secondary w-100">{{ getJsonLocalization('index', 'signin') }}</button>
                    </form>
                    <div class="d-flex flex-wrap justify-content-between mt-2">
                        <div class="px-2">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value=""
                                    id="flexCheckDefault">
                                <label class="form-check-label" for="flexCheckDefault">
                                    {{ getJsonLocalization('index', 'remember me') }}
                                </label>
                            </div>
                        </div>
                        <div class="px-2">
                            <a href="#"
                                class="text-secondary text-mini"><i>{{ getJsonLocalization('index', 'forgot credentials') }}</i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Contact Section -->
    @include('contactSection')

    <!-- Site Footer -->
    @include('footer')
</body>

</html>
